<?php
header('Content-Type: application/json; charset=UTF-8');
header('Access-Control-Allow-Origin: *');

require_once 'conexion.php';

// Consulta para obtener la primera fila de configuración
$sql = "SELECT plan FROM tm_configuracion LIMIT 1";

$result = mysqli_query($conn, $sql);
if (!$result) {
    http_response_code(500);
    echo json_encode(["error" => "Error en la consulta de configuración: " . mysqli_error($conn)]);
    mysqli_close($conn);
    exit;
}

if (mysqli_num_rows($result) > 0) {
    $row = mysqli_fetch_assoc($result);
    // El campo 'plan' es un string JSON, así que lo decodificamos
    $config_plan = json_decode($row['plan'], true);

    // Verificamos si la decodificación fue exitosa
    if (json_last_error() === JSON_ERROR_NONE) {
        http_response_code(200);
        echo json_encode($config_plan);
    } else {
        http_response_code(500);
        echo json_encode(["error" => "Error al decodificar el JSON de configuración."]);
    }
} else {
    http_response_code(404);
    echo json_encode(["error" => "No se encontró ninguna configuración en la base de datos."]);
}

mysqli_close($conn);
?>