<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --card-shadow-hover: 0 5px 20px rgba(0,0,0,0.12);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.75rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.5rem 1rem;
    border-radius: 20px;
    display: inline-block;
}

.breadcrumb-modern .breadcrumb-item {
    color: rgba(255, 255, 255, 0.9);
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

.breadcrumb-modern a {
    color: white;
    text-decoration: none;
}

/* === CARD MODERN === */
.card-modern {
    border: none;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    transition: var(--transition);
}

.card-modern:hover {
    box-shadow: var(--card-shadow-hover);
    transform: translateY(-5px);
}

/* === BUTTONS MODERN === */
.btn-modern {
    border-radius: 8px;
    font-weight: 500;
    padding: 0.6rem 1.2rem;
    box-shadow: 0 4px 6px rgba(50, 50, 93, 0.11), 0 1px 3px rgba(0, 0, 0, 0.08);
    transition: var(--transition);
    border: none;
}

.btn-modern:hover {
    transform: translateY(-1px);
    box-shadow: 0 7px 14px rgba(50, 50, 93, 0.1), 0 3px 6px rgba(0, 0, 0, 0.08);
}

.btn-modern-primary {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    color: white;
}

.btn-modern-success {
    background: linear-gradient(135deg, var(--success-color) 0%, #2ecc71 100%);
    color: white;
}

/* === ANIMACIONES === */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.animate-in {
    animation: fadeInUp 0.5s ease;
}
</style>

<div class="row page-titles-modern animate-in">
    <div class="col-md-5 align-self-center">
        <h4 class="text-white">Ajustes</h4>
        <div class="breadcrumb-modern">
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste"><i class="fa fa-home mr-1"></i>Inicio</a></span>
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste">Sistema</a></span>
            <span class="breadcrumb-item active">Optimización de procesos</span>
        </div>
    </div>
</div>

<div class="wrapper wrapper-content animated fadeIn ng-scope">
    <div class="row">
        <?php if(Session::get('modo') == 1) { ?>
            <div class="col-sm-12 col-lg-12">
                <div class="card card-modern text-center p-4">
                    <div class="card-body">
                        <div style="font-size: 4rem; margin-bottom: 1rem;"><i class="fa fa-window-close text-danger"></i></div>
                        <h3 class="card-title font-weight-bold">Acceso Restringido</h3>
                        <p class="card-text text-muted">No está permitido optimizar procesos cuando el sistema está en <strong>producción</strong>.</p>
                        <p class="card-text text-info"><i class="fa fa-info-circle"></i> Si desea restaurar datos iniciales, por favor, cambie a modo demo.</p>
                    </div>
                </div>
            </div>
        <?php } else { ?>
            <!-- Card Pedidos -->
            <div class="col-sm-6 col-md-4 col-lg-3 mb-4">
                <div class="card card-modern text-center h-100">
                    <div class="card-body d-flex flex-column justify-content-center">
                        <div class="mb-3"><i class="ti ti-receipt text-success" style="font-size: 3rem;"></i></div>
                        <h4 class="card-title font-weight-bold">Pedidos</h4>
                        <p class="card-text font-12 mb-4 text-muted">Eliminar recursos temporales</p>
                        <a href="javascript:void(0)" class="btn btn-primary btn-block opt-ped btn-modern btn-modern-primary mt-auto">Optimizar</a>
                    </div>
                </div>
            </div>
            
            <?php if(Session::get('usuid') == 1) { ?>
            <!-- Card Ventas -->
            <div class="col-sm-6 col-md-4 col-lg-3 mb-4">
                <div class="card card-modern text-center h-100">
                    <div class="card-body d-flex flex-column justify-content-center">
                        <div class="mb-3"><i class="ti ti-ticket text-success" style="font-size: 3rem;"></i></div>
                        <h4 class="card-title font-weight-bold">Ventas</h4>
                        <p class="card-text font-12 mb-4 text-muted">Restaurar ventas realizadas</p>
                        <a href="javascript:void(0)" class="btn btn-primary btn-block opt-ven btn-modern btn-modern-primary mt-auto">Restaurar</a>
                    </div>
                </div>
            </div>
            <!-- Card Productos -->
            <div class="col-sm-6 col-md-4 col-lg-3 mb-4">
                <div class="card card-modern text-center h-100">
                    <div class="card-body d-flex flex-column justify-content-center">
                        <div class="mb-3"><i class="mdi mdi-food-fork-drink text-success" style="font-size: 3rem;"></i></div>
                        <h4 class="card-title font-weight-bold">Productos</h4>
                        <p class="card-text font-12 mb-4 text-muted">Restaurar catálogo de productos</p>
                        <a href="javascript:void(0)" class="btn btn-primary btn-block opt-prod btn-modern btn-modern-primary mt-auto">Restaurar</a>
                    </div>
                </div>
            </div>
            <!-- Card Insumos -->
            <div class="col-sm-6 col-md-4 col-lg-3 mb-4">
                <div class="card card-modern text-center h-100">
                    <div class="card-body d-flex flex-column justify-content-center">
                        <div class="mb-3"><i class="mdi mdi-food-variant text-success" style="font-size: 3rem;"></i></div>
                        <h4 class="card-title font-weight-bold">Insumos</h4>
                        <p class="card-text font-12 mb-4 text-muted">Restaurar insumos de cocina</p>
                        <a href="javascript:void(0)" class="btn btn-primary btn-block opt-ins btn-modern btn-modern-primary mt-auto">Restaurar</a>
                    </div>
                </div>
            </div>
            <!-- Card Clientes -->
            <div class="col-sm-6 col-md-4 col-lg-3 mb-4">
                <div class="card card-modern text-center h-100">
                    <div class="card-body d-flex flex-column justify-content-center">
                        <div class="mb-3"><i class="mdi mdi-account-multiple text-success" style="font-size: 3rem;"></i></div>
                        <h4 class="card-title font-weight-bold">Clientes</h4>
                        <p class="card-text font-12 mb-4 text-muted">Restaurar base de datos de clientes</p>
                        <a href="javascript:void(0)" class="btn btn-primary btn-block opt-clientes btn-modern btn-modern-primary mt-auto">Restaurar</a>
                    </div>
                </div>
            </div>
            <!-- Card Proveedores -->
            <div class="col-sm-6 col-md-4 col-lg-3 mb-4">
                <div class="card card-modern text-center h-100">
                    <div class="card-body d-flex flex-column justify-content-center">
                        <div class="mb-3"><i class="mdi mdi-account-location text-success" style="font-size: 3rem;"></i></div>
                        <h4 class="card-title font-weight-bold">Proveedores</h4>
                        <p class="card-text font-12 mb-4 text-muted">Restaurar lista de proveedores</p>
                        <a href="javascript:void(0)" class="btn btn-primary btn-block opt-proveedores btn-modern btn-modern-primary mt-auto">Restaurar</a>
                    </div>
                </div>
            </div>
            <!-- Card Salones -->
            <div class="col-sm-6 col-md-4 col-lg-3 mb-4">
                <div class="card card-modern text-center h-100">
                    <div class="card-body d-flex flex-column justify-content-center">
                        <div class="mb-3"><i class="mdi mdi-folder-multiple-outline text-success" style="font-size: 3rem;"></i></div>
                        <h4 class="card-title font-weight-bold">Salones/Mesas</h4>
                        <p class="card-text font-12 mb-4 text-muted">Restaurar distribución de mesas</p>
                        <a href="javascript:void(0)" class="btn btn-primary btn-block opt-mesas btn-modern btn-modern-primary mt-auto">Restaurar</a>
                    </div>
                </div>
            </div>  
            <!-- Card Kardex -->
            <div class="col-sm-6 col-md-4 col-lg-3 mb-4">
                <div class="card card-modern text-center h-100">
                    <div class="card-body d-flex flex-column justify-content-center">
                        <div class="mb-3"><i class="fa fa-warehouse entory text-success" style="font-size: 3rem;"></i></div>
                        <h4 class="card-title font-weight-bold">Kardex</h4>
                        <p class="card-text font-12 mb-4 text-muted">Restaurar movimientos de almacén</p>
                        <a href="javascript:void(0)" class="btn btn-primary btn-block opt-inventario btn-modern btn-modern-primary mt-auto">Restaurar</a>
                    </div>
                </div>
            </div>  
        <?php } ?>
        <?php } ?>
    </div>
</div>