<input type="hidden" id="moneda" value="<?php echo Session::get('moneda'); ?>"/>
<input type="hidden" id="tribAcr" value="<?php echo Session::get('tribAcr'); ?>"/>
<input type="hidden" id="diAcr" value="<?php echo Session::get('diAcr'); ?>"/>
<input type="hidden" id="filtro_tipo_cliente" value="1"/>

<style>
/* === VARIABLES CSS (Extract from monitor.php) === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --card-shadow-hover: 0 5px 20px rgba(0,0,0,0.12);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 1.5rem 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.5rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.4rem 1rem;
    border-radius: 20px;
    display: inline-block;
    font-size: 0.9rem;
}

.breadcrumb-modern .breadcrumb-item, .breadcrumb-modern a {
    color: rgba(255, 255, 255, 0.9);
    text-decoration: none;
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

/* === TABS MODERNOS === */
.nav-tabs-modern {
    border-bottom: 2px solid #e9ecef;
    margin-bottom: 0;
}

.nav-tabs-modern .nav-link {
    border: none;
    color: #6c757d;
    font-weight: 500;
    padding: 1rem 1.5rem;
    position: relative;
    transition: var(--transition);
}

.nav-tabs-modern .nav-link:hover {
    color: var(--primary-color);
    background: transparent;
}

.nav-tabs-modern .nav-link.active {
    color: var(--primary-color);
    background: transparent;
    border-bottom: 3px solid var(--primary-color);
}

/* === TARJETAS DE ESTADÍSTICAS === */
.stats-container {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(140px, 1fr));
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.stat-card {
    background: white;
    border-radius: var(--border-radius);
    padding: 1rem;
    box-shadow: var(--card-shadow);
    transition: var(--transition);
    border-left: 4px solid;
    position: relative;
    overflow: hidden;
    display: flex;
    flex-direction: column;
    justify-content: center;
    min-height: 90px;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    width: 60px;
    height: 60px;
    background: currentColor;
    opacity: 0.05;
    border-radius: 50%;
    transform: translate(30%, -30%);
}

.stat-card:hover {
    transform: translateY(-3px);
    box-shadow: var(--card-shadow-hover);
}

.stat-card.stat-primary { border-left-color: var(--primary-color); color: var(--primary-color); }
.stat-card.stat-success { border-left-color: var(--success-color); color: var(--success-color); }
.stat-card.stat-warning { border-left-color: var(--warning-color); color: var(--warning-color); }
.stat-card.stat-danger { border-left-color: var(--danger-color); color: var(--danger-color); }
.stat-card.stat-info { border-left-color: var(--info-color); color: var(--info-color); }
.stat-card.stat-dark { border-left-color: var(--dark-color); color: var(--dark-color); }

.stat-icon {
    font-size: 1.8rem;
    opacity: 0.15;
    position: absolute;
    right: 0.75rem;
    top: 50%;
    transform: translateY(-50%);
}

.stat-value {
    font-size: 1.25rem;
    font-weight: 700;
    margin-bottom: 0.1rem;
    position: relative;
    z-index: 1;
    line-height: 1.2;
}

.stat-label {
    font-size: 0.75rem;
    font-weight: 600;
    color: #6c757d;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    position: relative;
    z-index: 1;
}

/* === FILTROS MEJORADOS === */
.filters-card {
    background: white;
    border-radius: var(--border-radius);
    padding: 1.25rem;
    box-shadow: var(--card-shadow);
    margin-bottom: 1.5rem;
}

.filter-section {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1rem;
    margin-bottom: 0;
    align-items: end;
}

.form-group-modern {
    position: relative;
    margin-bottom: 0;
}

.form-group-modern label {
    font-size: 0.8rem;
    font-weight: 600;
    color: #495057;
    margin-bottom: 0.4rem;
    display: block;
}

/* === ESTILOS PARA SELECT Y INPUTS === */
.form-control, 
.selectpicker,
.bootstrap-select .btn {
    border: 1.5px solid #ced4da !important;
    border-radius: 8px !important;
    transition: var(--transition);
    font-size: 0.9rem !important;
    padding: 0.4rem 0.8rem !important;
    height: auto !important;
    min-height: 38px;
}

.form-control:focus,
.bootstrap-select.open .btn {
    border-color: var(--primary-color) !important;
    box-shadow: 0 0 0 0.2rem rgba(86, 100, 210, 0.15) !important;
}

/* === TABLA RESPONSIVE === */
.table-card {
    background: white;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    overflow: hidden;
    min-height: 400px;
}

.table-responsive-modern {
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
}

.table-modern {
    margin-bottom: 0;
}

.table-modern thead {
    background: linear-gradient(135deg, #667eea 0%, var(--primary-color) 100%);
    color: white;
}

.table-modern thead th {
    border: none;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    padding: 0.8rem 1rem;
    white-space: nowrap;
}

.table-modern tbody tr {
    transition: var(--transition);
    border-bottom: 1px solid #f1f3f5;
}

.table-modern tbody tr:hover {
    background-color: #f8f9fa;
}

.table-modern tbody td {
    padding: 0.8rem 1rem;
    vertical-align: middle;
    font-size: 0.9rem;
}

/* === RESPONSIVE MODIFICATIONS === */
@media (max-width: 768px) {
    .stats-container {
        grid-template-columns: repeat(2, 1fr) !important; 
        gap: 0.75rem;
    }
}

/* === ANIMACIONES === */
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

.animate-in {
    animation: fadeInUp 0.5s ease;
}

/* === MODALES MODERNOS === */
.modal-content-modern {
    border: none;
    border-radius: var(--border-radius);
    box-shadow: 0 10px 40px rgba(0,0,0,0.2);
}

.modal-header-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    color: white;
    border: none;
    border-radius: var(--border-radius) var(--border-radius) 0 0;
    padding: 1rem 1.5rem;
}

.modal-title { font-size: 1.1rem; }

.modal-body-modern {
    padding: 1.5rem;
}

.modal-footer-modern {
    border: none;
    padding: 1rem 1.5rem;
    background: var(--light-bg);
    border-radius: 0 0 var(--border-radius) var(--border-radius);
}

/* CUSTOM CLIENTE VIEW STYLES */
.client-detail-card {
    height: 100%;
}
</style>

<!-- HEADER -->
<div class="page-titles-modern animate-in">
    <h4><i class="fas fa-users mr-2"></i>Gestión de Clientes</h4>
    <div class="breadcrumb-modern">
        <span class="breadcrumb-item"><i class="fas fa-home mr-1"></i>Facturación</span>
        <span class="breadcrumb-item">/</span>
        <span class="breadcrumb-item active">Clientes</span>
    </div>
</div>

<div class="row">
    <!-- COLUMNA IZQUIERDA: LISTA Y FILTROS -->
    <div class="col-md-7">
        
        <!-- ESTADÍSTICAS Y AGREGAR -->
        <div class="row mb-3">
            <div class="col-8">
                 <div class="stat-card stat-warning animate-in" style="min-height: 80px; flex-direction: row; align-items: center; justify-content: start; padding-left: 1.5rem;">
                    <i class="fas fa-users stat-icon" style="right: auto; left: 80%; opacity: 0.2; font-size: 3rem;"></i>
                    <div>
                        <div class="stat-value clientes-total" style="font-size: 1.8rem;">0</div>
                        <div class="stat-label">Total Clientes</div>
                    </div>
                </div>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-success btn-block shadow-sm h-100 btn-nuevo" style="border-radius: 12px; font-weight: 600;">
                    <i class="fas fa-plus-circle mr-2 fa-lg"></i><br>Nuevo
                </button>
            </div>
        </div>

        <!-- FILTRO DE BUSQUEDA -->
        <div class="filters-card animate-in p-3">
             <div class="form-group-modern">
                <label><i class="fas fa-search mr-1"></i>Buscar Cliente</label>
                <input type="text" class="form-control global_filter" id="global_filter" placeholder="Escriba nombre o documento..." autocomplete="off">
            </div>
        </div>

        <!-- TABS Y TABLA -->
        <div class="card" style="border: none; border-radius: var(--border-radius); box-shadow: var(--card-shadow);">
            <div class="card-body p-0">
                <ul class="nav nav-tabs nav-tabs-modern" role="tablist">
                    <li class="nav-item"> 
                        <a class="nav-link list-personas active" data-toggle="tab" href="#contenido" role="tab" onclick="$('#filtro_tipo_cliente').val(1);">
                            <i class="fas fa-user mr-2"></i>Personas
                        </a> 
                    </li>
                    <li class="nav-item"> 
                        <a class="nav-link list-empresas" data-toggle="tab" href="#contenido" role="tab" onclick="$('#filtro_tipo_cliente').val(2);">
                            <i class="fas fa-building mr-2"></i>Empresas
                        </a> 
                    </li>
                </ul>
                
                <div class="tab-content">
                    <div class="tab-pane active" id="contenido" role="tabpanel">
                        <div class="table-card" style="box-shadow: none; border-radius: 0 0 12px 12px;">
                            <div class="table-responsive-modern">
                                <table id="table" class="table table-modern" cellspacing="0" width="100%">
                                    <thead>
                                        <tr>
                                            <th style="width: 75%;">Cliente</th>
                                            <th style="width: 15%; text-align: center;">Estado</th>
                                            <th style="width: 10%; text-align: center;">Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody class="tb-st"></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- COLUMNA DERECHA: DETALLE -->
    <div class="col-md-5">
        <div class="card client-detail-card animate-in" style="border: none; border-radius: var(--border-radius); box-shadow: var(--card-shadow); min-height: 500px;">
            
            <!-- Default View: No Client Selected -->
            <div class="card-body display-one d-flex flex-column align-items-center justify-content-center text-center p-5" style="display: block; height: 100%;">
                <div style="background: var(--light-bg); width: 120px; height: 120px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 2rem;">
                    <i class="fas fa-user-circle" style="font-size: 4rem; color: #ced4da;"></i>
                </div>
                <h4 class="font-weight-bold text-dark mb-2">Seleccione un Cliente</h4>
                <p class="text-muted">Haga clic en un cliente de la lista para ver su historial de ventas y estadísticas.</p>
            </div>

            <!-- Detail View -->
            <div class="card-body p-0 display-two" style="display: none;">
                <div class="p-4 bg-light" style="border-radius: 12px 12px 0 0; border-bottom: 1px solid #e9ecef;">
                    <h5 class="mb-0 font-weight-bold text-dark"><i class="fas fa-user-tag mr-2 text-primary"></i> <span class="cliente-nombre">Cliente</span></h5>
                </div>
                
                <div class="p-3">
                    <div class="row">
                        <div class="col-4">
                            <div class="stat-card stat-info p-2 min-h-0 text-center" style="min-height: auto;">
                                <div class="stat-value ventas-operaciones font-16">0</div>
                                <div class="stat-label font-10">Operaciones</div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="stat-card stat-warning p-2 min-h-0 text-center" style="min-height: auto;">
                                <div class="stat-value ventas-descuentos font-16">0</div>
                                <div class="stat-label font-10">Descuentos</div>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="stat-card stat-success p-2 min-h-0 text-center" style="min-height: auto;">
                                <div class="stat-value ventas-total font-16">0</div>
                                <div class="stat-label font-10">Total</div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="table-responsive-modern px-3 pb-3">
                    <h6 class="font-weight-bold ml-1 mb-3 text-muted text-uppercase font-12">Historial de Ventas</h6>
                    <table id="table-ventas" class="table table-modern table-sm mb-0" width="100%">
                        <thead>
                            <tr>
                                <th>Fecha</th>
                                <th>Documento</th>
                                <th class="text-right">Total</th>
                            </tr>
                        </thead>
                        <tbody class="tb-st" id="list-venta"></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- MODAL CLIENTE -->
<div class="modal inmodal" id="modal" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content modal-content-modern">
            <form id="form" method="post" enctype="multipart/form-data">
                <input type="hidden" name="id_cliente" id="id_cliente">
                <input type="hidden" name="tipo_cliente" id="tipo_cliente">
                
                <div class="modal-header modal-header-modern">
                    <h4 class="modal-title font-weight-bold">Gestión de Cliente</h4>
                    <div class="ml-auto d-flex align-items-center">
                        <div class="custom-control custom-radio custom-control-inline text-white">
                            <input type="radio" id="td_dni" name="tipo_cli" value="1" class="custom-control-input text-white">
                            <label class="custom-control-label text-white" for="td_dni"><?php echo Session::get('diAcr'); ?></label>
                        </div>
                        <div class="custom-control custom-radio custom-control-inline text-white">
                            <input type="radio" id="td_ruc" name="tipo_cli" value="2" class="custom-control-input text-white">
                            <label class="custom-control-label text-white" for="td_ruc"><?php echo Session::get('tribAcr'); ?></label>
                        </div>
                    </div>
                </div>

                <div class="modal-body modal-body-modern">
                    <div class="row">
                        <!-- Column Left: Info Personal -->
                        <div class="col-lg-6 border-right">
                             <h6 class="text-primary font-weight-bold mb-3"><i class="fas fa-id-card mr-2"></i>Información Personal</h6>
                             
                             <!-- DNI INPUT -->
                             <div class="block01" style="display: block;">
                                <div class="form-group-modern mb-3">
                                    <label class="c-dni"><?php echo Session::get('diAcr'); ?></label>
                                    <input type="text" class="form-control dni" name="dni" id="dni" minlength="<?php echo Session::get('diCar'); ?>" maxlength="<?php echo Session::get('diCar'); ?>" autocomplete="off" required="required"/>
                                </div>
                             </div>

                             <!-- RUC INPUT -->
                             <div class="block02" style="display: none;">
                                <div class="form-group-modern mb-3">
                                    <label class="c-ruc"><?php echo Session::get('tribAcr'); ?></label>
                                    <input type="text" class="form-control ruc" name="ruc" id="ruc" minlength="<?php echo Session::get('tribCar'); ?>" maxlength="<?php echo Session::get('tribCar'); ?>" autocomplete="off" required="required"/>
                                </div>
                             </div>

                             <!-- RAZON SOCIAL -->
                             <div class="block07" style="display: none;">
                                <div class="form-group-modern mb-3">
                                    <label>Razón Social</label>
                                    <input type="text" class="form-control ruc input-mayus" name="razon_social" id="razon_social" autocomplete="off" required="required"/>
                                </div>
                             </div>

                             <!-- NOMBRE -->
                             <div class="block03" style="display: block;">
                                <div class="form-group-modern mb-3">
                                    <label>Nombre Completo</label>
                                    <input type="text" class="form-control dni input-mayus" name="nombres" id="nombres" autocomplete="off" required="required"/>
                                </div>
                             </div>
                        </div>

                        <!-- Column Right: Contacto -->
                        <div class="col-lg-6">
                            <h6 class="text-primary font-weight-bold mb-3"><i class="fas fa-address-book mr-2"></i>Contacto</h6>
                            
                            <div class="row">
                                <div class="col-md-6 block05" style="display: block;">
                                    <div class="form-group-modern mb-3">
                                        <label>F. Nacimiento</label>
                                        <input type="text" class="form-control dni" name="fecha_nac" id="fecha_nac" autocomplete="off" data-mask="99-99-9999" placeholder="DD-MM-AAAA"/>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group-modern mb-3">
                                        <label>Teléfono</label>
                                        <input type="text" class="form-control" name="telefono" id="telefono" autocomplete="off"/>
                                    </div>
                                </div>
                            </div>

                            <div class="block06" style="display: block;">
                                <div class="form-group-modern mb-3">
                                    <label>Correo Electrónico</label>
                                    <input type="email" class="form-control dni" name="correo" id="correo" autocomplete="off"/>
                                </div>
                            </div>

                            <div class="form-group-modern mb-3">
                                <label>Dirección</label>
                                <input type="text" class="form-control" name="direccion" id="direccion" autocomplete="off" required="required"/>
                            </div>
                            
                            <div class="form-group-modern mb-3">
                                <label>Referencia</label>
                                <input type="text" class="form-control input-mayus" name="referencia" id="referencia" autocomplete="off"/>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer modal-footer-modern">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-success shadow-sm"><i class="fas fa-save mr-2"></i>Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>
