<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>Pedidos Restaurante</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Fuentes -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&family=Poppins:wght@600;700&display=swap" rel="stylesheet">

  <!-- Bootstrap 4.3 CSS -->
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
  

  <style>
    /* Tipografías */
    body{ font-family: var(--font-primary); background: #f4f6f8; color: #6c757d; }
    h1,h2,h3,h4,h5,h6{ font-family:'Poppins','Inter',sans-serif; }


    :root {
        --primary-color: #5664d2;
        --success-color: #1bc943;
        --warning-color: #f4a100;
        --danger-color: #e74c3c;
        --info-color: #3498db;
        --dark-color: #2c3e50;
        --light-bg: #f8f9fa;
        --card-shadow: 0 4px 20px rgba(0,0,0,0.05);
        --border-radius: 12px;
        --transition: all 0.3s ease;
        --font-primary: 'Inter', system-ui, -apple-system, sans-serif;

        /* Mappings for legacy vars if needed */
        --custom-primary-color: #5664d2;
        --c-gray-color: #f8f9fa;
        --c-blue-light-color: #eef2f7;
    }

    /* Modern Layout Styles */
    body { 
        font-family: var(--font-primary); 
        background: #f4f6f8; 
        color: #6c757d;
    }
    
    h1, h2, h3, h4, h5, h6 { 
        font-family: var(--font-primary); 
        color: #343a40;
        font-weight: 600;
    }

    /* Card Modernization */
    .card {
        border: none;
        border-radius: 12px;
        box-shadow: 0 0.75rem 1.5rem rgba(18,38,63,.03);
        margin-bottom: 1.5rem;
    }

    .card-header.sticky {
        position: sticky; 
        top: 0; 
        z-index: 999;
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(10px);
        box-shadow: 0 4px 6px -1px rgba(0,0,0,0.05);
        border-bottom: 1px solid #edf2f9;
    }

    .order-card {
        border-radius: 12px !important;
        overflow: hidden;
        border: 1px solid #edf2f9;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58,59,69,.15);
        transition: transform 0.2s;
    }

        /* que el footer no “rompa” el borde redondeado */
    .order-card .card-footer{
        border-top-color: rgba(0,0,0,.06);
    }

    .toast-wrap{
        position: fixed;
        top: 16px;
        right: 16px;
        z-index: 2000;           /* mayor que el header */
        pointer-events: none;    /* no bloquea clics de la página */
    }
    .toast-wrap .toast{
        pointer-events: auto;    /* pero el toast sí es clickeable */
    }

    /* Grid de pedidos */
    .grid{
      display:grid;
      grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
      grid-gap:1rem;
      padding-top: 30px;
    }

   
    

/* Modal ancho */
.custom-modal{ max-width:90%; width:90%; }




    /* Modern Inputs */
    .form-control {
        background-color: var(--light-color);
        border: 1px solid #e3eaef;
        border-radius: 8px;
        color: var(--dark-color);
        padding: 0.6rem 1rem;
        height: auto;
        font-size: 0.9rem;
    }
    .form-control:focus {
        background-color: #fff;
        border-color: var(--primary-color);
        box-shadow: 0 0 0 2px rgba(44, 123, 229, 0.15);
    }

    /* === BUTTONS MODERN === */
    .btn-primary, .btn-primary-modern {
        background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
        border: none;
        box-shadow: 0 4px 15px rgba(86, 100, 210, 0.3);
        color: white;
        border-radius: 6px;
        padding: 0.6rem 1.2rem;
        font-weight: 500;
        transition: var(--transition);
    }
    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 20px rgba(86, 100, 210, 0.4);
    }

    /* === ORDER CARD (PRODUCT) === */
    .order-card {
        border-radius: 12px !important;
        overflow: hidden;
        border: 1px solid #f1f5f9;
        box-shadow: 0 4px 10px rgba(0,0,0,0.03);
        transition: all 0.3s ease;
        background: white;
    }
    .order-card:hover { 
        box-shadow: 0 10px 25px rgba(0,0,0,0.08); 
        transform: translateY(-3px); 
    }

    /* === ORDER HEADER === */
    .po-header {
        background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%) !important;
        box-shadow: 0 4px 15px rgba(86, 100, 210, 0.3) !important;
        color: white;
        padding: 0.5rem; /* Reduced from 1rem */
        border-radius: 12px 12px 0 0;
    }
    
    /* === RESPONSIVE FULL HEIGHT MODAL - FULL SCREEN POS V2 === */
    #modal-pedidos .modal-dialog {
        height: 95vh; /* Lifted slightly from bottom edge */
        margin: 1vh auto;
        display: flex;
        flex-direction: column;
        justify-content: center;
        font-size: 0.75rem; 
    }
    #modal-pedidos .modal-content {
        height: 100%;
        max-height: 100%;
        display: flex;
        flex-direction: column;
        overflow-y: auto; /* ALLOW SCROLL: Critical for small screens/tablets */
        -webkit-overflow-scrolling: touch;
    }
    #modal-pedidos .slice-wraper {
        flex: 1;
        padding: 0 !important;
        overflow: hidden;
        display: flex;
        flex-direction: column;
    }
    #modal-pedidos .modal-content .row {
        flex: 1;
        margin: 0;
        height: auto; /* Allow growth */
        min-height: 100%;
        flex-wrap: nowrap;
    }
    #modal-pedidos .modal-order-right, 
    #modal-pedidos .modal-order-left {
        height: auto; /* Let it grow if needed */
        min-height: 100%;
        padding-top: 2px;
        padding-bottom: 2px;
        overflow: visible;
        display: flex;
        flex-direction: column;
    }

    /* Right Column Flex Layout */
    .place-order.card {
        height: auto !important; /* Allow height to adapt */
        min-height: 100%;
        display: flex !important;
        flex-direction: column;
        justify-content: flex-start; 
        margin-bottom: 0 !important;
        background: white;
        overflow: visible; /* Don't hide overflow, let modal scroll handle it */
        position: relative;
    }
    
    .po-items {
        background: white;
        flex: 1 1 auto;
        flex-shrink: 1; 
        overflow-y: auto;
        min-height: 100px;
        
        /* FINAL SAFETY LIMIT: 25vh. */
        max-height: 30vh !important;
        
        overflow-x: hidden;
    }

    /* Compact Cart Items */
    .po-item {
        padding: 5px 8px !important; 
        border-bottom: 1px dashed #eee;
    }
    .po-item .description .info {
        margin-bottom: 0 !important;
    }
    .po-item .actions {
        margin-top: 0 !important;
    }
    
    /* Pin Footer to Bottom - Compact */
    #totales_tipo_pago {
        margin-top: 0; /* REMOVED auto: Hug the list, don't push to bottom */
        flex-shrink: 0;   
        background: white; 
        z-index: 10;
        padding-top: 2px;
        padding-bottom: 2px;
        border-top: 2px solid #e9ecef;
    }
    
    /* Compact Payment Inputs */
    #totales_tipo_pago .form-control {
        height: calc(1.4em + 0.5rem + 2px); 
        padding: 0.2rem 0.5rem;
        font-size: 0.75rem;
    }
    #totales_tipo_pago label {
        margin-bottom: 0 !important;
        font-size: 0.7rem;
        font-weight: 600;
    }
    
    /* Compact Totals & Buttons Extras */
    .payment-grid { gap: 0.30rem !important; }
    #botones_pedido button { height: 38px !important; width: 38px !important; margin: 0 !important; }
    #btnAccionMaster { height: 38px !important; width: auto !important; margin: 0 !important; min-width: 120px !important; }
    .po-filters { margin-bottom: 0 !important; margin-top: 0 !important; padding: 0 !important; gap: 0 !important; }

    /* === RESPONSIVE BREAKPOINTS (Tablets & Small Laptops) === */
    @media (max-width: 992px) {
        #modal-pedidos .modal-dialog {
            font-size: 0.7rem; /* Smaller base font */
            margin: 0 auto;
            height: 100vh; /* Use full height on small screens */
            max-width: 100%;
        }
        .po-items {
            max-height: 25vh !important; /* Keep list short */
        }
        #totales_tipo_pago label { font-size: 0.65rem; }
        #totales_tipo_pago .form-control { font-size: 0.7rem; height: calc(1.3em + 0.5rem + 1px); }
        .payment-grid { flex-wrap: wrap; }
        .payment-item { min-width: 45%; flex: 1 1 45%; } /* 2 per row */
        
        /* Adjust totals size */
        .h6 { font-size: 0.9rem; }
        .h5 { font-size: 1rem; }
    }

    /* === MOBILE PHONES === */
    @media (max-width: 576px) {
        .modal-order-left { display: none; } /* On phone, maybe user wants to hide menu? Or keep it stacked. Leaving logic to user JS but styling here. */
        .place-order.card { height: 100vh !important; } /* Full screen card */
        .po-items { max-height: 35vh !important; } /* More space for list on phone */
        
        .payment-grid { gap: 0.2rem !important; }
        .payment-item { min-width: 100%; flex: 1 1 100%; mb-1; } /* Stack inputs vertical */
        
        #botones_pedido { flex-wrap: wrap; justify-content: center; }
        #btnAccionMaster { width: 100% !important; margin-top: 5px !important; }
    }


    /* === CATEGORY BUTTONS === */
    .card-category {
        border: 1px solid #e9ecef;
        border-radius: 20px; /* Pill shape */
        padding: 0.5rem 1.2rem;
        background: white;
        color: #555;
        font-weight: 500;
        transition: var(--transition);
        box-shadow: none;
    }
    .card-category:hover {
        background: #f8f9fa;
        transform: translateY(-1px);
    }
    .card-category.selected {
        background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
        color: white;
        border-color: transparent;
        box-shadow: 0 4px 10px rgba(86, 100, 210, 0.3);
    }
    .card-category.selected .name { color: white !important; background: transparent; }
    .card-category .name { background: transparent; border: none; padding: 0; }

    /* Modern Table */
    .table-modern thead th {
        background-color: var(--light-color);
        color: var(--secondary-color);
        border-bottom: 2px solid #e3eaef;
        font-weight: 600;
        text-transform: uppercase;
        font-size: 0.8rem;
        letter-spacing: 0.5px;
        padding: 12px;
    }
    .table-modern tbody td {
        vertical-align: middle;
        border-top: 1px solid #e3eaef;
        color: var(--dark-color);
        padding: 12px;
    }
    .table-modern tbody tr:hover {
        background-color: rgba(44, 123, 229, 0.03);
    } 

    .order-card:hover{ box-shadow:0 0.5rem 1rem rgba(0,0,0,.10); transform:translateY(-2px); }

    .item-line{ display:flex; justify-content:space-between; }

    .priority-dot{ width:10px; height:10px; border-radius:50%; display:inline-block; margin-right:.30rem; }
    .priority-high{ background:#dc3545; } /* rojo */
    .priority-med{  background:#ffc107; } /* amarillo */
    .priority-low{  background:#28a745; } /* verde */

    /* Toolbar: búsqueda izq, filtros der, botón nuevo extremo der */
    .toolbar{ gap:.5rem; }
    .toolbar .search-wrap{ flex:1 1 auto; max-width:560px; }
    .toolbar .filters-wrap{ flex:0 0 auto; display:flex; gap:.5rem; }
    .filters-wrap select{ min-width:180px; }

    .btn-new{
      white-space:nowrap; border-radius:999px; padding:.45rem 1rem; font-weight:600;
      display:inline-flex; align-items:center;
    }
    .btn-new .plus{ font-weight:700; margin-right:.35rem; font-size:1rem; line-height:1; }

    @media (max-width:767.98px){
      .toolbar{ flex-direction:column; align-items:stretch; }
      .toolbar .search-wrap{ max-width:100%; }
      .filters-wrap{ width:100%; }
      .filters-wrap select{ flex:1 1 50%; min-width:auto; }
      .btn-new{ width:100%; justify-content:center; margin-top:.5rem; }
    }

   .collapsible {
            background-color: #fff;
            cursor: pointer;
            padding: 18px;
            width: 100%;
            border: none;
            text-align: left;
            outline: none;
            font-size: 13px;
            color: #515562;

            &:hover {
                background-color: #f5f5f5;
            }
        }

        .selected {
            background-color: #e0f7fa;
            border: 1px solid #00acc1;
        }

        .demo-checkbox {

            border-radius: 4px;
            padding: 1rem;

        }

        .content {
            padding: 0px 0px 3px 0px;
            display: none;
            overflow: hidden;
            background-color: darkorange;
        }

        /* Fin: Collapsible styles */

        .btn-up {
            position: fixed;
            bottom: 20px;
            right: 20px;
            padding: 25px;
        }

        .btn-down {
            position: fixed;
            bottom: 20px;
            right: 20px;
            padding: 25px;
        }

        .dropdown-toggle::after {
            display: none;
        }

        .btnCobrar {
            color: white;
        }

        .btnDividirCuenta {
            color: white;
        }

        .totalPagar {
            flex: 1;
            font-weight: bold;
        }

        .c-mozo-title {
            padding-left: 1rem;
            padding-right: 1rem;
            display: flex;
            align-items: center;
        }

        .c-mozo-title h2 {
            color: #0f172a;
            font-weight: 400;
            font-size: 1rem;
            text-transform: capitalize;
        }

        .c-mozo-title .state-tables {
            margin-left: auto;
        }

        .list-mesas {
            display: flex;
            flex-wrap: wrap;
            gap: .5rem;
            padding-top: .5rem;
            padding-bottom: .5rem;
            justify-content: center
        }

        #form-nuevo-pedido {
            height: 100%;
            display: flex;
            flex-direction: column;
        }

        .r-order-item .r-details {

            display: flex;
            flex-direction: column;
            gap: .5rem;
        }

        .r-order-item .r-details .order-name {
            font-size: 14px;
            color: #607d8b;
            font-weight: 500;

        }

        .r-order-type-label {
            border-radius: 12px;
            padding: .1rem .4rem;
            font-size: 0.7rem;
            text-transform: lowercase;
            color: rgba(39, 68, 175, 0.6);
            border: 1px solid#3555c7;
        }

        .g-medio {
            gap: .5rem !important;
        }

        :root {
            --custom-primary-color: #0f172a;
            --custom-alert-color: #fc4b6c;
            --c-gray-color: #f3f4fa;
            --c-blue-light-color: #e4eafe;
            --c-font-size-small: 14px;
            --c-title-color: #607d8b;
            --c-text-color: red;
            --c-low-gray-color: #c6c9d3;
            --c-mid-gray-color: #7d8296;
            --c-hight-gray-color: #515562;
            --c-gray-other: #585c6b;
        }

        .custom-bg-primary {
            background: var(--custom-primary-color) !important;
        }

        .custom-bg-alert {
            background: var(--custom-alert-color) !important;
        }

        .custom-text-alert {
            color: var(--custom-alert-color) !important;
        }

        /*utilidades */

        .min-height-0 {
            min-height: 0 !important;
        }

        .c-bg-gray {
            background: var(--c-gray-color) !important;
        }

        .c-small-font-size {
            font-size: var(--c-font-size-small);
        }

        .c-title-color {
            color: var(--c-hight-gray-color);
        }

        /* mesas*/

        .menu {

            height: 750px;
            display: grid;
            grid-template-rows: auto auto auto minmax(auto, 1fr);
            gap: 1rem;
            overflow: hidden;
            padding: 0.3rem;
        }

        .section-date {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        /* button */
        .lb-btn {
            padding: .5rem .5rem;
            background-color: var(--c-gray-color);
            border-radius: .5rem;
            display: flex;
            align-items: center;
            gap: 1rem;
            padding-right: 2rem;
            border: 1px solid var(--c-low-gray-color);
        }

        .lb-btn .icon {
            display: flex;
            padding: .5rem;
            background-color: white;
            border-radius: 50%;
        }

        .lb-btn.secondary {
            background-color: var(--c-gray-color);
            padding-right: .5rem;
            padding-left: 2rem;
        }

        .lb-btn.secondary .icon {
            background-color: white;
            margin-left: auto;
        }

        .btn-reload-menu {
            margin-left: auto;
            background: #0f172a;
            padding: .75rem;
            color: white;
            border-radius: .5rem;
            text-transform: uppercase;
            cursor: pointer;
        }

        /** quick search*/

        .custom-quick-search {
            position: relative
        }

        .custom-quick-search::after {
            content: "\f00d";
            font-family: "Font Awesome 5 Free";
            /* Icono de la "X" */
            font-weight: 900;
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            font-size: 14px;
            color: var(--c-mid-gray-color);
            /* display: none; */
        }

        .custom-quick-search input {
            border: 1px solid var(--c-mid-gray-color);
            padding: .375rem .75rem;
            border-radius: .30rem;
        }

        .custom-quick-search input::placeholder {
            color: var(--c-low-gray-color);
        }

        .custom-quick-search input:focus {
            border: 1px solid var(--c-blue-light-color);
            padding: .375rem .75rem;
            border-radius: .30rem;
            border-color: var(--custom-primary-color);
            box-shadow: 0 0 0 3px rgba(121, 82, 179, 0.25);
        }

        .custom-quick-search .result {
            height: 200px;
            width: 200px;
            position: absolute;
            border: 1px solid var(--c-low-gray-color);
            box-shadow: 0 0.5rem 1rem rgba(37, 56, 139, 0.175);
            background-color: white;
            border-radius: 4px;
            padding: .75rem 0 !important;
            margin-top: 4px;
            display: flex;
            flex-direction: column;
            right: 0;
            z-index: 9999;
        }

        .custom-quick-search .result ul {
            padding: 0rem;
            list-style: none;
            flex-grow: 1;
            overflow-y: scroll;
        }

        .custom-quick-search .result ul li {
            padding: 0rem;
            border-bottom: 1px dashed var(--c-low-gray-color);
            padding: .55rem .75rem;
            text-transform: capitalize;
        }

        .custom-quick-search .result ul li:hover {
            background: #e0e7ff;
        }

        .custom-quick-search .result .cq-footer {
            text-align: center;
            font-size: 10px;
            padding: .5rem;
            background: var(--c-gray-color);
        }

        /** cards*/

        /**start category */

.section-category {
  width: 100%;
  overflow-x: auto;               /* Scroll horizontal si se desborda */
  overflow-y: hidden;
  padding-bottom: 0.5rem;
  margin-bottom: 1rem;
  scroll-behavior: smooth;
  height: auto;                   /* Altura para 2 filas aprox */
}

.list-categories {
  display: grid;
  grid-auto-flow: column;        /* ✅ Llena primero hacia abajo (dos filas), luego crea columnas hacia la derecha */
  grid-template-rows: repeat(3, auto);  /* ✅ 2 filas automáticas */
  gap: 0.5rem;
}

/* Estilo de cada tarjeta (como antes, con altura más baja) */
.card-category {
  display: inline-flex;
  align-items: center;
  gap: 6px;
  border: 1px solid #ccc;
  padding: 0.5rem 1rem;
  border-radius: 0.5rem;
  background-color: #fff;
  cursor: pointer;
  font-size: 13px;
  height: 38px;
  white-space: nowrap;
  transition: all 0.2s ease;
  width: auto;
}


.card-category.selected {
  background-color: #7460ee;
  color: #fff;
  border-color: #7460ee;
}

.card-category .icon i {
  font-size: 16px;
}

.card-category .title {
  font-weight: 500;
}

.card-category .badge {
  background-color: #eee;
  padding: 1px 6px;
  border-radius: 12px;
  font-size: 12px;
  color: #333;
}

.card-category.selected .badge {
  background-color: rgba(255, 255, 255, 0.3);
  color: #fff;
}

.card-category .close {
  color: red;
  font-weight: bold;
  cursor: pointer;
  font-size: 14px;
}

/* Scrollbar opcional */
.section-category::-webkit-scrollbar {
  height: 6px;
}
.section-category::-webkit-scrollbar-thumb {
  background: #ccc;
  border-radius: 4px;
}

       
/**end category */
        /** search*/
        .section-search {
        display: flex;
        align-items: center;
        gap: .5rem;          /* separa buscador y botones */
        overflow: hidden;
        flex-wrap: nowrap;   /* todo en una sola fila */
        }

        .section-search .search-input {
        flex: 1 1 auto;      /* que ocupe el espacio restante */
        min-width: 0;        /* permite que encoja en pantallas pequeñas */
        display: flex;
        border-radius: .3rem;
        background-color: white;
        padding: .30rem .35rem;
        border: 1px solid var(--c-mid-gray-color);
        }

        .section-search .search-input input {
        flex-grow: 1;
        border: none;
        background: none;
        }

        .section-search .change-mode {
        flex: 0 0 auto;      /* no se encoje */
        display: inline-flex;
        gap: .30rem;
        }

        .section-search .change-mode .btn {
        width: 36px;
        height: 36px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        padding: 0;
        }

        /* Ajuste opcional para pantallas muy pequeñas */
        

        /* .section-search .change-mode{
            font-size: 21px;
            border: 1px solid var(--c-low-gray-color);
            display: flex;
            border-radius: .5rem;
            margin-left: 1rem;
        }
        .section-search .change-mode span{
            padding: .45rem .75rem;
        }
        .section-search .change-mode span:not(:first-child){
            border-left: 1px solid var(--c-low-gray-color);
            color: var(--custom-primary-color);
            background : #eff0f6;
        } */
        /** menu list*/

        .section-list {
            display: grid;
            grid-template-columns: repeat(2, minmax(auto, 1fr));
            gap: .5rem;
            height: 100%;
            overflow: scroll;
            /* Firefox */
            scrollbar-width: thin;
            scrollbar-color: rgba(0, 0, 0, 0.2) transparent;

            /* Chrome, Safari, Edge */
            &::-webkit-scrollbar {
                width: 8px;
            }

            &::-webkit-scrollbar-thumb {
                background: rgba(0, 0, 0, 0.2);
                border-radius: 4px;
            }

            &::-webkit-scrollbar-track {
                background: transparent;
            }
        }

        .section-list-table {
            display: flex;
            flex-direction: column;
        }

        .section-list-table .content-table {
            flex-grow: 1;
        }

        .section-list-table .navigation .page-link {
            border: 1px solid var(--c-low-gray-color);
        }

        .card-menu img {
            width: 100%;
            height: 100%;
            object-fit: contain;
            object-position: left;
        }

        .card-menu {
            padding: .5rem;
            background-color: white;
            border-radius: .5rem;
            display: flex;
            flex-direction: column;
            gap: .5rem;
            border: 1px solid var(--c-low-gray-color);
            transition: all .5s ease;
        }

        .card-menu:hover {
            border: 1px solid var(--custom-primary-color);
        }

        .card-menu .card-menu-header {
                width: 100%;
                height: 120px;       /* Alto fijo para todas las imágenes */
                overflow: hidden;    /* Oculta partes que sobresalgan */
                border-radius: .3rem;
                background: var(--c-gray-color);
                display: flex;
                align-items: center;
                justify-content: center;
            }

            .card-menu .card-menu-header img {
                width: 100%;
                height: 100%;
                object-fit: cover;   /* Recorta para llenar todo el espacio */
                object-position: center; /* Centra la imagen en el recorte */
                display: block;
            }

        .card-menu .menu-category {
            display: flex;
            justify-content: space-between;
            align-items: center;

        }

        .card-menu .menu-category .name {
            background-color: #e0e7ff;
            font-size: 10px;
            padding: .5rem .7rem;
            border-radius: .5rem;
            color: #0f172a;
            border: 1px solid #21388b1c;
        }

        /*payment order*/
        .place-order {
            background-color: white;
            height: 750px;
            display: flex;
            flex-direction: column;
        }

        .po-header {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 1rem;
            box-shadow: 0 4px 6px -3px rgba(0, 0, 0, 0.1);
            background: var(--custom-primary-color);
        }

        .po-header .info {
            margin-left: auto;
            margin-right: auto;
            display: flex;
            flex-direction: column;
            text-align: center;
        }

        .po-header .icon span {

            display: flex;
            padding: 1rem;
            border-radius: 50%;
            font-size: 16px;
        }

        .po-header .action span {
            /* background-color: var(--c-gray-color); */
            display: flex;
            padding: 1rem;
            border-radius: .5rem;
            border: 2px solid white;
        }

        .po-filters {
            display: flex;
            padding: .5rem;
            box-shadow: inset 0px 0px 8px 1px rgba(0, 0, 0, 0.1);
            gap: .5rem;
        }

        .po-filters .c-custom-select {
            
            border: none;
            border-radius: .5rem;
            flex-grow: 1;
            border: 1px solid var(--c-low-gray-color);
            display: flex;
            border-radius: .5rem;
        
        }

        .po-filters .c-custom-select select {

            background: inherit;
            width: 100%;
            font-size: 14px;
            margin-left: auto;
            color: var(--c-mid-gray-color);
            border: none;
        }

        .po-items {
            flex-grow: 1;
            overflow-y: scroll;
            /* Firefox */
            scrollbar-width: thin;
            scrollbar-color: rgba(0, 0, 0, 0.2) transparent;

            /* Chrome, Safari, Edge */
            &::-webkit-scrollbar {
                width: 8px;
            }

            &::-webkit-scrollbar-thumb {
                background: rgba(0, 0, 0, 0.2);
                border-radius: 4px;
            }

            &::-webkit-scrollbar-track {
                background: transparent;
            }
        }

        .po-items .empty-items {
            min-height: 60px;
            display: flex;
            justify-content: center;
            align-items: center;
            border-bottom: 1px dashed var(--c-gray-color);
            text-transform: capitalize;
        }

        .po-items .po-item {
            display: flex;
            padding: .7rem;
            gap: .5rem;
            border-bottom: 1px dashed var(--c-low-gray-color);
        }

        .po-items .po-item .img {
            background-color: var(--c-gray-color);
            padding: .5rem;
            border-radius: .5rem;
        }

        .po-items .po-item .img img {
            width: 100%;
            max-width: 80px;
        }

        .po-items .po-item .description {
            flex-grow: 1;
        }

        .po-items .po-item .description .info {
            display: flex;
            flex-direction: column;
            gap: .2rem;
            margin-bottom: .2rem
        }

        .po-items .po-item .description .info .price {
            color: var(--text-paragrap-color);
        }

        .po-items .po-item .description .actions {
            display: flex;
            justify-content: space-between;
        }

        .po-items .po-item .description .actions .quantity {
            background-color: var(--c-gray-color);
            display: flex;
            gap: .5rem;
            padding: 0rem .5rem;
            border-radius: .75rem;
        }

        .sub-total div {
            display: flex;
            justify-content: space-between;
        }

        .sub-total {
            padding: .7rem;
            box-shadow: 0 -4px 6px -3px rgba(0, 0, 0, 0.1);
            border: 1px solid var(--c-blue-light-color)
        }

        .total {
            display: flex;
            justify-content: space-between;
            padding: .7rem;
        }

        .po-actions {
            padding: 1rem;
            display: flex;
            gap: 1rem;
        }

        .po-actions>span {
            flex-grow: 1;
        }

        .po-confirm button {
            width: 100%;
            font-size: 15px;
            height: 5rem;
            text-transform: capitalize;
            background-color: var(--custom-primary-color);
            border: none;
        }

        .slice-wraper {
            transition: all 1s ease;
        }

        .bg-menu-panel {
            background: none !important;
        }

        @media (min-width: 767px) {
            .section-category .list-categories {
                justify-content: start;
            }

            .card-category {
                
                padding: 1rem;
                
            }

            .section-search .search-input {
                padding-left: 2rem;
            }

            .section-list {
                grid-template-columns: repeat(4, minmax(auto, 1fr));
                gap: 1rem;
            }


            .bg-menu-panel {
                background: var(--c-gray-color) !important;
            }
        }

        @media (max-width: 767px) {
            .list-mesas {
                gap: 0rem !important;
            }

            /* INICIO: estilos que ocultan en sidebar-right del modal de pedidos */
            .slice-wraper .modal-order-right {
                display: none;
                position: absolute;
                top: 0;
                left: 0;
                padding: 0;
            }
        }


        .custom-modal {
            max-width: 90%;
            width: 90%;
        }

        .card-category.selected {
            border-color: #007bff;
            /* Borde azul para la categoría seleccionada */
        }
        .po-item-wrapper.new-item {
        background-color: #e6f7ff;  /* un azul muy suave */
        transition: background-color 0.3s ease;
        }

        /* Si quieres que sólo el header cambie */
        .po-item-wrapper.new-item .po-item {
        background-color: #e6f7ff;
        }

        .section-list.list-view {
        display: flex;
        flex-direction: column;
        gap: 0.5rem;
        }

        .section-list.grid-view {
        display: flex;
        flex-wrap: wrap;
        gap: 1rem;
        }

        .section-list.grid-view .card-menu-wrapper {
        width: calc(33.333% - 1rem); /* 3 por fila */
        }

        .hide-force { display: none !important; }
    
        /* Tarjeta redondeada */
.order-card .card{
  border-radius:14px;
  overflow:hidden;
  transition: box-shadow .2s, transform .06s, border-color .2s;
  border:1px solid rgba(0,0,0,.06);
}
.order-card .card:hover{ box-shadow:0 6px 22px rgba(0,0,0,.10); }

/* Foco accesible (teclado) */
.order-card[tabindex="0"]:focus-visible .card{
  outline:none;
  box-shadow:0 0 0 3px rgba(25,118,210,.25);
  border-color:rgba(25,118,210,.5);
}

/* Selección persistente */
.order-card.is-selected .card{
  box-shadow:0 0 0 3px rgba(0,150,136,.28), 0 8px 24px rgba(0,0,0,.12);
  border-color:rgba(0,150,136,.6);
  transform:translateY(-1px);
}

.static-list-pedidos {
            flex-grow: 1;
            overflow-y: scroll;
            /* Firefox */
            scrollbar-width: thin;
            scrollbar-color: rgba(0, 0, 0, 0.2) transparent;

            /* Chrome, Safari, Edge */
            &::-webkit-scrollbar {
                width: 8px;
            }

            &::-webkit-scrollbar-thumb {
                background: rgba(0, 0, 0, 0.2);
                border-radius: 4px;
            }

            &::-webkit-scrollbar-track {
                background: transparent;
            }
        }

        .static-list-pedidos .empty-items {
            min-height: 60px;
            display: flex;
            justify-content: center;
            align-items: center;
            border-bottom: 1px dashed var(--c-gray-color);
            text-transform: capitalize;
        }

        .static-list-pedidos .po-item {
            display: flex;
            padding: .7rem;
            gap: .5rem;
            border-bottom: 1px dashed var(--c-low-gray-color);
        }

        .static-list-pedidos .po-item .img {
            background-color: var(--c-gray-color);
            padding: .5rem;
            border-radius: .5rem;
        }

        .static-list-pedidos .po-item .img img {
            width: 100%;
            max-width: 80px;
        }

        .static-list-pedidos .po-item .description {
            flex-grow: 1;
        }

        .static-list-pedidos .po-item .description .info {
            display: flex;
            flex-direction: column;
            gap: .2rem;
            margin-bottom: .2rem
        }

        .static-list-pedidos .po-item .description .info .price {
            color: var(--text-paragrap-color);
        }

        .static-list-pedidos .po-item .description .actions {
            display: flex;
            justify-content: space-between;
        }

        .static-list-pedidos .po-item .description .actions .quantity {
            background-color: var(--c-gray-color);
            display: flex;
            gap: .5rem;
            padding: 0rem .5rem;
            border-radius: .75rem;
        }

        .bootstrap-select .dropdown-menu .active > a,
        .bootstrap-select .dropdown-menu .active > a:focus,
        .bootstrap-select .dropdown-menu .active > a:hover {
            background-color: #007bff !important;
            color: #fff !important;
        }

        select:focus option:checked,
        select option:checked {
            background: #007bff;
            color: #fff;
        }

        body.split-mode .po-item-wrapper .cantidad .qty,
        body.split-mode .po-item-wrapper .cantidad span:nth-child(2) {
        display: inline-block;
        min-width: 2.4rem;
        text-align: center;
        padding: .1rem .35rem;
        border: 1px solid #888;
        border-radius: 10px;
        background: #f7f7f7;
        user-select: none;
        }
        body.split-mode .po-item-wrapper .cantidad .qty.complete,
        body.split-mode .po-item-wrapper .cantidad span:nth-child(2).complete {
        background: #e6ffe6;
        border-color: #2b8a3e;
        color: #1b5e20;
        }

        /* === NUEVO: resaltar todo el ítem seleccionado === */
        body.split-mode .po-item-wrapper.split-selected,
        body.split-mode .po-item-wrapper.split-selected .po-item {
        background: #e6f2ff !important;           /* celeste suave */
        transition: background-color .15s ease-in;
        }
        body.split-mode .po-item-wrapper.split-selected {
        border-radius: 8px;
        }


        /* =================== BASE =================== */
.tipo_documento{
  display:flex;
  flex-direction:column;
  gap:1rem;
  padding:1rem;
  flex-wrap:wrap;                 /* << permite que los grupos bajen de línea */
}

/* “Segmented control” */
.tipo_documento .doc-tabs{
  display:inline-flex; align-items:center; padding:4px;
  background:#fff; border:1px solid var(--bd); border-radius:12px;
  flex-wrap:wrap;                 /* << por si hay muchas tabs */
  overflow:hidden;
}
.tipo_documento .doc-tab{
  background:transparent; color:var(--txt-600); font-weight:600;
  border:0; border-radius:8px; padding:.35rem .75rem; margin:0 .125rem;
  letter-spacing:.2px; line-height:1.2;
}
.tipo_documento .doc-tab input{ display:none; }

/* estados */
.tipo_documento .doc-tab:hover{ background:#f1f5f9; color:var(--txt-900); }
.tipo_documento .doc-tab.active,
.tipo_documento .doc-tab[aria-pressed="true"]{
  background:var(--pri-600); color:#fff;
  box-shadow:0 0 0 3px rgba(79,70,229,.15);
}
.tipo_documento .doc-tab.disabled{ opacity:.5; pointer-events:none; }

/* =================== DESKTOP (≥992px) =================== */
@media (min-width: 992px){
  .tipo_documento{
    flex-direction:row;
    align-items:center;
    justify-content:flex-start;   /* antes: space-between (empujaba fuera el select) */
    gap:.75rem 1rem;
  }

  /* Clave para que los hijos puedan encoger y/o saltar de línea */
  .tipo_documento > .btn-group,
  .tipo_documento > .d-flex { min-width:0; }

  /* Grupo 1: Botones (flexible) */
  .tipo_documento > .btn-group { flex:1 1 260px; }

  /* Grupo 2: Checkboxes (flexible y centrado) */
  .tipo_documento > .d-flex:first-of-type{
    flex:1 1 220px;
    justify-content:center;
    gap:1rem !important;
  }

  /* Grupo 3: Select (encoge sin desbordar) */
  .tipo_documento > .d-flex:last-of-type{
    flex:0 1 200px;
    min-width:160px;
  }
}

/* =================== TABLET (768–991px) =================== */
@media (min-width: 768px) and (max-width: 991px){
  .tipo_documento{ flex-direction:column; gap:1.5rem; align-items:center; }
  .tipo_documento > .btn-group{ align-self:center; }
  .tipo_documento > .d-flex:first-of-type{ justify-content:center; gap:2rem !important; }
  .tipo_documento > .d-flex:last-of-type{ justify-content:center; min-width:250px; }
}

/* =================== MÓVIL (<768px) =================== */
@media (max-width: 767px){
  .tipo_documento{ flex-direction:column; gap:2rem; padding:1rem .5rem; }

  /* Grupo 1: Botones apilados */
  .tipo_documento > .btn-group{ flex-direction:column !important; width:100%; }
  .tipo_documento > .btn-group .btn{
    border-radius:4px !important; margin-bottom:8px; width:100%;
    min-height:45px; font-size:14px;
  }
  .tipo_documento > .btn-group .btn:not(:last-child){ border-bottom:1px solid #dee2e6; }

  /* Grupo 2: Checkboxes apilados */
  .tipo_documento > .d-flex:first-of-type{
    flex-direction:column !important; gap:1rem !important; align-items:flex-start;
  }
  .tipo_documento > .d-flex:first-of-type > div{
    width:100%; padding:.75rem; background:rgba(0,0,0,.02);
    border-radius:6px; border:1px solid rgba(0,0,0,.1);
  }

  /* Grupo 3: Select a ancho completo */
  .tipo_documento > .d-flex:last-of-type{ width:100%; }
  .tipo_documento select{ width:100% !important; min-height:45px; }

  /* Labels más legibles */
  .tipo_documento label{ font-size:14px !important; line-height:1.4; }

  /* bootstrap-select ancho completo en móvil */
  .tipo_documento .bootstrap-select{ width:100% !important; }
}

/* =================== EXTRAS UX =================== */
.tipo_documento, .tipo_documento > *, .tipo_documento .btn{ transition:all .3s ease; }
.tipo_documento .btn:hover{ transform:translateY(-2px); box-shadow:0 4px 8px rgba(0,0,0,.15); }

/* hover para “por consumo” */
.display_venta_por_consumo{ transition:background-color .2s ease; cursor:pointer; }
.display_venta_por_consumo:hover{ background-color:rgba(0,123,255,.05) !important; }

/* Títulos opcionales en móvil */
.grupo-titulo{
  display:none; font-size:.875rem; font-weight:600; color:#6c757d;
  text-align:center; margin-bottom:.75rem; text-transform:uppercase; letter-spacing:.5px;
}
@media (max-width: 767px){ .grupo-titulo{ display:block; } }

/* bootstrap-select: evitar desbordes también en desktop */
.tipo_documento .bootstrap-select{ max-width:100%; }
.tipo_documento .bootstrap-select > .dropdown-toggle{
  width:100%; text-overflow:ellipsis; white-space:nowrap; overflow:hidden;
}

/* =================== DEBUG (opcional) =================== */
.debug-mode .tipo_documento > *{
  border:2px dashed #007bff; position:relative; padding:1rem; margin:.30rem;
}
.debug-mode .tipo_documento > .btn-group::before{
  content:"GRUPO 1: Tipos de Documento";
  position:absolute; top:-10px; left:10px; background:#007bff; color:#fff;
  font-size:10px; padding:2px 6px; border-radius:3px;
}
.debug-mode .tipo_documento > .d-flex:first-of-type::before{
  content:"GRUPO 2: Checkboxes";
  position:absolute; top:-10px; left:10px; background:#28a745; color:#fff;
  font-size:10px; padding:2px 6px; border-radius:3px;
}
.debug-mode .tipo_documento > .d-flex:last-of-type::before{
  content:"GRUPO 3: Select";
  position:absolute; top:-10px; left:10px; background:#dc3545; color:#fff;
  font-size:10px; padding:2px 6px; border-radius:3px;
}

@media (min-width: 1200px){
  /* Que el grupo del select tome todo el sobrante */
  .tipo_documento > .d-flex:last-of-type{
    flex: 1 1 0;
    min-width: 320px;
    width: 100%;
  }

  /* Tabs y checkboxes mantienen su tamaño natural */
  .tipo_documento > .btn-group,
  .tipo_documento > .d-flex:first-of-type{
    flex: 0 0 auto;
  }

  /* bootstrap-select a ancho completo */
  .tipo_documento .bootstrap-select{
    width: 100% !important;
    max-width: 100%;
  }
  .tipo_documento .bootstrap-select > .dropdown-toggle{
    width: 100%;
    text-overflow: ellipsis;
    white-space: nowrap;
    overflow: hidden;
  }
}


  
    /* === MODERN SUCCESS BUTTON === */
    .btn-success-modern {
        background: linear-gradient(135deg, var(--success-color) 0%, #0ea332 100%) !important;
        border: none !important;
        box-shadow: 0 4px 15px rgba(27, 201, 67, 0.3) !important;
        color: white !important;
        border-radius: 6px;
        padding: 0.6rem 1.2rem;
        font-weight: 500;
        transition: var(--transition);
    }
    .btn-success-modern:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 20px rgba(27, 201, 67, 0.4) !important;
    }

    /* [MODERN DIALOG REDESIGN] */
    .modern-dialog {
        padding: 24px !important;
        background: #ffffff !important;
        border: none !important;
        border-radius: 16px !important;
        box-shadow: 0 10px 40px rgba(0,0,0,0.15), 0 0 0 1px rgba(0,0,0,0.02) !important;
        width: 380px;
        max-width: 90vw;
        color: #334155;
        animation: dialog-pop 0.3s cubic-bezier(0.34, 1.56, 0.64, 1);
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%); /* Centering fallback if not using native dialog mechanics perfectly */
        margin: 0; 
    }
    
    .modern-dialog::backdrop {
        background: rgba(15, 23, 42, 0.4);
        backdrop-filter: blur(4px);
    }

    .modern-dialog .table { margin-bottom: 20px; }
    .modern-dialog .table th {
        border: none !important;
        padding: 8px 0 !important;
        vertical-align: middle;
        font-weight: 500;
        color: #64748b;
        font-size: 0.9rem;
        width: 45%;
        padding-right: 15px !important;
    }

    /* Modern Inputs in Dialog */
    .modern-dialog .form-control,
    .modern-dialog select.form-control {
        background: #f8fafc;
        border: 1px solid #e2e8f0;
        border-radius: 8px;
        padding: 8px 12px;
        font-size: 0.9rem;
        transition: all 0.2s;
        color: #1e293b;
        height: auto !important;
    }

    .modern-dialog .form-control:focus,
    .modern-dialog select.form-control:focus {
        background: white;
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(86, 100, 210, 0.1);
        outline: none;
    }

    .modern-dialog .input-group-text {
        background: #f1f5f9;
        border: 1px solid #e2e8f0;
        border-left: none;
        color: #64748b;
        border-radius: 0 8px 8px 0;
        font-size: 0.85rem;
        font-weight: 600;
    }
    
    .modern-dialog .input-group .form-control { 
        border-radius: 8px 0 0 8px !important; 
    }

    /* Buttons Container */
    .modern-dialog div:last-child {
        display: flex;
        justify-content: flex-end;
        gap: 12px;
        margin-top: 15px;
        padding-top: 20px;
        border-top: 1px solid #f1f5f9;
    }

    .modern-dialog .btn-secondary {
        background: white;
        border: 1px solid #e2e8f0;
        color: #64748b;
        border-radius: 8px;
        padding: 8px 16px;
        font-size: 0.9rem;
        font-weight: 500;
    }

    .modern-dialog .btn-secondary:hover {
        background: #e2e8f0 !important;
        color: #334155 !important;
        border-color: #cbd5e1 !important;
    }

    /* Specific text tweaks */
    .modern-dialog .link {
        color: var(--primary-color);
        font-weight: 600;
        text-decoration: none;
    }
    .modern-dialog .link:hover { text-decoration: underline; }


    /* === PAYMENT GRID SYSTEM === */
    .payment-grid {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 12px;
        padding: 10px;
        background: #f8fafc;
        border: 1px solid #e2e8f0;
        border-radius: 12px;
        margin-top: 15px;
    }
    
    .payment-item {
        display: flex;
        flex-direction: column;
    }
    
    .payment-item label {
        font-size: 0.75rem;
        font-weight: 600;
        color: #64748b;
        margin-bottom: 4px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .payment-item .input-group-text {
        background: white;
        border: 1px solid #e2e8f0;
        border-right: none;
        color: #64748b;
        font-size: 0.85rem;
    }
    
    .payment-item .form-control {
        border-color: #e2e8f0;
        height: 38px;
        font-weight: 600;
        color: #334155;
    }

    .payment-summary {
        margin-top: 15px;
        background: white;
        border-radius: 12px;
        overflow: hidden;
        border: 1px solid #e2e8f0;
    }
    
    .payment-summary-row {
        display: flex;
        justify-content: space-between;
        padding: 10px 15px;
        border-bottom: 1px solid #f1f5f9;
        font-size: 0.9rem;
        color: #64748b;
    }
    .payment-summary-row:last-child { border-bottom: none; }
    
    .payment-summary-row.total {
        background: #f8fafc;
        color: var(--dark-color);
        font-weight: 700;
        font-size: 1rem;
    }

    /* === DOCUMENT TABS FIX === */
    .doc-tab.active {
        background: var(--primary-color) !important;
        color: white !important;
        border-color: var(--primary-color) !important;
        box-shadow: 0 4px 10px rgba(86,100,210,0.3);
    }
    .doc-tab input { display: none; }

    /* === CONTROLS ROW === */
    .controls-row {
        display: flex;
        align-items: center;
        gap: 15px;
        flex-wrap: wrap;
        margin-bottom: 15px;
        background: #fff;
        padding: 10px;
        border-radius: 12px;
        border: 1px solid #f1f5f9;
    }

    @media (max-width: 576px) {
        .payment-grid { grid-template-columns: 1fr; }
        .controls-row { flex-direction: column; align-items: stretch; }
    }


    /* === LAYOUT FIXES === */
    .place-order {
        display: flex;
        flex-direction: column;
        height: 100%;
    }
    .po-items {
        flex: 1;
        overflow-y: auto;
        width: 100%;
        padding: 0 5px;
    }

    /* === PRODUCT ITEM STYLES === */
    .po-item {
        width: 100%;
        background: white;
        border: none;
        border-bottom: 1px dotted #ccc;
        padding: 5px 0;
        text-align: left;
        transition: background 0.2s;
        outline: none !important;
        margin-bottom: 0;
        border-radius: 0;
    }
    .po-item:hover { background: #f9f9f9; }
    
    /* Name Styling */
    .po-item .name {
        font-weight: 600;
        color: #333;
        font-size: 0.95rem;
        text-transform: uppercase;
        line-height: 1.2;
    }

    /* Price Styling */
    .po-item .price {
        font-weight: 700;
        color: #333;
        font-size: 1rem;
        white-space: nowrap;
    }

    /* Quantity Controls */
    .po-item .cantidad {
        display: flex;
        align-items: center;
        gap: 2px;
    }
    
    .po-item .cantidad span {
        font-weight: 600;
        color: #333;
        font-size: 0.95rem;
        min-width: 25px;
        text-align: center;
    }
    
    .po-item .cantidad .up, 
    .po-item .cantidad .down {
        cursor: pointer;
        width: 28px;
        height: 28px;
        display: flex;
        align-items: center;
        justify-content: center;
        border: 1px solid #ccc;
        background: #fff;
        color: #555;
        border-radius: 4px;
        font-weight: bold;
    }
    .po-item .cantidad .up:hover, 
    .po-item .cantidad .down:hover {
        background: #e9ecef;
        border-color: #bbb;
    }

    /* Edit/Delete buttons - Restore colors */
    .po-item .edit_precio, 
    .po-item .comments, 
    .po-item .remove-item {
        padding: 5px 8px;
        border-radius: 4px;
        cursor: pointer;
        transition: all 0.2s;
        border: 1px solid #e1e1e1;
        background: #fff;
        margin-right: 4px;
        font-size: 0.9rem;
    }
    /* Explicitly set colors matching original design */
    .po-item .edit_precio { color: #007bff; border-color: #b3d7ff; }
    .po-item .comments { color: #fd7e14; border-color: #ffeeba; }
    .po-item .remove-item { color: #dc3545; border-color: #f5c6cb; }

    .po-item .edit_precio:hover { background: #e7f1ff; }
    .po-item .comments:hover { background: #fff3cd; }
    .po-item .remove-item:hover { background: #f8d7da; }

    /* Safety wrapper fix */
    .po-item-wrapper {
        width: 100% !important;
        display: block !important;
        position: relative;
        clear: both;
    }

    #content_pagos, #botones_pedido, .po-confirm {
        width: 100% !important;
        flex-shrink: 0;
    }

    /* Hide legacy totals since they are now in the grid */
    .place-order .sub-total, 
    .place-order .total {
        display: none !important;
    }

    @keyframes dialog-pop {
        from { opacity: 0; transform: translate(-50%, -45%) scale(0.95); }
        to { opacity: 1; transform: translate(-50%, -50%) scale(1); }
    }

  </style>
</head>
<body>



<input type="hidden" id="url" value="<?php echo URL; ?>" />
    
<script>
    $(document).ready(function() {
        // RUC/DNI Placeholder Logic based on Document Type
        function updatePlaceholder() {
            // Find the active label text
            var activeLabel = $('.doc-tab.active').text().trim().toLowerCase();
            var $input = $('#buscar_cliente_pedido');
            var currentVal = $input.val();
            
            if (activeLabel.includes('factura')) {
                $input.attr('placeholder', 'Ingrese Nro RUC...');
                // If value is default generic (DNI 0), clear it so user sees prompt
                if(currentVal.indexOf('00000000') !== -1 || currentVal.toUpperCase().indexOf('PUBLICO') !== -1) {
                    $input.val('');
                }
            } else if (activeLabel.includes('boleta') || activeLabel.includes('nota')) {
                $input.attr('placeholder', 'Ingrese DNI o Nombre...');
            } else {
                $input.attr('placeholder', 'Buscar cliente...');
            }
        }

        // Listen for changes on the radio buttons
        $(document).on('change', 'input[name="tipo_doc"]', function() {
            var selectedText = $(this).closest('label').text().trim().toLowerCase();
             var $input = $('#buscar_cliente_pedido');
             var currentVal = $input.val();

            if (selectedText.includes('factura')) {
                $input.attr('placeholder', 'Ingrese Nro RUC...');
                 // If switching to Factura and current customer is Generic/Invalid for Factura, clear it
                 if(currentVal.indexOf('00000000') !== -1 || currentVal.toUpperCase().indexOf('PUBLICO') !== -1) {
                    $input.val('').focus();
                }
            } else {
               $input.attr('placeholder', 'Ingrese DNI o Nombre...');
            }
        });
        
        // Initial check
        setTimeout(function(){
            updatePlaceholder();
        }, 500); // Wait for potential auto-fill

        // === MOZO ICON LOGIC ===
        // Update tooltip text when select changes
        $(document).on('change', '#select_mozo select', function() {
            var selectedName = $(this).find('option:selected').text();
            $('#mozo-name-tooltip').text(selectedName);
        });

        // Hover effect for icon
        $('.mozo-icon-wrapper').hover(function() {
            // Update name just in case
            var $sel = $('#select_mozo select');
            if($sel.length) {
                var selectedName = $sel.find('option:selected').text();
                $('#mozo-name-tooltip').text(selectedName);
            }
            $('#mozo-name-tooltip').stop(true, true).fadeIn(200);
        }, function() {
            $('#mozo-name-tooltip').stop(true, true).fadeOut(200);
        });

        // Wait for dynamic select injection
        var checkMozoInterval = setInterval(function() {
            var $sel = $('#select_mozo select');
            if ($sel.length) {
                // Initialize text
                var selectedName = $sel.find('option:selected').text();
                $('#mozo-name-tooltip').text(selectedName);
                clearInterval(checkMozoInterval);
                
                // Ensure select is transparent but clickable
                $sel.css({
                    'opacity': '0',
                    'width': '100%',
                    'height': '100%',
                    'cursor': 'pointer',
                    'appearance': 'none'
                });
            }
        }, 500);

    });
</script>
<input type="hidden" id="rol_usr" value="<?php echo Session::get('rol'); ?>" />
<input type="hidden" id="fecha" value="<?php echo $fecha; ?>" />
<input type="hidden" id="hora" value="<?php echo $hora; ?>" />
<input type="hidden" id="cod_ape" value="<?php echo Session::get('aperturaIn'); ?>" />
<input type="hidden" id="moneda" value="<?php echo Session::get('moneda'); ?>" />
<input type="hidden" id="pc_ip" value="<?php echo Session::get('pc_ip'); ?>" />
<input type="hidden" id="pc_name" value="<?php echo Session::get('pc_name'); ?>" />
<input type="hidden" id="print_com" value="<?php echo Session::get('print_com'); ?>" />
<input type="hidden" id="tribAcr" value="<?php echo Session::get('tribAcr'); ?>" />
<input type="hidden" id="diAcr" value="<?php echo Session::get('diAcr'); ?>" />
<input type="hidden" id="api_wsp" value="<?php echo Session::get('api_wsp'); ?>" />
<input type="hidden" name="codtipoped" id="codtipoped" value="1" />
<input type="hidden" name="codpagina" id="codpagina" value="1" />
<input type="hidden" id="codpestdelivery" value="" />
<input type="hidden" id="codsalonorigen" value="" />
<input type="hidden" id="codmesaorigen" value="" />
<input type="hidden" id="codigo_anular_venta" value="<?php echo $codigo_anular_venta; ?>" />
<input type="hidden" id="direccion_comanda" value="<?= Session::get('direccion_comanda') ?>" />
<input type="hidden" id="pedido_comanda" value="<?= Session::get('pedido_comanda') ?>" />
<input type="hidden" id="imp_icbper" value="<?php echo Session::get('imp_val_bol'); ?>" />
<input type="hidden" id="verpdf" value="<?php echo Session::get('verpdf'); ?>" />
<input type="hidden" id="limits_invoices" value="<?php echo $this->Invoice['limits']['total_invoices']; ?>" />
<input type="hidden" id="current_invoices" value="<?php echo $this->Invoice['current']['total_invoices']; ?>" />
<input type="hidden" id="locked_invoices" value="<?php echo $this->Invoice['locked_invoices']; ?>" />
<input type="hidden" id="id_pedido" value=0 />
<input type="hidden" id="codrepartidor" value="1" />
<input type="hidden" id="igv" value="<?php echo Session::get('igv'); ?>" />
<input type="hidden" id="codimpcomandamesa" value="<?php echo Session::get('opc_03'); ?>" />
<input type="hidden" id="mozos_data" value='<?= json_encode($this->Mozo) ?>'>
<input type="hidden" id="dato_usuario" value="<?= Session::get('nombres') ?>" />
<input type="hidden" id="permisoEditarPrecio" value="<?= Session::get('editarprecio') ?>" />
<input type="hidden" id="comision_tarjeta" value="<?= Session::get('comision_tarjeta') ?>" />
<input type="hidden" id="impresion_automatica_comanda" value="<?= Session::get('impresion_automatica_comanda') ?>" />
<input type="hidden" id="salon" value="" />
<input type="hidden" id="mesa" value="" />

<?php
$documentos = isset($this->TipoDocumento) && is_array($this->TipoDocumento)
    ? $this->TipoDocumento
    : [];

$result = array_filter($documentos, fn($d) => (int) $d['defecto'] === 1);
$porDefecto = reset($result) ?: [];
$defaultId = $porDefecto['id_tipo_doc'] ?? '';
?>
<input
  type="hidden"
  id="tipo_doc_defecto"
  value="<?= htmlspecialchars($defaultId, ENT_QUOTES) ?>"
/>

<!-- Contenedor a TODO el ancho -->
<div class="container-fluid px-3 px-md-4 my-4">
  <div class="card shadow-sm border-0 w-100">
    <!-- Header -->
    <div class="card-header bg-white border-0 py-3 sticky">
      <div class="d-flex align-items-center justify-content-between mb-2">
        <h5 class="mb-0">Pedidos</h5>
      </div>

      <!-- Una línea: búsqueda (izq), filtros (der), botón Nuevo extremo der -->
      <div class="toolbar d-flex align-items-center">
        <!-- Búsqueda -->
        <div class="search-wrap">
          <input id="searchInput" class="form-control" placeholder="Buscar mesa, mozo, ítem...">
        </div>

        <!-- Filtros -->
        <div class="filters-wrap ml-auto">
          <select id="salonFilter" class="form-control">
            <option value="">Todos los salones</option>
            <option>Principal</option>
            <option>Terraza</option>
            <option>Segundo piso</option>
          </select>
          <select id="sortBy" class="form-control">
            <option value="age_desc">Más antiguos</option>
            <option value="priority_desc">Mayor prioridad</option>
            <option value="total_desc">Mayor total</option>
          </select>
        </div>

        <!-- Botón Nuevo -->
        <button id="btnNuevo" class="btn btn-primary btn-new ml-2">
          <span class="plus">+</span> Nuevo
        </button>
      </div>

      <!-- Tabs -->
      <ul class="nav nav-pills mt-3" id="statusTabs" role="tablist">
        <li class="nav-item">
          <a class="nav-link active" data-toggle="pill" href="#tab-prep">En preparación
            <span class="badge badge-warning ml-1" id="count-preparacion">0</span>
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" data-toggle="pill" href="#tab-listo">Entregado
            <span class="badge badge-success ml-1" id="count-listo">0</span>
          </a>
        </li>
      </ul>
    </div>

    <!-- Body -->
    <div class="card-body pt-0">
      <div class="tab-content">
        
        <div class="tab-pane fade show active" id="tab-prep">
          <div id="list-preparacion" class="grid"></div>
        </div>
        <div class="tab-pane fade" id="tab-listo">
          <div id="list-listo" class="grid"></div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Toast feedback 
<div id="toast-wrap" class="toast-wrap">
  <div id="toast" class="toast bg-dark text-white border-0" role="alert" aria-live="assertive" aria-atomic="true" data-delay="2000" data-autohide="true">
    <div class="d-flex">
      <div class="toast-body" id="toast-body">Listo.</div>
      <button type="button" class="ml-2 mb-1 close text-white" data-dismiss="toast" aria-label="Cerrar">
        <span aria-hidden="true">&times;</span>
      </button>
    </div>
  </div>
</div>
-->
<div class="modal fade bd-example-modal-xl" tabindex="-1" role="dialog" aria-labelledby="myExtraLargeModalLabel" aria-hidden="true" id="modal-pedidos">
    <div class="modal-dialog custom-modal" style="margin:auto">
        <div class="modal-content">
            <div class="card mb-0 c-bg-gray">
                <div class="card-body bg-menu-panel c-title-color slice-wraper">
                    <div class="row">
                        <div class="col-xs-12 col-md-7 modal-order-left">
                            <div class="menu bg-white c-small-font-size card mb-0">
                                <div class="section-date" style="display:none;">
                                    <div class="lb-btn">
                                        <span class="icon"><i class="far fa-calendar"></i></span>
                                        <span>Mier 9 May 2024</span>
                                    </div>
                                    <span>-</span>
                                    <div class="lb-btn">
                                        <span class="icon"><i class="far fa-clock"></i></span>
                                        <span>07:59 AM</span>
                                    </div>
                                    <div class="ml-auto">
                                        <button class="btn btn-primary">
                                            <span>
                                                <i class="fas fa-sync-alt"></i>
                                            </span>
                                        </button>
                                    </div>
                                </div>
                                <div class="section-category">
                                    
                                    <div class="list-categories">

                                    </div>
                                </div>
                                <div class="section-search">
                                    <div class="search-input">
                                        <input type="text" id="input-buscar-carta" placeholder="Buscar dentro de la carta">
                                        <span>
                                            <i class="fa fa-search" aria-hidden="true"></i>
                                        </span>
                                    </div>
                                    <div class="change-mode btn-group">
                                        <button class="btn btn-primary"><span><i class="fas fa-th"></i></span></button>
                                        <button class="btn btn-secondary"><span><i class="fas fa-list-ul"></i></span></button>
                                    </div>
                                </div>
                                <div class="section-list">

                                </div>
                                
                                <div class="hidden-md-up">
                                    <button class="btn btn-primary w-100" id="ver_seleccionados" style="padding:1rem;">ver seleccionados</button>
                                </div>
                            </div>
                        </div>

                        <!-- Agregar JS para mostrar aside-right del modal de pedidos, en mobile -->
                        <div class="col-xs-12 col-md-5 modal-order-right">
                            <div class="place-order c-small-font-size card">
                                <div class="po-header text-white">
                                    <div class="icon">
                                        <!-- Botón para ocultar el aside-right en mobile -->
                                        <button onclick="closeModalOrder()"><i class="fas fa-arrow-left"></i></button>
                                    </div>
                                    <div class="info">
                                        <span id="info_mesa"></span>
                                        <span>Orden #000</span>
                                    </div>
                                <div class="d-flex align-items-center gap-2">

                                    <?php if (Session::get('rol') == 5): ?>
                                        
                                                <!-- Botón cancelar pedido -->
                                                <button
                                                id="btn_cancelar_pedido_mozo" 
                                                type="button" 
                                                class="btn btn-sm btn-outline-light"
                                                title="Cancelar el pedido">
                                                <i class="fas fa-ban"></i>
                                                </button>

                                                <!-- Botón dropdown para imprimir comandas -->
                                                <div class="dropdown">
                                                <button
                                                    class="btn btn-sm btn-outline-light dropdown-toggle"
                                                    type="button"
                                                    id="btn_dropdown_comandas_mozo"
                                                    data-toggle="dropdown"
                                                    aria-haspopup="true"
                                                    aria-expanded="false"
                                                    title="Imprimir comandas">
                                                    <i class="fas fa-print"></i>
                                                </button>
                                                <div class="dropdown-menu" aria-labelledby="btn_dropdown_comandas_mozo" id="imprimir_comandas_mozo">
                                                    <!-- Aquí se inyectarán las opciones desde listarComandas(...) -->
                                                </div>
                                                </div>

                                    <?php endif; ?>

                                    <!-- Botón cerrar -->
                                    <button 
                                        type="button" 
                                        class="btn btn-sm btn-outline-light" 
                                        id="btn_close_aside"
                                        title="Cerrar">
                                        &times;
                                    </button>

                                </div>
                                </div>

                                <div class="tipo_documento" style="display: none;">
                                    <!-- Header Row: Tabs + Mozo Icon -->
                                    <div class="d-flex justify-content-between align-items-center w-100 mb-0"> <!-- Reduced MB -->
                                        <div class="btn-group btn-group-sm btn-group-toggle doc-tabs" data-toggle="buttons">
                                            <?php
                                            $tdoc_defecto = null;
                                            foreach ($this->TipoDocumento as $t) {
                                                if (($t['defecto'] ?? '0') === '1') { $tdoc_defecto = $t['id_tipo_doc']; break; }
                                            }
                                            foreach ($this->TipoDocumento as $t):
                                                $isDefault = ($t['id_tipo_doc'] == $tdoc_defecto);
                                            ?>
                                            <label class="btn doc-tab <?php echo $isDefault ? 'active' : ''; ?>">
                                                <input type="radio" name="tipo_doc"
                                                    value="<?php echo $t['id_tipo_doc']; ?>"
                                                    autocomplete="off" <?php echo $isDefault ? 'checked' : ''; ?>>
                                                <?php echo ($t['id_tipo_doc'] == 1) ? 'BOLETA' : $t['descripcion']; ?>
                                            </label>
                                            <?php endforeach; ?>
                                        </div>

                                        <!-- Mozo Icon Selector (Right Aligned) -->
                                        <div class="mozo-icon-wrapper position-relative d-flex justify-content-center align-items-center" 
                                             style="width: 40px; height: 40px; cursor: pointer;" 
                                             title="Seleccionar Mozo">
                                            
                                            <i class="fas fa-user text-secondary" style="font-size: 1.5rem;"></i>
                                            
                                            <div id="select_mozo" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; opacity: 0; overflow: hidden; z-index: 10;">
                                                <!-- JS injects select here -->
                                            </div>
                                            
                                            <div id="mozo-name-tooltip" style="display:none; position: absolute; top: 110%; right: 0; background: #333; color: #fff; padding: 5px 10px; border-radius: 4px; font-size: 12px; white-space: nowrap; z-index: 100;">
                                                Mozo
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Controls Row: Payment Type etc. -->
                                    <div class="controls-row mb-0 mt-1"> <!-- Reduced spacing -->
                                        <div class="d-flex align-items-center" style="gap:15px">
                                            <div class="display_venta_por_consumo">
                                                <input type="checkbox" name="venta_por_consumo" id="venta_por_consumo" class="lever switch-col-light-green venta_por_consumo" />
                                                <label for="venta_por_consumo" style="color:#64748b;font-size:12px;margin:0">POR CONSUMO</label>
                                            </div>
                                            <div class="display_venta_por_consumo">
                                                <input type="checkbox" name="comision_tarjeta_venta" id="comision_tarjeta_venta" class="lever switch-col-light-green comision_tarjeta_venta" />
                                                <label for="comision_tarjeta_venta" style="color:#64748b;font-size:12px;margin:0">COM TARJETA</label>
                                            </div>
                                        </div>
                                        <div style="flex:1; min-width: 200px;">
                                            <select class="selectpicker" name="tipo_pago" id="tipo_pago" data-style="form-control btn-primary" data-width="100%" data-size="4" data-live-search-style="begins" data-live-search="true" autocomplete="off">
                                                <?php foreach ($this->TipoPago as $key => $value): ?>
                                                    <option style="font-size:12px" label="<?php echo $value['id_pago']; ?>" value="<?php echo $value['id_tipo_pago']; ?>"><?php echo $value['descripcion']; ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <!-- Client Row -->
                                    <div class="po-filters d-flex align-items-center mb-1 mt-1" style="gap: 10px;"> <!-- Reduced spacing -->
                                        
                                        <div style="flex: 1;">
                                            <input type="hidden" name="cliente_pedido_id" id="cliente_pedido_id" value="1" />
                                            <input type="hidden" name="cliente_pedido_doc" id="cliente_pedido_doc" value="1" />
                                            <input type="hidden" name="cliente_pedido_nombres" id="cliente_pedido_nombres" value="1" />
                                            <input type="hidden" name="cliente_pedido_tipo" id="cliente_pedido_tipo" value="1" />
                                            <div class="input-group input-group-sm w-100">
                                                <div class="opcion-cliente-pedido input-group-prepend">
                                                    <a class="input-group-prepend" href="javascript:void(0)" data-original-title="Registrar nuevo cliente" data-toggle="tooltip" data-placement="top">
                                                        <span class="input-group-text bg-header">
                                                            <small>
                                                            <i class="fas fa-user-plus"></i>
                                                        </small>
                                                    </span>
                                                </a>
                                            </div>
                
                                                <input type="text" class="form-control" name="buscar_cliente_pedido" id="buscar_cliente_pedido" autocomplete="off" placeholder="Buscar cliente...">
                                                <a class="input-group-append" href="javascript:void(0)" id="btnClientePedidoLimpiar" data-original-title="Limpiar datos" data-toggle="tooltip" data-placement="top">
                                                    <span class="input-group-text bg-header">
                                                        <small><i class="fas fa-times link-danger"></i></small>
                                                    </span>
                                                </a>
                                            </div>
                                        </div>
                                    
                                    <div class="c-custom-select" id="select_mozo" style="display: none;">
                                        <!-- Removed from here, moved to header -->
                                    </div>
                                </div>
                                </div> <!-- END tipo_documento -->
                                
                                <div class="po-items" id="list-pedidos">

                                </div>

                                <div id="static-list-pedidos" class="static-list-pedidos" style="display: none;">
                                    
                                    <button type="button" class="po-item collapsible">
                                    <div class="description">
                                    <div class="info">
                                        <span class="name">
                                        POR CONSUMO
                                        
                                        </span>
                                        <span class="price">0.00</span>
                                    </div>
                                    <div class="actions">
                                        <div style="display:flex;align-items:center;gap:.5rem">
                                        <span class="edit_precio" title="Editar pedido" style="padding:4px 8px;border:1px solid #ddd;border-radius:4px;
                                                    color:blue;background-color:#fff">
                                            <i class="fas fa-pencil-alt"></i>
                                        </span>
                                        <span class="comments" title="Agregar comentario" style="padding:4px 8px;border:1px solid #ddd;border-radius:4px;
                                                    color:darkorange;background-color:#fff">
                                            <i class="fas fa-comment-alt"></i>
                                        </span>
                                        <span class="remove-item" title="Quitar de la lista" style="padding:4px 8px;border:1px solid #ddd;border-radius:4px;
                                                    color:red;background-color:#fff">
                                            <i class="fas fa-trash"></i>
                                        </span>
                                        </div>
                                        <div class="texto-intermedio" style="margin: 0.5rem 0; font-weight: bold; color: #555;"></div>
                                        <div class="cantidad" style="display:flex;align-items:center;gap:.5rem">
                                        <span class="down" style="padding:4px 8px;border:1px solid #999;border-radius:4px;
                                                    background-color:#fff">-</span>
                                        <span>1</span>
                                        <span class="up" style="padding:4px 8px;border:1px solid #999;border-radius:4px;
                                                    background-color:#fff">+</span>
                                        </div>
                                    </div>
                                    </div>
                                </button>

                                </div>

                                <div class="d-flex justify-content-around" id="totales_tipo_pago">
                                    <div style="width:100%">
                                    <div class="mensaje-pago" style="display: none;"></div>

                                    <div id="content_pagos" style="display: none; width: 100%;">
                                        
                                        <div class="payment-grid d-flex gap-2 w-100">
                                            <!-- Voucher Code -->
                                            <div class="payment-item display-cod-voucher flex-fill">
                                                <label>COD VOUCHER</label>
                                                <input type="text" class="form-control form-control-sm display-cod-voucher w-100" name="cod_voucher" id="cod_voucher" autocomplete="off" placeholder="Código..." />
                                            </div>

                                            <!-- Effective (Cash) -->
                                            <div class="payment-item display-pago-efectivo flex-fill">
                                                <label>Efectivo (<?php echo Session::get('moneda'); ?>)</label>
                                                <div class="input-group input-group-sm w-100">
                                                    <input type="text" class="form-control doble_clic display-pago-efectivo w-100" name="pago_efe" id="pago_efe" autocomplete="off" placeholder="0.00" />
                                                </div>
                                            </div>

                                            <!-- Card -->
                                            <div class="payment-item display-pago-tarjeta flex-fill">
                                                <label>Tarjeta (<?php echo Session::get('moneda'); ?>)</label>
                                                <div class="input-group input-group-sm w-100">
                                                    <input type="text" class="form-control doble_clic display-pago-tarjeta w-100" name="pago_tar" id="pago_tar" value="0.00" autocomplete="off" />
                                                </div>
                                            </div>

                                            <!-- Yape/Wallet -->
                                            <div class="payment-item display-pago-tarjeta flex-fill">
                                                <label>Yape/Plin (<?php echo Session::get('moneda'); ?>)</label>
                                                <div class="input-group input-group-sm w-100">
                                                    <input type="text" class="form-control doble_clic display-pago-tarjeta w-100" name="pago_yape" id="pago_yape" value="0.00" autocomplete="off" />
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Nuevo Grid Horizontal de Totales -->
                                        <!-- Nuevo Grid Horizontal de Totales -->
                                        <div class="d-flex w-100 align-items-center justify-content-end mt-1 pt-0 border-top">
                                            
                                            <!-- Sub Total -->
                                            <div class="mx-3 text-right">
                                                <small class="d-block text-muted font-weight-bold" style="font-size:11px;">Sub Total</small>
                                                <span class="h6 mb-0"><?php echo Session::get('moneda'); ?> <span class="SubtotalPedido">0.00</span></span>
                                            </div>

                                            <!-- Descuento (Dynamic) -->
                                            <div id="row-descuento" class="mx-3 text-right d-none">
                                                <small class="d-block text-muted font-weight-bold" style="font-size:11px;">Descuento</small>
                                                <span class="h6 mb-0 text-danger"><?php echo Session::get('moneda'); ?> <span class="totalDescuento">0.00</span></span>
                                            </div>

                                            <!-- Delivery (Dynamic) -->
                                            <div id="row-delivery" class="mx-3 text-right d-none">
                                                <small class="d-block text-muted font-weight-bold" style="font-size:11px;">Delivery</small>
                                                <span class="h6 mb-0 text-info"><?php echo Session::get('moneda'); ?> <span class="totalDelivery">0.00</span></span>
                                            </div>

                                            <!-- Comisión (Dynamic) -->
                                            <div id="row-comision" class="mx-3 text-right view_comision_tarjeta" style="display:none;">
                                                <small class="d-block text-muted font-weight-bold" style="font-size:11px;">Comisión</small>
                                                <span class="h6 mb-0 text-warning"><?php echo Session::get('moneda'); ?> <span class="comisionTarjeta">0.00</span></span>
                                            </div>

                                            <!-- Monto Total (Mandatory) -->
                                            <div class="mx-3 text-right px-3 border-left border-right bg-light rounded">
                                                <small class="d-block text-dark font-weight-bold" style="font-size:11px;">Monto Total</small>
                                                <span class="h5 mb-0 font-weight-bold text-dark"><?php echo Session::get('moneda'); ?> <span class="totalPedidoMenosTarjeta">0.00</span></span>
                                            </div>

                                            <!-- Vuelto (Mandatory - Green) -->
                                            <div class="ml-3 text-right btn-success-modern rounded px-3 py-1 shadow-sm">
                                                <small class="d-block text-white font-weight-bold" style="font-size:11px;">VUELTO</small>
                                                <span class="h5 mb-0 font-weight-bold text-white"><?php echo Session::get('moneda'); ?> <span id="vuelto">0.00</span></span>
                                            </div>
                                            </div>
                                        </div>

                                        <!-- Buttons moved inside the flow, below summary -->
                                        <!-- Buttons Row: Unified -->
                                        <div class="d-flex align-items-center mt-2 mb-3" id="botones_pedido" style="gap:5px; flex-wrap: nowrap;">
                                            <!-- Botón rojo: Anular -->
                                            <button type="button"
                                                    id="btn_anular_venta"
                                                    class="btn btn-danger d-none"
                                                    style="width:48px; height:48px; border-radius:10px; display:flex; align-items:center; justify-content:center;">
                                                    <i class="fas fa-times"></i>
                                            </button>

                                            <!-- Botón azul: Dividir -->
                                            <button type="button"
                                                    id="btnDividirCuenta"
                                                    class="btn btn-primary d-none"
                                                    style="width:48px; height:48px; border-radius:10px; display:flex; align-items:center; justify-content:center;">
                                                    <i class="fas fa-file-alt"></i>
                                            </button>

                                            <!-- Botón naranja: Descuentos -->
                                            <button type="button"
                                                    id="openDialog"
                                                    class="btn d-none"
                                                    data-toggle="tooltip"
                                                    data-placement="top"
                                                    title="Descuento y comisión"
                                                    style="width:48px; height:48px; border-radius:10px; background:#fdbf79; color:#5f5f5f; display:flex; align-items:center; justify-content:center;">
                                                <i class="fas fa-gift"></i>
                                            </button>

                                            <!-- Botón MAIN (Master Proxy) -->
                                            <button id="btnAccionMaster" class="btn btn-primary d-flex align-items-center justify-content-center shadow-lg px-4" style="height: 48px; min-width: 150px; flex: 0 0 auto; margin: 0 !important;">
                                                <i class="fas fa-save mr-2 fa-lg"></i>
                                                <span style="font-size: 1.1rem; font-weight:600;">PEDIDO</span>
                                            </button>

                                            <!-- OLD BUTTONS (Hidden Proxies) -->
                                            <button id="btnCobrar" class="btn d-none"></button>
                                            <button id="btn_entregado" class="btn d-none"></button>
                                            <button id="btn_registrar_pedido" class="btn d-none"></button>
                                        </div>
                                    </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<dialog class="dialogBtn modern-dialog">
                            <table class="table table-condensed">
                                <thead>
                                    <tr class="display-icbpr">
                                        <th class="p-b-5">Impuesto a la bolsa - ICBPER</th>
                                        <th class="text-right p-b-5">
                                        <div class="input-group input-group-sm">
                                                
                                                <input
                                                type="number"
                                                id="impuesto_bolsa"
                                                class="form-control"
                                                placeholder="0.00"
                                                >
                                                <span class="input-group-text">S/</span>
                                            </div>
                                        </th>
                                    </tr>
                                    
                                    <tr class="display-descuento">
                                        <th class="p-b-5"><a href="javascript:void(0);" onclick="descuento_factura()" class="link">Cortes&iacute;a / Descuento <i class="ti-info-alt text-warning font-10" data-original-title="Puede generar una cortesia o ingresar un descuento por aqu铆" data-toggle="tooltip" data-placement="top"></i></a></th>
                                        <th class="text-right p-b-5">
                                            <input type="hidden" name="descuento_monto_hidden" id="descuento_monto_hidden" class="descuento" value="0.00">
                                            <input type="hidden" name="descuento_tipo_hidden" id="descuento_tipo_hidden" value="">
                                            <input type="hidden" name="descuento_motivo_hidden" id="descuento_motivo_hidden" value="">
                                            <input type="hidden" name="descuento_personal_hidden" id="descuento_personal_hidden" value="">
                                            <span><?php echo Session::get('moneda'); ?>
                                                <span class="descuento">0.00</span>
                                            </span>
                                        </th>
                                    </tr>
                                    <tr class="display-descuento">
                                        <th class="p-b-5">Tipo</th>
                                        <th class="text-right p-b-5">
                                        <select id="tipo_descuento_select" class="form-control">
                                            <option value="0" selected>Seleccionar</option>
                                            <option value="1">Cortesía</option>
                                            <option value="2">Descuento</option>
                                            <option value="3">Crédito Personal</option>
                                        </select>
                                        </th>
                                    </tr>

                                    <tr class="display-personal" style="display: none;">
                                        <th class="p-b-5">Personal</th>
                                        <th class="text-right p-b-5">
                                        <select id="personal_descuento" class="form-control">
                                            
                                        </select>
                                        </th>
                                    </tr>

                                    <tr class="display-descuento-monto" style="display: none;">
                                        <th class="p-b-5">Monto</th>
                                        <th class="text-right p-b-5">
                                            <div class="d-flex flex-column align-items-end gap-1">
                                            <!-- Control % -->
                                            <div class="input-group input-group-sm" >
                                                <input
                                                type="number"
                                                id="descuento_porcentaje"
                                                class="form-control"
                                                placeholder="0"
                                                >
                                                <span class="input-group-text">%</span>
                                            </div>
                                            <!-- Control S/ -->
                                            <div class="input-group input-group-sm">
                                                
                                                <input
                                                type="number"
                                                id="descuento_monto_fijo"
                                                class="form-control"
                                                placeholder="0.00"
                                                >
                                                <span class="input-group-text">S/</span>
                                            </div>
                                            </div>
                                        </th>
                                    </tr>

                                    
                                    <!-- 3) Motivo -->
                                    <tr id="fila_motivo_descuento" >
                                        <th class="p-b-5">Motivo</th>
                                        <th class="text-right p-b-5">
                                        <textarea id="descuento_motivo" class="form-control" rows="2" placeholder="Escribe el motivo…"></textarea>
                                        </th>
                                    </tr>
                                    
                                    <tr class="display-comision-delivery">
                                        <th class="p-b-5">Comision delivery</th>
                                        <th class="text-right p-b-5">
                                        <div class="input-group input-group-sm">
                                                
                                                <input
                                                type="number"
                                                id="comision_delivery"
                                                class="form-control"
                                                placeholder="0.00"
                                                >
                                                <span class="input-group-text">S/</span>
                                            </div>
                                        </th>
                                    </tr>

                                    <tr id="fila_observacion" >
                                        <th class="p-b-5">Observación</th>
                                        <th class="text-right p-b-5">
                                        <textarea id="observacion" class="form-control" rows="2" placeholder="Escribe la observación"></textarea>
                                        </th>
                                    </tr>
                                    
                                </thead>
                            </table>

                            <div>
                                <button type="button" class="btn btn-secondary closeDialogBtn">Cancelar</button>
                                <button type="button" id="btn_descuentos" class="btn btn-success-modern">Aceptar</button>
                            </div>
                        </dialog>

<!-- jQuery + Popper + Bootstrap JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" crossorigin="anonymous"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" crossorigin="anonymous"></script>
<script src="https://js.pusher.com/7.0/pusher.min.js"></script>

<script>
  // --- Datos de ejemplo ---
  
</script>
</body>
</html>
