<?php
date_default_timezone_set($_SESSION["zona_horaria"]);
setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
$fecha = date("d-m-Y h:i A");
$fechaa = date("m-Y 07:00");
?>
<input type="hidden" id="moneda" value="<?php echo Session::get('moneda'); ?>"/>
<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 4px 20px rgba(0,0,0,0.05);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MODERN === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 1.5rem 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.5rem;
}

@media (max-width: 767px) {
    /* Header Mobile Improvements */
    .page-titles-modern {
        flex-direction: column;
        text-align: center;
        padding: 1.5rem 1rem;
    }
    .page-titles-modern > div {
        width: 100%;
        margin-bottom: 1rem;
    }
    .page-titles-modern .btn-group {
        width: 100%;
        margin-bottom: 0;
    }
    .page-titles-modern .btn {
        flex: 1;
    }
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.4rem 1rem;
    border-radius: 20px;
    display: inline-block;
    font-size: 0.9rem;
}

.breadcrumb-modern .breadcrumb-item, .breadcrumb-modern a {
    color: rgba(255, 255, 255, 0.9);
    text-decoration: none;
    transition: color 0.2s;
}

.breadcrumb-modern a:hover {
    color: white;
    text-decoration: underline;
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

/* === FILTERS CARD === */
.filters-card {
    background: white;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    box-shadow: var(--card-shadow);
    margin-bottom: 2rem;
}

.form-group-modern label {
    font-size: 0.85rem;
    font-weight: 600;
    color: #555;
    margin-bottom: 0.5rem;
    display: block;
}

.form-control-modern {
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    padding: 0.6rem 1rem;
    font-size: 0.95rem;
    height: 45px;
    display: flex;
    align-items: center;
}

/* === TABLE MODERN === */
.table-card {
    background: white;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    overflow: hidden;
}

.table-responsive-modern {
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
}

.table-modern {
    margin-bottom: 0;
}

.table-modern thead {
    background: linear-gradient(135deg, #667eea 0%, var(--primary-color) 100%);
    color: white;
}

.table-modern thead th {
    border: none;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    padding: 1rem;
    white-space: nowrap;
}

.table-modern tbody tr {
    transition: var(--transition);
    border-bottom: 1px solid #f1f3f5;
}

.table-modern tbody tr:hover {
    background-color: #f8f9fa;
    transform: scale(1.01);
}

.table-modern tbody td {
    padding: 1rem;
    vertical-align: middle;
}

/* === SCROLLBAR PERSONALIZADO === */
.table-responsive-modern::-webkit-scrollbar {
    height: 8px;
}

.table-responsive-modern::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 10px;
}

.table-responsive-modern::-webkit-scrollbar-thumb {
    background: var(--primary-color);
    border-radius: 10px;
}

.table-responsive-modern::-webkit-scrollbar-thumb:hover {
    background: #667eea;
}

.animate-in { animation: fadeInUp 0.6s ease; }
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}
</style>

<!-- HEADER -->
<div class="page-titles-modern animate-in">
    <div>
        <h4><i class="fas fa-cash-register mr-2"></i>Arqueos de Caja</h4>
        <div class="breadcrumb-modern">
            <a href="<?php echo URL; ?>informe" class="breadcrumb-item"><i class="fas fa-home mr-1"></i>Informe</a>
            <span class="breadcrumb-item">/</span>
            <span class="breadcrumb-item">Finanzas</span>
            <span class="breadcrumb-item active">Arqueos</span>
        </div>
    </div>
</div>

<div class="wrapper wrapper-content animated fadeIn">
    <!-- FILTERS -->
    <div class="filters-card animate-in">
        <form method="post" enctype="multipart/form-data" target="_blank" action="#">
            <div class="row align-items-end">
                <!-- Rango Fechas -->
                <div class="col-lg-4 col-md-6 mb-3">
                    <div class="form-group-modern">
                        <label>Rango de Fechas</label>
                        <div class="input-group">
                            <input type="text" class="form-control form-control-modern text-center" name="start" id="start" value="<?php echo '01-'.$fechaa.' AM'; ?>" autocomplete="off" placeholder="Inicio"/>
                            <div class="input-group-append">
                                 <span class="input-group-text bg-light border-0">al</span>
                            </div>
                            <input type="text" class="form-control form-control-modern text-right" name="end" id="end" value="<?php echo $fecha; ?>" autocomplete="off" placeholder="Fin"/>
                        </div>
                    </div>
                </div>
                 <!-- Búsqueda -->
                 <div class="col-lg-4 col-md-6 mb-3">
                    <div class="form-group-modern">
                        <label>Búsqueda</label>
                        <input type="text" class="form-control form-control-modern global_filter" id="global_filter" autocomplete="off" placeholder="Buscar...">
                    </div>
                </div>
                <!-- Cajero -->
                <div class="col-lg-4 col-md-6 mb-3">
                    <div class="form-group-modern">
                        <label>Cajero</label>
                        <select class="selectpicker form-control" name="filtro_cajero" id="filtro_cajero" data-style="btn-white border" data-live-search="true" autocomplete="off" data-size="5" title="Mostrar Todo">
                            <option value="%" selected>Mostrar Todo</option>
                             
                                <?php foreach($this->Cajero as $key => $value): ?>
                                    <option value="<?php echo $value['id_usu']; ?>"><?php echo $value['nombres'].' '.$value['ape_paterno'].' '.$value['ape_materno']; ?></option>
                                <?php endforeach; ?>
                            
                        </select>
                    </div>
                </div>
            </div>
        </form>
    </div>

    <!-- TABLE -->
    <div class="table-card animate-in">
        <div class="table-responsive-modern">
            <table id="table" class="table table-modern" width="100%">
                 <thead>
                    <tr>
                        <th style="width: 10%">C&oacute;digo</th>
                        <th style="width: 10%">Fech.Aper.</th>
                        <th style="width: 10%">Fech.Cier.</th>
                        <th style="width: 20%">Cajero</th>
                        <th style="width: 10%">Caja</th>
                        <th style="width: 20%">Turno</th>
                        <th style="width: 10%">Estado</th>
                        <th style="width: 10%" class="text-right">Acciones</th>
                    </tr>
                </thead>
                <tbody class="tb-st"></tbody>
            </table>
        </div>
    </div>
</div>
