var moneda = $("#moneda").val();
$(function() {
	$('#informes').addClass("active");
	$('#start').bootstrapMaterialDatePicker({
        format: 'DD-MM-YYYY LT',
        //time: false,
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });

    $('#end').bootstrapMaterialDatePicker({
        useCurrent: false,
        format: 'DD-MM-YYYY LT',
        //time: false,
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });

    $('#start,#end,#filtro_personal').change( function() {
        listar_egresos();
        listar_creditos();
    });

    // Delegado al document o al contenedor del DataTable
    $(document).on('click', '.btn-pagar', function () {
    
        const idVenta = $(this).data('id');

        Swal.fire({
            title: '¿Confirmar pago?',
            text: "Esta acción marcará la venta como pagada.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, pagar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            console.log(result);
            
            if (result.value) {
                registrarPago(idVenta);
            }
        });
    });



});

function registrarPago(id_venta) {
    
  $.ajax({
    type: "POST",
    url: $('#url').val() + "informe/registrarPago", // Ajusta según tu ruta real
    data: { id_venta: id_venta },
    dataType: "json",
    success: function (response) {
      if (response.success) {
        Swal.fire({
          icon: 'success',
          title: '¡Pago registrado!',
          text: 'El crédito ha sido pagado correctamente.',
          timer: 2000,
          showConfirmButton: false
        });

        // Recargar la tabla
        $('#table-2').DataTable().ajax.reload(null, false);
      } else {
        Swal.fire({
          icon: 'error',
          title: 'Error',
          text: response.error || 'No se pudo registrar el pago.'
        });
      }
    },
    error: function (xhr, status, error) {
      Swal.fire({
        icon: 'error',
        title: 'Error de servidor',
        text: xhr.responseText || error
      });
    }
  });
}


var listar_egresos = function(){

	ifecha = $("#start").val();
    ffecha = $("#end").val();
    id_personal = $("#filtro_personal").selectpicker('val');

	var	table =	$('#table-1')
	.DataTable({
		"destroy": true,
        "responsive": true,
		"dom": "tip",
		"bSort": true,
		"ajax":{
			"method": "POST",
			"url": $('#url').val()+"informe/finanza_adel_list_a",
			"data": {
                ifecha: ifecha,
                ffecha: ffecha,
                id_personal: id_personal
            }
		},
		"columns":[
            {"data":"fecha_re","render": function ( data, type, row ) {
                return '<i class="ti-calendar"></i> '+moment(data).format('DD-MM-Y')
                +'<br><span class="font-12"><i class="ti-time"></i> '+moment(data).format('h:mm A')+'</span>';
            }},
            {"data":"desc_usu"},
            {"data":"motivo"},
            {"data":"importe","render": function ( data, type, row) {
                return '<div class="text-right bold">'+moneda+' '+formatNumber(data)+'</div>';
            }},
		],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            total = api
                .column( 3 /*, { search: 'applied', page: 'current'} */)
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );

            operaciones = api
                .rows()
                .data()
                .count();

            $('.ventas-total-1').text(formatNumber(total));
            $('.ventas-operaciones-1').text(operaciones);
            var monto_global = parseFloat(total) + parseFloat($('.ventas-total-2').text().replace(/,/g, ""));
            $('.monto-global').text(formatNumber(monto_global));
        }
	});
};

var listar_creditos = function(){

	ifecha = $("#start").val();
    ffecha = $("#end").val();
    id_personal = $("#filtro_personal").selectpicker('val');

	var	table =	$('#table-2')
	.DataTable({
		"destroy": true,
        "responsive": true,
		"dom": "tip",
		"bSort": true,
		"ajax":{
			"method": "POST",
			"url": $('#url').val()+"informe/finanza_adel_list_b",
			"data": {
                ifecha: ifecha,
                ffecha: ffecha,
                id_personal: id_personal
            }
		},
		"columns":[
        {
            "data": "fec_ven",
            "render": function ( data, type, row ) {
            return '<i class="ti-calendar"></i> '+moment(data).format('DD-MM-Y')+
                '<br><span class="font-12"><i class="ti-time"></i> '+moment(data).format('h:mm A')+'</span>';
            }
        },
        { "data": "desc_usu" },
        {
            "data": null,
            "render": function ( data, type, row) {
            return data.desc_td+'<br><span class="font-12">Ser.'+data.ser_doc+' - Nro.'+data.nro_doc+'</span>';
            }
        },
        {
            "data": "total_venta",
            "render": function ( data, type, row) {
            return '<div class="text-right bold">'+moneda+' '+formatNumber(data)+'</div>';
            }
        },
        {
            data: null,
            title: "Opciones",
            orderable: false,
            render: function (data, type, row) {
                if (row.pago_credito == 0) {
                    return `
                        <button class="btn btn-success btn-sm btn-pagar" 
                                data-id="${row.id_ven}" 
                                title="Registrar pago">
                            <i class="ti-wallet"></i> Pagar
                        </button>
                    `;
                } else {
                      return `
                        <button class="btn btn-warning btn-sm" disabled>
                            Pagado
                        </button>
                    `;
                }
            }
        }

        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api();

            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '') * 1 :
                    typeof i === 'number' ?
                        i : 0;
            };

            let total = 0;
            let operaciones = 0;

            api.rows({ page: 'current' }).data().each(function (rowData) {
                if (rowData.pago_credito == 0) {
                    total += intVal(rowData.desscuento_monto);
                    operaciones++;
                }
            });

            $('.ventas-total-2').text(formatNumber(total));
            $('.ventas-operaciones-2').text(operaciones);

            var monto_global = parseFloat(total) + parseFloat($('.ventas-total-1').text().replace(/,/g, ""));
            $('.monto-global').text(formatNumber(monto_global));
        }

	});
};