<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --card-shadow-hover: 0 5px 20px rgba(0,0,0,0.12);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.75rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.5rem 1rem;
    border-radius: 20px;
    display: inline-block;
}

.breadcrumb-modern .breadcrumb-item {
    color: rgba(255, 255, 255, 0.9);
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

.breadcrumb-modern a {
    color: white;
    text-decoration: none;
}

/* === CARD MODERN === */
.card-modern {
    border: none;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    transition: var(--transition);
}

.card-modern:hover {
    box-shadow: var(--card-shadow-hover);
}

/* === BUTTONS MODERN === */
.btn-modern {
    border-radius: 8px;
    font-weight: 500;
    padding: 0.6rem 1.2rem;
    box-shadow: 0 4px 6px rgba(50, 50, 93, 0.11), 0 1px 3px rgba(0, 0, 0, 0.08);
    transition: var(--transition);
    border: none;
}

.btn-modern:hover {
    transform: translateY(-1px);
    box-shadow: 0 7px 14px rgba(50, 50, 93, 0.1), 0 3px 6px rgba(0, 0, 0, 0.08);
}

.btn-modern-primary {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    color: white;
}

.btn-modern-success {
    background: linear-gradient(135deg, var(--success-color) 0%, #2ecc71 100%);
    color: white;
}

/* === TABLA MODERN === */
.table-modern thead {
    background: linear-gradient(135deg, #667eea 0%, var(--primary-color) 100%);
    color: white;
}

.table-modern thead th {
    border: none;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    padding: 1rem;
}

.table-modern tbody tr {
    transition: var(--transition);
    border-bottom: 1px solid #f1f3f5;
}

.table-modern tbody tr:hover {
    background-color: #f8f9fa;
    transform: scale(1.005);
}

.table-modern tbody td {
    padding: 1rem;
    vertical-align: middle;
}

/* === VERTICAL TABS (VTABS) MODERN === */
.vtabs.customvtab {
    display: flex; /* Flexbox for layout */
}

.vtabs .tabs-vertical {
    border-right: 1px solid #e9ecef;
    min-width: 200px;
}

.vtabs .tabs-vertical li .nav-link {
    color: #6c757d;
    border-radius: 0;
    border-right: 3px solid transparent;
    transition: all 0.3s;
    font-weight: 500;
    padding: 1rem;
    display: block;
}

.vtabs .tabs-vertical li .nav-link:hover,
.vtabs .tabs-vertical li .nav-link.active {
    color: var(--primary-color);
    background: rgba(86, 100, 210, 0.05); /* Light primary bg */
    border-right: 3px solid var(--primary-color);
}

.vtabs .tab-content {
    flex-grow: 1; /* Content takes remaining space */
    padding: 20px;
}

/* === ANIMACIONES === */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.animate-in {
    animation: fadeInUp 0.5s ease;
}
/* === RESPONSIVE UTILS === */
@media (max-width: 768px) {
    .vtabs.customvtab {
        flex-direction: column;
    }
    .vtabs .tabs-vertical {
        width: 100%;
        min-width: 100%;
        border-right: none;
        border-bottom: 1px solid #e9ecef;
        margin-bottom: 20px;
    }
    
    /* Make the vertical tabs act like horizontal scrollable tabs on mobile */
    .vtabs .tabs-vertical {
        display: flex;
        flex-direction: row;
        overflow-x: auto;
        white-space: nowrap;
        -webkit-overflow-scrolling: touch;
    }
    
    .vtabs .tabs-vertical li {
        width: auto;
        flex: 0 0 auto;
    }

    .vtabs .tabs-vertical li .nav-link {
        border-right: none;
        border-bottom: 3px solid transparent;
        padding: 0.8rem 1rem;
    }
    
    .vtabs .tabs-vertical li .nav-link:hover,
    .vtabs .tabs-vertical li .nav-link.active {
        border-right: none;
        border-bottom: 3px solid var(--primary-color);
    }

    .vtabs .tab-content {
        padding: 0;
    }
}

/* === MODAL & FORM DEEP MODERNIZATION === */
/* Switch Polish */
.switch label input[type=checkbox]:checked + .lever {
    background-color: #aeb5ea; /* Lighter primary */
}
.switch label input[type=checkbox]:checked + .lever:after {
    background-color: var(--primary-color);
    left: 24px;
}
.switch label .lever {
    width: 50px;
    height: 24px;
    margin: 0;
    background-color: #e9ecef;
    border-radius: 24px;
}
.switch label .lever:after {
    width: 18px;
    height: 18px;
    background-color: #adb5bd;
    border-radius: 50%;
    box-shadow: 0 2px 5px rgba(0,0,0,0.2);
    top: 3px;
    left: 4px;
    transition: all 0.3s ease;
}

/* Clean Input Groups */
.input-group-text {
    background: #f8f9fa;
    border-color: #ced4da;
    color: #6c757d;
}
</style>

<input type="hidden" id="url" value="<?php echo URL; ?>"/>
<div class="row page-titles-modern animate-in">
    <div class="col-md-5 align-self-center">
        <h4 class="text-white">Ajustes</h4>
        <div class="breadcrumb-modern">
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste"><i class="fa fa-home mr-1"></i>Inicio</a></span>
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste">Sistema</a></span>
            <span class="breadcrumb-item active">Configuración inicial</span>
        </div>
    </div>
</div>

<form id="form" method="post" enctype="multipart/form-data">
<div class="row">
    <div class="col-md-9">
        <div class="card card-modern p-20 h-100">
            <!-- Nav tabs -->
            <div class="vtabs customvtab">
                <ul class="nav nav-tabs tabs-vertical flex-column" role="tablist" >
                    <li class="nav-item"> <a class="nav-link active" data-toggle="tab" href="#step6" role="tab" aria-selected="true"><span class="hidden-sm-up"><i class="ti-settings"></i></span> <span class="hidden-xs-down">Configuración</span> </a> </li>
                    <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#step1" role="tab" aria-selected="false"><span class="hidden-sm-up"><i class="ti-location-pin"></i></span> <span class="hidden-xs-down">Zona Horaria</span> </a> </li>
                    <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#step2" role="tab" aria-selected="false"><span class="hidden-sm-up"><i class="ti-id-badge"></i></span> <span class="hidden-xs-down">Identificación</span> </a> </li>
                    <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#step3" role="tab" aria-selected="false"><span class="hidden-sm-up"><i class="ti-money"></i></span> <span class="hidden-xs-down">Impuesto/Moneda</span> </a> </li>
                    <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#step4" role="tab" aria-selected="false"><span class="hidden-sm-up"><i class="ti-desktop"></i></span> <span class="hidden-xs-down">Ordenador</span> </a> </li>
                    <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#step5" role="tab" aria-selected="false"><span class="hidden-sm-up"><i class="ti-printer"></i></span> <span class="hidden-xs-down">Impresión</span> </a> </li>
                    <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#step7" role="tab" aria-selected="false"><span class="hidden-sm-up"><i class="ti-printer"></i></span> <span class="hidden-xs-down">Accesos directos</span> </a> </li>
                    <li class="nav-item"> <a class="nav-link" data-toggle="tab" href="#step8" role="tab" aria-selected="false"><span class="hidden-sm-up"><i class="ti-settings"></i></span> <span class="hidden-xs-down">Comisiones</span> </a> </li>
                </ul>
                <!-- Tab panes -->
                
                <div class="tab-content w-100">
                    <div class="tab-pane active" id="step6" role="tabpanel">
                        <div class="p-20">
                            <div class="row floating-labels">
                                <div class="col-md-12">
                                    <h4 class="card-title text-primary font-weight-bold mb-4"><i class="ti-settings font-18 mr-2"></i> Configuración</h4>
                                    <!-- <h6 class="card-subtitle">Tributo, exacci&oacute;n o la cantidad de dinero que se paga al Estado.</h6><br> -->
                                    <div class="row pt-2">
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 form-group-modern">
                                                <input type="text" name="cod_seg" id="cod_seg" class="form-control" autocomplete="off">
                                                <span class="bar"></span>
                                                <label for="cod_seg">Código de Seguridad</label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 form-group-modern">
                                                <input type="hidden" name="opc_01" id="opc_01_hidden">
                                                <span class="bar"></span>
                                                <label for="cod_seg" style="position:relative; top:0; margin-bottom:5px; font-size:12px;">Delivery</label>
                                                <div class="row">
                                                    <div class="col-8">
                                                    <h6 class="text-muted mt-2">PEDIDOSYA, DIDI FOOD, ETC</h6>
                                                    </div>
                                                    <div class="col-4 text-right">
                                                        <div class="switch">
                                                            <label style="position: inherit;"><input type="checkbox" id="opc_01"><span class="lever switch-col-light-green"></span></label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>                                      
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 mt-4">
                                    <h4 class="card-title text-primary font-weight-bold mb-4"><i class="ti-settings font-18 mr-2"></i> Configuración para ventas</h4>
                                    <div class="row mt-4">
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 form-group-modern">
                                                <input type="hidden" name="sep_items" id="sep_items_hidden">
                                                <span class="bar"></span>
                                                <label for="sep_items" style="position:relative; top:0; margin-bottom:5px; font-size:12px;">Separar items en venta</label>
                                                <div class="row">
                                                    <div class="col-8">
                                                    <h6 class="text-muted mt-2">Permitir decidir separar siempre a los items que se vaya agregando a la mesa para la comanda</h6>
                                                    </div>
                                                    <div class="col-4 text-right">
                                                        <div class="switch">
                                                            <label style="position: inherit;"><input type="checkbox" id="sep_items"><span class="lever switch-col-light-green"></span></label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>                                          
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 form-group-modern">
                                                <input type="hidden" name="verpdf" id="verpdf_hidden">
                                                <span class="bar"></span>
                                                <label for="verpdf" style="position:relative; top:0; margin-bottom:5px; font-size:12px;">Previsualizar PDF</label>
                                                <div class="row">
                                                    <div class="col-8">
                                                    <h6 class="text-muted mt-2">Mostrar el PDF despues de realizar la venta y cobrar.</h6>
                                                    </div>
                                                    <div class="col-4 text-right">
                                                        <div class="switch">
                                                            <label style="position: inherit;"><input type="checkbox" id="verpdf"><span class="lever switch-col-light-green"></span></label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 form-group-modern">
                                                <span class="bar"></span>
                                                <label for="nota_ind" style="position:relative; top:0; margin-bottom:5px; font-size:12px;">Activar notas temporales</label> 
                                                <div class="row">
                                                    <div class="col-8">
                                                    <h6 class="text-muted mt-2">se activara un campo de nota temporal</h6>
                                                    </div>
                                                    <div class="col-4 text-right">
                                                        <div class="switch">
                                                            <label style="position: inherit;"><input type="checkbox" id="nota_ind"><span class="lever switch-col-light-green"></span></label>
                                                            <input type="hidden" name="nota_ind" id="nota_ind_hidden">                             
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>  
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 form-group-modern">
                                                <span class="bar"></span>
                                                <label for="mostrarimagen" style="position:relative; top:0; margin-bottom:5px; font-size:12px;">Activar imagenes en venta</label> 
                                                <div class="row">
                                                    <div class="col-8">
                                                    <h6 class="text-muted mt-2">Se ocultara o mostrará las imágenes en el panel de venta</h6>
                                                    </div>
                                                    <div class="col-4 text-right">
                                                        <div class="switch">
                                                            <label style="position: inherit;"><input type="checkbox" id="mostrarimagen"><span class="lever switch-col-light-green"></span></label>
                                                            <input type="hidden" name="mostrarimagen" id="mostrarimagen_hidden">                              
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>  
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 form-group-modern">
                                                <input type="hidden" name="envios_auto" id="envios_auto_hidden">
                                                <span class="bar"></span>
                                                <label for="envios_auto" style="position:relative; top:0; margin-bottom:5px; font-size:12px;">Activar envios directos a SUNAT</label>
                                                <div class="row">
                                                    <div class="col-8">
                                                    <h6 class="text-muted mt-2">Se enviara los comprobantes directos a SUNAT el momento de la venta.</h6>
                                                    </div>
                                                    <div class="col-4 text-right">
                                                        <div class="switch">
                                                            <label style="position: inherit;"><input type="checkbox" id="envios_auto"><span class="lever switch-col-light-green"></span></label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 form-group-modern">
                                                <input type="hidden" name="multiples_precios" id="multiples_precios_hidden">
                                                <span class="bar"></span>
                                                <label for="multiples_precios" style="position:relative; top:0; margin-bottom:5px; font-size:12px;">Activar precios multiples en presentaciones</label>
                                                <div class="row">
                                                    <div class="col-8">
                                                    <h6 class="text-muted mt-2">Se mostrará una pestaña nueva en la config de la presentación para poder añadir multiples precios.</h6>
                                                    </div>
                                                    <div class="col-4 text-right">
                                                        <div class="switch">
                                                            <label style="position: inherit;"><input type="checkbox" id="multiples_precios"><span class="lever switch-col-light-green"></span></label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 mt-4">
                                    <h4 class="card-title text-primary font-weight-bold mb-4"><i class="ti-ticket font-18 mr-2"></i> Configuración para comandas</h4>
                                    <div class="row mt-4">
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 form-group-modern">
                                                <input type="hidden" name="precio_comanda" id="precio_comanda_hidden">
                                                <span class="bar"></span>
                                                <label for="precio_comanda" style="position:relative; top:0; margin-bottom:5px; font-size:12px;">Mostrar nombre de precio en comanda</label>
                                                <div class="row">
                                                    <div class="col-8">
                                                    <h6 class="text-muted mt-2">Se mostrará el nombre del precio de la presentación al imprimir la comanda.</h6>
                                                    </div>
                                                    <div class="col-4 text-right">
                                                        <div class="switch">
                                                            <label style="position: inherit;"><input type="checkbox" id="precio_comanda"><span class="lever switch-col-light-green"></span></label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 form-group-modern">
                                                <input type="hidden" name="direccion_comanda" id="direccion_comanda_hidden">
                                                <span class="bar"></span>
                                                <label for="direccion_comanda" style="position:relative; top:0; margin-bottom:5px; font-size:12px;">Mostrar dirección de DELIVERY en comanda</label>
                                                <div class="row">
                                                    <div class="col-8">
                                                    <h6 class="text-muted mt-2">Se mostrará la dirección del pedido DELIVERY al imprimir la comanda.</h6>
                                                    </div>
                                                    <div class="col-4 text-right">
                                                        <div class="switch">
                                                            <label style="position: inherit;"><input type="checkbox" id="direccion_comanda"><span class="lever switch-col-light-green"></span></label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 form-group-modern">
                                                <input type="hidden" name="impresion_automatica_comanda_hidden" id="impresion_automatica_comanda_hidden">
                                                <span class="bar"></span>
                                                <label for="impresion_automatica_comanda" style="position:relative; top:0; margin-bottom:5px; font-size:12px;">Impresion automatica de COMANDAS</label>
                                                <div class="row">
                                                    <div class="col-8">
                                                    <h6 class="text-muted mt-2">Al activar se imprimira o mostrara la comanda del pedido automaticamente.</h6>
                                                    </div>
                                                    <div class="col-4 text-right">
                                                        <div class="switch">
                                                            <label style="position: inherit;"><input type="checkbox" id="impresion_automatica_comanda"><span class="lever switch-col-light-green"></span></label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 form-group-modern">
                                                <input type="hidden" name="pedido_comanda" id="pedido_comanda_hidden">
                                                <span class="bar"></span>
                                                <label for="pedido_comanda" style="position:relative; top:0; margin-bottom:5px; font-size:12px;">Mostrar numero del PEDIDO DELVIERY en comanda</label>
                                                <div class="row">
                                                    <div class="col-8">
                                                    <h6 class="text-muted mt-2">Se mostrará el número del pedido DELIVERY al imprimir la comanda.</h6>
                                                    </div>
                                                    <div class="col-4 text-right">
                                                        <div class="switch">
                                                            <label style="position: inherit;"><input type="checkbox" id="pedido_comanda"><span class="lever switch-col-light-green"></span></label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 form-group-modern">
                                                <input type="hidden" name="mostrar_web_hidden" id="mostrar_web_hidden">
                                                <span class="bar"></span>
                                                <label for="mostrar_web" style="position:relative; top:0; margin-bottom:5px; font-size:12px;">Mostrar la redirección a la  web</label>
                                                <div class="row">
                                                    <div class="col-8">
                                                    <h6 class="text-muted mt-2">Se mostrará acceso directo a la pagina web que permite hacer pedidos.</h6>
                                                    </div>
                                                    <div class="col-4 text-right">
                                                        <div class="switch">
                                                            <label style="position: inherit;"><input type="checkbox" id="mostrar_web"><span class="lever switch-col-light-green"></span></label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> 
                    <div class="tab-pane" id="step1" role="tabpanel">
                        <div class="p-20">
                            <h4 class="card-title text-primary font-weight-bold mb-3"><i class="ti-location-pin font-18 mr-2"></i> Zona Horaria</h4>
                            <h6 class="card-subtitle mb-4">Ingrese la zona horaria de su localidad.</h6>
                            <div class="row floating-labels">
                                <div class="col-md-12">
                                    <div class="form-group m-b-40 form-group-modern">
                                        <input type="text" name="zona_hora" id="zona_hora" class="form-control" autocomplete="off" required>
                                        <span class="bar"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="step2" role="tabpanel">
                        <div class="p-20">
                            <div class="row floating-labels">
                                <div class="col-md-12">
                                    <h4 class="card-title text-primary font-weight-bold mb-3"><i class="ti-bookmark-alt font-18 mr-2"></i> Identificación Tributaria</h4>
                                    <h6 class="card-subtitle">Utilizado para identificar inequívocamente a los contribuyentes.</h6><br>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 letNumMayMin form-group-modern">
                                                <input type="text" name="trib_acr" id="trib_acr" class="form-control input-mayus" autocomplete="off" required>
                                                <span class="bar"></span>
                                                <label for="trib_acr">Nomenclatura <span class="badge badge-info font-13">EJ: RUC</span></label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 ent form-group-modern">
                                                <input type="text" name="trib_car" id="trib_car" class="form-control" autocomplete="off" required>
                                                <span class="bar"></span>
                                                <label for="trib_car">Número de caracteres</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <h4 class="card-title text-primary font-weight-bold mb-3"><i class="ti-id-badge font-18 mr-2"></i> Documento de Identidad</h4>
                                    <h6 class="card-subtitle">Documento público de identificación personal.</h6><br>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 letNumMayMin form-group-modern">
                                                <input type="text" name="di_acr" id="di_acr" class="form-control input-mayus" autocomplete="off" required>
                                                <span class="bar"></span>
                                                <label for="di_acr">Nomenclatura <span class="badge badge-info font-13">EJ: DNI</span></label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 ent form-group-modern">
                                                <input type="text" name="di_car" id="di_car" class="form-control" autocomplete="off" required>
                                                <span class="bar"></span>
                                                <label for="di_car">Número de caracteres</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="step3" role="tabpanel">
                        <div class="p-20">
                            <div class="row floating-labels">
                                <div class="col-md-12">
                                    <h4 class="card-title text-primary font-weight-bold mb-3"><i class="ti-file font-18 mr-2"></i> Impuesto</h4>
                                    <h6 class="card-subtitle">Tributo a pagar al Estado.</h6><br>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 letNumMayMin form-group-modern">
                                                <input type="text" name="imp_acr" id="imp_acr" class="form-control input-mayus" autocomplete="off" required>
                                                <span class="bar"></span>
                                                <label for="imp_acr">Nomenclatura <span class="badge badge-info font-13">EJ: IGV</span></label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 dec form-group-modern">
                                                <input type="text" name="imp_val" id="imp_val" class="form-control" autocomplete="off" required>
                                                <span class="bar"></span>
                                                <label for="imp_val">Valor (%)</label>
                                            </div>
                                        </div>
                                    </div>
                                    <h4 class="card-title text-primary font-weight-bold mb-3"><i class="ti-money font-18 mr-2"></i> Moneda</h4>
                                    <h6 class="card-subtitle">Divisa para transacciones.</h6><br>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 form-group-modern">
                                                <input type="text" name="mon_acr" id="mon_acr" class="form-control" autocomplete="off" required>
                                                <span class="bar"></span>
                                                <label for="mon_acr">Nomenclatura <span class="badge badge-info font-13">EJ: SOLES</span></label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 form-group-modern">
                                                <input type="text" name="mon_val" id="mon_val" class="form-control" autocomplete="off" required>
                                                <span class="bar"></span>
                                                <label for="mon_val">Símbolo</label>
                                            </div>
                                        </div>
                                    </div>
                                    <h4 class="card-title text-primary font-weight-bold mb-3"><i class="ti-file font-18 mr-2"></i> Impuesto a la bolsa plástica</h4>
                                    <h6 class="card-subtitle">Impuesto al consumo de bolsas (ICBP)</h6><br>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 letNumMayMin form-group-modern">
                                                <input type="text" name="imp_bol" id="imp_bol" class="form-control input-mayus" autocomplete="off" value="">
                                                <span class="bar"></span>
                                                <label for="imp_bol">Nomenclatura <span
                                                        class="badge badge-info font-13">EJ: ICBP</span></label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 dec form-group-modern">
                                                <input type="text" name="imp_val_bol" id="imp_val_bol" class="form-control" value="0.50" autocomplete="off" required>
                                                <span class="bar"></span>
                                                <label for="imp_val_bol">Valor (S/)</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>  
                    <div class="tab-pane" id="step4" role="tabpanel">
                        <div class="p-20">
                            <div class="row floating-labels">
                                <div class="col-md-12">
                                    <h4 class="card-title text-primary font-weight-bold mb-3"><i class="ti-desktop font-18 mr-2"></i> PC Principal</h4>
                                    <h6 class="card-subtitle mb-4">Configuración del equipo principal.</h6>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 form-group-modern">
                                                <input type="text" name="pc_name" id="pc_name" class="form-control" autocomplete="off" required>
                                                <span class="bar"></span>
                                                <label for="pc_name">Nombre</label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group m-b-40 form-group-modern">
                                                <input type="text" name="pc_ip" id="pc_ip" class="form-control" autocomplete="off" required>
                                                <span class="bar"></span>
                                                <label for="pc_ip">IP</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>  
                    <div class="tab-pane" id="step5" role="tabpanel">
                        <div class="p-20">
                            <div class="row">
                                <div class="col-md-12">
                                    <h4 class="card-title text-primary mb-4 font-weight-bold"><i class="ti-printer font-18 mr-2"></i> Gestión de Impresión</h4>
                                    <div class="table-responsive table-responsive-modern">
                                        <table class="table table-hover table-modern" width="100%">
                                            <thead>
                                                <tr>
                                                    <th colspan="2">Nombre</th>
                                                    <th class="text-right">Opción</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td style="width:50px;">
                                                        <span class="round round-warning"><i class="ti-ticket"></i></span>
                                                    </td>
                                                    <td>
                                                        <h5 class="m-t-5 m-b-0">Comandas</h5><h6 class="text-muted">Envía comandas a la cocina a través de una impresora.</h6>
                                                    </td>
                                                    <td class="text-right p-r-0" style="vertical-align: middle;">
                                                        <div class="switch">
                                                            <label><input type="checkbox" id="print_com"><span class="lever switch-col-light-green"></span></label>
                                                        </div>
                                                        <input type="hidden" name="print_com" id="print_com_hidden">
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;">
                                                        <span class="round round-warning"><i class="ti-receipt"></i></span>
                                                    </td>
                                                    <td>
                                                        <h5 class="m-t-5 m-b-0">Pre Cuenta</h5><h6 class="text-muted">Impresión de precuentas físicas.</h6>
                                                    </td>
                                                    <td class="text-right p-r-0" style="vertical-align: middle;">
                                                        <div class="switch">
                                                            <label><input type="checkbox" id="print_pre"><span class="lever switch-col-light-green"></span></label>
                                                        </div>
                                                        <input type="hidden" name="print_pre" id="print_pre_hidden">
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="width:50px;">
                                                        <span class="round round-warning"><i class="ti-receipt"></i></span>
                                                    </td>
                                                    <td>
                                                        <h5 class="m-t-5 m-b-0">Comprobantes Electronicos</h5><h6 class="text-muted">Imprimir directamente Boleta, Factura y Notas de venta.</h6>
                                                    </td>
                                                    <td class="text-right p-r-0" style="vertical-align: middle;">
                                                        <div class="switch">
                                                            <label><input type="checkbox" id="print_cpe"><span class="lever switch-col-light-green"></span></label>
                                                        </div>
                                                        <input type="hidden" name="print_cpe" id="print_cpe_hidden">
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="step7" role="tabpanel">
                        <div class="p-20">
                            <div class="row floating-labels">
                                <div class="col-md-12">
                                    <h4 class="card-title text-primary font-weight-bold mb-3"><i class="ti-settings font-18 mr-2"></i> Configuración de accesos directos</h4>
                                    <div class="row pt-4">
                                        <div class="col-md-12">
                                            <div class="form-group m-b-40">
                                                <table class="table table-hover table-modern" style="width: 100%">
                                                    <tr class="">
                                                        <td class="text-center" width="20%">Titulo</td>
                                                        <td class="text-center" width="10%">Icono</td>
                                                        <td class="text-center" width="10%">Color</td>
                                                        <td class="text-center" width="">URL</td>
                                                        <td class="text-center" width="8%">Acción</td>
                                                    </tr>
                                                    <?php foreach($this->Iconos as $key => $value): ?>  
                                                        <tr style="padding: 10px">
                                                            <td style="padding: 10px"><input class="form-control" type="text" name="url" id="titulo_<?=$value['id_acceso']?>" value="<?=$value['titulo']?>"/></td>
                                                            <td style="padding: 10px"><input class="form-control" type="text" name="icono" id="icono_<?=$value['id_acceso']?>" value="<?=$value['icono']?>" /></td>
                                                            <td style="padding: 10px"><input class="form-control" type="text" name="color" id="color_<?=$value['id_acceso']?>" value="<?=$value['color']?>" /></td>
                                                            <td style="padding: 10px"><input class="form-control" type="text" name="url" id="url_<?=$value['id_acceso']?>" value="<?=$value['url']?>"/></td>
                                                            <td class="text-center" style="padding: 10px"><button type="button" class="btn btn-success btn-modern btn-modern-success" onclick="guardarIcono(<?=$value['id_acceso']?>)"><i class="fa fa-save"></i></button></td>
                                                        </tr>
                                                    <?php endforeach; ?>
                                                </table>
                                                    <div class="col-12 mt-4">
                                                        <h6 class="card-subtitle">
                                                            Para conocer los nombres de iconos debe visitar <a href="https://themify.me/themify-icons" target="_blank"> AQUI</a><br>
                                                            Si desea desactivar algun icono solo dejar en blanco su cuadro correspondiente.
                                                        </h6>
                                                    </div>
                                            </div>              
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="step8" role="tabpanel">
                        <div class="p-20">
                            <h4 class="card-title text-primary font-weight-bold mb-3">
                            <i class="fa fa-credit-card mr-2"></i> Comisiones
                            </h4>
                            <h6 class="card-subtitle mb-4">Configura las comisiones para la venta con tarjetas.</h6>

                            <div class="row">
                            <div class="col-md-6">
                                <div class="form-group m-b-40 form-group-modern">
                                <label for="comision_tarjeta" class="form-label" style="position:relative; top:0; margin-bottom:5px; font-size:12px;">Comisión por Tarjeta</label>
                                <div class="input-group">
                                    <span class="input-group-text">%</span>
                                    <input type="number" name="comision_tarjeta" id="comision_tarjeta" class="form-control" autocomplete="off" required min="0" step="0.01">
                                </div>
                                </div>
                            </div>
                            </div>

                        </div>
                    </div>
                        
                    <div class="col-sm-12 text-right mt-3">
                        <a href="<?php echo URL; ?>ajuste" class="btn btn-secondary btn-modern">Cancelar</a>
                        <button class="btn btn-success text-right btn-modern btn-modern-success" type="submit">Aceptar</button>
                    </div>               
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card card-modern p-20 alert-info border-0 shadow-sm" style="background-color: #e1f5fe;">
            <h3 class="text-info"><i class="fa fa-exclamation-circle mr-2"></i> Información</h3>
            <div class="p-2" style="color: #455a64!important;">
                <strong>Configuración inicial</strong>
                <p>Permite realizar la configuración de los atributos principales del sistema.</p>
            </div>
        </div>
    </div>
</div>
</form>