<?php
// ARCHIVO CENTRAL DE CONEXIÓN A LA BASE DE DATOS

/**
 * Función simple para cargar variables desde un archivo .env
 */
function loadEnv($path) {
    if (!file_exists($path)) return false;

    $lines = file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos(trim($line), '#') === 0) continue;
        $parts = explode('=', $line, 2);
        if (count($parts) === 2) {
            $name = trim($parts[0]);
            $value = trim($parts[1]);
            putenv(sprintf('%s=%s', $name, $value));
            $_ENV[$name] = $value;
            $_SERVER[$name] = $value;
        }
        
    }
    return true;
}

// Cargar variables de entorno
loadEnv(__DIR__ . '/.env');

$host = getenv('DB_HOST') ?: "localhost";
$username = getenv('DB_USER');
$password = getenv('DB_PASS');
$database = getenv('DB_NAME');

// Establecer la conexión
$conn = mysqli_connect($host, $username, $password, $database);

if ($conn) {
    mysqli_set_charset($conn, "utf8");
} else {
    // Si falla localhost en Windows, intentar 127.0.0.1
    if ($host === 'localhost') {
        $conn = @mysqli_connect('127.0.0.1', $username, $password, $database);
        if ($conn) mysqli_set_charset($conn, "utf8");
    }
}

if (!$conn) {
    error_log("Fallo en la conexión a la BD: " . mysqli_connect_error());
}

/**
 * Función auxiliar para asegurar respuesta JSON
 */
function check_connection($conn) {
    if (!$conn) {
        http_response_code(500);
        header('Content-Type: application/json');
        echo json_encode(["error" => "No se pudo conectar al servidor."]);
        exit;
    }
    return true;
}
?>