<input type="hidden" id="tribAcr" value="<?php echo Session::get('tribAcr'); ?>"/>

<style>
/* === VARIABLES CSS (Extract from monitor.php) === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --card-shadow-hover: 0 5px 20px rgba(0,0,0,0.12);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 1.5rem 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
    position: relative;
    overflow: hidden;
}

.page-titles-modern::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -10%;
    width: 200px;
    height: 200px;
    background: rgba(255,255,255,0.1);
    border-radius: 50%;
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.5rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.4rem 1rem;
    border-radius: 20px;
    display: inline-block;
    font-size: 0.9rem;
}

.breadcrumb-modern .breadcrumb-item, .breadcrumb-modern a {
    color: rgba(255, 255, 255, 0.9);
    text-decoration: none;
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

/* === BOTONES === */
.btn-new-modern {
    background: linear-gradient(135deg, #1bc943 0%, #17a032 100%);
    color: white;
    border: none;
    border-radius: 50px;
    padding: 0.8rem 2rem;
    font-weight: 600;
    box-shadow: 0 4px 15px rgba(27, 201, 67, 0.3);
    transition: var(--transition);
    display: inline-flex;
    align-items: center;
    text-decoration: none !important;
}

.btn-new-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(27, 201, 67, 0.4);
    color: white;
}

/* === STATS & SEARCH ROW === */
.control-row {
    display: grid;
    grid-template-columns: 1fr 2fr;
    gap: 1.5rem;
    margin-bottom: 2rem;
    align-items: stretch;
}

@media (max-width: 768px) {
    .control-row {
        grid-template-columns: 1fr;
    }
}

.stat-card-mini {
    background: white;
    padding: 1.2rem;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    display: flex;
    align-items: center;
    border-left: 4px solid var(--warning-color);
}

.stat-card-mini .icon {
    font-size: 2.5rem;
    color: var(--warning-color);
    margin-right: 1.5rem;
    opacity: 0.2;
}

.stat-card-mini .data h2 {
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    color: #333;
}

.stat-card-mini .data h6 {
    margin: 0;
    font-size: 0.8rem;
    color: #888;
    text-transform: uppercase;
}

.search-card {
    background: white;
    padding: 1.2rem;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    display: flex;
    align-items: center;
}

.form-group-modern {
    width: 100%;
    margin: 0;
}

.form-control-modern {
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    padding: 0.8rem 1rem;
    width: 100%;
    font-size: 0.95rem;
    transition: var(--transition);
}

.form-control-modern:focus {
    border-color: var(--primary-color);
    box-shadow: 0 0 0 3px rgba(86, 100, 210, 0.1);
    outline: none;
}

/* === TABLA MODERNA === */
.table-card {
    background: white;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    overflow: hidden;
}

.table-responsive-modern {
    width: 100%;
    overflow-x: auto;
}

.table-modern {
    width: 100%;
    margin-bottom: 0;
}

.table-modern thead th {
    background: linear-gradient(to right, #f8f9fa, #fff);
     background: #f8f9fa;
    color: #495057;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    border-bottom: 2px solid #e9ecef;
    padding: 1rem;
}

.table-modern tbody td {
    padding: 1rem;
    vertical-align: middle;
    border-bottom: 1px solid #f1f3f5;
    font-size: 0.9rem;
}

.table-modern tbody tr:hover {
    background-color: #f8f9fa;
}

/* === MODAL === */
.modal-content-modern {
    border: none;
    border-radius: 15px;
    box-shadow: 0 15px 50px rgba(0,0,0,0.2);
}

.modal-header-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 1.5rem;
    border-radius: 15px 15px 0 0;
    color: white;
}

.modal-body-modern {
    padding: 2rem;
}

.form-group-material {
    position: relative;
    margin-bottom: 1.5rem;
}

.form-group-material label {
    font-size: 0.85rem;
    font-weight: 600;
    color: #666;
    margin-bottom: 0.4rem;
    display: block;
}

.form-group-material .form-control {
    border: 1px solid #ced4da;
    border-radius: 6px;
    padding: 0.6rem;
}

.animate-in {
    animation: fadeInUp 0.6s ease;
}

@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

</style>

<!-- HEADER -->
<div class="page-titles-modern animate-in">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h4><i class="fas fa-truck mr-2"></i>Proveedores</h4>
            <div class="breadcrumb-modern">
                <span class="breadcrumb-item"><i class="fas fa-home mr-1"></i>Facturación</span>
                <span class="breadcrumb-item">/</span>
                <span class="breadcrumb-item active">Gestión de Proveedores</span>
            </div>
        </div>
        <div>
            <a href="javascript:void(0)" class="btn-new-modern btn-nuevo">
                <i class="fas fa-plus mr-2"></i>Nuevo Proveedor
            </a>
        </div>
    </div>
</div>

<!-- STATS AND SEARCH -->
<div class="control-row animate-in">
    <div class="stat-card-mini">
        <div class="icon"><i class="fas fa-users"></i></div>
        <div class="data">
            <h2 class="proveedores-total">0</h2>
            <h6>Proveedores Registrados</h6>
        </div>
    </div>
    
    <div class="search-card">
        <div class="form-group-modern">
            <input type="text" class="form-control-modern global_filter" id="global_filter" placeholder="Buscar proveedor por nombre, RUC o dirección..." autocomplete="off">
        </div>
    </div>
</div>

<!-- TABLE -->
<div class="table-card animate-in">
    <div class="table-responsive-modern">
        <table id="table" class="table table-modern" cellspacing="0" width="100%">
            <thead>
                <tr>
                    <th style="width: 35%;">Proveedor</th>
                    <th style="width: 45%;">Dirección</th>
                    <th style="width: 10%; text-align: center">Estado</th>
                    <th style="width: 10%; text-align: center">Acciones</th>
                </tr>
            </thead>
            <tbody class="tb-st"></tbody>
        </table>
    </div>
</div>

<!-- MODAL PROVEEDOR -->
<div class="modal inmodal" id="modal-proveedor" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-md modal-dialog-centered">
        <div class="modal-content modal-content-modern">
            <form id="frm-proveedor" method="post" enctype="multipart/form-data">
                <input type="hidden" name="id_prov" id="id_prov">
                
                <div class="modal-header modal-header-modern">
                    <h4 class="modal-title m-0 font-weight-bold">Gestión de Proveedor</h4>
                    <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
                </div>
                
                <div class="modal-body modal-body-modern">
                    <div class="row">
                        <!-- RUC -->
                        <div class="col-md-6">
                            <div class="form-group-material">
                                <label for="ruc"><?php echo Session::get('tribAcr'); ?></label>
                                <input type="text" class="form-control" name="ruc" id="ruc" minlength="<?php echo Session::get('tribCar'); ?>" maxlength="<?php echo Session::get('tribCar'); ?>" autocomplete="off" required/>
                            </div>
                        </div>

                        <!-- RAZON SOCIAL -->
                        <div class="col-md-12">
                            <div class="form-group-material">
                                <label for="razon_social">Razón Social</label>
                                <input type="text" class="form-control input-mayus" name="razon_social" id="razon_social" autocomplete="off" required/>
                            </div>
                        </div>
                        
                        <!-- DIRECCION -->
                        <div class="col-md-12">
                            <div class="form-group-material">
                                <label for="direccion">Dirección</label>
                                <input type="text" class="form-control" name="direccion" id="direccion" autocomplete="off" required/>
                            </div>
                        </div>

                        <!-- TELEFONO -->
                        <div class="col-md-6">
                            <div class="form-group-material">
                                <label for="telefono">Teléfono</label>
                                <input type="text" class="form-control" name="telefono" id="telefono" autocomplete="off"/>
                            </div>
                        </div>

                        <!-- CONTACTO -->
                        <div class="col-md-6">
                            <div class="form-group-material">
                                <label for="contacto">Contacto</label>
                                <input type="text" class="form-control input-mayus" name="contacto" id="contacto" autocomplete="off"/>
                            </div>
                        </div>

                        <!-- EMAIL -->
                        <div class="col-md-12">
                            <div class="form-group-material m-0">
                                <label for="email">Correo Electrónico</label>
                                <input type="email" class="form-control" name="email" id="email" autocomplete="off"/>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer" style="border-top: 1px solid #f0f0f0;">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-success shadow-sm">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>