/* ESTADO DE LOS PEDIDOS
a = aperturado/abierto/activo/
b = preparacion
c = en camino
d = despachado/entregado/cerrado
z = anulado
*/

var Categorias = [];

var Productos = [];

var selectedCategoryId = null;

var selectionMode = false;

var selectedProducts = [];

var pedidoSeleccionado = [];

var modoListaProductos = "grid";

var TotalPedido = 0;

let isLoadingPedidos = false;
let ajaxListarPedidos = null;

var mesaListXHR = null;
var mesaListTimeout = null;
var currentSalon = null;

var moneda = $("#moneda").val();
$(function () {
  console.log($("#comision_tarjeta").val());

  $("#button-open-modal-menu").on("click", function () {
    openModalTest();
  });
  moment.locale("es");
  mesa_list(1);
  tiempo_mesa();
  //setInterval(tiempo_mesa, 1000);
  tiempo_pedido();
  //setInterval(tiempo_pedido, 1000);
  tiempo_preparacion();
  //setInterval(tiempo_preparacion, 1000);
  //countNuevoPedidoDelivery();
  //setInterval(countNuevoPedidoDelivery, 10000);
  alert_pedidos_programados();
  //setInterval(alert_pedidos_programados, 50000);
  validarApertura();
  listarCategorias();

  document
    .querySelector(".section-category")
    .addEventListener("wheel", function (e) {
      if (e.deltaY !== 0) {
        e.preventDefault();
        this.scrollLeft += e.deltaY;
      }
    });

  let dataMozo = $("#mozos_data").val();
  dataMozo = JSON.parse(dataMozo);

  $("#btn_close_aside").on("click", function (e) {
    e.preventDefault();

    var $panel = $("#modal-super-test");

    // 1) Si es un modal de BS4, ciérralo
    if ($panel.hasClass("modal")) {
      $panel.modal("hide");
      // también quita el backdrop si queda alguno
      $(".modal-backdrop").remove();

      // 2) Si es un Collapse (offcanvas custom), ciérralo
    } else if ($panel.hasClass("collapse")) {
      $panel.collapse("hide");

      // 3) Fallback: quita clases manualmente
    } else {
      $panel.removeClass("show");
    }
  });

  $("#descuento_porcentaje").on("input", function () {
    let pct = parseFloat(this.value) || 0;
    if (pct < 0) pct = 0;
    if (pct > 100) pct = 100;
    // 3) Calculas el monto de descuento
    const monto = (TotalPedido * pct) / 100;
    // 4) Lo vuelcas donde quieras y haces tu log
    console.log(
      "TotalPedido:",
      TotalPedido,
      "– %:",
      pct,
      "– Descuento:",
      monto
    );
    $("#descuento_monto_fijo").val(monto.toFixed(2));
  });

  function sanitize($el) {
    let v = String($el.val() || "");

    // Solo números y punto
    v = v.replace(/[^\d.]/g, "");

    // Mantener solo el primer punto decimal
    const i = v.indexOf(".");
    if (i !== -1) v = v.slice(0, i + 1) + v.slice(i + 1).replace(/\./g, "");

    $el.val(v);
  }

  // Sanea mientras escribe
  $(document).on("input", ".decimal-only", function () {
    sanitize($(this));
  });

  // Sanea al pegar
  $(document).on("paste", ".decimal-only", function () {
    const $el = $(this);
    setTimeout(() => sanitize($el), 0);
  });

  // Evita arrastrar texto
  $(document).on("drop", ".decimal-only", function (e) {
    e.preventDefault();
  });

  // Bloquea exponentes/signos
  $(document).on("keydown", ".decimal-only", function (e) {
    if (["e", "E", "+", "-"].includes(e.key)) e.preventDefault();
  });

  // Normaliza al salir (quita punto final suelto)
  $(document).on("blur", ".decimal-only", function () {
    let v = this.value;
    if (v === ".") v = "0";
    if (v.endsWith(".")) v = v.slice(0, -1);
    this.value = v;
  });

  $("#pago_tar").on("input", function () {
    let valor = $(this).val();
    let tipo_pago = parseInt($("#tipo_pago").val());
    let porcentaje_comision_tarjeta = $("#comision_tarjeta").val();
    let comision_tarjeta_check = $(".comision_tarjeta_venta").is(":checked");
    let comision_tarjeta = 0;
    let totalPagos = 0;

    let pagoEfectivo = $("#pago_efe").val();
    let pagoYape = $("#pago_yape").val();

    if (
      tipo_pago === 3 &&
      porcentaje_comision_tarjeta > 0 &&
      comision_tarjeta_check
    ) {
      porcentaje_comision_tarjeta = porcentaje_comision_tarjeta / 100;
      comision_tarjeta = valor * porcentaje_comision_tarjeta;

      console.log(comision_tarjeta);

      $(".comisionTarjeta").text(formatNumber(comision_tarjeta));

      totalPagos =
        parseFloat(pagoEfectivo) +
        parseFloat(pagoYape) +
        parseFloat(valor) +
        comision_tarjeta;

      $(".totalPedidoMenosTarjeta").text(formatNumber(totalPagos));
    }
  });

  $("#pago_efe, #pago_yape").on("input", function () {
    let tipo_pago = parseInt($("#tipo_pago").val());
    let porcentaje_comision_tarjeta = $("#comision_tarjeta").val();

    let pagoEfectivo = $("#pago_efe").val();
    let pagoYape = $("#pago_yape").val();
    let pagoTarjeta = $("#pago_tar").val();
    let comision = parseFloat($(".comisionTarjeta").text()) || 0;
    let comision_tarjeta = $(".comision_tarjeta_venta").is(":checked");
    let totalPagos = 0;

    comision =
      tipo_pago === 3 && porcentaje_comision_tarjeta > 0 && comision_tarjeta
        ? comision
        : 0;

    totalPagos =
      parseFloat(pagoEfectivo) +
      parseFloat(pagoYape) +
      parseFloat(pagoTarjeta) +
      comision;

    $(".totalPedidoMenosTarjeta").text(formatNumber(totalPagos));
  });

  const $select = $('<select class="form-control"></select>');
  // Agregar las opciones
  dataMozo.forEach(function (mozo) {
    const nombre = `${mozo.nombres} ${mozo.ape_paterno} ${mozo.ape_materno}`;
    const $option = $("<option></option>").val(mozo.id_usu).text(nombre);
    $select.append($option);
  });

  // Insertar el select dentro del div
  $("#select_mozo").html($select);

  $("#btnActualizarDataDelivery").on("click", function (event) {
    event.preventDefault(); // Evitar redirección

    actualizarDataDelivery();
  });

  $("#btn_descuentos").on("click", function (event) {
    actualizarPrecioDescuentos();
    event.preventDefault(); // Evitar redirección
  });

  $("#tipo_descuento_select").on("change", function () {
    var tipo = $(this).val(); // 'cortesia', 'descuento', 'credito_personal' o ''
    tipo_pago = $("#id_tipo_pago").val();
    value = $('input:radio[name="tipo_doc"]:checked').val();

    console.log(tipo);

    // Lógica específica por tipo
    switch (tipo) {
      case "0":
        $(".display-descuento-monto").hide();
        $(".display-personal").hide();

        break;
      case "1":
        if (value == 1 || value == 2) {
          mostrarAlerta(
            "warning",
            "Atención",
            "No se puede aplicar cortesía con boleta o factura."
          );
          return;
        }
        $(".display-descuento-monto").hide();
        $(".display-personal").hide();

        break;
      case "2":
        $(".display-personal").hide();
        $(".display-descuento-monto").show();

        break;
      case "3":
        $(".display-personal").show();
        $(".display-descuento-monto").show();
        listarPersonal();
        break;
    }
  });

  $("#input-buscar-carta").on("keyup", function () {
    const filtro = $(this).val().toLowerCase();
    const idCategoriaSeleccionada = $(
      ".list-categories .card-category.selected"
    ).data("id");

    if (filtro.trim().length > 0) {
      const resultados = Productos.filter((producto) => {
        return (
          producto.pro_nom.toLowerCase().includes(filtro) ||
          producto.pro_pre.toLowerCase().includes(filtro)
        );
      });

      generarProductos(resultados);
      return;
    }

    listarProductos(idCategoriaSeleccionada, modoListaProductos);
  });

  $(".change-mode button").on("click", function () {
    // marcar solo este botón como activo

    const idCategoriaSeleccionada = $(
      ".list-categories .card-category.selected"
    ).data("id");
    $(this)
      .addClass("btn-primary")
      .removeClass("btn-secondary")
      .siblings()
      .removeClass("btn-primary")
      .addClass("btn-secondary");

    // ver qué modo se pidió

    modoListaProductos = $(this).find(".fa-th").length ? "grid" : "list";

    listarProductos(idCategoriaSeleccionada, modoListaProductos);
  });

  $("#list-pedidos")
    .off("click", ".comment-list")
    .on("click", ".comment-list", function (e) {
      if (!selectionMode) return;

      e.stopImmediatePropagation();
      const $orderItemEl = $(this);
      const maxSelectableQty =
        parseInt($orderItemEl.attr("data-quantity"), 10) || 0;
      let selectedQty = parseInt($orderItemEl.attr("data-selected"), 10) || 0;
      const unitPrice = parseFloat($orderItemEl.attr("data-price")) || 0;

      // Toggle de selección
      if (selectedQty < maxSelectableQty) {
        selectedQty++;
        $orderItemEl.addClass("selected");
      } else {
        selectedQty = 0;
        $orderItemEl.removeClass("selected");
      }
      $orderItemEl.attr("data-selected", selectedQty);
      $orderItemEl
        .find(".selection-counter")
        .text(`${selectedQty}/${maxSelectableQty}`);

      // *** 1) Actualiza subtotal de ESTE ítem ***
      const itemSubtotal = selectedQty * unitPrice;
      $orderItemEl
        .find(".price")
        .text(`${moneda} ${formatNumber(itemSubtotal)}`);

      let totalSelectedSubtotal = 0;
      $("#list-pedidos .comment-list").each(function () {
        const cantidad = parseInt($(this).attr("data-selected"), 10) || 0;
        const precio = parseFloat($(this).attr("data-price")) || 0;
        totalSelectedSubtotal += cantidad * precio;
      });

      console.log(totalSelectedSubtotal);
      calcularTotalDividirCuenta(totalSelectedSubtotal);
    });

  $(document).on("input", "#numero_cliente", function () {
    const $this = $(this);
    const val = $this.val().trim();
    const len = val.length;

    if (len === 11) {
      $("#button-addon2").prop("disabled", false); // habilita el botón
    } else {
      $("#button-addon2").prop("disabled", true); // lo deshabilita si no tiene 11
    }
  });

  //   $(document).on("click", ".agregar-precio", function (e) {
  //     e.stopPropagation(); // evita conflicto con el clic general

  //     const $btn  = $(this);
  //     const precio = $(this).data("precio");
  //     const id_pres = $(this).data("id_pres");
  //     const nombre_precio = $(this).data("price-name");
  //     const productoBase = $(this).data("producto");
  //     const $card = $btn.closest(".card-menu-wrapper").find(".card-menu");

  //     const producto = {
  //       ...productoBase,
  //       pro_cos: precio,
  //       id_pres: id_pres,
  //       nombre_precio : nombre_precio,
  //       cantidad: 1
  //     };

  //     if (producto.Stock && producto.Stock.crt_stock == 1 && producto.Stock.ingredientes) {

  //       if (tieneStockDisponible(producto)) {

  //         agregarProducto(producto);
  //         actualizarStockVisual($card[0], producto);
  //       } else {
  //         mostrarAlerta('warning', 'Sin stock disponible', 'No hay stock suficiente para agregar este producto.');
  //       }
  //     } else {
  //       agregarProducto(producto);
  //     }

  //     $btn.closest(".card-menu-wrapper").find(".content").slideUp("fast");

  //   });

  $(document).on("click", ".agregar-precio", function (e) {
    e.stopPropagation();

    const $btn = $(this);
    const precio = $btn.data("precio");
    const id_pres = $btn.data("id_pres");
    const nombre_precio = $btn.data("price-name");

    const productoBase = Productos.find((p) => p.id_pres == id_pres);

    if (!productoBase) {
      console.warn("Producto no encontrado para id_pres:", id_pres);
      return;
    }

    const producto = {
      ...productoBase,
      pro_cos: precio,
      id_pres: id_pres,
      nombre_precio: nombre_precio,
      cantidad: 1,
    };

    const $wrapper = $btn.closest(".card-menu-wrapper");

    //const $card = $btn.closest(".card-menu-wrapper").find(".card-menu");

    if (
      producto.Stock &&
      producto.Stock.crt_stock == 1 &&
      producto.Stock.ingredientes
    ) {
      if (tieneStockDisponible(producto)) {
        agregarProducto(producto);
        actualizarStockVisual($wrapper[0], producto);
        actualizarBadgeDelProducto(producto.id_pres); // 🔥 fuerza re-render del badge
      } else {
        mostrarAlerta(
          "warning",
          "Sin stock disponible",
          "No hay stock suficiente para agregar este producto."
        );
      }
    } else {
      agregarProducto(producto);
    }

    $btn.closest(".card-menu-wrapper").find(".content").slideUp("fast");
  });

  $(".list-categories").on("wheel", function (e) {
    e.preventDefault();
    this.scrollLeft += e.originalEvent.deltaY;
  });

  $(document).on("click", "#btn_registrar_pedido", function (e) {
    e.preventDefault();
    guardarPedido();
  });

  $("#pago_efe, #pago_tar, #pago_yape").on("input", calcularPagos);

  $(".por_consumo").on("click", function (e) {
    if ($(e.target).is("input")) {
      return;
    }

    if ($("#order-name-por_consumo").is(":visible")) {
      $("#input_por_consumo")
        .val($("#order-name-por_consumo").text().trim())
        .show()
        .focus()
        .select();
      $("#order-name-por_consumo").hide();
    }
  });

  $("#input_por_consumo").on("blur", function () {
    var nuevoTexto = $(this).val();
    $("#order-name-por_consumo").text(nuevoTexto).show();
    $(this).hide();
  });

  $("#input_por_consumo").on("keydown", function (e) {
    if (e.key === "Enter") {
      // o e.keyCode === 13
      e.preventDefault();
      $(this).blur();
    }
  });

  $(document).on("click", ".po-item .edit_precio", function (e) {
    e.stopPropagation();
    const permisoEditarPrecio = $("#permisoEditarPrecio").val() === "1";

    if (!permisoEditarPrecio) {
      mostrarAlerta(
        "warning",
        "sin permisos",
        "No tienes permiso para editar el precio"
      );
      return;
    }

    const $wrapper = $(this).closest(".po-item-wrapper");
    const product = $wrapper.data("item");
    const $priceSpan = $wrapper.find(".price");
    const oldPrice = parseFloat($priceSpan.text()) || 0;

    if ($wrapper.find(".price-edit-input").length) return;

    const $input = $(`
      <input
        type="number"
        class="price-edit-input form-control form-control-sm"
        style="width:80px; display:inline-block; margin-left:.5rem;"
        step="0.01"
        value="${oldPrice.toFixed(2)}"
      >
    `);

    $priceSpan.replaceWith($input);
    $input.focus().select();

    $input.on("blur keyup", function (evt) {
      if (evt.type === "blur" || evt.key === "Enter") {
        let nv = parseFloat($input.val());
        if (isNaN(nv) || nv < 0) nv = oldPrice;

        product.pro_cos = nv.toFixed(2);
        const $newSpan = $(`<span class="price">${nv.toFixed(2)}</span>`);
        $input.replaceWith($newSpan);

        actualizarTotalesDesdeLista();
      }
    });
  });

  $(document).on("click", ".po-item .comments", function (e) {
    e.stopPropagation();

    const $wrapper = $(this).closest(".po-item-wrapper");
    const product = $wrapper.data("item");
    const $content = $wrapper.find(".content");
    const $checkboxContainer = $wrapper.find(".nota-list .demo-checkbox");

    console.log(product);

    // 1) Calculamos aquí el array de notas originales (si existen)
    const notasOriginal =
      product.notas && product.notas.notas
        ? product.notas.notas
          .split(",")
          .map((n) => n.trim())
          .filter((n) => n)
        : [];

    $content.slideToggle("fast");
    if (!$content.is(":visible")) return;

    // 2) Inicialización de los checkboxes (sólo la primera vez)
    if (!$wrapper.data("initialized")) {
      $checkboxContainer.empty().addClass("row");

      notasOriginal.forEach((nota, idx) => {
        const cbId = `nota-${product.wrapperId}-${idx}`;
        const checked = (product.selectedNotas || []).includes(nota)
          ? "checked"
          : "";
        const html = `
          <div class="col-6 mb-2">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="${cbId}"
                     value="${nota}" ${checked}>
              <label class="form-check-label" for="${cbId}">${nota}</label>
            </div>
          </div>
        `;
        $checkboxContainer.append(html);
      });

      $wrapper.find(".nota-new").toggle(notasOriginal.length === 0);
      $wrapper.find(".nota-list").show();
      $wrapper.data("initialized", true);
    }

    // 3) Manejo de cambios en los checkboxes
    $checkboxContainer
      .off("change")
      .on("change", "input[type=checkbox]", function () {
        // recolectamos seleccionadas
        const seleccionadas = $checkboxContainer
          .find("input:checked")
          .map((i, el) => el.value.trim())
          .get();

        // guardamos en el producto
        product.selectedNotas = seleccionadas;

        // reconstruimos el texto intermedio: notas manuales + seleccionadas
        const $texto = $wrapper.find(".texto-intermedio");
        const actualTexto = $texto.text().trim();
        const manuales = actualTexto
          .split(",")
          .map((t) => t.trim())
          .filter((t) => t && !notasOriginal.includes(t));

        $texto.text([...manuales, ...seleccionadas].join(", "));
      });

    // 4) Al abrir siempre actualizamos el texto según lo guardado
    const prevSel = product.selectedNotas || [];
    const $texto = $wrapper.find(".texto-intermedio");
    const manuales = $texto
      .text()
      .split(",")
      .map((t) => t.trim())
      .filter((t) => t && !notasOriginal.includes(t));

    $texto.text([...manuales, ...prevSel].join(", "));
  });

  $(document).on("click", "#ver_seleccionados", function () {
    $(".modal-order-right").css("display", "block");
  });

  $(document).on("click", ".guardar-nota-manual", function () {
    const $clickedWrapper = $(this).closest(".po-item-wrapper");
    const nota = $clickedWrapper.find(".nota_manual_text").val().trim();
    const producto = $clickedWrapper.data("item");

    if (nota === "") {
      alert("Por favor escribe una nota antes de guardar.");
      return;
    }

    $.ajax({
      url: $("#url").val() + "venta/tags_crud",
      method: "POST",
      dataType: "json",
      data: {
        id_prod: producto.notas.id_prod,
        notas: nota.toUpperCase(),
      },
      success: function (response) {
        if (response.success) {
          const cleanNota = nota.toUpperCase();

          // ✅ ACTUALIZA LAS NOTAS EN EL OBJETO PRODUCTO
          producto.notas.notas = producto.notas.notas
            ? `${producto.notas.notas},${cleanNota}`
            : cleanNota;

          if (!Array.isArray(producto.selectedNotas)) {
            producto.selectedNotas = [];
          }

          if (!producto.selectedNotas.includes(cleanNota)) {
            producto.selectedNotas.push(cleanNota);
          }

          // Recorrer todos los productos con el mismo id_pres
          $(".po-item-wrapper").each(function () {
            const $wrapper = $(this);
            const item = $wrapper.data("item");

            if (item.id_pres === producto.id_pres) {
              const $checkboxContainer = $wrapper.find(
                ".nota-list .demo-checkbox"
              );
              const existeCheckbox =
                $checkboxContainer.find(`input[value="${cleanNota}"]`).length >
                0;

              if (!existeCheckbox) {
                const id = `nota-${item.id_pres}-${Date.now()}`;
                const checkboxHtml = `
                <div class="col-md-6 col-sm-12 mb-2">
                  <div class="form-check">
                    <input class="form-check-input checkk chk-col-light-green" type="checkbox" id="${id}" name="checks[]" value="${cleanNota}" checked>
                    <label class="form-check-label" for="${id}">${cleanNota}</label>
                  </div>
                </div>
              `;
                $checkboxContainer.append(checkboxHtml);
                $checkboxContainer.find(`#${id}`).trigger("change");

                if (!$checkboxContainer.data("change-registered")) {
                  $checkboxContainer.on(
                    "change",
                    "input[type='checkbox']",
                    function () {
                      const seleccionadas = $checkboxContainer
                        .find("input:checked")
                        .map(function () {
                          return $(this).val().trim();
                        })
                        .get();

                      const $texto = $wrapper.find(".texto-intermedio");
                      const actualTexto = $texto.text().trim();
                      const partes = actualTexto
                        .split(",")
                        .map((p) => p.trim())
                        .filter((p) => p !== "");

                      const todasLasOpciones = $checkboxContainer
                        .find("input[type='checkbox']")
                        .map(function () {
                          return $(this).val().trim();
                        })
                        .get();

                      const notasManual = partes.filter(
                        (n) => !todasLasOpciones.includes(n)
                      );
                      const combinado = [...notasManual, ...seleccionadas].join(
                        ", "
                      );
                      $texto.text(combinado);

                      $checkboxContainer.data("seleccionadas", seleccionadas);
                    }
                  );

                  $checkboxContainer.data("change-registered", true);
                }
              }
            }
          });

          // Limpiar campo de nota manual
          $clickedWrapper.find(".nota_manual_text").val("").focus();
          $clickedWrapper.find(".nota-new").hide();
        } else {
          mostrarAlerta("Error al guardar nota", "error");
        }
      },
      error: function () {
        mostrarAlerta("Error al conectar con el servidor", "error");
      },
    });
  });

  $(document).on("click", ".po-item .remove-item", function (e) {
    e.stopPropagation();
    var $wrapper = $(this).closest(".po-item-wrapper");
    var prod = $wrapper.data("item");

    if (prod) {
      if (!prod.isNew) {
        anularPedido(
          $("#id_pedido").val(),
          prod.id_pres,
          prod.cantidad,
          prod.pro_nom,
          prod.pro_pre,
          prod.fecha_pedido,
          prod.estado_pedido,
          $wrapper, // Pasar el elemento para eliminarlo después
          prod // Pasar los datos del producto
        );
      } else {
        reponerStockVisual(prod);
        $wrapper
          .find(".demo-checkbox")
          .removeData("initialized")
          .removeData("seleccionadas");
        $wrapper.remove();
        actualizarTotalesDesdeLista();
        actualizarContadorPedidos();
      }
    }
  });

  $(document).on("click", ".agregar-nota-manual", function () {
    const $wrapper = $(this).closest(".po-item-wrapper");
    const nota = $wrapper.find(".nota_manual_text").val().trim();

    if (nota !== "") {
      const $texto = $wrapper.find(".texto-intermedio");
      const actual = $texto.text().trim();

      const combinado = actual ? actual + ", " + nota : nota;

      $texto.text(combinado);
      $wrapper.find(".nota_manual_text").val("").focus();
    }
  });

  $("#form-nuevo-pedido").on("keydown", function (e) {
    //$('#input_por_consumo').blur();
    if (e.key === "Enter") {
      e.preventDefault();
      return false;
    }
  });

  $(document).on("click", ".cantidad .up", function () {
    var $count = $(this).prev();
    var count = parseInt($count.text());
    $count.text(count + 1);
    actualizarTotalesDesdeLista();
  });

  $(document).on("click", ".cantidad .down", function () {
    var $count = $(this).next();
    var count = parseInt($count.text());
    if (count > 1) {
      $count.text(count - 1);
    }
    actualizarTotalesDesdeLista();
  });

  const pusher = new Pusher("01c14cdca26db19318e0", {
    cluster: "us2",
    forceTLS: true,
  });

  const channel = pusher.subscribe("pale-channel");

  channel.bind("new-notification", async function (data) {
    try {
      mesa_list($("#id_salon").val());
      await getProductosByCategory();
      listarProductos(selectedCategoryId, modoListaProductos);
    } catch (err) {
      console.error("Error actualizando tras la notificación:", err);
    }
  });

  $(".scroll_list_items_facturar").slimscroll({
    height: "100%",
  });
  var scroll_list_items_facturar = function () {
    var topOffset = 400;
    var height =
      (window.innerHeight > 0 ? window.innerHeight : this.screen.height) - 1;
    height = height - topOffset;
    $(".scroll_list_items_facturar").css("height", height + "px");
  };

  $(window).ready(scroll_list_items_facturar);
  $(window).on("resize", scroll_list_items_facturar);

  var parametro = getUrlParameter("cod");
  if (parametro !== undefined) {
    if (getUrlParameter("tip") == 3) {
      $("#codtipoped").val(3);
      listarPedidosDetalle(3, parametro, 0);
      activaTab("tabp-3");
      $("#form-nuevo-pedido").attr("action", "venta/pedido_create/pc3");
      if (getUrlParameter("est") == "a") {
        $("#codpestdelivery").val(1);
        activaTab("delivery01");
        delivery_list_a();
        editar_pedido(parametro);
      } else if (getUrlParameter("est") == "b") {
        activaTab("delivery02");
        delivery_list_b();
      } else if (getUrlParameter("est") == "c") {
        activaTab("delivery03");
        delivery_list_c();
      } else if (getUrlParameter("est") == "d") {
        activaTab("delivery04");
        delivery_list_d();
      }
      $(".display-estado-mesa").css("display", "none");
      $(".cont01-1").css("display", "none");
      $(".cont01-2").css("display", "block");
    } else if (getUrlParameter("tip") == 2) {
      activaTab("tabp-2");
      if (getUrlParameter("est") == "a") {
        $("#codtipoped").val(2);
        activaTab("mostrador01");
        mostrador_list_a();
        //listarPedidosDetalle(2,parametro,0);
      }
      $("#form-nuevo-pedido").attr("action", "venta/pedido_create/pc2");
      $(".display-estado-mesa").css("display", "none");
      $(".cont01-1").css("display", "none");
      $(".cont01-2").css("display", "block");
    }
  }
  $("#form-nuevo-pedido")
    .formValidation({
      framework: "bootstrap",
      excluded: ":disabled",
      fields: {},
    })
    .on("success.form.fv", function (e) {
      // Prevent form submission
      if ($("#codtipoped").val() == 3 && $("#cliente_id").val() == "") {
        Swal.fire(
          {
            title: "Advertencia",
            text: "Ingrese un cliente al pedido",
            icon: "warning",
            confirmButtonColor: "#34d16e",
            confirmButtonText: "Aceptar",
            allowOutsideClick: false,
            showCancelButton: false,
            showConfirmButton: true,
          },
          function () {
            return false;
          }
        );
        return false;
      } else {
        e.preventDefault();
        var $form = $(e.target);
        var fv = $form.data("formValidation");
        fv.defaultSubmit();
      }
    });
  $("#form-cambiar-mesa")
    .formValidation({
      framework: "bootstrap",
      excluded: ":disabled",
      fields: {},
    })
    .on("success.form.fv", function (e) {
      // Prevent form submission
      e.preventDefault();
      var $form = $(e.target);
      var fv = $form.data("formValidation");
      fv.defaultSubmit();
    });

  $(".opc-01").click(function () {
    $("#pago_efe").val($(".totalPedido").val());
    calculo_efectivo();
  });

  //   $('input[name="tipo_doc"]').on("change", function () {

  //     $tipo_descuento = $("#tipo_descuento_select").val();

  //     value = $('input:radio[name="tipo_doc"]:checked').val();

  //     console.log(value);

  //     if ((value == 2 || value == 1) && $tipo_descuento == 1) {
  //         mostrarAlerta(
  //             "warning",
  //             "Tipo de documento no permitido",
  //             "No se puede aplicar descuento cortesia para boletas o facturas"
  //         );
  //         $(`input[name="tipo_doc"][value="${3}"]`).prop('checked', true);
  //         return;
  //     }

  //     $("#cliente_tipo").val(value);
  //     $("#tipo_cliente").val(value);
  //     $("#id_cliente").val(1);
  //     // console.log(value)
  //     if (value == 3 || value == 1) {
  //       $("#cliente_id").val(1);
  //       $("#cliente_documento").val("");
  //       $("#buscar_cliente").val("DNI: 00000000 | PUBLICO EN GENERAL");
  //     } else {
  //       $("#cliente_id").val(1);
  //       $("#cliente_documento").val("");
  //       $("#buscar_cliente").val("");
  //     }
  //     $(".opcion-cliente").html(
  //       '<a class="input-group-prepend" href="javascript:void(0)"' +
  //         'onclick="nuevoClienteVista();" data-original-title="Registrar nuevo cliente" data-toggle="tooltip"' +
  //         'data-placement="top">' +
  //         '<span class="input-group-text bg-header">' +
  //         '<small><i class="fas fa-user-plus"></i></small>' +
  //         "</span>" +
  //         "</a>"
  //     );
  //   });

  $('input[name="tipo_doc"]').on("change", function () {
    const DEFAULT_TIPO_DOC = 3;

    const tipo_descuento = Number($("#tipo_descuento_select").val() || 0);
    let value = Number($('input[name="tipo_doc"]:checked').val() || 0);

    // Bloquea boleta/factura cuando hay cortesía
    if ((value === 1 || value === 2) && tipo_descuento === 1) {
      mostrarAlerta(
        "warning",
        "Tipo de documento no permitido",
        "No se puede aplicar descuento cortesía para boletas o facturas"
      );
      // Forzar selección a 3 y continuar con esa opción

      $(".btn-tipo-doc-2").removeClass("active");
      $(".btn-tipo-doc-1").removeClass("active");
      $(".btn-tipo-doc-3").addClass("active");
      $("input[name=tipo_doc][value='3']").attr("checked", true);
      return;
    }

    // Actualiza campos dependientes con el valor (posiblemente forzado a 3)
    $("#cliente_tipo").val(value);
    $("#tipo_cliente").val(value);
    $("#id_cliente, #cliente_id").val(1);
    $("#cliente_documento").val("");

    if (value === 1 || value === 3) {
      $("#buscar_cliente").val("DNI: 00000000 | PUBLICO EN GENERAL");
    } else {
      $("#buscar_cliente").val("");
    }

    $(".opcion-cliente").html(
      '<a class="input-group-prepend" href="javascript:void(0)" ' +
      'onclick="nuevoClienteVista();" data-original-title="Registrar nuevo cliente" ' +
      'data-toggle="tooltip" data-placement="top">' +
      '<span class="input-group-text bg-header"><small><i class="fas fa-user-plus"></i></small></span>' +
      "</a>"
    );
  });

  $("#form-mover-pedidos")
    .formValidation({
      framework: "bootstrap",
      excluded: ":disabled",
      fields: {},
    })
    .on("success.form.fv", function (e) {
      // Prevent form submission
      e.preventDefault();
      var $form = $(e.target);
      var fv = $form.data("formValidation");
      fv.defaultSubmit();
    });

  $("#form-editar-pedido")
    .formValidation({
      framework: "bootstrap",
      excluded: ":disabled",
      fields: {},
    })
    .on("success.form.fv", function (e) {
      e.preventDefault();
      var $form = $(e.target),
        fv = $form.data("formValidation");

      var id_repartidor =
        $("#id_repartidor_edit").val() == null
          ? "1"
          : $("#id_repartidor_edit").val();

      id_pedido = $("#id_pedido").val();
      hora_entrega = $("#hora_entrega_edit").val();
      id_repartidor = id_repartidor;
      amortizacion = $("#amortizacion").val();
      tipo_pago = $("#id_tipo_pago").val();
      paga_con = $("#paga_con").val();
      comision_delivery = $("#comision_delivery").val();

      $.ajax({
        dataType: "JSON",
        type: "POST",
        url: $("#url").val() + "venta/pedido_crud",
        data: {
          id_pedido: id_pedido,
          id_repartidor: id_repartidor,
          hora_entrega: hora_entrega,
          amortizacion: amortizacion,
          tipo_pago: tipo_pago,
          paga_con: paga_con,
          comision_delivery: comision_delivery,
        },
        success: function (cod) {
          $("#modal-editar-pedido").modal("hide");
          Swal.fire(
            {
              title: "Proceso Terminado",
              text: "Datos actualizados correctamente",
              icon: "success",
              confirmButtonColor: "#34d16e",
              confirmButtonText: "Aceptar",
              allowOutsideClick: false,
              showCancelButton: false,
              showConfirmButton: true,
            },
            function () {
              return false;
            }
          );
          delivery_list_a();
          delivery_list_b();
          listarPedidosDetalle(3, $("#id_pedido").val(), 0);
        },
        error: function (jqXHR, textStatus, errorThrown) {
          console.log(errorThrown + " " + textStatus);
        },
      });
      return false;
    });

  $("#btnDividirCuenta").on("click", function (event) {
    event.preventDefault();
    var id_pedido = $(this).data("id-pedido");
    var id_mesa = $(this).data("id-mesa");
  });

  $(".venta_por_consumo").on("click", function (event) {
    if ($(this).is(":checked")) {
      $("#venta_por_consumo").val("1");
      $(".lista-producto-facturar").hide();
      $(".lista-venta-por-consumo").show();
      $("#venta_por_consumo_concepto").focus();
      $("#venta_por_consumo_concepto").select();
      $("#static-list-pedidos").show();
      $(".scroll_pedidos").hide();
    } else {
      $("#venta_por_consumo").val("0");
      $("#static-list-pedidos").hide();
      $(".scroll_pedidos").show();
      $(".lista-producto-facturar").show();
      $(".lista-venta-por-consumo").hide();
    }
  });

  $(".comision_tarjeta_venta").on("click", function (event) {
    console.log("Comision Tarjeta Clicked");

    let comision_tarjeta = 0;
    let total_tarjeta = 0;
    let porcentaje_comision_tarjeta = $("#comision_tarjeta").val();

    let subtotal = parseFloat($(".SubtotalPedido").text());
    let descuento = parseFloat($(".totalDescuento").text());
    let delivery = parseFloat($(".totalDelivery").text());
    let total = parseFloat($(".totalPedidoMenosTarjeta").text());

    console.log(porcentaje_comision_tarjeta);

    if ($(this).is(":checked")) {
      if (
        isNaN(porcentaje_comision_tarjeta) ||
        porcentaje_comision_tarjeta <= 0
      ) {
        swal.fire({
          title: "Advertencia",
          text: "Ingrese un valor válido para la comisión de tarjeta o configure el porcentaje",
          icon: "warning",
          confirmButtonColor: "#34d16e",
          confirmButtonText: "Aceptar",
          allowOutsideClick: false,
          showCancelButton: false,
          showConfirmButton: true,
        });

        return;
      }

      porcentaje_comision_tarjeta = porcentaje_comision_tarjeta / 100;

      console.log(porcentaje_comision_tarjeta);

      comision_tarjeta = (subtotal - descuento) * porcentaje_comision_tarjeta;
      total_tarjeta = subtotal - descuento + delivery + comision_tarjeta;

      $(".comisionTarjeta").text(formatNumber(comision_tarjeta));
      $(".SubtotalPedido").text(formatNumber(subtotal));
      $(".totalDescuento").text(formatNumber(descuento));
      $(".totalDelivery").text(formatNumber(delivery));
      $(".totalPedidoMenosTarjeta").text(formatNumber(total_tarjeta));

      $(".view_comision_tarjeta").show();
      $("#tipo_pago").prop("selectedIndex", 1).trigger("change");
    } else {
      total_tarjeta = subtotal - descuento + delivery - comision_tarjeta;

      $("#tipo_pago").prop("selectedIndex", 0).trigger("change");
      $(".view_comision_tarjeta").hide();
      $(".comisionTarjeta").text(formatNumber(0));
      $(".SubtotalPedido").text(formatNumber(subtotal));
      $(".totalDescuento").text(formatNumber(descuento));
      $(".totalDelivery").text(formatNumber(delivery));
      $(".totalPedidoMenosTarjeta").text(formatNumber(total_tarjeta));
      $("#pago_efe").val(formatNumber(total_tarjeta));
    }
  });

  $("#tipo_pago").change(function () {
    var x = document.getElementById("tipo_pago").selectedIndex;
    value = document.getElementById("tipo_pago").options[x].label;

    console.log(value);


    if (value == 1) {

      limpiar_pagos_a();
      $(".mensaje-pago").hide();
      $(".display-pago-efectivo").show();
      $(".display-pago-tarjeta").hide();
      //$(".display-pago-default").show();
      $(".display-cod-voucher").hide();
      $(".display-pago-rapido-efectivo").show();
      $(".display-codigo-operacion").hide();
      $("#pago_efe").val(formatNumber(parseFloat($(".totalPedidoMenosTarjeta").first().text()) || 0));
      $(".opc-01").text(formatNumber($(".totalPedidoMenosTarjeta").val()));

    } else if (value == 3) {

      limpiar_pagos_a();
      $(".mensaje-pago").hide();
      $(".display-pago-efectivo").show();
      $(".display-pago-tarjeta").show();
      //$(".display-pago-default").show();
      $(".display-cod-voucher").hide();
      $(".display-pago-rapido-efectivo").show();
      $(".display-codigo-operacion").show();

    } else if (value == 4) {

      $(".mensaje-pago").hide();
      //$('.mensaje-pago-text').text(' Ingrese codigo de transferencia');
      $(".display-pago-efectivo").hide();
      $(".display-pago-tarjeta").hide();
      //$(".display-pago-default").hide();
      $(".display-cod-voucher").show();
      $(".display-pago-rapido-efectivo").hide();
      $(".display-codigo-operacion").show();

    } else if (value == 2) {
      limpiar_pagos_a();
      $(".mensaje-pago").hide();
      //$('.mensaje-pago-text').text(' Ingrese codigo de transferencia');
      $(".display-pago-efectivo").hide();
      $(".display-pago-tarjeta").hide();
      //$(".display-pago-default").hide();
      $(".display-cod-voucher").show();
      $(".display-pago-rapido-efectivo").hide();
      $(".display-codigo-operacion").show();
    } else if (value >= 5) {
      $(".mensaje-pago").hide();
      //$('.mensaje-pago-text').text(' Ingrese codigo de transferencia');
      $(".display-pago-efectivo").hide();
      $(".display-pago-tarjeta").hide();
      //$(".display-pago-default").hide();
      $(".display-cod-voucher").show();
      $(".display-pago-rapido-efectivo").hide();
      $(".display-codigo-operacion").show();
    }
    calculo_total();
  });

  $("#buscar_cliente").autocomplete({
    delay: 4,
    autoFocus: true,
    source: function (request, response) {
      $.ajax({
        url: $("#url").val() + "venta/buscar_cliente",
        type: "post",
        dataType: "json",
        data: {
          cadena: request.term,
          tipo_cliente: $("#cliente_tipo").val(),
        },
        success: function (data) {
          console.log(data);

          // Si no hay data, devolvemos un arreglo vacío.
          if (!data) {
            response([]);
            return;
          }

          // Si data no es un arreglo, lo envolvemos en uno.
          if (!Array.isArray(data)) {
            data = [data];
          }

          // Mapear los items. Se valida la existencia de propiedades y se normaliza el nombre.
          var items = $.map(data, function (item) {
            if (!item) return; // Evita errores si item es null

            // Determina el prefijo según la existencia y valor de 'ruc' o el tipo de cliente.
            // Puedes ajustar la lógica si la validación depende de otras propiedades.
            var tipo_cli =
              typeof item.ruc !== "undefined" && item.ruc
                ? $("#tribAcr").val()
                : $("#diAcr").val();

            // Normalizamos el nombre: Si 'nombre' no existe, se intenta 'nombres', luego 'razonSocial'
            var nombre = item.nombre || item.nombres || item.razonSocial || "";

            return {
              id: item.id_cliente || "",
              dni: item.dni || "",
              ruc: item.ruc || "",
              tipo: item.tipo_cliente || "",
              nombres: nombre,
              fecha_n: item.fecha_nac || "",
              label:
                tipo_cli +
                ": " +
                (item.dni || "") +
                (item.ruc || "") +
                " | " +
                nombre,
              value:
                tipo_cli +
                ": " +
                (item.dni || "") +
                (item.ruc || "") +
                " | " +
                nombre,
            };
          });

          response(items);
        },
      });
    },
    select: function (e, ui) {
      $("#cliente_id").val(ui.item.id);
      $("#cliente_documento").val(ui.item.ruc);
      $(this).blur();
      $("#btn-submit-facturar").removeAttr("disabled").removeClass("disabled");
      $(".opcion-cliente").html(
        '<a class="input-group-prepend" href="javascript:void(0)" ' +
        'onclick="editar_cliente(' +
        ui.item.id +
        ');" data-original-title="Editar cliente" data-toggle="tooltip" ' +
        'data-placement="top">' +
        '<span class="input-group-text bg-header"><small><i class="fas fa-user text-info"></i></small></span>' +
        "</a>"
      );
    },
  });

  $("#buscar_cliente_pedido").autocomplete({
    delay: 4,
    autoFocus: true,
    appendTo: "#modal-super-test",
    source: function (request, response) {
      $.ajax({
        url: $("#url").val() + "venta/buscar_cliente",
        type: "post",
        dataType: "json",
        data: {
          cadena: request.term,
          tipo_cliente: $("#cliente_pedido_tipo").val(),
        },
        success: function (data) {
          console.log(data);

          // Si no hay data, devolvemos un arreglo vacío.
          if (!data || data.length === 0) {
            $("#cliente_pedido_id").val(0); // ← Aquí asignas 0 si no hay resultados
            response([]);
            return;
          }

          // Si data no es un arreglo, lo envolvemos en uno.
          if (!Array.isArray(data)) {
            data = [data];
          }

          // Mapear los items. Se valida la existencia de propiedades y se normaliza el nombre.
          var items = $.map(data, function (item) {
            if (!item) return; // Evita errores si item es null

            // Determina el prefijo según la existencia y valor de 'ruc' o el tipo de cliente.
            // Puedes ajustar la lógica si la validación depende de otras propiedades.
            var tipo_cli =
              typeof item.ruc !== "undefined" && item.ruc
                ? $("#tribAcr").val()
                : $("#diAcr").val();

            // Normalizamos el nombre: Si 'nombre' no existe, se intenta 'nombres', luego 'razonSocial'
            var nombre = item.nombre || item.nombres || item.razonSocial || "";

            return {
              id: item.id_cliente || "",
              dni: item.dni || "",
              ruc: item.ruc || "",
              tipo: item.tipo_cliente || "",
              nombres: nombre,
              fecha_n: item.fecha_nac || "",
              label:
                tipo_cli +
                ": " +
                (item.dni || "") +
                (item.ruc || "") +
                " | " +
                nombre,
              value:
                tipo_cli +
                ": " +
                (item.dni || "") +
                (item.ruc || "") +
                " | " +
                nombre,
            };
          });

          response(items);
        },
      });
    },
    select: function (e, ui) {
      $("#cliente_pedido_id").val(ui.item.id);
      $(this).blur();

      $(".opcion-cliente-pedido").html(
        '<a class="input-group-prepend" href="javascript:void(0)" ' +
        'onclick="editar_cliente(' +
        ui.item.id +
        ');" data-original-title="Editar cliente" data-toggle="tooltip" ' +
        'data-placement="top">' +
        '<span class="input-group-text bg-header"><small><i class="fas fa-user text-info"></i></small></span>' +
        "</a>"
      );
    },
  });

  //$("#buscar_cliente").autocomplete("option", "appendTo", ".form-facturar");

  $("#form-editar-venta-pago")
    .formValidation({
      framework: "bootstrap",
      excluded: ":disabled",
      fields: {},
    })
    .on("success.form.fv", function (e) {
      e.preventDefault();
      var $form = $(e.target),
        fv = $form.data("formValidation");

      tipo_pago = $("#id_venta_tipopago").val();
      id_venta = $("#id_venta").val();
      id_tipo_pago = $("#id_tipo_pago_v").val();

      $.ajax({
        dataType: "JSON",
        type: "POST",
        url: $("#url").val() + "venta/venta_edit_pago",
        data: {
          id_venta: id_venta,
          id_tipo_pago: id_tipo_pago,
          tipo_pago: tipo_pago,
        },
        success: function (cod) {
          $("#modal-editar-venta-pago").modal("hide");
          Swal.fire(
            {
              title: "Proceso Terminado",
              text: "Datos actualizados correctamente",
              icon: "success",
              confirmButtonColor: "#34d16e",
              confirmButtonText: "Aceptar",
              allowOutsideClick: false,
              showCancelButton: false,
              showConfirmButton: true,
            },
            function () {
              return false;
            }
          );
          delivery_list_c();
          listarPedidosDetalle(3, $("#id_pedido").val(), id_venta);
        },
        error: function (jqXHR, textStatus, errorThrown) {
          console.log(errorThrown + " " + textStatus);
        },
      });
      return false;
    });

  $("#telefono_cliente")
    .autocomplete({
      delay: 1,
      autoFocus: true,
      source: function (request, response) {
        $.ajax({
          url: $("#url").val() + "venta/buscar_cliente_telefono",
          type: "post",
          dataType: "json",
          data: {
            cadena: request.term,
          },
          success: function (data) {
            response(
              $.map(data, function (item) {
                tipo_cli =
                  item.tipo_cliente == 1
                    ? $("#diAcr").val()
                    : $("#tribAcr").val();
                // console.log(item)
                return {
                  id_cliente: item.id_cliente,
                  nombre: item.nombre,
                  telefono: item.telefono,
                  direccion: item.direccion,
                  referencia: item.referencia,
                  tipo_cliente: item.tipo_cliente,
                  ruc: item.ruc,
                  dni: item.dni,
                  //label: tipo_cli+': '+item.dni+''+item.ruc,
                  value: item.telefono,
                };
              })
            );
          },
        });
      },
      select: function (e, ui) {
        //$("#documento_cliente").val('');
        $("#cliente_id").val(ui.item.id_cliente);
        /////////////////////////////////////////////
        $(".display-nombre").css("display", "block");
        //$('.display-telefono-cliente').css('display','block');
        $("#nomb_cliente").removeAttr("disabled");
        //$("#telefono_cliente").removeAttr('disabled');
        /////////////////////////////////////////
        if ($("input:radio[name=tipo_entrega]:checked").val() == 1) {
          $(".display-direccion-cliente").css("display", "block");
          $(".display-referencia-cliente").css("display", "block");
          $(".display-repartidor").css("display", "block");
          $("#direccion_cliente").removeAttr("disabled");
          $("#referencia_cliente").removeAttr("disabled");
          $("#id_repartidor").removeAttr("disabled");
        } else {
          $(".display-direccion-cliente").css("display", "none");
          $(".display-referencia-cliente").css("display", "none");
          $(".display-repartidor").css("display", "none");
          $("#direccion_cliente").attr("disabled", "true");
          $("#referencia_cliente").attr("disabled", "true");
          $("#id_repartidor").attr("disabled", "true");
        }
        ////////////////////////////////////////////
        $("#telefono_cliente").val(ui.item.telefono);
        $("#nomb_cliente").val(ui.item.nombre);
        $("#nomb_cliente").val(ui.item.nombre);
        $("#direccion_cliente").val(ui.item.direccion);
        $("#referencia_cliente").val(ui.item.referencia);

        $("#num_cliente").val(
          ui.item.tipo_cliente == 1 ? ui.item.dni : ui.item.ruc
        );
        $("#id_tdoc").selectpicker("val", ui.item.tipo_cliente);
        $("#id_tdoc").selectpicker("refresh");

        $("#form-nuevo-pedido").formValidation(
          "revalidateField",
          "telefono_cliente"
        );
        $("#form-nuevo-pedido").formValidation(
          "revalidateField",
          "nomb_cliente"
        );
        $("#form-nuevo-pedido").formValidation(
          "revalidateField",
          "direccion_cliente"
        );
        $("#form-nuevo-pedido").formValidation(
          "revalidateField",
          "referencia_cliente"
        );
        //$('.btn-opc-nuevo-cliente').html('<button class="btn btn-info" onclick="editar_cliente('+ui.item.id_cliente+');" type="button"><i class="fa fa-user"></i></button>');
      },
      change: function (e, ui) {
        $("#documento_cliente").val("");
      },
    })
    .autocomplete("instance")._renderItem = function (ul, item) {
      return $("<li class='ui-menu-item'></li>")
        .data("item.autocomplete", item)
        .append(
          "<div class='ui-menu-item-wrapper'>" +
          item.nombre +
          "<br>Telefono/Celular: " +
          item.telefono +
          "</div>"
        )
        .appendTo(ul);
    };


  /*
    var minlength = 1;
    $("#telefono_cliente").keyup(function () {
        var that = this,
        value = $(this).val();
        if (value.length < minlength ) {
            //$("#cliente_id").val('');
            //////////////////////////////////////////////
            //$('.display-nombre').css('display','none');
            //$('.display-telefono-cliente').css('display','none');
            //$('.display-direccion-cliente').css('display','none');
            //$('.display-referencia-cliente').css('display','none');
            //$('.display-repartidor').css('display','none');
            //$("#nomb_cliente").attr('disabled','true');
            //$("#telefono_cliente").attr('disabled','true');
            //$("#direccion_cliente").attr('disabled','true');
            //$("#referencia_cliente").attr('disabled','true');
            $('#id_repartidor').selectpicker('refresh');
            $('#id_repartidor').selectpicker('val', '');
            $('#form-nuevo-pedido').formValidation('revalidateField', 'id_repartidor');
            ////////////////////////////////////////////
            $("#telefono_cliente").val('');
            $("#nomb_cliente").val('');
            $("#direccion_cliente").val('');
            $("#referencia_cliente").val('');
            $('#form-nuevo-pedido').formValidation('revalidateField', 'telefono_cliente');
            $('#form-nuevo-pedido').formValidation('revalidateField', 'nomb_cliente');
            $('#form-nuevo-pedido').formValidation('revalidateField', 'direccion_cliente');
            $('#form-nuevo-pedido').formValidation('revalidateField', 'referencia_cliente');
            //$('.btn-opc-nuevo-cliente').html('<button class="btn btn-secondary" onclick="nuevo_cliente();" type="button"><i class="fa fa-user-plus"></i></button>');
        }
    });
    */
});

function closeModalOrder() {
  if (esDispositivoMovil()) {
    $(".modal-order-right").css("display", "none");
  }
}

var mesa_list = function (cod) {
  // 🔥 Si ya está mostrando este salón, no hacer nada
  if (currentSalon === cod && mesaListXHR !== null) {
    console.log("Ya mostrando este salón, ignorando...");
    return;
  }

  console.log("mesa list - Solicitado para salón:", cod);
  currentSalon = cod;

  // Cancelar timeout anterior
  if (mesaListTimeout !== null) {
    clearTimeout(mesaListTimeout);
  }

  // Debounce para clicks rápidos entre tabs
  mesaListTimeout = setTimeout(function () {
    // Cancelar petición anterior
    if (mesaListXHR !== null) {
      mesaListXHR.abort();
    }

    $("#id_salon").val(cod);

    // Mostrar loading solo si el contenido está vacío
    if ($(".list-mesas").is(":empty")) {
      $(".list-mesas").html(`
        <div class="text-center p-3">
          <i class="fa fa-spinner fa-spin"></i>
          <small>Cargando mesas...</small>
        </div>
      `);
    }

    mesaListXHR = $.ajax({
      dataType: "JSON",
      type: "POST",
      url: $("#url").val() + "venta/mesa_list",
      data: { id_salon: cod }, // 🔥 Asegurar que se envía el salón correcto
      success: function (item) {
        // 🔥 VERIFICAR que todavía estamos en el mismo salón
        if (currentSalon !== cod) {
          console.log("Salón cambió durante la carga, ignorando respuesta");
          return;
        }

        $(".list-mesas").empty();

        var count = 0,
          count_disponibles = 0,
          count_ocupadas = 0,
          count_pagos = 0;

        $.each(item["mesa"], function (i, mesa) {
          x = mesa.estado == "a" ? count_disponibles++ : "NINGUNO";
          y = mesa.estado == "p" ? count_pagos++ : "NINGUNO";
          z = mesa.estado == "i" ? count_ocupadas++ : "NINGUNO";

          forma = mesa.forma == 1 ? "" : "rounded-circle";

          if ($("#rol_usr").val() == 5) {
            if (mesa.id_salon == cod && mesa.estado == "a") {
              $(".list-mesas").append(
                $(
                  '<button class="btn btn-green ' +
                  forma +
                  ' dim btn-large-dim"' +
                  'onclick="registrarMesa(' +
                  mesa.id_mesa +
                  ",'" +
                  mesa.nro_mesa +
                  "','" +
                  mesa.desc_salon +
                  "');\">" +
                  mesa.nro_mesa +
                  '<br><img src="public/images/table_empty.png" width="40px" height="40px" class="hidden-sm-down"/><input type="radio" autocomplete="off"></button>'
                )
              );
            } else if (mesa.id_salon == cod && mesa.estado == "p") {
              $(".list-mesas");
              $(".list-mesas").append(
                $(
                  '<input type="hidden" name="tiempo_mesa[]" value="' +
                  mesa.fecha_pedido +
                  '"/>' +
                  '<button class="btn btn-blue ' +
                  forma +
                  ' dim btn-large-dim"' +
                  'onclick="orden(' +
                  mesa.id_pedido +
                  ')">' +
                  '<span class="span-a"><i class="far fa-user"></i> ' +
                  mesa.nro_personas +
                  "</span><span>" +
                  mesa.nro_mesa +
                  '</span><br><img src="public/images/table_full.png" width="40px" height="40px" class="hidden-sm-down"/>' +
                  '<span class="span-b"><i class="ti-timer"></i>&nbsp;<span class="hora-mesa' +
                  count++ +
                  '">' +
                  moment(mesa.fecha_pedido).fromNow(true) +
                  '</span></span><input type="radio" autocomplete="off"></button>'
                )
              );
            } else if (mesa.id_salon == cod && mesa.estado == "i") {
              const $listMesas = $(".list-mesas");

              // Desestructura los valores que necesitas
              const {
                fecha_pedido,
                id_pedido,
                nro_personas,
                nro_mesa,
                desc_salon,
              } = mesa;

              // Genera la clase única y el texto “hace X” de Moment.js
              const timerClass = `hora-mesa${count++}`;
              const timeAgo = moment(fecha_pedido).fromNow(true);

              // Construye el <input hidden>
              const hiddenInput = `
              <input 
                type="hidden" 
                name="tiempo_mesa[]" 
                value="${fecha_pedido}"
              />
            `;

              // Construye el <button> completo
              const button = `
              <button
                class="btn btn-reed ${forma} dim btn-large-dim"
                onclick="orden(${id_pedido}, '${nro_mesa}', '${desc_salon}');"
              >
                <span class="span-a">
                  <i class="far fa-user"></i>
                  ${nro_personas}
                </span>
                <span>${nro_mesa}</span>
                <br/>
                <img
                  src="public/images/table_full.png"
                  width="40"
                  height="40"
                  class="hidden-sm-down"
                />
                <span class="span-b">
                  <i class="ti-timer"></i>
                  &nbsp;<span class="${timerClass}">${timeAgo}</span>
                </span>
                <input type="radio" autocomplete="off"/>
              </button>
            `;

              // Finalmente lo añade al DOM
              $listMesas.append($(hiddenInput + button));
            }
          } else {
            if (mesa.id_salon == cod && mesa.estado == "a") {
              $(".list-mesas").append(
                $(
                  '<button class="btn btn-green ' +
                  forma +
                  ' dim btn-large-dim"' +
                  'onclick="nuevoPedidoMesa(' +
                  mesa.id_mesa +
                  ",'" +
                  mesa.nro_mesa +
                  "','" +
                  mesa.desc_salon +
                  "')\">" +
                  mesa.nro_mesa +
                  '<br><img src="public/images/table_empty.png" width="40px" height="40px" class="hidden-sm-down"/><input type="radio" autocomplete="off"></button>'
                )
              );
            } else if (mesa.id_salon == cod && mesa.estado == "p") {
              $(".list-mesas");
              $(".list-mesas").append(
                $(
                  '<input type="hidden" name="tiempo_mesa[]" value="' +
                  mesa.fecha_pedido +
                  '"/>' +
                  '<button class="btn btn-blue ' +
                  forma +
                  ' dim btn-large-dim"' +
                  'onclick="listarPedidos(' +
                  mesa.id_salon +
                  "," +
                  mesa.id_mesa +
                  ",1," +
                  mesa.id_pedido +
                  ",'" +
                  mesa.nro_mesa +
                  "','" +
                  mesa.desc_salon +
                  "','" +
                  mesa.estado +
                  "')\">" +
                  '<span class="span-a"><i class="far fa-user"></i> ' +
                  mesa.nro_personas +
                  "</span><span>" +
                  mesa.nro_mesa +
                  '</span><br><img src="public/images/table_full.png" width="40px" height="40px" class="hidden-sm-down"/>' +
                  '<span class="span-b"><i class="ti-timer"></i> <span class="hora-mesa' +
                  count++ +
                  '">' +
                  moment(mesa.fecha_pedido).fromNow(true) +
                  '</span></span><input type="radio" autocomplete="off"></button>'
                )
              );
            } else if (mesa.id_salon == cod && mesa.estado == "i") {
              $(".list-mesas").append(
                $(
                  '<input type="hidden" name="tiempo_mesa[]" value="' +
                  mesa.fecha_pedido +
                  '"/>' +
                  '<button class="btn btn-reed ' +
                  forma +
                  ' dim btn-large-dim"' +
                  'onclick="listarPedidos(' +
                  mesa.id_salon +
                  "," +
                  mesa.id_mesa +
                  ",1," +
                  mesa.id_pedido +
                  ",'" +
                  mesa.nro_mesa +
                  "','" +
                  mesa.desc_salon +
                  "','" +
                  mesa.estado +
                  "')\">" +
                  '<span class="span-a"><i class="far fa-user"></i> ' +
                  mesa.nro_personas +
                  "</span><span>" +
                  mesa.nro_mesa +
                  '</span><br><img src="public/images/table_full.png" width="40px" height="40px" class="hidden-sm-down"/>' +
                  '<span class="span-b"><i class="ti-timer"></i> <span class="hora-mesa' +
                  count++ +
                  '">' +
                  moment(mesa.fecha_pedido).fromNow(true) +
                  '</span></span><input type="radio" autocomplete="off"></button>'
                )
              );
            }
          }
          console.log(mesa.id_salon);
        });
        $(".mesas-disponibles").attr(
          "data-original-title",
          count_disponibles + " mesas disponibles"
        );
        $("#mesa_libre").text(count_disponibles);
        $(".mesas-ocupadas").attr(
          "data-original-title",
          count_ocupadas + " mesas ocupadas"
        );
        $("#mesa_ocupada").text(count_ocupadas);
        $(".mesas-pago").attr(
          "data-original-title",
          count_pagos + " mesas en proceso de pago"
        );
        $("#mesa_proceso").text(count_pagos);
      },
      error: function (xhr, status, error) {
        if (status !== "abort" && currentSalon === cod) {
          console.error("Error cargando mesas:", error);
          $(".list-mesas").html(`
            <div class="text-center p-3 text-warning">
              <small>No se pudieron cargar las mesas</small>
            </div>
          `);
        }
      },
      complete: function () {
        mesaListXHR = null;
      },
    });
  }, 100); // 🔥 Debounce reducido a 100ms para mejor UX
};

// var mesa_list = function (cod) {
//   console.log("mesa list");

//   $("#id_salon").val(cod);

//   $(".list-mesas").empty();

//   $.ajax({
//     dataType: "JSON",
//     type: "POST",
//     url: $("#url").val() + "venta/mesa_list",
//     success: function (item) {
//       var count = 0,
//         count_disponibles = 0,
//         count_ocupadas = 0,
//         count_pagos = 0;

//       $.each(item["mesa"], function (i, mesa) {
//         x = mesa.estado == "a" ? count_disponibles++ : "NINGUNO";
//         y = mesa.estado == "p" ? count_pagos++ : "NINGUNO";
//         z = mesa.estado == "i" ? count_ocupadas++ : "NINGUNO";

//         forma = mesa.forma == 1 ? "" : "rounded-circle";

//         if ($("#rol_usr").val() == 5) {
//           if (mesa.id_salon == cod && mesa.estado == "a") {
//             $(".list-mesas").append(
//               $(
//                 '<button class="btn btn-green ' +
//                   forma +
//                   ' dim btn-large-dim"' +
//                   'onclick="registrarMesa(' +
//                   mesa.id_mesa +
//                   ",'" +
//                   mesa.nro_mesa +
//                   "','" +
//                   mesa.desc_salon +
//                   "');\">" +
//                   mesa.nro_mesa +
//                   '<br><img src="public/images/table_empty.png" width="40px" height="40px" class="hidden-sm-down"/><input type="radio" autocomplete="off"></button>'
//               )
//             );
//           } else if (mesa.id_salon == cod && mesa.estado == "p") {
//             $(".list-mesas");
//             $(".list-mesas").append(
//               $(
//                 '<input type="hidden" name="tiempo_mesa[]" value="' +
//                   mesa.fecha_pedido +
//                   '"/>' +
//                   '<button class="btn btn-blue ' +
//                   forma +
//                   ' dim btn-large-dim"' +
//                   'onclick="orden(' +
//                   mesa.id_pedido +
//                   ')">' +
//                   '<span class="span-a"><i class="far fa-user"></i> ' +
//                   mesa.nro_personas +
//                   "</span><span>" +
//                   mesa.nro_mesa +
//                   '</span><br><img src="public/images/table_full.png" width="40px" height="40px" class="hidden-sm-down"/>' +
//                   '<span class="span-b"><i class="ti-timer"></i>&nbsp;<span class="hora-mesa' +
//                   count++ +
//                   '">' +
//                   moment(mesa.fecha_pedido).fromNow(true) +
//                   '</span></span><input type="radio" autocomplete="off"></button>'
//               )
//             );
//           } else if (mesa.id_salon == cod && mesa.estado == "i") {
//             const $listMesas = $(".list-mesas");

//             // Desestructura los valores que necesitas
//             const {
//               fecha_pedido,
//               id_pedido,
//               nro_personas,
//               nro_mesa,
//               desc_salon,
//             } = mesa;

//             // Genera la clase única y el texto “hace X” de Moment.js
//             const timerClass = `hora-mesa${count++}`;
//             const timeAgo = moment(fecha_pedido).fromNow(true);

//             // Construye el <input hidden>
//             const hiddenInput = `
//               <input
//                 type="hidden"
//                 name="tiempo_mesa[]"
//                 value="${fecha_pedido}"
//               />
//             `;

//             // Construye el <button> completo
//             const button = `
//               <button
//                 class="btn btn-reed ${forma} dim btn-large-dim"
//                 onclick="orden(${id_pedido}, '${nro_mesa}', '${desc_salon}');"
//               >
//                 <span class="span-a">
//                   <i class="far fa-user"></i>
//                   ${nro_personas}
//                 </span>
//                 <span>${nro_mesa}</span>
//                 <br/>
//                 <img
//                   src="public/images/table_full.png"
//                   width="40"
//                   height="40"
//                   class="hidden-sm-down"
//                 />
//                 <span class="span-b">
//                   <i class="ti-timer"></i>
//                   &nbsp;<span class="${timerClass}">${timeAgo}</span>
//                 </span>
//                 <input type="radio" autocomplete="off"/>
//               </button>
//             `;

//             // Finalmente lo añade al DOM
//             $listMesas.append($(hiddenInput + button));
//           }
//         } else {
//           if (mesa.id_salon == cod && mesa.estado == "a") {
//             $(".list-mesas").append(
//               $(
//                 '<button class="btn btn-green ' +
//                   forma +
//                   ' dim btn-large-dim"' +
//                   'onclick="nuevoPedidoMesa(' +
//                   mesa.id_mesa +
//                   ",'" +
//                   mesa.nro_mesa +
//                   "','" +
//                   mesa.desc_salon +
//                   "')\">" +
//                   mesa.nro_mesa +
//                   '<br><img src="public/images/table_empty.png" width="40px" height="40px" class="hidden-sm-down"/><input type="radio" autocomplete="off"></button>'
//               )
//             );
//           } else if (mesa.id_salon == cod && mesa.estado == "p") {
//             $(".list-mesas");
//             $(".list-mesas").append(
//               $(
//                 '<input type="hidden" name="tiempo_mesa[]" value="' +
//                   mesa.fecha_pedido +
//                   '"/>' +
//                   '<button class="btn btn-blue ' +
//                   forma +
//                   ' dim btn-large-dim"' +
//                   'onclick="listarPedidos(' +
//                   mesa.id_salon +
//                   "," +
//                   mesa.id_mesa +
//                   ",1," +
//                   mesa.id_pedido +
//                   ",'" +
//                   mesa.nro_mesa +
//                   "','" +
//                   mesa.desc_salon +
//                   "','" +
//                   mesa.estado +
//                   "')\">" +
//                   '<span class="span-a"><i class="far fa-user"></i> ' +
//                   mesa.nro_personas +
//                   "</span><span>" +
//                   mesa.nro_mesa +
//                   '</span><br><img src="public/images/table_full.png" width="40px" height="40px" class="hidden-sm-down"/>' +
//                   '<span class="span-b"><i class="ti-timer"></i> <span class="hora-mesa' +
//                   count++ +
//                   '">' +
//                   moment(mesa.fecha_pedido).fromNow(true) +
//                   '</span></span><input type="radio" autocomplete="off"></button>'
//               )
//             );
//           } else if (mesa.id_salon == cod && mesa.estado == "i") {
//             $(".list-mesas").append(
//               $(
//                 '<input type="hidden" name="tiempo_mesa[]" value="' +
//                   mesa.fecha_pedido +
//                   '"/>' +
//                   '<button class="btn btn-reed ' +
//                   forma +
//                   ' dim btn-large-dim"' +
//                   'onclick="listarPedidos(' +
//                   mesa.id_salon +
//                   "," +
//                   mesa.id_mesa +
//                   ",1," +
//                   mesa.id_pedido +
//                   ",'" +
//                   mesa.nro_mesa +
//                   "','" +
//                   mesa.desc_salon +
//                   "','" +
//                   mesa.estado +
//                   "')\">" +
//                   '<span class="span-a"><i class="far fa-user"></i> ' +
//                   mesa.nro_personas +
//                   "</span><span>" +
//                   mesa.nro_mesa +
//                   '</span><br><img src="public/images/table_full.png" width="40px" height="40px" class="hidden-sm-down"/>' +
//                   '<span class="span-b"><i class="ti-timer"></i> <span class="hora-mesa' +
//                   count++ +
//                   '">' +
//                   moment(mesa.fecha_pedido).fromNow(true) +
//                   '</span></span><input type="radio" autocomplete="off"></button>'
//               )
//             );
//           }
//         }
//         console.log(mesa.id_salon);
//       });
//       $(".mesas-disponibles").attr(
//         "data-original-title",
//         count_disponibles + " mesas disponibles"
//       );
//       $("#mesa_libre").text(count_disponibles);
//       $(".mesas-ocupadas").attr(
//         "data-original-title",
//         count_ocupadas + " mesas ocupadas"
//       );
//       $("#mesa_ocupada").text(count_ocupadas);
//       $(".mesas-pago").attr(
//         "data-original-title",
//         count_pagos + " mesas en proceso de pago"
//       );
//       $("#mesa_proceso").text(count_pagos);
//     },
//   });
// };

// function get_json_pedidos() {
//     var pedidos = [];

//     $('#list-pedidos .comment-list').each(function () {
//         var pedido = {};

//         // Extraer información del evento onclick
//         var onclickAttr = $(this).attr('onclick'); // subPedido(1,10,5,'20.00');
//         var matches = onclickAttr.match(/subPedido\((\d+),(\d+),(\d+),'([\d.]+)'\)/);

//         if (matches) {
//             pedido.tipo = parseInt(matches[1]); // 1
//             pedido.id_pedido = parseInt(matches[2]); // 10
//             pedido.id_pres = parseInt(matches[3]); // 5
//             pedido.precio = parseFloat(matches[4]); // 20.00
//         }

//         // Extraer nombre del producto
//         pedido.producto = $(this).find('.r-order-type-label').text().trim();

//         // Extraer presentación del producto
//         pedido.presentacion = $(this).find('.order-name').text().trim();

//         // Extraer cantidad
//         var cantidadText = $(this).find('.order-units').text().match(/(\d+)\s+Unidad/);
//         pedido.cantidad = cantidadText ? parseInt(cantidadText[1]) : 0;

//         // Extraer el precio total
//         var totalText = $(this).find('.price').text().replace(/[^\d.]/g, '');
//         pedido.total = parseFloat(totalText) || 0;

//         pedidos.push(pedido);
//     });

//     return pedidos;
// }

function get_json_pedidos() {
  const id_pres_array = [];
  const precios_array = [];
  const cantidades_array = [];

  $("#list-pedidos .comment-list").each(function () {
    const $item = $(this);

    const id_pres = parseInt($item.data("product")); // data-product
    const precio = parseFloat($item.data("price")); // data-price

    let cantidad = 0;
    if (selectionMode) {
      const counterText = $item.find(".selection-counter").text(); // Ej: "2/3"
      const match = counterText.match(/^(\d+)\//);
      cantidad = match ? parseInt(match[1]) : 0;
    } else {
      const qtyText = $item.find(".full-quantity").text(); // Ej: "3"
      cantidad = parseInt(qtyText) || 0;
    }

    id_pres_array.push(id_pres);
    precios_array.push(precio);
    cantidades_array.push(cantidad);
  });

  return {
    id_pres: id_pres_array,
    precios: precios_array,
    cantidades: cantidades_array,
  };
}

var subPedido = function (cod, id_pedido, id_pres, precio) {
  if (selectionMode) {
    return;
  }

  $("#list-subitems").empty();
  var tipo_pedido = $("#codtipoped").val();
  /*
  if($('#rol_usr').val() == 4){
      disp = 'none';
  }else{
      disp = 'block';
  }
  */
  $.ajax({
    dataType: "JSON",
    type: "POST",
    url: $("#url").val() + "venta/subPedido",
    data: {
      tipo_pedido: tipo_pedido,
      id_pedido: id_pedido,
      id_pres: id_pres,
      precio: precio,
    },
    success: function (data) {
      $.each(data.Detalle, function (i, item) {
        $(".title-subitems").html(
          "Detalle por orden de pedido:<br>" +
          item.Producto.pro_nom +
          ' <span class="label label-warning text-uppercase">' +
          item.Producto.pro_pre +
          "</span>"
        );
        var opc = item.estado;
        switch (opc) {
          case "a":
            estado = '<span class="label label-success">PENDIENTE</span>';
            break;
          case "b":
            estado = '<span class="label label-warning">EN PREPARACION</span>';
            break;
          case "c":
            estado = '<span class="label label-info">PREPARADO</span>';
            break;
          case "d":
            estado = '<span class="label label-primary">ENTREGADO</span>';
            break;
          case "z":
            estado = '<span class="label label-danger">ANULADO</span>';
            break;
          case "y":
            estado =
              '<span class="label label-inverse">ESPERANDO CONFIRMACION</span>';
            break;
        }

        if (data.estado_pedido == "a") {
          switch (opc) {
            case "a":
              boton_anular = "block";
              break;
            case "b":
              boton_anular = "block";
              break;
            case "c":
              boton_anular = "block";
              break;
            case "d":
              boton_anular = "block";
              break;
            case "z":
              boton_anular = "none";
              break;
            case "y":
              boton_anular = "block";
              break;
          }
        } else if (data.estado_pedido == "b") {
          if (data.id_tipo_pedido == 2) {
            switch (opc) {
              case "a":
                boton_anular = "block";
                break;
              case "b":
                boton_anular = "block";
                break;
              case "c":
                boton_anular = "block";
                break;
              case "d":
                boton_anular = "block";
                break;
              case "z":
                boton_anular = "none";
                break;
              case "y":
                boton_anular = "block";
                break;
            }
          } else if (data.id_tipo_pedido == 3) {
            switch (opc) {
              case "a":
                boton_anular = "block";
                break;
              case "b":
                boton_anular = "block";
                break;
              case "c":
                boton_anular = "block";
                break;
              case "d":
                boton_anular = "block";
                break;
              case "z":
                boton_anular = "none";
                break;
              case "y":
                boton_anular = "block";
                break;
            }
          }
        } else if (data.estado_pedido == "c") {
          boton_anular = "none";
        } else if (data.estado_pedido == "d") {
          boton_anular = "none";
        }

        var notas_ = "";
        var notas_t = "";

        if (item.comentario.length > 0) {
          var comentarios = item.comentario.trim();
          var arreglo1 = comentarios.split(",");
          $.each(arreglo1, function (ind, elem) {
            console.log(elem);
            if (elem != "") {
              notas_ +=
                '<span class="label label-info ml-1 mr-1 font-13">' +
                elem +
                "</span>";
            }
          });
          var notas_t = "Notas:";
        }

        if (item.estado != "z") {
          $("#list-subitems").append(
            $('<div class="d-flex flex-row comment-row comment-list"/>').append(
              '<div class="comment-text w-100 p-0 m-b-10n"><span style="display: inline-block;">' +
              '<h6 class="m-b-5"><i class="ti-calendar"></i> ' +
              moment(item.fecha_pedido).format("DD-MM-Y") +
              ' <i class="ti-time"></i> ' +
              moment(item.fecha_pedido).format("h:mm:ss A") +
              "</span></h6>" +
              '<p class="m-b-0 font-13">' +
              estado +
              " :: " +
              item.cant +
              " Unidad(es)</p></span>" +
              '<span class="price" style="display: ' +
              boton_anular +
              '">' +
              '<button type="button" class="btn btn-xs btn-danger pull-right"' +
              'onclick="anularPedido(' +
              id_pedido +
              "," +
              item.id_pres +
              "," +
              item.cant +
              ",'" +
              item.Producto.pro_nom +
              "','" +
              item.Producto.pro_pre +
              "','" +
              item.fecha_pedido +
              "','" +
              item.estado +
              "')\">" +
              '<i class="fas fa-trash"></i></button></span>' +
              '<p class="m-b-0 font-13 mt-1">' +
              notas_t +
              " " +
              notas_ +
              " </p></div>"
            )
          );
        } else {
          $("#list-subitems").append(
            $('<div class="d-flex flex-row comment-row comment-list"/>').append(
              '<div class="comment-text w-100 p-0 m-b-10n"><span style="display: inline-block;">' +
              '<h6 class="m-b-5"><i class="ti-calendar"></i> ' +
              moment(item.fecha_pedido).format("DD-MM-Y") +
              ' <i class="ti-time"></i> ' +
              moment(item.fecha_pedido).format("h:mm:ss A") +
              "</span></h6>" +
              '<p class="m-b-0 font-13">' +
              estado +
              " :: " +
              item.cantidad +
              " Unidad(es)</p></span>" +
              '<p class="m-b-0 font-13 mt-1">' +
              notas_t +
              " " +
              notas_ +
              " </p>" +
              "</div>"
            )
          );
        }
      });

      if (data.id_tipo_pedido == 2) {
        console.log("asdasdas");

        listarPedidosDetalle(tipo_pedido, id_pedido);
      }
    },
    error: function (jqXHR, textStatus, errorThrown) {
      console.log(errorThrown + " " + textStatus);
    },
  });
  $("#modal-sub-pedido").modal("show");
};

function procesarData(id_pedido) {
  var current_invoices = parseInt($("#current_invoices").val());
  var limits_invoices = parseInt($("#limits_invoices").val());
  var locked_invoices = parseInt($("#locked_invoices").val());

  const clienteId = $("#cliente_id").val();
  const clienteDoc = $("#cliente_documento").val().trim();
  const descuentoTipo = $("#descuento_tipo_hidden").val();
  const tipoPago = $("#tipo_pago").val();
  const totalPedido = Number($(".totalPedido").val());
  const pagoEfe = Number($("#pago_efe").val());
  const tipoDocumento = $("input[name=tipo_doc]:checked").val();
  const tipo_descuento = $("#tipo_descuento_select").val();

  var datosSerializados = $("#form-nuevo-pedido").serializeArray();

  const total = Number(
    $(".totalPagar .text span")
      .text()
      .replace(/[^\d.,]/g, "")
  );

  const detalles = get_json_pedidos();

  if (tipoDocumento == undefined || tipoDocumento === "undefined") {
    mostrarAlerta("error", "Advertencia", "Seleccione un tipo de documento");
    return;
  }

  if (tipoDocumento == 2 && clienteDoc.length !== 11) {
    mostrarAlerta(
      "warning",
      "Advertencia",
      "Ingrese un RUC valido para su factura"
    );
    return;
  }

  if (clienteId === "") {
    mostrarAlerta(
      "warning",
      "Advertencia",
      "Ingrese un cliente para el comprobante de pago"
    );
    return;
  }

  if (descuentoTipo !== "1" && tipoPago === "1" && totalPedido > pagoEfe) {
    mostrarAlerta(
      "warning",
      "Advertencia",
      "Ingrese un monto mayor o igual al total"
    );
    return;
  }

  if (current_invoices >= limits_invoices && locked_invoices == "1") {
    mostrarAlerta(
      "error",
      "Alcanzó el límite",
      "Alcanzó el límite permitido para la emisión de comprobantes"
    );
    return;
  }

  if (TotalPedido == 0 && selectionMode) {
    mostrarAlerta(
      "warning",
      "Pedido Vacio",
      "Debe seleccionar un producto para continuar"
    );
    return;
  }

  const venta = {
    tipo_pedido: $("ul.nav-tabs .nav-link.active")
      .attr("href")
      .replace(/[^0-9]/g, ""),
    tipo_entrega: pedidoSeleccionado.tipo_entrega ?? 0,
    dividir_cuenta: selectionMode ? 2 : 1,
    id_pedido: id_pedido,
    cliente_id: clienteId,
    tipo_doc: tipoDocumento,
    tipo_pago: tipoPago,
    pago_efe: datosSerializados.find((x) => x.name === "pago_efe").value,
    pago_tar: datosSerializados.find((x) => x.name === "pago_tar").value,
    pago_yape: datosSerializados.find((x) => x.name === "pago_yape").value,
    pago_plin: 0,
    pago_tran: 0,
    ibcper: $("#impuesto_bolsa").val(),
    descuento_tipo: tipo_descuento,
    descuento_personal: parseInt($("#personal_descuento").val()) || 0,
    descuento_monto: $("#descuento_monto_fijo").val() || 0,
    descuento_motivo: $("#descuento_motivo").val(),
    comision_tarjeta: parseFloat($(".comisionTarjeta").text()) || 0,
    comision_delivery: $("#comision_delivery").val() || 0,
    codigo_operacion: "",
    venta_por_consumo: $(".venta_por_consumo").val(),
    venta_por_consumo_concepto: $("#input_por_consumo").val(),
    observacion: $("#observacion").val(),
    total: parseFloat(TotalPedido) || 0,
    idProd: detalles.id_pres,
    cantProd: detalles.cantidades,
    precProd: detalles.precios,
  };

  console.log(venta);
  registrarVenta(venta);
}

function registrarVenta(venta) {
  $("#loading-overlay").show(); // antes del $.ajax
  $("#btnCobrar").prop("disabled", true);

  $.ajax({
    dataType: "JSON",
    type: "POST",
    url: $("#url").val() + "venta/RegistrarVenta",
    data: venta,
    success: function (data) {
      console.log(data);

      limpiarDescuentos();
      var cod_ven = data.replace(/['"]+/g, "");
      var urlticketreparto =
        $("#url").val() + "venta/impresion_reparto/" + cod_ven;

      // Construcción del iframe según verpdf
      var Urlpdfiframe, withmodal, cantcolumn;
      console.log($("#verpdf").val());

      if ($("#verpdf").val() == 1) {
        Urlpdfiframe =
          '<div class="col-6 col-md-6 hidden-md-down"><iframe src="' +
          $("#url").val() +
          "informe/venta_all_imp/" +
          cod_ven +
          '#toolbar=0" style="border:none;width: 100%;height: 100%;" /></div>';
        withmodal = 800;
        cantcolumn = 6;
      } else {
        Urlpdfiframe = "";
        withmodal = 400;
        cantcolumn = 12;
      }

      // Construcción de enlaces según print_cpe
      var linkpdf, linkpdff, linkrep, linkrepp, linkgaveta, linkgavetap;
      if ($("#print_cpe").val() == 1) {
        // imprimir directo
        linkpdf =
          '<a href="' +
          $("#url").val() +
          "informe/venta_all_imp_/" +
          cod_ven +
          '" target="_blank" class="link"><i class="mdi mdi-receipt text-muted"></i></a>';
        linkpdff =
          '<a class="link" href="' +
          $("#url").val() +
          "informe/venta_all_imp_/" +
          cod_ven +
          '" target="_blank"><small>Imprimir comprobante</small></a>';
        linkrep =
          '<a class="link" href="' +
          $("#url").val() +
          "venta/impresion_reparto/" +
          cod_ven +
          '" target="_blank"><i class="fas fa-print text-muted"></i></a>';
        linkrepp =
          '<a class="link" href="' +
          $("#url").val() +
          "venta/impresion_reparto/" +
          cod_ven +
          '" target="_blank"><small>Ticket reparto</small></a>';
        linkgaveta =
          '<a class="link" href="' +
          $("#url").val() +
          'imprimir/gaveta.php" target="_blank"><i class="fas fa-print text-muted"></i></a>';
        linkgavetap =
          '<a class="link" href="' +
          $("#url").val() +
          'imprimir/gaveta.php" target="_blank"><small>GAVETA</small></a>';
      } else {
        console.log("else");

        // vista previa
        linkrep =
          '<a class="link" onclick="printPdf(\'' +
          urlticketreparto +
          '\',true);" href="javascript:void(0)"><i class="fas fa-print text-muted"></i></a>';
        linkrepp =
          '<a class="link" onclick="printPdf(\'' +
          urlticketreparto +
          '\',true);" href="javascript:void(0)"><small>Ticket reparto</small></a>';
        linkpdf =
          '<a href="' +
          $("#url").val() +
          "informe/venta_all_imp_/" +
          cod_ven +
          '" target="_blank" class="link"><i class="mdi mdi-receipt text-muted"></i></a>';
        linkpdff =
          '<a class="link" href="' +
          $("#url").val() +
          "informe/venta_all_imp_/" +
          cod_ven +
          '" target="_blank"><small>Imprimir comprobante</small></a>';
        linkgaveta =
          '<a class="link" href="' +
          $("#url").val() +
          'imprimir/gaveta.php" target="_blank"><i class="fas fa-print text-muted"></i></a>';
        linkgavetap =
          '<a class="link" href="' +
          $("#url").val() +
          'imprimir/gaveta.php" target="_blank"><small>GAVETA</small></a>';
      }

      // Montaje del HTML del modal (tal cual lo tenías)
      var html_confirm;
      if (
        $("ul.nav-tabs .nav-link.active")
          .attr("href")
          .replace(/[^0-9]/g, "") == 3
      ) {
        html_confirm =
          '<div class="row"> <div class="col-' +
          cantcolumn +
          " col-md-" +
          cantcolumn +
          '">' +
          '<div class="text-center p-20"><i class="fas fa-check-circle display-3 text-success"></i>' +
          '<h4 class="m-t-20 font-bold">¡Venta completada!</h4></div>' +
          '<div class="card-body text-center">' +
          '<div class="row">' +
          '<div class="col-6 text-center">' +
          '<h1 class="font-light m-b-0">' +
          linkpdf +
          "</h1>" +
          linkpdff +
          "</div>" +
          '<div class="col-6 text-center">' +
          '<h1 class="font-light m-b-0">' +
          linkgaveta +
          "</h1>" +
          linkgavetap +
          "</div>" +
          '<div class="col-6 text-center">' +
          '<h1 class="font-light m-b-0">' +
          linkrep +
          "</h1>" +
          linkrepp +
          "</div>" +
          "</div>" +
          '<div class="row mt-5">' +
          '<div class="col-12 text-center">' +
          '<span class="mb-2 text-center" style="display: block;">Enviar comprobante por WhatsApp</span>' +
          '<div class="input-group">' +
          '<div class="input-group-prepend">' +
          '<span class="input-group-text">Nº</span>' +
          "</div>" +
          '<input type="text" id="numero_cliente" value="51" class="form-control" placeholder="51999999999">' +
          '<div class="input-group-append">' +
          '<button class="btn btn-success" type="button" id="button-addon2" onclick="clickSendWhatsapp(\'' +
          cod_ven +
          '\');">enviar <i class="fab fa-whatsapp"></i></button>' +
          '<i id="wsp-status" class="fas fa-circle text-secondary" title="No enviado aún"></i>' +
          "</div>" +
          "</div>" +
          "</div>" +
          "</div>" +
          "</div>" +
          "</div>" +
          Urlpdfiframe +
          "</div>";
      } else {
        html_confirm =
          '<div class="row"> <div class="col-' +
          cantcolumn +
          " col-md-" +
          cantcolumn +
          '">' +
          '<div class="text-center p-20"><i class="fas fa-check-circle display-3 text-success"></i>' +
          '<h4 class="m-t-20 font-bold">¡Venta completada!</h4></div>' +
          '<div class="card-body text-center">' +
          '<div class="row">' +
          '<div class="col-12 text-center">' +
          '<h1 class="font-light m-b-0">' +
          linkpdf +
          "</h1>" +
          linkpdff +
          "</div>" +
          '<div class="col-12 text-center">' +
          '<h1 class="font-light m-b-0">' +
          linkgaveta +
          "</h1>" +
          linkgavetap +
          "</div>" +
          "</div>" +
          '<div class="row mt-5">' +
          '<div class="col-12 text-center">' +
          '<span class="mb-2 text-center" style="display: block;">Enviar comprobante por WhatsApp</span>' +
          '<div class="input-group">' +
          '<div class="input-group-prepend">' +
          '<span class="input-group-text">Nº</span>' +
          "</div>" +
          '<input type="text" id="numero_cliente" value="51" class="form-control" placeholder="51999999999">' +
          '<div class="input-group-append">' +
          '<button class="btn btn-success" type="button" id="button-addon2" onclick="clickSendWhatsapp(\'' +
          cod_ven +
          '\');">enviar <i class="fab fa-whatsapp"></i></button>' +
          "</div>" +
          "</div>" +
          "</div>" +
          "</div>" +
          "</div>" +
          "</div>" +
          Urlpdfiframe +
          "</div>";
      }

      Swal.fire({
        html: html_confirm,
        width: withmodal,
        footer:
          '<div><a class="btn btn-orange" href="#" onclick="fin_venta(); Swal.close();">Continuar <i class="fas fa-arrow-right"></i></a></div>',
        allowOutsideClick: false,
        allowEscapeKey: false,
        showCancelButton: false,
        showConfirmButton: false,
      });

      window.open(
        $("#url").val() + "informe/venta_all_imp_/" + cod_ven,
        "_blank"
      );
      $("#loading-overlay").hide();
      $(".venta_por_consumo").prop("checked", false).triggerHandler("click");
      $("#button-addon2").prop("disabled", true);
      $("#btnCobrar").prop("disabled", false);
    },
    error: function (xhr, status, error) {
      console.error("Error al guardar pedido:", error);
      $("#btnCobrar").prop("disabled", false);
      $("#loading-overlay").hide();
    },
  });
}

function testVenta(venta) {
  $.ajax({
    dataType: "JSON",
    type: "POST",
    url: $("#url").val() + "venta/TestVenta",
    data: { id_venta: venta },
    success: function (data) {
      console.log(data);
    },
    error: function (xhr, status, error) {
      console.error("Error al guardar pedido:", error);
    },
  });
}

function fin_venta() {
  console.log("fin_venta");

  let tipo_pedido = $("#codtipoped").val();
  if (tipo_pedido == 2) {
    $(".mostrador02").trigger("click");
    return;
  } else if (tipo_pedido == 3) {
    $(".delivery02").trigger("click");
    return;
  }

  $(".card_height").attr(
    "style",
    "background: rgb(102, 102, 102); height: 867px;"
  );
  $(".card-settings").hide();
  $(".card-header").hide();
  $(".card-footer").hide();
  $(".card-body").show();
  $(".cont01").show();
  $("#list-pedidos").empty();
  $("#viewLivetoast").css("display", "none");
}

var tiempo_mesa = function () {
  moment.locale("es");
  $('input[name^="tiempo_mesa"]').each(function (i) {
    var fechaConvertida = moment($(this).val()).fromNow(true);
    $(".hora-mesa" + i).text(fechaConvertida);
  });
};

var mostrador = function () {
  //mostrador_list_a();
  //mostrador_list_c();
  activaTab("mostrador01");
  mostrador_list_a();
  $(".pedido-mozo").hide();
};

var mostrador_list_a = function () {
  function filterGlobal() {
    $("#list-mostrador-confirmacion")
      .DataTable()
      .search($("#search_filter_e").val())
      .draw();
  }

  var count = 0;
  var table = $("#list-mostrador-confirmacion").DataTable({
    destroy: true,
    dom: "tip",
    bSort: true,
    ajax: {
      method: "POST",
      url: $("#url").val() + "venta/mostrador_list",
      data: {
        estado: "a",
      },
    },
    columns: [
      {
        data: null,
        render: function (data, type, row) {
          return (
            '<a href="javascript::void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(2,' +
            data.id_pedido +
            ',0);">' +
            data.nro_pedido +
            "</span></a>"
          );
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          return (
            '<input type="hidden" name="tiempo_pedido_mostrador[]" value="' +
            data.fecha_pedido +
            '"/><i class="ti-timer"></i> <span class="tiempo-pedido-mostrador' +
            count++ +
            '">' +
            moment(data.fecha_pedido).fromNow(true) +
            "</span>"
          );
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          return '<i class="ti-user"></i> ' + data.nomb_cliente;
        },
      },
      {
        data: null,
        className: "text-right",
        render: function (data, type, row) {
          return moneda + " " + formatNumber(data.Total.total);
        },
      },
    ],
    footerCallback: function (row, data, start, end, display) {
      var api = this.api(),
        data;

      total = api.rows().data().count();

      $(".pedidos-mostrador-total").text(total);
    },
  });

  $("input.search_filter_e").on("keyup click", function () {
    filterGlobal();
  });
};

var mostrador_list_b = function () {
  function filterGlobal() {
    $("#list-mostrador-preparacion")
      .DataTable()
      .search($("#search_filter_f").val())
      .draw();
  }

  var count = 0;
  var table = $("#list-mostrador-preparacion").DataTable({
    destroy: true,
    dom: "tip",
    bSort: true,
    ajax: {
      method: "POST",
      url: $("#url").val() + "venta/mostrador_list_c",
      data: {
        estado: "b",
      },
    },
    columns: [
      {
        data: null,
        render: function (data, type, row) {
          return (
            '<a href="javascript::void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(2,' +
            data.id_pedido +
            ');">' +
            data.nro_pedido +
            "</span></a>"
          );
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          return (
            '<input type="hidden" name="tiempo_preparacion_mostrador[]" value="' +
            data.fecha_pedido +
            '"/><i class="ti-timer"></i> <span class="tiempo-preparacion-mostrador' +
            count++ +
            '">' +
            moment(data.fecha_pedido).fromNow(true) +
            "</span>"
          );
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          return '<i class="ti-user"></i> ' + data.nomb_cliente;
        },
      },
      {
        data: null,
        className: "text-right",
        render: function (data, type, row) {
          return moneda + " " + formatNumber(data.total);
        },
      },
    ],
    footerCallback: function (row, data, start, end, display) {
      var api = this.api(),
        data;

      total = api.rows().data().count();

      $(".pedidos-mostrador-total").text(total);
    },
  });

  $("input.search_filter_f").on("keyup click", function () {
    filterGlobal();
  });
};

var mostrador_list_c = function () {
  function filterGlobal() {
    $("#list-mostrador-entregados")
      .DataTable()
      .search($("#search_filter_g").val())
      .draw();
  }

  var table = $("#list-mostrador-entregados").DataTable({
    destroy: true,
    dom: "tip",
    bSort: true,
    ajax: {
      method: "POST",
      url: $("#url").val() + "venta/mostrador_list_c",
      data: {
        estado: "d",
      },
    },
    columns: [
      {
        data: null,
        render: function (data, type, row) {
          return (
            '<a href="javascript::void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(2,' +
            data.id_pedido +
            "," +
            data.id_venta +
            ');">' +
            data.nro_pedido +
            "</span></a>"
          );
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          var fecha1 = moment(data.fecha_entrega);
          var fecha2 = moment(data.fecha_pedido);
          var duration = moment.duration(fecha2 - fecha1).humanize();
          return (
            '<i class="ti-arrow-up text-warning"></i> ' +
            moment(data.fecha_pedido).format("h:mm A") +
            '<br><i class="ti-arrow-down text-success"></i> ' +
            moment(data.fecha_entrega).format("h:mm A") +
            '<br><i class="ti-timer"></i> ' +
            duration
          );
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          return '<i class="ti-user"></i> ' + data.nomb_cliente;
        },
      },

      {
        data: null,
        className: "text-right",
        render: function (data, type, row) {
          return moneda + " " + formatNumber(data.total);
        },
      },
    ],
    footerCallback: function (row, data, start, end, display) {
      var api = this.api(),
        data;

      total = api.rows().data().count();

      $(".pedidos-mostrador-total").text(total);
    },
  });

  $("input.search_filter_g").on("keyup click", function () {
    filterGlobal();
  });
};

var delivery = function () {
  activaTab("delivery01");
  delivery_list_a();
  $(".pedido-mozo").hide();
};

var count_pedido_delivery = 0;
var countNuevoPedidoDelivery = function () {
  $.ajax({
    dataType: "JSON",
    type: "POST",
    url: $("#url").val() + "venta/delivery_list",
    data: {
      estado: "a",
    },
    success: function (data) {
      $.each(data, function (i, item) {
        if (parseInt(item.length) !== count_pedido_delivery) {
          count_pedido_delivery = 0;
          if ($("#codpestdelivery").val() == 1) {
            delivery_list_a();
          }
          var sound = new buzz.sound(
            $("#url").val() + "public/sound/ding_ding",
            {
              formats: ["ogg", "mp3", "aac"],
            }
          );
          sound.play();
          count_pedido_delivery = item.length + count_pedido_delivery;
          $(".pedidos-total-1").text(count_pedido_delivery);
        }
      });
    },
  });
};

var delivery_list_a = function () {
  function filterGlobal() {
    $("#list-delivery-confirmacion")
      .DataTable()
      .search($("#search_filter_a").val())
      .draw();
  }

  var count = 0;
  var table = $("#list-delivery-confirmacion").DataTable({
    destroy: true,
    dom: "tip",
    bSort: true,
    ajax: {
      method: "POST",
      url: $("#url").val() + "venta/delivery_list",
      data: {
        estado: "a",
      },
    },
    columns: [
      {
        data: null,
        render: function (data, type, row) {
          if (data.pedido_programado == 1) {
            return (
              '<a href="javascript::void(0)"><span class="round round-primary" onclick="listarPedidosDetalle(3,' +
              data.id_pedido +
              ',0);">' +
              data.nro_pedido +
              "</span></a>"
            );
          } else {
            return (
              '<a href="javascript::void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(3,' +
              data.id_pedido +
              ',0);">' +
              data.nro_pedido +
              "</span></a>"
            );
          }
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          return (
            '<input type="hidden" name="tiempo_pedido_delivery[]" value="' +
            data.fecha_pedido +
            '"/><i class="ti-timer"></i> <span class="tiempo-pedido-delivery' +
            count++ +
            '">' +
            moment(data.fecha_pedido).fromNow(true) +
            "</span>"
          );
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          return (
            '<i class="ti-mobile"></i> ' +
            data.telefono_cliente +
            '<br><i class="ti-user"></i> ' +
            data.nombre_cliente
          );
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          var tipo_entrega =
            data.tipo_entrega == 1
              ? '<span class="label label-primary">A DOMICILIO</span>'
              : '<span class="label label-inverse">POR RECOGER</span>';
          return tipo_entrega;
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          //var repartidor = (data.tipo_entrega == 1) ? '<i class="fas fa-bicycle"></i> '+data.Tipopago.nombre : '-';
          if (data.tipo_pago == 1) {
            return (
              '<span class="label label-success">' +
              data.Tipopago.nombre +
              "</span>"
            );
          } else if (data.tipo_pago == 2) {
            return (
              '<span class="label label-info">' +
              data.Tipopago.nombre +
              "</span>"
            );
          } else if (data.tipo_pago == 3) {
            return (
              '<span class="label label-warning">' +
              data.Tipopago.nombre +
              "</span>"
            );
          } else if (data.tipo_pago == 4) {
            return (
              '<span class="label label-danger text-primary font-bold">C</span> <span class="text-primary font-bold">' +
              data.Tipopago.nombre +
              "</span>"
            );
          } else if (data.tipo_pago >= 5) {
            return (
              '<span class="label label-light-primary">' +
              data.Tipopago.nombre +
              "</span>"
            );
          }
        },
      },
      {
        data: null,
        className: "text-right",
        render: function (data, type, row) {
          var sumatoria =
            Number(data.Total.total) + Number(data.comision_delivery);
          return moneda + " " + sumatoria;
        },
      },
    ],
    footerCallback: function (row, data, start, end, display) {
      var api = this.api(),
        data;

      total = api.rows().data().count();

      $(".pedidos-total").text(total);
      $(".pedidos-total-1").text(total);
    },
  });

  $("input.search_filter_a").on("keyup click", function () {
    filterGlobal();
  });
};

function listarPersonal() {
  var personal = $("#personal_descuento");

  $.ajax({
    url: $("#url").val() + "venta/Personal",
    type: "POST",
    dataType: "json",
    success: function (data) {
      personal.find("option").remove();
      $(data).each(function (i, v) {
        // indice, valor
        personal.append(
          '<option value="' +
          v.id_usu +
          '">' +
          v.nombres +
          " " +
          v.ape_paterno +
          " " +
          v.ape_materno +
          "</option>"
        );
      });
    },
  });
}

var limpiar_pagos_a = function () {
  $("#pago_efe").val("0.00");
  $("#pago_tar").val("0.00");
  $("#pago_yape").val("0.00");
  $("#pago_plin").val("0.00");
  $("#pago_tran").val("0.00");
  $("#vuelto").text("0.00");
};

var delivery_list_b = function () {
  function filterGlobal() {
    $("#list-delivery-preparacion")
      .DataTable()
      .search($("#search_filter_b").val())
      .draw();
  }

  var count = 0;
  var table = $("#list-delivery-preparacion").DataTable({
    destroy: true,
    dom: "tip",
    bSort: true,
    ajax: {
      method: "POST",
      url: $("#url").val() + "venta/delivery_list",
      data: {
        estado: "b",
      },
    },
    columns: [
      {
        data: null,
        render: function (data, type, row) {
          return (
            '<a href="javascript::void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(3,' +
            data.id_pedido +
            ',0);">' +
            data.nro_pedido +
            "</span></a>"
          );
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          return (
            '<input type="hidden" name="tiempo_preparacion_delivery[]" value="' +
            data.fecha_preparacion +
            '"/><i class="ti-timer"></i> <span class="tiempo-preparacion-delivery' +
            count++ +
            '">' +
            moment(data.fecha_preparacion).fromNow(true) +
            "</span>"
          );
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          return (
            '<i class="ti-mobile"></i> ' +
            data.telefono_cliente +
            '<br><i class="ti-user"></i> ' +
            data.nombre_cliente
          );
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          var tipo_entrega =
            data.tipo_entrega == 1
              ? '<span class="label label-primary">A DOMICILIO</span>'
              : '<span class="label label-inverse">POR RECOGER</span>';
          return tipo_entrega;
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          //var repartidor = (data.tipo_entrega == 1) ? '<i class="fas fa-bicycle"></i> '+data.Tipopago.nombre : '-';
          if (data.tipo_pago == 1) {
            return (
              '<span class="label label-success">' +
              data.Tipopago.nombre +
              "</span>"
            );
          } else if (data.tipo_pago == 2) {
            return (
              '<span class="label label-info">' +
              data.Tipopago.nombre +
              "</span>"
            );
          } else if (data.tipo_pago == 3) {
            return (
              '<span class="label label-warning">' +
              data.Tipopago.nombre +
              "</span>"
            );
          } else if (data.tipo_pago == 4) {
            return (
              '<span class="label label-danger text-primary font-bold">C</span> <span class="text-primary font-bold">' +
              data.Tipopago.nombre +
              "</span>"
            );
          } else if (data.tipo_pago >= 5) {
            return (
              '<span class="label label-light-primary">' +
              data.Tipopago.nombre +
              "</span>"
            );
          }
        },
      },
      {
        data: null,
        className: "text-right",
        render: function (data, type, row) {
          var sumatoria =
            Number(data.Total.total) + Number(data.comision_delivery);
          return moneda + " " + sumatoria;
          // return moneda+' '+formatNumber(data.Total.total);
        },
      },
    ],
    footerCallback: function (row, data, start, end, display) {
      var api = this.api(),
        data;

      total = api.rows().data().count();

      $(".pedidos-total").text(total);
    },
  });

  $("input.search_filter_b").on("keyup click", function () {
    filterGlobal();
  });
};

var delivery_list_c = function () {
  function filterGlobal() {
    $("#list-delivery-enviados")
      .DataTable()
      .search($("#search_filter_c").val())
      .draw();
  }

  var table = $("#list-delivery-enviados").DataTable({
    destroy: true,
    dom: "tip",
    bSort: true,
    ajax: {
      method: "POST",
      url: $("#url").val() + "venta/delivery_list_c",
      data: {
        estado: "c",
      },
    },
    columns: [
      {
        data: null,
        render: function (data, type, row) {
          return (
            '<a href="javascript::void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(3,' +
            data.id_pedido +
            "," +
            data.id_venta +
            ');">' +
            data.nro_pedido +
            "</span></a>"
          );
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          var fecha1 = moment(data.fecha_envio);
          var fecha2 = moment(data.fecha_pedido);
          var duration = moment.duration(fecha2 - fecha1).humanize();
          return (
            '<i class="ti-arrow-up text-warning"></i> ' +
            moment(data.fecha_pedido).format("h:mm A") +
            '<br><i class="ti-arrow-down text-info"></i> ' +
            moment(data.fecha_envio).format("h:mm A") +
            '<br><i class="ti-timer"></i> ' +
            duration
          );
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          return (
            '<i class="ti-mobile"></i> ' +
            data.telefono_cliente +
            '<br><i class="ti-user"></i> ' +
            data.nombre_cliente
          );
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          var tipo_entrega =
            data.tipo_entrega == 1
              ? '<span class="label label-primary">A DOMICILIO</span>'
              : '<span class="label label-inverse">POR RECOGER</span>';
          return tipo_entrega;
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          //var repartidor = (data.tipo_entrega == 1) ? '<i class="fas fa-bicycle"></i> '+data.Tipopago.nombre : '-';
          if (data.tipo_pago_new == 1) {
            return (
              '<span class="label label-success">' +
              data.Tipopago.nombre +
              "</span>"
            );
          } else if (data.tipo_pago_new == 2) {
            return (
              '<span class="label label-info">' +
              data.Tipopago.nombre +
              "</span>"
            );
          } else if (data.tipo_pago_new == 3) {
            return (
              '<span class="label label-warning">' +
              data.Tipopago.nombre +
              "</span>"
            );
          } else if (data.tipo_pago_new == 4) {
            return (
              '<span class="label label-danger text-primary font-bold">C</span> <span class="text-primary font-bold">' +
              data.Tipopago.nombre +
              "</span>"
            );
          } else if (data.tipo_pago_new >= 5) {
            return (
              '<span class="label label-light-primary">' +
              data.Tipopago.nombre +
              "</span>"
            );
          }
        },
      },
      {
        data: null,
        className: "text-right",
        render: function (data, type, row) {
          return moneda + " " + formatNumber(data.total);
        },
      },
    ],
    footerCallback: function (row, data, start, end, display) {
      var api = this.api(),
        data;

      total = api.rows().data().count();

      $(".pedidos-total").text(total);
      //$('#idventa').val(idventa);
    },
  });

  $("input.search_filter_c").on("keyup click", function () {
    filterGlobal();
  });
};

var delivery_list_d = function () {
  function filterGlobal() {
    $("#list-delivery-entregados")
      .DataTable()
      .search($("#search_filter_d").val())
      .draw();
  }

  var table = $("#list-delivery-entregados").DataTable({
    destroy: true,
    dom: "tip",
    bSort: true,
    ajax: {
      method: "POST",
      url: $("#url").val() + "venta/delivery_list_c",
      data: {
        estado: "d",
      },
    },
    columns: [
      {
        data: null,
        render: function (data, type, row) {
          return (
            '<a href="javascript::void(0)"><span class="round round-warning" onclick="listarPedidosDetalle(3,' +
            data.id_pedido +
            ',0);">' +
            data.nro_pedido +
            "</span></a>"
          );
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          var fecha1 = moment(data.fecha_entrega);
          var fecha2 = moment(data.fecha_envio);
          var fecha3 = moment(data.fecha_preparacion);
          if (data.fecha_envio == "0000-00-00 00:00:00") {
            var fecha_i = fecha3;
          } else {
            var fecha_i = fecha2;
          }
          var duration = moment.duration(fecha_i - fecha1).humanize();
          return (
            '<i class="ti-arrow-up text-info"></i> ' +
            fecha_i.format("h:mm A") +
            '<br><i class="ti-arrow-down text-success"></i> ' +
            moment(data.fecha_entrega).format("h:mm A") +
            '<br><i class="ti-timer"></i> ' +
            duration
          );
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          return (
            '<i class="ti-mobile"></i> ' +
            data.telefono_cliente +
            '<br><i class="ti-user"></i> ' +
            data.nombre_cliente
          );
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          var tipo_entrega =
            data.tipo_entrega == 1
              ? '<span class="label label-primary">A DOMICILIO</span>'
              : '<span class="label label-inverse">POR RECOGER</span>';
          return tipo_entrega;
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          //var repartidor = (data.tipo_entrega == 1) ? '<i class="fas fa-bicycle"></i> '+data.Tipopago.nombre : '-';
          if (data.tipo_pago_new == 1) {
            return (
              '<span class="label label-success">' +
              data.Tipopago.nombre +
              "</span>"
            );
          } else if (data.tipo_pago_new == 2) {
            return (
              '<span class="label label-info">' +
              data.Tipopago.nombre +
              "</span>"
            );
          } else if (data.tipo_pago_new == 3) {
            return (
              '<span class="label label-warning">' +
              data.Tipopago.nombre +
              "</span>"
            );
          } else if (data.tipo_pago_new == 4) {
            return (
              '<span class="label label-danger text-primary font-bold">C</span> <span class="text-primary font-bold">' +
              data.Tipopago.nombre +
              "</span>"
            );
          } else if (data.tipo_pago_new >= 5) {
            return (
              '<span class="label label-light-primary">' +
              data.Tipopago.nombre +
              "</span>"
            );
          }
        },
      },
      {
        data: null,
        className: "text-right",
        render: function (data, type, row) {
          return moneda + " " + formatNumber(data.total);
        },
      },
    ],
    footerCallback: function (row, data, start, end, display) {
      var api = this.api(),
        data;

      total = api.rows().data().count();

      $(".pedidos-total").text(total);
    },
  });

  $("input.search_filter_d").on("keyup click", function () {
    filterGlobal();
  });
};

function listarComandas(id_pedido) {
  console.log("ID Pedido:", id_pedido);

  const $menu =
    $("#rol_usr").val() == 5
      ? $("#imprimir_comandas_mozo")
      : $("#imprimir_comandas");
  $menu.empty(); // Limpiar el contenido actual

  $.ajax({
    dataType: "JSON",
    type: "POST",
    url: $("#url").val() + "venta/listarComandas",
    data: { id_pedido: id_pedido },
    success: function (data) {
      if (data.length !== 0) {
        let comandasList = "";

        $.each(data, function (i, v) {
          comandasList += `
            <a class="dropdown-item" href="javascript:void(0)" onclick="reimpresion_comanda('${v.id_key}')">
              <i class="fas fa-print mr-2"></i> ${v.fecha_pedido}
            </a>`;
        });

        $menu.html(comandasList);
      } else {
        $menu.html(`
          <div class="dropdown-item text-muted text-center">
            <i class="fas fa-exclamation-circle"></i> No existe registro
          </div>
        `);
      }
    },
    error: function (xhr, status, error) {
      console.error("Error al listar comandas:", error);
      $menu.html(`
        <div class="dropdown-item text-danger text-center">
          Error de conexión
        </div>
      `);
    },
  });
}

var tiempo_pedido = function () {
  moment.locale("es");
  $('input[name^="tiempo_pedido_mostrador"]').each(function (i) {
    var fechaConvertida_mostrador_a = moment($(this).val()).fromNow(true);
    $(".tiempo-pedido-mostrador" + i).text(fechaConvertida_mostrador_a);
  });
  $('input[name^="tiempo_pedido_delivery"]').each(function (i) {
    var fechaConvertida_delivery_a = moment($(this).val()).fromNow(true);
    $(".tiempo-pedido-delivery" + i).text(fechaConvertida_delivery_a);
  });
};

var tiempo_preparacion = function () {
  moment.locale("es");
  $('input[name^="tiempo_preparacion_mostrador"]').each(function (i) {
    var fechaConvertida_mostrador_b = moment($(this).val()).fromNow(true);
    $(".tiempo-preparacion-mostrador" + i).text(fechaConvertida_mostrador_b);
  });
  $('input[name^="tiempo_preparacion_delivery"]').each(function (i) {
    var fechaConvertida_delivery_b = moment($(this).val()).fromNow(true);
    $(".tiempo-preparacion-delivery" + i).text(fechaConvertida_delivery_b);
  });
};
function docDefecto(doc_defecto) {
  const $input = $(`input[name="tipo_doc"][value="${doc_defecto}"]`);
  const $label = $input.closest("label");

  if (!$input.length) {
    console.error("No encontré el input tipo_doc con value=" + doc_defecto);
    return;
  }

  $('input[name="tipo_doc"]').prop("checked", false);
  $("label.btn-tipo-doc-" + doc_defecto)
    .closest("label")
    .siblings("label")
    .removeClass("active");

  $input.prop("checked", true);
  $label.addClass("active");
  $input.trigger("click").trigger("change");
}

// Método que muestra la información en el aside de la venta.
// var listarPedidos = function (
//   cod_salon,
//   cod_mesa,
//   id_tipo_pedido,
//   id_pedido,
//   mesa,
//   salon,
//   estado
// ) {

//   $("#codsalonorigen").val(cod_salon);
//   $("#codmesaorigen").val(cod_mesa);
//   $("#salon").val(salon);
//   $("#mesa").val(mesa);

//   selectionMode = false;

//   reset_default();
//   $(".card_height").css("background", "#ffffff");
//   $(".card-body-right").css("display", "block");
//   $(".display-opciones-pedido").hide();
//   $(".static-list-pedidos").hide();
//   $("#content_pagos").show();
//   if (id_tipo_pedido == 1) {
//     $(".pedido-numero-icono").html("");
//     // $('.pedido-numero').html(salon+' - Mesa: '+mesa);
//     $(".pedido-numero").html(
//       `${salon} - Mesa: <span class="ml-2">${mesa}</span>`
//     );
//   }
//   $(".cont03").css("display", "block");

//   $(".imprimir_precuenta").off("click").on("click", function () {
//     impPreCuenta(id_pedido, cod_mesa, estado, true);
//   });

//   const doc_defecto = $('#tipo_doc_defecto').val().trim();
//   docDefecto(doc_defecto);

//   $("#tipo_pago").prop("selectedIndex", 0).trigger("change");

//   $("#list-pedidos").empty();

//   //$('.venta_por_consumo').prop('checked', false).trigger('click').trigger('change');

//   $('.venta_por_consumo').prop('checked', false).triggerHandler('click');

//   $.ajax({
//     dataType: "JSON",
//     type: "POST",
//     url: $("#url").val() + "venta/listarPedidos",
//     data: {
//       id_pedido: id_pedido,
//       codpagina: $("#codpagina").val(),
//     },
//     success: function (data) {
//       var totPed = 0,
//         total = 0;
//       if (data.length != 0) {
//         $.each(data, function (i, item) {
//           $("#nombre_mozo").val(item.nombre_mozo);
//           $(".pedido-mozo").show();
//           $(".pedido-mozo").attr(
//             "data-original-title",
//             "Mozo: " + item.nombre_mozo
//           );
//           totPed = item.cantidad * item.precio;

//           let selectionCounter = `
//             <span class="selection-counter ${selectionMode ? '' : 'd-none'}">0/${item.cantidad}</span>
//             <span class="full-quantity ${selectionMode ? 'd-none' : ''}">${item.cantidad}</span>
//           `;

//           const html = `
//             <div class="d-flex flex-row comment-list" data-id="${item.id_pedido}" data-quantity="${item.cantidad}" data-product="${item.id_pres}" data-price="${item.precio}"
//                 onclick="subPedido(1, ${item.id_pedido}, ${item.id_pres}, '${item.precio}');">
//               <div class="w-100 d-flex justify-content-between align-items-end r-order-item">
//                 <div class="r-details">
//                   <p class="order-name mb-0">
//                     ${item.Producto.pro_pre}
//                     <span class="r-order-type-label" style="margin-left:.6rem">
//                       ${item.Producto.pro_nom}
//                     </span>
//                   </p>
//                   <p class="order-units m-b-0 font-13">
//                     ${selectionCounter} Unidad(es) en ${moneda} ${formatNumber(item.precio)} | Unidad
//                   </p>
//                 </div>
//                 <div class="price">
//                   ${moneda} ${formatNumber(totPed)}
//                 </div>
//               </div>
//             </div>
//           `;

//           $("#list-pedidos").append(html);
//           total = totPed + total;
//         });

//         TotalPedido = total;

//         $(".totalPagar").html(
//           '<div class="text"><span>' +
//             moneda +
//             " " +
//             formatNumber(total) +
//             "</span>"
//         );

//         $(".totalDelivery").text(formatNumber(0));
//         $(".totalDescuento").text(formatNumber(0));
//         $(".SubtotalPedido").text(formatNumber(total));
//         $("#pago_efe").val(formatNumber(total));

//         $(".totalPedidoMenosTarjeta").text(formatNumber(total));
//       } else {
//         $("#list-pedidos").html(
//           '<div class="justify-center" style="height: 100%;"><div class="text-center"><h2><i class="fas fa-shopping-basket display-4" style="color: #d3d3d3;"></i></h2><h4 style="color: #d3d3d3;">Agregue productos</h4><h6 style="color: #d3d3d3;">No se encontraron productos</h6></div></div>'
//         );
//         $(".totalPagar").html(
//           '<div class="text"><span>' +
//             moneda +
//             " " +
//             formatNumber(total) +
//             "</span>"
//         );
//       }
//     },
//   });
//   $(".card-footer-right").css("display", "block");
//   //$('.btn-submit-nuevo-pedido').html('<a class="btn btn-orange" href="'+$('#url').val()+'venta/orden/'+id_pedido+'">Continuar <i class="fas fa-arrow-right"></i></a>');
//   $(".btn-submit-dividir-cuenta").html(
//     '<a class="btn btn-blue btnDividirCuenta" id="btnDividirCuenta" data-id-pedido="' +
//       id_pedido +
//       '" data-id-mesa="' +
//       cod_mesa +
//       '" href="javascript:void(0);"><i class="far fa-file-alt"></i></a>'
//   );

//   $(".btn-agregar-productos").html(
//     '<a class="btn btn-blue btnAgregarProdcuto" id="btnAgregarProdcuto" data-id-pedido="' +
//       id_pedido +
//       '" data-id-mesa="' +
//       cod_mesa +
//       '" href="javascript:void(0);"><i class="icon-plus"></i></a>'
//   );

//   $(".btn_cancelar_pedido").html(
//     '<a class="btn btn-danger btnCancelarPedido" id="btnCancelarPedido" data-id-pedido="' +
//       id_pedido +
//       '" data-id-mesa="' +
//       cod_mesa +
//       '" href="javascript:void(0);"><i class="fas fa-times-circle"></i></a>'
//   );

//   $("#btnDividirCuenta").on("click", function (event) {
//   event.preventDefault();

//   selectionMode = !selectionMode;

//   if (selectionMode) {

//     $(this).text("Desactivar");
//     $("#list-pedidos").addClass("selection-mode");
//     $(".selection-counter").removeClass("d-none");
//     $(".full-quantity").addClass("d-none");

//     $("#list-pedidos .comment-list").each(function () {
//       const $item = $(this);
//       const maxQty = $item.data("quantity") || 0;

//       $item.attr("data-selected", 0);
//       $item.find(".selection-counter").text(`0/${maxQty}`);

//       $item.find(".price").text(`${moneda} ${formatNumber(0)}`);
//     });

//     let monto_descuento = $("#descuento_monto_fijo").val();
//     let monto_delivery = $("#comision_delivery").val();

//     $("#pago_efe").val(formatNumber(0));
//     $(".SubtotalPedido").text(`${formatNumber(0)}`);
//     $(".totalDelivery").text(`${formatNumber(monto_delivery)}`);
//     $(".totalDescuento").text(`${formatNumber(monto_descuento)}`);
//     $(".totalPedidoMenosTarjeta").text(`${formatNumber(0)}`);
//     TotalPedido = 0;

//   } else {
//     // Salir de modo selección: restaurar valores originales
//     $(this).text("Activar selección");
//     $("#list-pedidos").removeClass("selection-mode");
//     $(".selection-counter").addClass("d-none");
//     $(".full-quantity").removeClass("d-none");

//     let globalTotal = 0;

//     $("#list-pedidos .comment-list").each(function () {
//       const $item     = $(this);
//       const maxQty    = $item.data("quantity")    || 0;
//       const unitPrice = parseFloat($item.data("price")) || 0;

//       // limpia selección
//       $item.removeClass("selected");
//       $item.attr("data-selected", 0);

//       // restaura cantidad mostrada
//       $item.find(".full-quantity").text(maxQty);

//       // calcula y restaura precio total por ítem
//       const itemTotal = maxQty * unitPrice;
//       $item.find(".price").text(`${moneda} ${formatNumber(itemTotal)}`);

//       // acumula para subtotal global
//       globalTotal += itemTotal;
//     });

//     let monto_descuento = $("#descuento_monto_fijo").val();
//     let monto_delivery = $("#comision_delivery").val();

//     total_pedido = globalTotal - monto_descuento + parseFloat(monto_delivery);

//     $("#pago_efe").val(formatNumber(globalTotal));
//     $(".totalPedidoMenosTarjeta").text(formatNumber(globalTotal));

//     $("#pago_efe").val(formatNumber(0));
//     $(".SubtotalPedido").text(`${formatNumber(globalTotal)}`);
//     $(".totalDelivery").text(`${formatNumber(monto_delivery)}`);
//     $(".totalDescuento").text(`${formatNumber(monto_descuento)}`);
//     $(".totalPedidoMenosTarjeta").text(`${formatNumber(total_pedido)}`);

//     TotalPedido = globalTotal;

//   }
// });

//   $("#btnAgregarProdcuto").on("click", function (event) {
//     event.preventDefault();
//     var id_pedido = $(this).data("id-pedido");

//     listarPedidosMozo(id_pedido);
//   });

//   $("#btnCancelarPedido").on("click", function (event) {
//     event.preventDefault(); // Evitar redirección
//     var id_pedido = $(this).data("id-pedido");

//     cancelarPedido(id_pedido, cod_mesa, id_tipo_pedido);

//   });

//   $(".btn-submit-cobrar").html(
//     '<a class="btn btn-green btnCobrar" id="btnCobrar" data-id-pedido="' +
//       id_pedido +
//       '" data-id-mesa="' +
//       cod_mesa +
//       '" href="javascript:void(0);">Cobrar <i class="far fa-money-bill-alt"></i></a>'
//   );
//   $("#btnCobrar").on("click", function (event) {
//     event.preventDefault(); // Evitar redirección
//     var id_pedido = $(this).data("id-pedido");
//     //facturar(id_pedido, 1, id_tipo_pedido);
//     procesarData(id_pedido);
//   });

//   if(id_tipo_pedido !== 3){
//     $("#openDialogBtnDelivery").hide();
//   }

//   $("#openDialog").show();

//   listarComandas(id_pedido);

// };

var listarPedidos = function (
  cod_salon,
  cod_mesa,
  id_tipo_pedido,
  id_pedido,
  mesa,
  salon,
  estado
) {
  if (isLoadingPedidos) return;
  isLoadingPedidos = true;

  if (ajaxListarPedidos && ajaxListarPedidos.readyState !== 4) {
    ajaxListarPedidos.abort();
  }

  console.log("ID Pedido:", id_pedido);

  $("#codsalonorigen").val(cod_salon);
  $("#codmesaorigen").val(cod_mesa);
  $("#salon").val(salon);
  $("#mesa").val(mesa);
  $(".ticket_reparto").hide();
  $("#cliente_documento").val("");

  selectionMode = false;

  reset_default();
  $(".card_height").css("background", "#ffffff");
  $(".card-body-right").css("display", "block");
  $(".display-opciones-pedido").hide();
  $(".static-list-pedidos").hide();
  $("#content_pagos").show();
  $("#top-payment-inputs").show();

  if (id_tipo_pedido == 1) {
    $(".pedido-numero-icono").html("");
    $(".pedido-numero").html(
      `${salon} - Mesa: <span class="ml-2">${mesa}</span>`
    );
  }

  $(".cont03").css("display", "block");

  $(".imprimir_precuenta")
    .off("click")
    .on("click", function () {
      impPreCuenta(id_pedido, cod_mesa, estado, true);
    });

  const doc_defecto = $("#tipo_doc_defecto").val().trim();
  docDefecto(doc_defecto);

  $("#tipo_pago").prop("selectedIndex", 0).trigger("change");
  $("#list-pedidos").empty();
  $(".venta_por_consumo").prop("checked", false).triggerHandler("click");
  limpiarComisionTarjeta();
  limpiarDescuentos();

  ajaxListarPedidos = $.ajax({
    dataType: "JSON",
    type: "POST",
    url: $("#url").val() + "venta/listarPedidos",
    data: {
      id_pedido: id_pedido,
      codpagina: $("#codpagina").val(),
    },
    success: function (data) {
      var totPed = 0,
        total = 0;

      if (data.length != 0) {
        $.each(data, function (i, item) {
          const id = item.id_pedido;
          const pres = item.id_pres;

          //   const exists =
          //     $("#list-pedidos").find(`[data-id='${id}'][data-product='${pres}']`).length > 0;
          //   if (exists) return;

          $("#nombre_mozo").val(item.nombre_mozo);
          $(".pedido-mozo")
            .show()
            .attr("data-original-title", "Mozo: " + item.nombre_mozo);

          totPed = item.cantidad * item.precio;

          let selectionCounter = `
            <span class="selection-counter ${selectionMode ? "" : "d-none"
            }">0/${item.cantidad}</span>
            <span class="full-quantity ${selectionMode ? "d-none" : ""}">${item.cantidad
            }</span>
          `;

          const html = `
            <div class="d-flex flex-row comment-list" data-id="${id}" data-quantity="${item.cantidad
            }" data-product="${pres}" data-price="${item.precio}"
                onclick="subPedido(1, ${id}, ${pres}, '${item.precio}');">
              <div class="w-100 d-flex justify-content-between align-items-end r-order-item">
                <div class="r-details">
                  <p class="order-name mb-0">
                    ${item.Producto.pro_pre}
                    <span class="r-order-type-label" style="margin-left:.6rem">${item.Producto.pro_nom
            }</span>
                  </p>
                  <p class="order-units m-b-0 font-13">
                    ${selectionCounter} Unidad(es) en ${moneda} ${formatNumber(
              item.precio
            )} | Unidad
                  </p>
                </div>
                <div class="price">${moneda} ${formatNumber(totPed)}</div>
              </div>
            </div>
          `;

          $("#list-pedidos").append(html);
          total += totPed;

          // if (item.tipo_cliente != null) {
          //  if(item.tipo_cliente == 1){
          //     let clienteInfo = `DNI: ${item.cliente_dni} | ${item.cliente_nombres}`;
          //     $("#buscar_cliente").val(clienteInfo);
          //   }else{
          //     let clienteInfo = `RUC: ${item.cliente_ruc} | ${item.cliente_razon_social}`;
          //     $("#buscar_cliente").val(clienteInfo);
          //   }

          //   $("#cliente_id").val(item.cliente_id);
          // }
        });

        TotalPedido = total;

        $(".totalPagar").html(
          `<div class="text"><span>${moneda} ${formatNumber(total)}</span>`
        );

        $(".totalDelivery").text(formatNumber(0));
        $(".totalDescuento").text(formatNumber(0));
        $(".SubtotalPedido").text(formatNumber(total));
        $("#pago_efe").val(formatNumber(total));
        $(".totalPedidoMenosTarjeta").text(formatNumber(total));
      } else {
        $("#list-pedidos").html(`
          <div class="justify-center" style="height: 100%;">
            <div class="text-center">
              <h2><i class="fas fa-shopping-basket display-4" style="color: #d3d3d3;"></i></h2>
              <h4 style="color: #d3d3d3;">Agregue productos</h4>
              <h6 style="color: #d3d3d3;">No se encontraron productos</h6>
            </div>
          </div>
        `);
        $(".totalPagar").html(
          `<div class="text"><span>${moneda} ${formatNumber(0)}</span>`
        );
      }
    },
    complete: function () {
      isLoadingPedidos = false;
    },
  });

  $(".card-footer-right").css("display", "block");

  $(".btn-submit-dividir-cuenta").html(
    `<a class="btn btn-blue btnDividirCuenta" id="btnDividirCuenta" data-id-pedido="${id_pedido}" data-id-mesa="${cod_mesa}" href="javascript:void(0);"><i class="far fa-file-alt"></i></a>`
  );

  $(".btn-agregar-productos").html(
    `<a class="btn btn-blue btnAgregarProdcuto" id="btnAgregarProdcuto" data-id-pedido="${id_pedido}" data-id-mesa="${cod_mesa}" href="javascript:void(0);"><i class="icon-plus"></i></a>`
  );

  $(".btn_cancelar_pedido").html(
    `<a class="btn btn-danger btnCancelarPedido" id="btnCancelarPedido" data-id-pedido="${id_pedido}" data-id-mesa="${cod_mesa}" href="javascript:void(0);"><i class="fas fa-times-circle"></i></a>`
  );

  $("#btnDividirCuenta").on("click", function (event) {
    event.preventDefault();
    selectionMode = !selectionMode;

    if (selectionMode) {
      $(this).text("Desactivar");
      $("#list-pedidos").addClass("selection-mode");
      $(".selection-counter").removeClass("d-none");
      $(".full-quantity").addClass("d-none");

      $("#list-pedidos .comment-list").each(function () {
        const $item = $(this);
        const maxQty = $item.data("quantity") || 0;
        $item.attr("data-selected", 0);
        $item.find(".selection-counter").text(`0/${maxQty}`);
        $item.find(".price").text(`${moneda} ${formatNumber(0)}`);
      });

      let monto_descuento = $("#descuento_monto_fijo").val();
      let monto_delivery = $("#comision_delivery").val();
      $("#pago_efe").val(formatNumber(0));
      $(".SubtotalPedido").text(`${formatNumber(0)}`);
      $(".totalDelivery").text(`${formatNumber(monto_delivery)}`);
      $(".totalDescuento").text(`${formatNumber(monto_descuento)}`);
      $(".totalPedidoMenosTarjeta").text(`${formatNumber(0)}`);
      TotalPedido = 0;
    } else {
      $(this).html('<i class="far fa-file-alt"></i>');
      $("#list-pedidos").removeClass("selection-mode");
      $(".selection-counter").addClass("d-none");
      $(".full-quantity").removeClass("d-none");

      let globalTotal = 0;
      $("#list-pedidos .comment-list").each(function () {
        const $item = $(this);
        const maxQty = $item.data("quantity") || 0;
        const unitPrice = parseFloat($item.data("price")) || 0;
        $item.removeClass("selected").attr("data-selected", 0);
        $item.find(".full-quantity").text(maxQty);
        const itemTotal = maxQty * unitPrice;
        $item.find(".price").text(`${moneda} ${formatNumber(itemTotal)}`);
        globalTotal += itemTotal;
      });

      let monto_descuento = $("#descuento_monto_fijo").val();
      let monto_delivery = $("#comision_delivery").val();
      total_pedido = globalTotal - monto_descuento + parseFloat(monto_delivery);

      $("#pago_efe").val(formatNumber(globalTotal));
      $(".totalPedidoMenosTarjeta").text(formatNumber(globalTotal));
      $("#pago_efe").val(formatNumber(0));
      $(".SubtotalPedido").text(`${formatNumber(globalTotal)}`);
      $(".totalDelivery").text(`${formatNumber(monto_delivery)}`);
      $(".totalDescuento").text(`${formatNumber(monto_descuento)}`);
      $(".totalPedidoMenosTarjeta").text(`${formatNumber(total_pedido)}`);
      TotalPedido = globalTotal;
    }
  });

  $(".btn-agregar-productos").show();

  $("#btnAgregarProdcuto").on("click", function (event) {
    event.preventDefault();
    listarPedidosMozo($(this).data("id-pedido"));
  });

  $("#btnCancelarPedido").on("click", function (event) {
    event.preventDefault();
    cancelarPedido($(this).data("id-pedido"), cod_mesa, id_tipo_pedido);
  });

  $(".btn-submit-cobrar").html(
    `<a class="btn btn-green btnCobrar" id="btnCobrar" data-id-pedido="${id_pedido}" data-id-mesa="${cod_mesa}" href="javascript:void(0);">Cobrar <i class="far fa-money-bill-alt"></i></a>`
  );

  $("#btnCobrar").on("click", function (event) {
    event.preventDefault();
    procesarData($(this).data("id-pedido"));
  });

  if (id_tipo_pedido !== 3) {
    $("#openDialogBtnDelivery").hide();
  }

  $("#openDialog").show();
  listarComandas(id_pedido);
};

function esDispositivoMovil() {
  return /Android|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(
    navigator.userAgent
  );
}

function limpiarComisionTarjeta() {
  $(".comision_tarjeta_venta").prop("checked", false).triggerHandler("click");
  $(".comisionTarjeta").text(formatNumber(0));
}

function listarPedidosMozo(id_pedido, mesa, salon) {
  $.ajax({
    dataType: "JSON",
    type: "POST",
    url: $("#url").val() + "venta/listarPedidos",
    data: {
      id_pedido: id_pedido,
      codpagina: $("#codpagina").val(),
    },
    success: function (data) {
      pedidoSeleccionado = data;

      if (data.length != 0) {
        const arregloExtraido = data.map((item) => {
          const {
            Producto,
            cantidad,
            precio,
            id_pres,
            fecha_pedido,
            estado_pedido,
            id_pedido,
          } = item;
          const total = parseFloat(cantidad) * parseFloat(precio);
          const pro_img = "default.png";

          return {
            ...Producto,
            id_pedido,
            fecha_pedido,
            estado_pedido,
            cantidad,
            id_pres,
            pro_cos: precio,
            pro_img,
            total,
          };
        });

        $(".po-items").empty();
        $("#id_pedido").val(id_pedido);

        arregloExtraido.forEach((producto) => {
          agregarProducto(producto, false, id_pedido);
        });

        if ($("#rol_usr").val() == 5) {
          $(".card_height ").css("display", "none");
        }

        if (esDispositivoMovil()) {
          $(".modal-order-right").css("display", "block");
        }

        $("#btn_cancelar_pedido_mozo").on("click", function (event) {
          event.preventDefault();

          console.log(pedidoSeleccionado);

          cancelarPedido(pedidoSeleccionado[0].id_pedido, mesa, 1);
        });

        $("#info_mesa").text(`${salon} - Mesa: ${mesa}`);

        listarComandas(id_pedido);

        $("#modal-super-test").modal("show");
      }
    },
  });
}
// inicio: MODAL DIALOG - comisiones, descuentos y promociones
const dialog = document.querySelector(".dialogBtn");
const showButton = document.querySelector(".openDialogBtn");
const closeButton = document.querySelector(".closeDialogBtn");

showButton.addEventListener("click", () => {
  dialog.showModal();
});

closeButton.addEventListener("click", () => {
  dialog.close();
});
// fin: MODAL DIALOG - comisiones, descuentos y promociones

// inicio: MODAL DIALOG - delivery
// const dialogDelivery = document.querySelector(".dialogBtnDelivery");
// const showButtonDelivery = document.querySelector(".openDialogBtnDelivery");
// const closeButtonDelivery = document.querySelector(".closeDialogBtnDelivery");

// showButtonDelivery.addEventListener("click", () => {
//   dialogDelivery.showModal();
// });

// closeButtonDelivery.addEventListener("click", () => {
//   dialogDelivery.close();
// });
// fin: MODAL DIALOG - delivery

var conf_dividir = function (id_pedido, dividir_cuenta) {
  Swal.fire({
    title: "Confirmación",
    html: "¿Desea dividir cuenta?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#34d16e",
    confirmButtonText: "Si, Adelante!",
    cancelButtonText: "No!",
    showLoaderOnConfirm: true,
  }).then((result) => {
    if (result.value) {
      facturar(id_pedido, dividir_cuenta);
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      return false;
    }
  });
};

var facturar = function (id_pedido, dividir_cuenta, id_tipo_pedido) {
  $("#btn-submit-facturar").removeAttr("disabled");
  $("#list-items-facturar").empty();
  $("#id_pedido").val(id_pedido);
  $("#dividir_cuenta").val(dividir_cuenta);
  var tipo_pedido = $("#codtipoped").val();
  var moneda = $("#moneda").val();

  defaultdata(id_pedido, id_tipo_pedido);

  $.ajax({
    dataType: "JSON",
    type: "POST",
    url: $("#url").val() + "venta/ListarDetallePed",
    data: {
      id_pedido: id_pedido,
      tipo_pedido: tipo_pedido,
    },
    success: function (data) {
      var sub_total = 0;
      var total = 0;
      var precio_imp_bol = 0;

      $.each(data.Detalle, function (i, item) {
        var totped = $("#total_pedido").val();
        var imp_bol = $("#imp_icbper").val();

        if (item.Producto.impuesto_icbper == "1") {
          precio_imp_bol =
            parseFloat(item.cantidad * imp_bol) + parseFloat(precio_imp_bol);
        } else {
          precio_imp_bol = parseFloat(precio_imp_bol);
        }

        var calc = (item.cantidad * item.precio).toFixed(2);
        sub_total =
          parseFloat(item.cantidad * precio_imp_bol) + parseFloat(sub_total);

        total = parseFloat(sub_total) + parseFloat(total);

        if (1 == dividir_cuenta && item.cantidad > 0) {
          $(".icbper").text(formatNumber(imp_bol));
          $(".totalPedido").val(totped);
          $(".totalPedido").text(formatNumber(totped));
          $(".subtotal").text(formatNumber(totped));
          $("#total_venta").val(totped);
          $(".btn-cancel-facturar-1").show();
          $(".btn-cancel-facturar-2").hide();
          calculo_total();
          calculo_efectivo();
          $("#list-items-facturar").append(
            $('<tr class="comment-list"/>')
              .append(
                $('<td width="20%"/>').html(
                  '<input type="hidden" name="cantProd[]" value="' +
                  item.cantidad +
                  '"/>' +
                  '<input type="hidden" name="precProd[]" value="' +
                  item.precio +
                  '"/>' +
                  item.cantidad
                )
              )
              .append(
                $('<td width="60%"/>').html(
                  '<input type="hidden" name="idProd[]" value="' +
                  item.id_pres +
                  '"/>' +
                  item.Producto.pro_nom +
                  ' <span class="label label-warning text-uppercase">' +
                  item.Producto.pro_pre +
                  "</span>"
                )
              )
              .append(
                $('<td width="20%" class="text-right"/>').html(
                  moneda + " " + formatNumber(calc)
                )
              )
          );
        } else if (2 == dividir_cuenta && item.cantidad > 0) {
          limpiar_datos_add();
          $(".display-pago-rapido-efectivo").show();
          $(".totalPedido").val("0.00");
          $(".totalPedido").text("0.00");
          $("#total_venta").val("0.00");
          $(".subtotal").text("0.00");
          $(".btn-cancel-facturar-1").hide();
          $(".btn-cancel-facturar-2").show();
          calculo_total();
          $(".opc-01").text("0.00");
          $("#list-items-facturar").append(
            $(
              '<tr class="comment-list priceU" data-price="' +
              item.precio +
              '" style="cursor: pointer;"/>'
            )
              .append(
                $('<td width="20%"/>').html(
                  '<input type="hidden" class="cantidad" name="cantProd[]" value="0"/>' +
                  '<input type="hidden" name="precProd[]" value="' +
                  item.precio +
                  '"/>' +
                  '<input type="hidden" value="' +
                  item.cantidad +
                  '" class="cantOrg"/>' +
                  '<input type="hidden" value="1" class="cantTemp"/>' +
                  "<b></b> " +
                  item.cantidad
                )
              )
              .append(
                $('<td width="60%"/>').html(
                  '<input type="hidden" name="idProd[]" value="' +
                  item.id_pres +
                  '"/>' +
                  item.Producto.pro_nom +
                  ' <p class="label label-warning text-uppercase">' +
                  item.Producto.pro_pre +
                  "</p>"
                )
              )
              .append(
                $('<td width="20%" class="text-right"/>').html(
                  moneda + " <span>0.00</span>"
                )
              )
          );
        }
      });

      $(".subtotal").text(formatNumber(sub_total));
      $(".icbper").text(formatNumber(precio_imp_bol));
      $("#monto_icbper").val(parseFloat(precio_imp_bol));

      $(".priceU").on("click", function () {
        var totalTemp = $(this).find(".cantTemp").val();
        $(this).css(
          "cssText",
          "background: #f9e79f !important; color: #424949 !important; cursor: pointer;"
        );
        $(this)
          .find(".cantTemp")
          .val(parseInt(totalTemp) + 1);
        var totalCant = $(this).find(".cantOrg").val();
        var cantB = parseInt(totalCant) - 1;
        $(this)
          .find("b")
          .text(totalTemp + " /");
        var valorItem = $(this).find("span").text();
        var valorPrice = $(this).attr("data-price");
        var totalItem = (
          parseFloat(valorItem) + parseFloat(valorPrice)
        ).toFixed(2);
        $(this).find("span").text(totalItem);
        var totalGneral = 0;
        $(this).find(".cantidad").val(totalTemp);
        if (parseInt(totalCant) < parseInt(totalTemp)) {
          $(this).find(".cantTemp").val(1);
          $(this).css(
            "cssText",
            "background: transparent !important; cursor:pointer;"
          );
          $(this).find("span").text("0.00");
          $(this).find("b").text("");
          $(this).find(".cantidad").val(0);
        }
        $(".priceU").each(function () {
          totalGneral += parseFloat($(this).find("span").text());
        });
        $(".totalPedido").val(totalGneral.toFixed(2));
        $(".totalPedido").text(formatNumber(totalGneral));
        $(".totalPedidoMenosTarjeta").text(formatNumber(totalGneral));
        $("#total_venta").val(totalGneral);
        $(".subtotal").text(formatNumber(totalGneral));
        $("#btn-submit-facturar").removeAttr("disabled");
        $("#btn-submit-facturar").removeClass("disabled");
        limpiar_datos_add();
        $("#pago_efe").val(totalGneral.toFixed(2));
        $(".opc-01").text(totalGneral.toFixed(2));
      });
    },
    error: function (jqXHR, textStatus, errorThrown) {
      console.log(errorThrown + " " + textStatus);
    },
  });
  $("#modal-facturar").modal("show");
};

var defaultdata = function (id_pedido, id_tipo_pedido) {
  $.ajax({
    async: false,
    dataType: "JSON",
    type: "POST",
    url: $("#url").val() + "venta/defaultdata",
    data: {
      id_pedido: id_pedido,
      tipo_pedido: id_tipo_pedido,
    },
    success: function (data) {
      var sbtot = 0;
      var total = 0;

      var imp_bol = $("#imp_icbper").val();
      $.each(data.Detalle, function (i, item) {
        var precio_imp_bol = 0;

        if (item.impuesto_icbper == "1") {
          precio_imp_bol = parseFloat(item.precio) + parseFloat(imp_bol);
        } else {
          precio_imp_bol = item.precio;
        }

        var importe = parseFloat(item.cantidad * precio_imp_bol);
        if (item.estado != "i" && item.cantidad > 0) {
          sbtot = parseFloat(importe) + parseFloat(sbtot);
        }
      });

      total = parseFloat(sbtot) + parseFloat(total);

      $("#totalPagar").text(moneda + " " + formatNumber(total));
      $(".totalPagar").text(moneda + " " + formatNumber(total));
      $("#total_pedido").val(total.toFixed(2));
      $("#pago_efe").val(formatNumber(total));
      $(".opc-01").text(formatNumber(total));
      $(".totalPedidoMenosTarjeta").text(formatNumber(total));

      $(".opcion-cliente").html(
        '<a class="input-group-prepend" href="javascript:void(0)"' +
        'onclick="nuevoClienteVista();" data-original-title="Registrar nuevo cliente" data-toggle="tooltip"' +
        'data-placement="top">' +
        '<span class="input-group-text bg-header">' +
        '<small><i class="fas fa-user-plus"></i></small>' +
        "</span>" +
        "</a>"
      );

      if (total != "0.00") {
        if (data.id_tipo_pedido == 3) {
          // if(data.estado_pedido != 'a'){
          //     $('#list-productos').css('visibility','hidden');
          //     $('.opc1').css('display','block');
          //     $('.opc2').css('display','none');
          // } else {
          $(".opc1").css("display", "none");
          $(".opc2").css("display", "none");
          $(".opc3").css("display", "block");
          if ($("#rol_usr").val() == 5) {
            $(".opc1").css("display", "block");
          }
          // }
        } else {
          $(".opc1").css("display", "block");
          $(".opc2").css("display", "none");
        }
      } else {
        $(".opc1").css("display", "none");
        $(".opc2").css("display", "block");
      }

      if (data.id_tipo_pedido == 1) {
        $(".pedido-numero-icono").text("");
        $(".pedido-cliente-icono").removeClass("far fa-user");
        $(".pedido-numero").text(data.desc_salon);
        $("#nombre_salon").val(data.desc_salon);
        $("#nombre_mozo").val(data.nombre_mozo);
        $(".pedido-cliente").text("MESA: " + data.nro_mesa);
        // if($("#print_pre").val() == 1){ // impresion por comanda
        //     $('.btn-imp').html('<a href="'+$("#url").val()+'venta" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Monitor de mesas"><i class="fas fa-desktop"></i></a> <button onclick="impPreCuenta('+data.id_pedido+','+data.id_mesa+',\''+data.estado_mesa+'\')" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Imprimir pre cuenta"><i class="fas fa-print"></i></button>');
        // }else{ // impresion por view print
        //     $('.btn-imp').html('<a href="'+$("#url").val()+'venta" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Monitor de mesas"><i class="fas fa-desktop"></i></a> <button  onclick="impPreCuenta('+data.id_pedido+','+data.id_mesa+',\''+data.estado_mesa+'\',true)" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Imprimir pre cuenta"><i class="fas fa-print"></i></button>');
        // }
        if ($("#print_pre").val() == 1) {
          // impresion por comanda
          $(".btn-imp").html(
            '<a href="' +
            $("#url").val() +
            'venta" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Monitor de mesas"><i class="fas fa-desktop"></i></a> <button onclick="impPreCuenta(' +
            data.id_pedido +
            "," +
            data.id_mesa +
            ",'" +
            data.estado_mesa +
            '\')" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Imprimir pre cuenta"><i class="fas fa-print"></i></button> <div class="btn-group" data-toggle="tooltip" title="Imprimir Comanda"><button type="button" class="btn btn-warning dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-print"></i></button><div class="dropdown-menu" id="list-comandas"></div></div>'
          );
        } else {
          // impresion por view print
          $(".btn-imp").html(
            '<a href="' +
            $("#url").val() +
            'venta" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Monitor de mesas"><i class="fas fa-desktop"></i></a> <button  onclick="impPreCuenta(' +
            data.id_pedido +
            "," +
            data.id_mesa +
            ",'" +
            data.estado_mesa +
            '\',true)" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Imprimir pre cuenta"><i class="fas fa-print"></i></button> <div class="btn-group" data-toggle="tooltip" title="Imprimir Comanda"><button type="button" class="btn btn-warning dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-print"></i></button><div class="dropdown-menu" id="list-comandas"></div></div>'
          );
        }
        $("#cliente_id").val(1);
        $("#cliente_documento").val("");
        $("#buscar_cliente").val("DNI: 00000000 | PUBLICO EN GENERAL");
      } else if (data.id_tipo_pedido == 2 || data.id_tipo_pedido == 3) {
        $(".pedido-numero-icono").text("Pedido: ");
        $(".pedido-cliente-icono").addClass("far fa-user");
        $(".pedido-numero").text(data.nro_pedido);
        $("#btn-confirmar").text("AÑADIR");
        if (data.id_tipo_pedido == 2) {
          $(".pedido-cliente").text(data.nombre_cliente);
          $(".btn-imp").html(
            '<a href="' +
            $("#url").val() +
            "venta?tip=2&cod=" +
            $("#codped").val() +
            "&est=" +
            data.estado_pedido +
            '" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Monitor de ventas"><i class="fas fa-desktop"></i></a>'
          );
          $("#cliente_id").val(1);
          $("#cliente_documento").val("");
          $("#buscar_cliente").val("DNI: 00000000 | PUBLICO EN GENERAL");
        } else if (data.id_tipo_pedido == 3) {
          //$('.mensaje-pago-2-text').html('PAGA CON: S/'+data.paga_con+'<br>COMISION DELIVERY: S/'+data.comision_delivery);

          $(".comision_delivery").val(data.comision_delivery);
          $(".comision_delivery").text(formatNumber(data.comision_delivery));
          $("#pago_efe").val(formatNumber(data.paga_con));
          $(".opc-01").text(
            formatNumber(parseFloat(total) + parseFloat(data.comision_delivery))
          );
          var tipo_entrega = data.tipo_entrega == 1 ? "c" : "d";
          $("#codtipopedentrega").val(tipo_entrega);
          if (data.estado_pedido == "a") {
            $(".btn-imp").html(
              '<a href="' +
              $("#url").val() +
              "venta?tip=3&cod=" +
              $("#codped").val() +
              "&est=" +
              data.estado_pedido +
              '" class="btn btn-orange" data-toggle="tooltip" data-placement="top" data-original-title="Continuar">Continuar <i class="fas fa-arrow-right"></i></a>'
            );
          } else if (data.estado_pedido == "b") {
            $(".btn-imp").html(
              '<a href="' +
              $("#url").val() +
              "venta?tip=3&cod=" +
              $("#codped").val() +
              "&est=" +
              data.estado_pedido +
              '" class="btn btn-inverse" data-toggle="tooltip" data-placement="top" data-original-title="Monitor de ventas"><i class="fas fa-desktop"></i></a>'
            );
          } else {
            $("#list-productos").css("visibility", "hidden");
          }
          //$('.pedido-cliente').text(data.desc_repartidor);
          $(".pedido-cliente").text(data.nombre_cliente.substr(0, 13));
          $("#cliente_id").val(data.id_cliente);
          $("#cliente_tipo").val(data.tipo_cliente);
          $("#tipo_cliente").val(data.tipo_cliente);
          var tipo =
            data.tipo_cliente == 1 ? $("#diAcr").val() : $("#tribAcr").val();
          $("#buscar_cliente").val(
            tipo +
            ": " +
            data.dni_cliente +
            "" +
            data.ruc_cliente +
            " | " +
            data.nombre_cliente
          );
          //$('#buscar_cliente').val('PUBLICO EN GENERAL');
          $(".opcion-cliente").html(
            '<a class="input-group-prepend" href="javascript:void(0)"' +
            'onclick="editar_cliente(' +
            data.id_cliente +
            ');" data-original-title="Editar cliente" data-toggle="tooltip"' +
            'data-placement="top">' +
            '<span class="input-group-text bg-header">' +
            '<small><i class="fas fa-user text-info"></i></small>' +
            "</span>" +
            "</a>"
          );
        }
      }

      if (data.tipo_cliente == 2) {
        $(".btn-tipo-doc-2").addClass("active");
        $("input[name=tipo_doc][value='2']").attr("checked", true);
      } else {
        $(".btn-tipo-doc-1").addClass("active");
        $("input[name=tipo_doc][value='1']").attr("checked", true);

        if ($("input[name=tipo_doc][value='1']").length == false) {
          $(".btn-tipo-doc-3").addClass("active");
          $("input[name=tipo_doc][value='3']").attr("checked", true);
        }
      }

      // $('.btn-tipo-doc-3').addClass('disabled');
      // $("input[name=tipo_doc][value='2']").attr("disabled",false);

      if (data.tipo_pago == 1) {
        $("#tipo_pago").selectpicker("val", data.tipo_pago);
        $(".mensaje-pago").hide();
        $(".display-pago-efectivo").show();
        $(".display-pago-tarjeta").hide();
        $(".display-pago-default").show();
        $(".display-pago-rapido-efectivo").show();
        $(".display-codigo-operacion").hide();
      } else if (
        data.tipo_pago != 3 &&
        (data.tipo_pago == 2 || data.tipo_pago >= 4)
      ) {
        $("#tipo_pago").selectpicker("val", data.tipo_pago);
        $(".mensaje-pago").hide();
        $(".display-pago-efectivo").hide();
        $(".display-pago-tarjeta").hide();
        $(".display-pago-default").hide();
        $(".display-pago-rapido-efectivo").hide();
        $(".display-descuento").show();
        $(".display-codigo-operacion").show();
      } else {
        $("#tipo_pago").selectpicker("val", 1);
        $(".mensaje-pago").hide();
        $(".display-pago-efectivo").show();
        $(".display-pago-tarjeta").hide();
        $(".display-pago-default").show();
        $(".display-pago-rapido-efectivo").show();
        $(".display-codigo-operacion").hide();
      }

      if (data.amortizacion > 0) {
        $(".mensaje-amortizacion").show();
        $(".mensaje-amortizacion-text").html(
          "Existe una amortizaci&oacute;n de pago con un monto de " +
          moneda +
          " " +
          formatNumber(data.amortizacion)
        );
      } else {
        $(".mensaje-amortizacion").hide();
      }

      /*
            if(data.id_repartidor == 1){
                if (data.tipo_pago == 4) {
                    $('.display-comision-delivery').hide();
                } else {
                    $('.display-comision-delivery').show();
                }
            } else {
                $('.display-comision-delivery').hide();
            }
            */
      if (data.tipo_pago == 4) {
        $(".display-comision-delivery").hide();
      } else {
        $(".display-comision-delivery").show();
      }
      $("#codtipoped").val(data.id_tipo_pedido);
      $(".display-comision-tarjeta").hide();

      if (
        data.id_repartidor == 2222 ||
        data.id_repartidor == 3333 ||
        data.id_repartidor == 4444
      ) {
        $("#codrepartidor").val(2);
      } else {
        $("#codrepartidor").val(1);
      }
    },
  });
};

function calcularPagos() {
  var efectivo = parseFloat($("#pago_efe").val()) || 0;
  var tarjeta = parseFloat($("#pago_tar").val()) || 0;
  var yape = parseFloat($("#pago_yape").val()) || 0;

  var totalPedido =
    parseFloat($(".totalPedidoMenosTarjeta").first().text()) || 0;

  console.log("totalPedido: " + totalPedido);

  var totalPagado = efectivo + tarjeta + yape;

  var vuelto = totalPagado - totalPedido;

  if (vuelto < 0) {
    vuelto = 0;
  }
  console.log(vuelto);

  $("#vuelto").text(vuelto.toFixed(2));
}

var limpiar_datos_add = function () {
  $("#pago_efe").val("0.00");
  $("#pago_tar").val("0.00");
  $("#pago_yape").val("0.00");
  $("#pago_plin").val("0.00");
  $("#pago_tran").val("0.00");
  $("#vuelto").text("0.00");
  $(".descuento").val("0.00");
  $(".descuento").text("0.00");
  $(".comision_delivery").val("0.00");
  $(".comision_delivery").text("0.00");
  $("#observacion").val("");
  $(".comision_tarjeta").val("0.00");
  $(".comision_tarjeta").text("0.00");
  $(".display-pago-efectivo").show();
  $(".display-pago-default").show();
  $(".display-pago-tarjeta").hide();
  $("#descuento_tipo_hidden").val("");
  $("#descuento_monto_hidden").val("0.00");
  $("#descuento_motivo_hidden").val("");
  $("#tipo_pago").selectpicker("val", 1);
  $(".mensaje-pago").hide();
  $(".display-codigo-operacion").hide();
  $(".display-pago-rapido-efectivo").show();
};

var calculo_total = function () {
  if ($("#descuento_monto_hidden").val() == "") {
    $("#descuento_monto_hidden").val("0.00");
  }
  if ($("#comision_delivery").val() == "") {
    $("#comision_delivery").val("0.00");
  }

  var descuento = parseFloat($("#descuento_monto_hidden").val()) || 0.0;
  var comision_delivery = parseFloat($("#comision_delivery").val()) || 0.0;
  var total_venta = parseFloat($("#total_venta").val()) || 0.0;
  var comision_tarjeta = parseFloat($(".comision_tarjeta").val()) || 0.0;

  var calculo = total_venta + comision_delivery + comision_tarjeta - descuento;

  $(".totalPedido").val(formatNumber(calculo));
  $(".totalPedido").text(formatNumber(calculo));
  //$(".totalPedidoMenosTarjeta").text(formatNumber(calculo));
  //console.log('calculo_total: '+calculo);
};

var calculo_efectivo = function () {
  var cal1 =
    parseFloat($(".totalPedido").val().replace(",", "")) -
    parseFloat($("#pago_tar").val().replace(/,/g, "")) -
    parseFloat($("#pago_yape").val().replace(/,/g, "")) -
    parseFloat($("#pago_plin").val().replace(/,/g, "")) -
    parseFloat($("#pago_tran").val().replace(/,/g, "")) -
    parseFloat($(".comision_tarjeta").val().replace(/,/g, ""));
  var cal2 =
    parseFloat($("#pago_efe").val().replace(/,/g, "")) - parseFloat(cal1);

  if (isNaN(cal2)) {
    cal2 = 0;
  }

  $("#vuelto").text(formatNumber(cal2));
  //console.log('vuelto: '+cal2);
};

var opcion_pago_efectivo = function (monto) {
  $("#pago_efe").val(formatNumber(monto));
  calculo_efectivo();
};

var listarPedidosDetalle = function (
  cod_atencion,
  id_pedido,
  id_venta,
  tipo = "manual"
) {
  reset_default();
  limpiarComisionTarjeta();
  limpiarDescuentos();
  $(".display-delivery").hide();
  $(".card_height").css("background", "#ffffff");
  $(".card-body-right").css("display", "block");
  $(".pedido-numero-icono").html('<i class="ti-arrow-circle-right"></i> ');
  $(".cont03").css("display", "block");
  $('input[name="tipo_doc"]:checked').trigger("change");
  $("#tipo_pago").trigger("change");
  $("#cliente_documento").val("");
  $("#list-pedidos").empty();
  $("#content_pagos").show();
  $("#top-payment-inputs").show();

  const doc_defecto = $("#tipo_doc_defecto").val().trim();
  docDefecto(doc_defecto);
  //$("#list-pedidos-detalle").empty();

  selectionMode = false;

  $.ajax({
    dataType: "JSON",
    type: "POST",
    url: $("#url").val() + "venta/listarPedidosDetalle",
    data: {
      cod_atencion: cod_atencion,
      id_pedido: id_pedido,
    },
    success: function (data) {
      let totPed = 0;
      let total = 0;
      $(".pedido-numero").html(data.nro_pedido);
      $(".pedido-cliente").text(data.nombre_cliente);

      // if(cod_atencion == 3){
      //   console.log("delivery");

      //   $(".ticket_reparto").show();
      // }else{
      //   console.log("no delivery");
      //   $(".ticket_reparto").hide();
      // }

      cod_atencion == 3
        ? $(".ticket_reparto").show()
        : $(".ticket_reparto").hide();

      $(".imprimir_ticket_reparto")
        .off("click")
        .on("click", function () {
          imprimirTickeReparto(id_pedido);
        });

      pedidoSeleccionado = data;

      $.each(data.Detalle, function (i, item) {
        totPed = item.cant * item.precio;

        let selectionCounter = `
          <span class="selection-counter ${selectionMode ? "" : "d-none"}">0/${item.cant
          }</span>
          <span class="full-quantity ${selectionMode ? "d-none" : ""}">${item.cant
          }</span>
        `;

        // Solo si el tipo de pedido es 2, se agrega el onclick
        let onClickAttr = "";
        // if (data.id_tipo_pedido == 2) {
        //   onClickAttr = `onclick="subPedido(1, ${item.id_pedido}, ${item.id_pres}, '${item.precio}');"`;
        // }
        onClickAttr = `onclick="subPedido(1, ${item.id_pedido}, ${item.id_pres}, '${item.precio}');"`;

        const html = `
          <div class="d-flex flex-row comment-list" 
              data-id="${item.id_pedido}" 
              data-quantity="${item.cant}" 
              data-product="${item.id_pres}" 
              data-price="${item.precio}" 
              ${onClickAttr}>
            <div class="w-100 d-flex justify-content-between align-items-end r-order-item">
              <div class="r-details">
                <p class="order-name mb-0">
                  ${item.Producto.pro_pre}
                  <span class="r-order-type-label" style="margin-left:.6rem">
                    ${item.Producto.pro_nom}
                  </span>
                </p>
                <p class="order-units m-b-0 font-13">
                  ${selectionCounter} Unidad(es) en ${moneda} ${formatNumber(
          item.precio
        )} | Unidad
                </p>
              </div>
              <div class="price">
                ${moneda} ${formatNumber(totPed)}
              </div>
            </div>
          </div>
        `;

        $("#list-pedidos").append(html);
        total = totPed + total;
      });

      $(".totalPagar").html(
        '<div class="text"><span>' +
        moneda +
        " " +
        formatNumber(total) +
        "</span>"
      );
      $(".SubtotalPedido").text(formatNumber(total));
      let descuento = $("#comision_delivery").val();
      TotalPedido = total;
      //total += parseFloat(data.comision_delivery) - descuento;

      $("#descuento_monto_fijo").val();

      $(".totalDelivery").text(formatNumber(0));
      $(".totalDescuento").text(formatNumber(0));

      if (data.comision_delivery > 0) {
        $(".totalDelivery").text(formatNumber(data.comision_delivery));
        $("#comision_delivery").val(formatNumber(data.comision_delivery));
        total += parseFloat(data.comision_delivery);
      }

      $(".totalPedidoMenosTarjeta").text(formatNumber(total));
      $("#pago_efe").val(formatNumber(total));

      (pedidoSeleccionado.id_tipo_pedido == 2 ||
        pedidoSeleccionado.id_tipo_pedido == 3) &&
        pedidoSeleccionado.estado_pedido == "d"
        ? $(".card-footer-right").css("display", "none")
        : $(".card-footer-right").css("display", "block");

      if (
        (pedidoSeleccionado.id_tipo_pedido == 3 &&
          data.estado_pedido != "c" &&
          data.estado_pedido != "d") ||
        (pedidoSeleccionado.id_tipo_pedido == 2 &&
          pedidoSeleccionado.estado_pedido == "a")
      ) {
        $(".btn-submit-dividir-cuenta").html(
          '<a class="btn btn-blue btnDividirCuenta" id="btnDividirCuenta" data-id-pedido="' +
          id_pedido +
          '" href="javascript:void(0);"><i class="far fa-file-alt"></i></a>'
        );
        $("#btnDividirCuenta").on("click", function (event) {
          event.preventDefault();
          limpiarDescuentos();
          selectionMode = !selectionMode;
          if (selectionMode) {
            $(this).text("Desactivar");
            $("#list-pedidos").addClass("selection-mode");
            $(".selection-counter").removeClass("d-none");
            $(".full-quantity").addClass("d-none");
          } else {
            $(this).html('<i class="far fa-file-alt"></i>');
            $("#list-pedidos").removeClass("selection-mode");
            $(".selection-counter").addClass("d-none");
            $(".full-quantity").removeClass("d-none");
            $("#list-pedidos .comment-list").removeClass("selected");
          }
        });
      }

      $(".btn-agregar-productos").html(
        '<a class="btn btn-blue btnAgregarProdcuto" id="btnAgregarProdcuto" data-id-pedido="' +
        id_pedido +
        '" href="javascript:void(0);"><i class="icon-plus"></i></a>'
      );

      $(".btn_cancelar_pedido").html(
        '<a class="btn btn-danger btnCancelarPedido" id="btnCancelarPedido" data-id-pedido="' +
        id_pedido +
        '" href="javascript:void(0);"><i class="fas fa-times-circle"></i></a>'
      );

      $("#btnAgregarProdcuto").on("click", function (event) {
        event.preventDefault();
        var id_pedido = $(this).data("id-pedido");

        addPedido(id_pedido);
      });

      $("#btnCancelarPedido").on("click", function (event) {
        event.preventDefault(); // Evitar redirección
        var id_pedido = $(this).data("id-pedido");

        anular_pedido(id_pedido);
      });

      if (
        pedidoSeleccionado.id_tipo_pedido == 3 &&
        pedidoSeleccionado.estado_pedido == "c"
      ) {
        $("#openDialog").hide();

        $(".btn-submit-cobrar").html(
          '<a class="btn btn-green btnEntregado" id="btnEntregado" data-id-pedido="' +
          id_pedido +
          '" href="javascript:void(0);">Entregado</a>'
        );

        $("#btnEntregado").on("click", function (event) {
          event.preventDefault(); // Evitar redirección
          var id_pedido = $(this).data("id-pedido");
          //facturar(id_pedido, 1, id_tipo_pedido);
          pedidoAccion(3, 2, data.estado_pedido, id_pedido);
        });

        $(".btn-agregar-productos").hide();
        $(".btn_cancelar_pedido").hide();
      } else if (
        pedidoSeleccionado.id_tipo_pedido == 3 &&
        pedidoSeleccionado.estado_pedido == "b"
      ) {
        $("#openDialog").show();
        $(".btn-submit-cobrar").html(
          '<a class="btn btn-green btnCobrar" id="btnCobrar" data-id-pedido="' +
          id_pedido +
          '" href="javascript:void(0);">Cobrar <i class="far fa-money-bill-alt"></i></a>'
        );

        $("#btnCobrar").on("click", function (event) {
          event.preventDefault(); // Evitar redirección
          var id_pedido = $(this).data("id-pedido");
          //facturar(id_pedido, 1, id_tipo_pedido);
          procesarData(id_pedido);
        });
        $(".btn-agregar-productos").show();
        $(".btn_cancelar_pedido").show();
      }

      if (pedidoSeleccionado.id_tipo_pedido == 2 && data.estado_pedido == "c") {
        $("#openDialog").hide();

        $(".btn-submit-cobrar").html(
          '<a class="btn btn-green btnEntregado" id="btnEntregado" data-id-pedido="' +
          id_pedido +
          '" href="javascript:void(0);">Entregado</a>'
        );

        $("#btnEntregado").on("click", function (event) {
          event.preventDefault(); // Evitar redirección
          var id_pedido = $(this).data("id-pedido");
          //facturar(id_pedido, 1, id_tipo_pedido);
          pedidoAccion(2, 2, data.estado_pedido, id_pedido);
        });

        $(".btn-agregar-productos").hide();
        $(".btn_cancelar_pedido").hide();
      } else if (
        pedidoSeleccionado.id_tipo_pedido == 2 &&
        data.estado_pedido == "b"
      ) {
        $("#openDialog").show();
        $(".btn-submit-cobrar").html(
          '<a class="btn btn-green btnCobrar" id="btnCobrar" data-id-pedido="' +
          id_pedido +
          '" href="javascript:void(0);">Cobrar <i class="far fa-money-bill-alt"></i></a>'
        );

        $("#btnCobrar").on("click", function (event) {
          event.preventDefault(); // Evitar redirección
          var id_pedido = $(this).data("id-pedido");
          //facturar(id_pedido, 1, id_tipo_pedido);
          procesarData(id_pedido);
        });

        $(".btn-agregar-productos").show();
        $(".btn_cancelar_pedido").show();
      }

      if (
        cod_atencion == 3 &&
        data.estado_pedido != "c" &&
        data.estado_pedido != "d"
      ) {
        const $dialog = $(".dialogBtnDelivery");
        $("#openDialogDelivery").show();
        $("#openDialogDelivery").on("click", function (event) {
          event.preventDefault(); // Evitar redirección
          llenarModalDelivery(pedidoSeleccionado);
          $dialog[0].showModal();
          console.log(id_pedido);
        });
        $(".closeDialogBtnDelivery").on("click", function () {
          $dialog[0].close();
        });
      }
    },
    error: function (jqXHR, textStatus, errorThrown) {
      console.log(errorThrown + " " + textStatus);
    },
    complete: function () {
      if (cod_atencion == 3 && tipo == "automatico") {
        $("#openDialogDelivery").trigger("click");
      }
    },
  });
};

function llenarModalDelivery(data) {
  if (!data) {
    console.error("No hay datos para llenar el modal de delivery.");
    return;
  }

  // Tipo de entrega (radio visual)
  $(".btn-group-toggle .btn").removeClass("active");
  $("#tipo_entrega_" + data.tipo_entrega).prop("checked", true);
  $(".btn-tipo-entrega-" + data.tipo_entrega)
    .closest("label")
    .addClass("active");

  // Hora de entrega
  const $horaSelect = $("#hora_entrega_modal");
  if (
    data.hora_entrega &&
    $horaSelect.find("option[value='" + data.hora_entrega + "']").length > 0
  ) {
    $horaSelect.val(data.hora_entrega);
  } else {
    $horaSelect.val(null);
  }
  $horaSelect.selectpicker("refresh");

  // Inputs normales con trigger para floating labels
  $("#comision_delivery_modal")
    .val(data.comision_delivery || "")
    .trigger("input");
  $("#nomb_cliente_modal")
    .val(data.nombre_cliente || "")
    .trigger("input");
  $("#telefono_cliente_modal")
    .val(data.telefono_cliente || "")
    .trigger("input");
  $("#num_cliente_modal")
    .val(data.tipo_cliente == "1" ? data.dni_cliente : data.ruc_cliente)
    .trigger("input");
  $("#direccion_cliente_modal")
    .val(data.direccion_cliente || "")
    .trigger("input");
  $("#referencia_cliente_modal")
    .val(data.referencia_cliente || "")
    .trigger("input");

  // Selects con selectpicker
  $("#id_tdoc_modal").val(data.tipo_cliente).selectpicker("refresh");
  $("#id_repartidor_modal").val(data.id_repartidor).selectpicker("refresh");
  //$("#id_mozo").val(data.id_usu).selectpicker('refresh');
}

function imprimirTickeReparto(id_pedido) {
  var url = $("#url").val() + "venta/impresion_reparto_pedido/" + id_pedido;
  window.open(url, "_blank");
}

function obtenerDataDeliveryModal() {
  const tipo_entrega = $("input[name='tipo_entrega_modal']:checked").val();
  const tipo_cliente = $("#id_tdoc_modal").val();

  return {
    tipo_entrega: tipo_entrega,
    hora_entrega: $("#hora_entrega_modal").val(),
    comision_delivery: $("#comision_delivery_modal").val(),
    nombre_cliente: $("#nomb_cliente_modal").val(),
    telefono_cliente: $("#telefono_cliente_modal").val(),
    tipo_cliente: tipo_cliente,
    tipo_documento: $("#id_tdoc_modal").val(),
    numero_documento: $("#num_cliente_modal").val(),
    id_cliente: pedidoSeleccionado.id_cliente,
    direccion_cliente: $("#direccion_cliente_modal").val(),
    referencia_cliente: $("#referencia_cliente_modal").val(),
    id_repartidor: $("#id_repartidor_modal").val(),
    desc_respartidor: $("#id_repartidor_modal option:selected").text(),
  };
}

function actualizarDataDelivery() {
  data = obtenerDataDeliveryModal();
  id_pedido = pedidoSeleccionado.id_pedido;
  console.log(data);
  console.log(id_pedido);

  $.ajax({
    type: "POST",
    url: $("#url").val() + "venta/actualizarDataDelivery",
    dataType: "json",
    data: {
      id_pedido: id_pedido,
      data: data,
    },
    success: function (request) {
      console.log(request);
      if (request.success) {
        const $dialog = $(".dialogBtnDelivery");
        $dialog[0].close();

        $("#comision_delivery_modal").val("").trigger("input");
        $("#nomb_cliente_modal").val("").trigger("input");
        $("#telefono_cliente_modal").val("").trigger("input");
        $("#num_cliente_modal").val("").trigger("input");
        $("#direccion_cliente_modal").val("").trigger("input");
        $("#referencia_cliente_modal").val("").trigger("input");

        delivery_list_b();
        listarPedidosDetalle(3, id_pedido);
        imprimirTickeReparto(id_pedido);
      }
    },
  });
}

function addPedido(id_pedido) {
  if (pedidoSeleccionado.Detalle.length != 0) {
    const arregloExtraido = pedidoSeleccionado.Detalle.map((item) => {
      const { Producto, cant, precio, id_pres, fecha_pedido, estado_pedido } =
        item;
      const total = parseFloat(cant) * parseFloat(precio);
      const pro_img = "default.png";

      return {
        ...Producto,
        fecha_pedido,
        estado_pedido,
        cantidad: cant,
        id_pres,
        pro_cos: precio,
        pro_img,
        total,
      };
    });

    $(".po-items").empty();
    $("#id_pedido").val(id_pedido);

    arregloExtraido.forEach((producto) => {
      agregarProducto(producto, false, id_pedido);
    });

    $("#modal-super-test").modal("show");
  }
}

var pedidoAccion = function (
  tipo_pedido,
  cod_accion,
  estado_pedido,
  id_pedido
) {
  /* cod_accion
        1 = enviar delivery, 2 = entregado delivery, 3 = entregado mostrador
    */
  if (cod_accion == 1) {
    var accion = "PREPARADO";
  } else if (cod_accion == 2 || cod_accion == 3) {
    var accion = "ENTREGADO";
  }
  var html_confirm =
    '<div><br>\
        <div style="width: 100% !important; float: none !important;">\
            <table class="table m-b-0">\
                <tr><td class="text-left">Pedido: </td><td class="text-right">' +
    $(".pedido-numero").text() +
    '</td></tr>\
            </table>\
        </div><br>\
        Ingrese código de vaucher</div>\
        <form><input class="form-control text-center w-100" type="text" id="codigo_vaucher" autocomplete="off"/></form><br>\
        <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';

  Swal.fire({
    title: "Necesitamos de tu Confirmación",
    html: html_confirm,
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#34d16e",
    confirmButtonText: "Si, Adelante!",
    cancelButtonText: "No!",
    showLoaderOnConfirm: true,
    preConfirm: function () {
      return new Promise(function (resolve) {
        $.ajax({
          url: $("#url").val() + "venta/pedidoAccion",
          type: "POST",
          data: {
            tipo_pedido: tipo_pedido,
            cod_accion: cod_accion,
            id_pedido: id_pedido,
            codigo_operacion: $("#codigo_vaucher").val(),
          },
          dataType: "json",
        })
          .done(function (response) {
            Swal.fire({
              title: "Proceso Terminado",
              text: "El pedido ha sido " + accion,
              icon: "success",
              confirmButtonColor: "#34d16e",
              confirmButtonText: "Aceptar",
            });
            reset_default();
            $(".cont01").css("display", "flex");
            if (cod_accion == 1 || cod_accion == 2) {
              if (estado_pedido == "b") {
                delivery_list_b();
              } else if (estado_pedido == "c") {
                tipo_pedido == 2 ? mostrador_list_b() : delivery_list_b();
              }
            } else if (cod_accion == 3) {
              mostrador();
            }
          })
          .fail(function () {
            Swal.fire(
              "Oops...",
              "Problemas con la conexión a internet!",
              "error"
            );
          });
      });
    },
    allowOutsideClick: false,
  });
};

// var registrarMesa = function (id_mesa, nro_mesa, salon) {
//   var html_confirm =
//     '<div>Se procederá aperturar la siguiente mesa:</div><br>\
//     <table class="table m-b-0">\
//     <tr><td class="text-left">Salon: </td><td class="text-right">' +
//     salon +
//     '</td></tr>\
//     <tr><td class="text-left">Mesa: </td><td class="text-right">' +
//     nro_mesa +
//     '</td></tr>\
//     </table>\
//     <label>Nro personas</label>\
//     <input class="form-control numero-personas text-center" type="text" value="1" id="nro_personas"/><br>\
//     <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';

//   Swal.fire({
//     title: "Necesitamos de tu Confirmación",
//     html: html_confirm,
//     icon: "warning",
//     showCancelButton: true,
//     confirmButtonColor: "#34d16e",
//     confirmButtonText: "Si, Adelante!",
//     cancelButtonText: "No!",
//     showLoaderOnConfirm: true,
//     preConfirm: function () {
//       return new Promise(function (resolve) {
//         $.ajax({
//           url: $("#url").val() + "venta/pedido_create/pc1",
//           type: "POST",
//           data: {
//             id_mesa: id_mesa,
//             nomb_cliente: "Mesa " + nro_mesa,
//             nro_personas: $("#nro_personas").val(),
//           },
//           dataType: "json",
//           success: function (data) {
//             if (data["fil"] == 1) {
//               window.open(
//                 $("#url").val() + "venta/orden/" + data["id_pedido"],
//                 "_self"
//               );
//             } else {
//               window.open($("#url").val() + "venta", "_self");
//             }
//           },
//         }).fail(function () {
//           Swal.fire(
//             "Oops...",
//             "Problemas con la conexión a internet!",
//             "error"
//           );
//         });
//       });
//     },
//     allowOutsideClick: false,
//   });
//   $(".numero-personas").TouchSpin({
//     buttondown_class: "btn btn-secondary",
//     buttonup_class: "btn btn-secondary",
//     min: 1,
//     mousewheel: false,
//   });
// };

function registrarMesa(id_mesa, nro_mesa, salon) {
  $(".po-items").empty();
  $("#id_pedido").val(0);
  $(".id-mesa").val(id_mesa);
  $("#info_mesa").text(`${salon} - Mesa: ${nro_mesa}`);
  if (esDispositivoMovil()) {
    $(".modal-order-right").css("display", "none");
  }

  $("#imprimir_comandas_mozo").empty();

  $("#btn_dropdown_comandas_mozo").prop("disabled", true);

  $("#btn_cancelar_pedido_mozo").prop("disabled", true);

  $("#modal-super-test").modal("show");
}

var orden = function (id_pedido, mesa, salon) {
  //window.open($("#url").val() + "venta/orden/" + id_pedido, "_self");

  $("#imprimir_comandas_mozo").empty();

  $("#btn_dropdown_comandas_mozo").prop("disabled", false);

  $("#btn_cancelar_pedido_mozo").prop("disabled", false);

  listarPedidosMozo(id_pedido, mesa, salon);
};

var list_categorias_menu = function () {
  $(".categoriamenu").css("display", "block");
  $("#categoriamenu").css("display", "none");
  $("#modal-lista-menu").modal("show");
  $(".list_categorias_menu").empty();
  $.ajax({
    type: "POST",
    url: $("#url").val() + "venta/menu_categoria_list",
    dataType: "json",
    success: function (item) {
      if (item.data.length > 0) {
        $.each(item.data, function (i, item) {
          var categoria_nombre =
            item.descripcion.substr(0, 1).toUpperCase() +
            item.descripcion.substr(1).toLowerCase();
          $(".list_categorias_menu").append(
            $('<li class="nav-item m-t-10"/>').html(
              '<a class="nav-link bg-header" data-toggle="tab" href="#categoriamenu" onclick="list_platos_menu(' +
              item.id_catg +
              ');" role="tab">' +
              '<span class="hidden-sm-up">' +
              categoria_nombre +
              "</span>" +
              '<span class="hidden-xs-down font-14">' +
              categoria_nombre +
              "</span> </a>"
            )
          );
        });
      } else {
        $(".list_categorias_menu").html("");
      }
    },
  });
};

var list_platos_menu = function (id_catg) {
  $(".categoriamenu").css("display", "none");
  $("#categoriamenu").css("display", "block");

  function filterGlobal() {
    $("#list_platos_menu")
      .DataTable()
      .search($("#search_filter_menu").val())
      .draw();
  }

  var count = 0;
  var table = $("#list_platos_menu").DataTable({
    destroy: true,
    dom: "tp",
    bSort: false,
    ajax: {
      method: "POST",
      url: $("#url").val() + "venta/menu_plato_list",
      data: {
        id_catg: id_catg,
      },
    },
    columns: [
      {
        data: null,
        render: function (data, type, row) {
          var pro_nom =
            data.pro_nom.substr(0, 1).toUpperCase() +
            data.pro_nom.substr(1).toLowerCase();
          var pro_pre =
            data.pro_pre.substr(0, 1).toUpperCase() +
            data.pro_pre.substr(1).toLowerCase();
          return (
            pro_nom +
            " | " +
            pro_pre +
            " | " +
            $("#moneda").val() +
            " " +
            data.pro_cos
          );
        },
      },
      {
        data: null,
        render: function (data, type, row) {
          var checked = data.est_c == "a" ? "checked" : "";
          return (
            '<div class="switch text-right" onclick="estado_plato_menu(' +
            data.id_catg +
            "," +
            data.id_pres +
            ",'" +
            data.est_c +
            '\');"><label class="m-b-0"><input type="checkbox" ' +
            checked +
            '><span class="lever switch-col-light-green"></span></label></div>'
          );
        },
      },
    ],
  });

  $("input.search_filter_menu").on("keyup click", function () {
    filterGlobal();
  });
};

var estado_plato_menu = function (id_catg, id_pres, estado) {
  $.ajax({
    type: "POST",
    url: $("#url").val() + "venta/menu_plato_estado",
    dataType: "json",
    data: {
      id_pres: id_pres,
      estado: estado,
    },
    success: function (request) {
      list_platos_menu(id_catg);
    },
  });
};

var nuevoPedidoMesa = function (id_mesa, mesa, salon) {
  $("#id_pedido").val(0);

  $("#info_mesa").text(`${salon} - Mesa: ${mesa}`);

  $("#cliente_pedido_id").val(1);
  $("#buscar_cliente_pedido").val("DNI: 00000000 | PUBLICO EN GENERAL");

  $("#modal-super-test").modal("show");

  if (esDispositivoMovil()) {
    $(".modal-order-right").css("display", "none");
  }
  $("#openDialog").hide();
  $("#codsalonorigen").val("0");
  $("#codmesaorigen").val("0");
  $(".id-mesa").val(id_mesa);
  $("#list-pedidos").empty();
  $(".po-items").empty();
  //////////////////////////////////////
  reset_default();
  $(".display-mozo").css("display", "block");
  $("#id_mozo").removeAttr("disabled");
  $("#id_mozo").selectpicker("refresh");
  $("#id_mozo").selectpicker("val", "" + id_mozo_ + "");
  $("#nomb_cliente").removeAttr("disabled");
  $(".pedido-mozo").hide();
  $("#content_pagos").hide();
  $("#top-payment-inputs").hide();
  $(".display-personas").css("display", "block");
  $(".numero-personas").TouchSpin({
    buttondown_class: "btn btn-link text-success",
    buttonup_class: "btn btn-link text-success",
    min: 1,
    mousewheel: false,
  });
  ///////////////////////////////////////////
  // $('.card_height').css('background','#fffde3');
  $(".card_height").css("background", "#ffffff");
  $(".card-body-right").css("display", "block");
  $(".card-settings").hide();
  $(".cont02").css("display", "block");
  $(".pedido-numero-icono").html("");
  $(".pedido-numero").html(salon + " - Mesa: " + mesa);
  $(".card-footer-right").css("display", "block");
  $(".display-opciones-pedido").hide();
  /////////////////////////////////////////////
  $("#nomb_cliente").val("Mesa: " + mesa);

  $("#id_pedido").val(0);
};

var tab01 = function () {
  $(".topbar").css("width", "100%");
  $(".display-estado-mesa").css("display", "block");
  $('input[name^="codtipoped"]').val(1);
  $("#list-pedidos").empty();
  /////////////////////
  reset_default();
  $(".cont01").css("display", "flex");
  $(".cont01-1").css("display", "block");
  $(".cont01-2").css("display", "none");
  $(".nomPed").html("una mesa");
  $(".dim").removeClass("active");
  $("#codpestdelivery").val(0);
};

var tab02 = function () {
  $(".venta_por_consumo").prop("checked", false).triggerHandler("click");
  $(".topbar").css("width", "100%");
  $("#form-nuevo-pedido").attr("action", "venta/pedido_create/pc2");
  $(".display-estado-mesa").css("display", "none");
  $('input[name^="codtipoped"]').val(2);
  /////////////////////////////
  reset_default();
  $(".cont01").css("display", "flex");
  $(".cont01-1").css("display", "none");
  $(".cont01-2").css("display", "block");
  $(".nomPed").html("un pedido");
  $("#codpestdelivery").val(0);
};

var tab03 = function () {
  $(".venta_por_consumo").prop("checked", false).triggerHandler("click");
  $(".topbar").css("width", "100%");
  $("#form-nuevo-pedido").attr("action", "venta/pedido_create/pc3");
  $(".display-estado-mesa").css("display", "none");
  $('input[name^="codtipoped"]').val(3);
  ///////////////////////
  reset_default();
  $(".cont01").css("display", "flex");
  $(".cont01-1").css("display", "none");
  $(".cont01-2").css("display", "block");
  $(".nomPed").html("un pedido");
  $("#codpestdelivery").val(1);
  //$('#cliente_id').val('');
};

$(".tab01,.list-salones").click(function () {
  tab01();
});

$(".tab02").click(function () {
  tab02();
});

$(".tab03").click(function () {
  tab03();
});

$(".btn-nuevo-pedido").click(function () {
  $("#modal-super-test").modal("show");
  reset_default();
  $("#id_pedido").val(0);
  $(".card_height").css("background", "#fffde3");
  //$('.card_height').css('background','#FFFFF0');
  //$(".card-body-right").css("display", "block");
  $(".pedido-numero-icono").html("");
  $(".pedido-numero").show();
  $(".pedido-numero").html("Nuevo pedido:");
  $(".cont02").css("display", "block");

  if ($("#codtipoped").val() == 2) {
    $(".display-nombre").css("display", "block");
    $("#nomb_cliente").removeAttr("disabled");
    $("#nomb_cliente").val("PUBLICO GENERAL");
    $("#nomb_cliente").select();
    $("#form-nuevo-pedido").formValidation("revalidateField", "nomb_cliente");
    $("#id_tdoc").selectpicker("val", "1");
    $("#id_repartidor").selectpicker("refresh");

    $("#num_cliente").attr("maxlength", 8);
    $("#num_cliente").val("00000000");
  } else if ($("#codtipoped").val() == 3) {
    //$('#cliente_id').val('');
    $(".display-pedido-programado").css("display", "block");
    $("#tipo_entrega_1").prop("checked", true);
    $("#tipo_entrega_2").prop("checked", false);
    $(".display-tipo-entrega").css("display", "block");
    $(".btn-tipo-entrega-1").addClass("active");
    $(".btn-tipo-entrega-2").removeClass("active");
    $(".display-telefono-cliente").css("display", "block");
    $("#telefono_cliente").removeAttr("disabled");
    $("#telefono_cliente").val("0000");
    $(".display-nombre").css("display", "block");
    $("#nomb_cliente").removeAttr("disabled");
    $("#nomb_cliente").val("GENERAL");
    $(".display-direccion-cliente").css("display", "block");
    $("#direccion_cliente").removeAttr("disabled");
    $("#direccion_cliente").val("-");
    $("#referencia_cliente").val("-");
    $(".display-referencia-cliente").css("display", "block");
    $("#referencia_cliente").removeAttr("disabled");
    $(".display-repartidor").css("display", "block");
    $("#id_repartidor").removeAttr("disabled");

    $("#id_tdoc").selectpicker("val", "1");
    $("#id_repartidor").selectpicker("refresh");

    $("#num_cliente").attr("maxlength", 8);
    $("#num_cliente").val("00000000");

    $("#id_repartidor").selectpicker("val", "" + id_repartidor_ + "");
    $("#id_repartidor").selectpicker("refresh");

    $("#form-nuevo-pedido").formValidation("revalidateField", "id_repartidor");
    $("#form-nuevo-pedido").formValidation(
      "revalidateField",
      "telefono_cliente"
    );
    $("#form-nuevo-pedido").formValidation("revalidateField", "nomb_cliente");
    $("#form-nuevo-pedido").formValidation(
      "revalidateField",
      "direccion_cliente"
    );
    $("#form-nuevo-pedido").formValidation(
      "revalidateField",
      "referencia_cliente"
    );
    //$('.btn-opc-nuevo-cliente').html('<button class="btn btn-secondary" onclick="nuevo_cliente();" type="button"><i class="fa fa-user-plus"></i></button>');
    setTimeout(() => {
      $("#telefono_cliente").focus();
    }, 500);
  }
  //$(".card-footer-right").css("display", "block");
  $(".display-opciones-pedido").hide();

  $("#cliente_pedido_id").val(1);
  $("#buscar_cliente_pedido").val("DNI: 00000000 | PUBLICO EN GENERAL");
});

$(".btn-cancelar-pedido").click(function () {
  if ($("#codtipoped").val() == 1) {
    tab01();
  } else if ($("#codtipoped").val() == 2) {
    tab02();
  } else if ($("#codtipoped").val() == 3) {
    tab03();
  }
});

$(".btn-tipo-entrega-1").on("click", function (event) {
  $(".display-nombre").css("display", "block");
  $("#nomb_cliente").prop("disabled", false);
  $(".display-direccion-cliente").css("display", "block");
  $("#direccion_cliente").prop("disabled", false);
  $(".display-referencia-cliente").css("display", "block");
  $("#referencia_cliente").prop("disabled", false);
  $(".display-repartidor").css("display", "block");
  $("#id_repartidor").prop("disabled", false);
  $("#id_repartidor").selectpicker("refresh");
  $("#id_repartidor").selectpicker("val", "");
  $("#form-nuevo-pedido").formValidation("revalidateField", "id_repartidor");
  $("#form-nuevo-pedido").formValidation("revalidateField", "telefono_cliente");
  $("#form-nuevo-pedido").formValidation("revalidateField", "nomb_cliente");
  $("#form-nuevo-pedido").formValidation(
    "revalidateField",
    "direccion_cliente"
  );
  $("#form-nuevo-pedido").formValidation(
    "revalidateField",
    "referencia_cliente"
  );
});

$(".btn-tipo-entrega-2").on("click", function (event) {
  $(".display-nombre").css("display", "block");
  $("#nomb_cliente").prop("disabled", false);
  $(".display-direccion-cliente").css("display", "none");
  $("#direccion_cliente").prop("disabled", true);
  $(".display-referencia-cliente").css("display", "none");
  $("#referencia_cliente").prop("disabled", true);
  $(".display-repartidor").css("display", "none");
  $("#id_repartidor").prop("disabled", true);
  $("#form-nuevo-pedido").formValidation("revalidateField", "telefono_cliente");
  $("#form-nuevo-pedido").formValidation("revalidateField", "nomb_cliente");
});

/* INICIO - OPCION DE MESAS */
/* 1.- OPCION CAMBIAR MESA  */
/* Combo mesa origen */
var comboMesaOrigenOpc01 = function (cod_salon_origen_opc01) {
  $("#cod_mesa_origen_opc01").find("option").remove();
  $.ajax({
    type: "POST",
    url: $("#url").val() + "venta/ComboMesaOri",
    data: {
      cod_salon_origen: cod_salon_origen_opc01,
    },
    success: function (response) {
      $("#cod_mesa_origen_opc01").html(response);
      $("#cod_mesa_origen_opc01").selectpicker();
      $("#cod_mesa_origen_opc01").selectpicker("refresh");
      $("#cod_mesa_origen_opc01")
        .val($("#codmesaorigen").val())
        .selectpicker("refresh");
    },
    error: function () {
      $("#cod_mesa_origen_opc01").html("There was an error!");
    },
  });
};

/* Combo mesa destino */
var comboMesaDestinoOpc01 = function (cod_salon_destino_opc01) {
  $("#cod_mesa_destino_opc01").find("option").remove();
  $.ajax({
    type: "POST",
    url: $("#url").val() + "venta/ComboMesaDes",
    data: {
      cod_salon_destino: cod_salon_destino_opc01,
      estado: "a",
    },
    success: function (response) {
      $("#cod_mesa_destino_opc01").html(response);
      $("#cod_mesa_destino_opc01").selectpicker();
      $("#cod_mesa_destino_opc01").selectpicker("refresh");
    },
    error: function () {
      $("#cod_mesa_destino_opc01").html("There was an error!");
    },
  });
};

/* Combo salon origen */
$("#cod_salon_origen_opc01").change(function () {
  var cod_salon_origen_opc01 = $("#cod_salon_origen_opc01").val();
  comboMesaOrigenOpc01(cod_salon_origen_opc01);
  $("#form-cambiar-mesa").formValidation(
    "revalidateField",
    "cod_mesa_origen_opc01"
  );
});

/* Combo salon destino */
$("#cod_salon_destino_opc01").change(function () {
  var cod_salon_destino_opc01 = $("#cod_salon_destino_opc01").val();
  comboMesaDestinoOpc01(cod_salon_destino_opc01);
});

/* Boton cambiar mesa */
$(".opc-cambiar-mesa").click(function () {
  $("#cod_salon_origen_opc01")
    .val($("#codsalonorigen").val())
    .selectpicker("refresh");
  var cod_salon_destino_opc01 = $("#cod_salon_destino_opc01").val();
  comboMesaOrigenOpc01($("#codsalonorigen").val());
  comboMesaDestinoOpc01(cod_salon_destino_opc01);
});

$("#modal-cambiar-mesa").on("hidden.bs.modal", function () {
  $(this).find("form")[0].reset();
  $("#form-cambiar-mesa").formValidation("resetForm", true);
  $("#cod_salon_origen_opc01").val("").selectpicker("refresh");
  $("#cod_salon_destino_opc01").val("").selectpicker("refresh");
});
/* OPCION CAMBIAR MESA  */

/* 2.- OPCION MOVER PEDIDOS  */
/* Combo mesa origen */
var comboMesaOrigenOpc02 = function (cod_salon_origen_opc02) {
  $("#cod_mesa_origen_opc02").find("option").remove();
  $.ajax({
    type: "POST",
    url: $("#url").val() + "venta/ComboMesaOri",
    data: {
      cod_salon_origen: cod_salon_origen_opc02,
    },
    success: function (response) {
      $("#cod_mesa_origen_opc02").html(response);
      $("#cod_mesa_origen_opc02").selectpicker();
      $("#cod_mesa_origen_opc02").selectpicker("refresh");
      $("#cod_mesa_origen_opc02")
        .val($("#codmesaorigen").val())
        .selectpicker("refresh");
    },
    error: function () {
      $("#cod_mesa_origen_opc02").html("There was an error!");
    },
  });
};

/* Combo mesa destino */
var comboMesaDestinoOpc02 = function (cod_salon_destino_opc02) {
  $("#cod_mesa_destino_opc02").find("option").remove();
  $.ajax({
    type: "POST",
    url: $("#url").val() + "venta/ComboMesaDes",
    data: {
      cod_salon_destino: cod_salon_destino_opc02,
      estado: "i",
    },
    success: function (response) {
      $("#cod_mesa_destino_opc02").html(response);
      $("#cod_mesa_destino_opc02").selectpicker();
      $("#cod_mesa_destino_opc02").selectpicker("refresh");
    },
    error: function () {
      $("#cod_mesa_destino_opc02").html("There was an error!");
    },
  });
};

/* Combo salon origen */
$("#cod_salon_origen_opc02").change(function () {
  var cod_salon_origen_opc02 = $("#cod_salon_origen_opc02").val();
  comboMesaOrigenOpc02(cod_salon_origen_opc02);
  $("#form-mover-pedidos").formValidation(
    "revalidateField",
    "cod_mesa_origen_opc02"
  );
});

/* Combo salon destino */
$("#cod_salon_destino_opc02").change(function () {
  var cod_salon_destino_opc02 = $("#cod_salon_destino_opc02").val();
  comboMesaDestinoOpc02(cod_salon_destino_opc02);
});

/* Boton cambiar mesa */
$(".opc-mover-pedidos").click(function () {
  $("#cod_salon_origen_opc02")
    .val($("#codsalonorigen").val())
    .selectpicker("refresh");
  var cod_salon_destino_opc02 = $("#cod_salon_destino_opc02").val();
  comboMesaOrigenOpc02($("#codsalonorigen").val());
  comboMesaDestinoOpc02(cod_salon_destino_opc02);
});

$("#modal-mover-pedidos").on("hidden.bs.modal", function () {
  $(this).find("form")[0].reset();
  $("#form-mover-pedidos").formValidation("resetForm", true);
  $("#cod_salon_origen_opc02").val("").selectpicker("refresh");
  $("#cod_salon_destino_opc02").val("").selectpicker("refresh");
});
/* OPCION MOVER PEDIDOS  */

/* FIN OPCION DE MESAS */

/************  */

var reset_default = function () {
  $("#list-pedidos").empty();
  $(".cont01").css("display", "none");
  $(".cont02").css("display", "none");
  $(".cont03").css("display", "none");
  $(".cont04").css("display", "none");
  $(".card-body-right").css("display", "none");
  $(".card-footer-right").css("display", "none");
  $(".card_height").css("background", "#666");
  $(".totalPagar").html("");
  $(".pedido-numero-icono").html("");
  $(".pedido-numero").html("Detalle:");
  // NONE DISPLAY
  $(".display-pedido-programado").css("display", "none");
  $(".pedido_programado").prop("checked", false);
  $(".pedido_programado").val("0");
  $(".display-tipo-entrega").css("display", "none");
  $(".display-hora-entrega").css("display", "none");
  $(".display-pedido-total-amortizado").css("display", "none");
  $(".display-busqueda-cliente").css("display", "none");
  $(".display-nombre").css("display", "none");
  $(".display-telefono-cliente").css("display", "none");
  $(".display-direccion-cliente").css("display", "none");
  $(".display-referencia-cliente").css("display", "none");
  $(".display-repartidor").css("display", "none");
  $(".display-personas").css("display", "none");
  $(".display-mozo").css("display", "none");
  //DISABLED INPUT
  $("#hora_entrega").attr("disabled", "true");
  $("#nomb_cliente").attr("disabled", "true");
  $("#telefono_cliente").attr("disabled", "true");
  $("#direccion_cliente").attr("disabled", "true");
  $("#referencia_cliente").attr("disabled", "true");
  $("#id_repartidor").attr("disabled", "true");
  $("#id_mozo").attr("disabled", "true");
  $(".btn-submit-dividir-cuenta").html("");
  $(".btn-submit-cobrar").html("");
  $(".btn_cancelar_pedido").html("");
  $(".btn-agregar-productos").html("");
  $("#openDialogDelivery").hide();
  vaciarListaProductos();
};

$(".mostrador01").click(function () {
  mostrador_list_a();
  reset_default();
  $(".cont01").css("display", "flex");
});

$(".mostrador02").click(function () {
  console.log("mostrador02");

  mostrador_list_b();
  reset_default();
  $(".cont01").css("display", "flex");
});

$(".mostrador03").click(function () {
  mostrador_list_c();
  reset_default();
  $(".cont01").css("display", "flex");
});

$(".delivery01").click(function () {
  delivery_list_a();
  reset_default();
  $(".cont01").css("display", "flex");
  $("#codpestdelivery").val(1);
});

$(".delivery02").click(function () {
  delivery_list_b();
  reset_default();
  $(".cont01").css("display", "flex");
  $("#codpestdelivery").val(0);
});

$(".delivery03").click(function () {
  delivery_list_c();
  reset_default();
  $(".cont01").css("display", "flex");
  $("#codpestdelivery").val(0);
});

$(".delivery04").click(function () {
  delivery_list_d();
  reset_default();
  $(".cont01").css("display", "flex");
  $("#codpestdelivery").val(0);
});

var enviar_whatsapp_pago = function (
  nro_pedido,
  total_pedido,
  cliente,
  telefono
) {
  var html_confirm =
    '<div>Enviar mensaje:</div>\
    <div class="font-18 font-bold">Pedido N° ' +
    nro_pedido +
    '</div><br>\
    <div><form><textarea id="textarea" class="form-control" rows="8">Hola ' +
    cliente +
    ": Ya aceptamos tu solicitud de tu pedido por un monto de " +
    $("#moneda").val() +
    " " +
    formatNumber(total_pedido) +
    '. Gracias por confiar en nosotros</textarea><input class="form-control text-center w-100" type="text" id="num_cliente" value="51' +
    telefono +
    '" autocomplete="off"/></div><div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';
  window.setTimeout(function () {
    var obj = $("#num_cliente"),
      val = obj.val();
    obj.focus().val("").val(val);
    obj.scrollTop(obj[0].scrollHeight);
  }, 300);

  Swal.fire({
    title: "",
    html: html_confirm,
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#34d16e",
    confirmButtonText: "Si, Adelante!",
    cancelButtonText: "No!",
    showLoaderOnConfirm: true,
    preConfirm: function () {
      if ($("#api_wsp").val() == 1) {
        $.ajax({
          url: $("#url").val() + "whatsapp/send_wsp_txt",
          type: "POST",
          data: {
            num_cliente: $("#num_cliente").val(),
            mensaje: $("#textarea").val(),
          },
          dataType: "json",
        })
          .done(function (response) {
            if (response.status == true) {
              Swal.fire({
                title: "Proceso Terminado",
                html: "Whatsapp enviado correctamente <br><br> <strong>Respuesta server: </strong>Mensaje enviado con éxito",
                icon: "success",
                confirmButtonColor: "#34d16e",
                confirmButtonText: "OK",
              });
            } else {
              Swal.fire({
                title: "Proceso No Culminado",
                html:
                  "" + response.msg + "<br>" + response.errors
                    ? response.errors
                    : "" + "",
                icon: "error",
                confirmButtonColor: "#34d16e",
                confirmButtonText: "OK",
              });
            }
          })
          .fail(function (error) {
            // console.log(error)
            console.log(error.responseText);
            Swal.fire(
              "Oops...",
              "Error: " + error.responseText.msg + "",
              "error"
            );
          });
      } else {
        window.open(
          "https://api.whatsapp.com/send?phone=51" +
          telefono +
          "&text=" +
          $("#textarea").val(),
          "_blank"
        );
      }
    },
  });
};

var anular_pedido = function (id_pedido) {
  var html_confirm =
    '<div>Se procederá a anular este pedido</div><br>\
    <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';
  Swal.fire({
    title: "Necesitamos de tu Confirmación",
    html: html_confirm,
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#34d16e",
    confirmButtonText: "Si, Adelante!",
    cancelButtonText: "No!",
    showLoaderOnConfirm: true,
    preConfirm: function () {
      return new Promise(function (resolve) {
        $.ajax({
          url: $("#url").val() + "venta/anular_pedido",
          type: "POST",
          data: {
            id_pedido: id_pedido,
            tipo_pedido: $("#codtipoped").val(),
          },
          dataType: "json",
        })
          .done(function (response) {
            let tipo_pedido = $("#codtipoped").val();
            if (tipo_pedido == 2) {
              $(".mostrador02").trigger("click");
            } else if (tipo_pedido == 3) {
              $(".delivery02").trigger("click");
            }

            resolve();
          })
          .fail(function () {
            Swal.fire(
              "Oops...",
              "Problemas con la conexión a internet!",
              "error"
            );
          });
      });
    },
    allowOutsideClick: false,
  });
};

var anular_venta = function (id_pedido, nro_pedido, id_venta) {
  var html_confirm =
    '<div>Se procederá a anular el siguiente pedido:</div>\
    <div class="font-18 font-bold">Pedido N° ' +
    nro_pedido +
    '</div><br>\
    Ingrese código de seguridad</div><br>\
    <form><input class="form-control text-center w-50" type="password" id="codigo_anular_venta_" autocomplete="off"/></form><br>\
    <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';
  Swal.fire({
    title: "Necesitamos de tu Confirmación",
    html: html_confirm,
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#34d16e",
    confirmButtonText: "Si, Adelante!",
    cancelButtonText: "No!",
    showLoaderOnConfirm: true,
    preConfirm: function () {
      return new Promise(function (resolve) {
        if (
          $("#codigo_anular_venta").val() == $("#codigo_anular_venta_").val()
        ) {
          $.ajax({
            url: $("#url").val() + "venta/anular_venta",
            type: "POST",
            data: {
              id_venta: id_venta,
              id_pedido: id_pedido,
            },
            dataType: "json",
          })
            .done(function (response) {
              window.open($("#url").val() + "venta", "_self");
            })
            .fail(function () {
              Swal.fire(
                "Oops...",
                "Problemas con la conexión a internet!",
                "error"
              );
            });
        } else {
          Swal.fire({
            title: "Proceso No Culminado",
            text: "El código ingresado es incorrecto",
            icon: "error",
            confirmButtonColor: "#34d16e",
            confirmButtonText: "Aceptar",
          });
        }
      });
    },
  });
};

var editar_pedido = function (id_pedido) {
  $("#modal-editar-pedido").modal("show");
  $.ajax({
    type: "post",
    dataType: "json",
    data: {
      id_pedido: id_pedido,
    },
    url: $("#url").val() + "venta/pedido_edit",
    success: function (item) {
      $.each(item.data, function (i, campo) {
        $("#id_pedido").val(id_pedido);
        $("#id_repartidor_edit").selectpicker("val", campo.id_repartidor);
        $("#hora_entrega_edit").selectpicker("val", campo.hora_entrega);
        $("#amortizacion").val(campo.amortizacion);
        $("#id_tipo_pago").selectpicker("val", campo.tipo_pago);

        if (campo.paga_con === "0.00") {
          setTimeout(function () {
            $("#paga_con").val(formatNumber($("#total_pagar_").val()));
          }, 500);
        } else {
          $("#paga_con").val(campo.paga_con);
        }

        $("#comision_delivery").val(campo.comision_delivery);
        if (campo.tipo_pago == 1) {
          $(".display-paga-con").show();
        } else {
          $(".display-paga-con").hide();
        }
      });
    },
  });
};

$("#id_tipo_pago").change(function () {
  if (this.value == 1) {
    $(".display-paga-con").show();
  } else {
    $(".display-paga-con").hide();
  }
});

var editar_venta_pago = function (id_venta) {
  $("#modal-editar-venta-pago").modal("show");
  $.ajax({
    type: "post",
    dataType: "json",
    data: {
      id_venta: id_venta,
    },
    url: $("#url").val() + "venta/venta_edit",
    success: function (item) {
      $.each(item.data, function (i, campo) {
        $("#id_pedido").val(campo.id_pedido);
        $("#id_venta").val(campo.id_venta);
        $("#id_venta_tipopago").val(campo.id_tipo_pago);
        $("#id_tipo_pago_v").selectpicker("val", campo.id_tipo_pago);
      });
    },
  });
};

confirmar_pedido = function (id_pedido, estado_pedido) {
  var html_confirm =
    '<div>Enviar los productos para su preparación, a su área de producción correspondiente</div><br>\
    <div style="width: 100% !important; float: none !important;">\
        <table class="table m-b-0">\
            <tr><td class="text-left">Pedido: </td><td class="text-right">' +
    $(".pedido-numero").text() +
    '</td></tr>\
            <tr><td class="text-left">Cliente: </td><td class="text-right">' +
    $(".pedido-cliente").text() +
    '</td></tr>\
        </table>\
    </div><br>\
    <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';
  Swal.fire({
    title: "Necesitamos de tu Confirmación",
    html: html_confirm,
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#34d16e",
    confirmButtonText: "Si, Adelante!",
    cancelButtonText: "No!",
    showLoaderOnConfirm: true,
    preConfirm: function () {
      return new Promise(function (resolve) {
        impresion_comanda(id_pedido, estado_pedido);
        printPdf(
          $("#url").val() + "venta/impresion_reparto_pedido/" + id_pedido
        );

        delivery_list_a();
        reset_default();
        $(".cont01").css("display", "flex");
        swal.close();
      });
    },
  });
};

var alert_pedidos_programados = function () {
  $.ajax({
    type: "post",
    dataType: "json",
    url: $("#url").val() + "venta/alert_pedidos_programados",
    success: function (data) {
      var fecha1 = moment($("#hora").val(), "HH:mm:ss");
      var fecha2 = moment(data.hora_entrega, "HH:mm:ss");
      var duration = moment.duration(fecha2 - fecha1).humanize();
      var minutos = fecha2.diff(fecha1, "minutes");
      if (minutos < 30) {
        html = "";
        var html_confirm =
          '<div class="font-16">Hay un pedido para las <strong>' +
          moment(fecha2).format("hh:mm A") +
          '</strong> esperando ser enviado a <strong>PREPARACIÓN</strong></div>\
                <br><div style="width: 100% !important; float: none !important;">\
                    <table class="table m-b-0">\
                    <tr><td class="text-left">Pedido: </td><td class="text-right">' +
          data.nro_pedido +
          '</td></tr>\
                    <tr><td class="text-left">Cliente: </td><td class="text-right">' +
          data.nombre_cliente +
          '</td></tr>\
                    </table>\
                </div><br>\
                <div><span class="text-success" style="font-size: 17px;">¿Continuar ahora?</span></div>';
        Swal.fire({
          title: "",
          html: html_confirm,
          icon: "info",
          position: "top-end",
          showCancelButton: true,
          confirmButtonColor: "#34d16e",
          confirmButtonText: "Si, Adelante!",
          cancelButtonText: "No!",
          showLoaderOnConfirm: true,
          preConfirm: function () {
            return new Promise(function (resolve) {
              $("#codtipoped").val(3);
              listarPedidosDetalle(3, data.id_pedido, 0);
              activaTab("tabp-3");
              activaTab("delivery01");
              delivery_list_a();
              $(".display-estado-mesa").css("display", "none");
              $(".cont01-1").css("display", "none");
              $(".cont01-2").css("display", "block");
              Swal.close();
            });
          },
        });
        var sound = new buzz.sound($("#url").val() + "public/sound/alert02", {
          formats: ["ogg", "mp3", "aac"],
        });
        sound.play();
      }
    },
  });
};

var validarApertura = function () {
  if ($("#cod_ape").val() == 0 && $("#rol_usr").val() != 1) {
    var html_confirm =
      '<div>Para poder realizar esta operación es necesario Aperturar Caja</div>\
            <br>\
            <div><span class="text-success" style="font-size: 18px;">¿Está Usted de Acuerdo?</span></div><br>\
            <a href="' +
      $("#url").val() +
      'caja/apercie" class="btn btn-success">Si, Adelante!</a>';

    Swal.fire({
      title: "Advertencia",
      html: html_confirm,
      icon: "warning",
      allowOutsideClick: false,
      allowEscapeKey: false,
      showCancelButton: false,
      showConfirmButton: false,
      closeOnConfirm: false,
      closeOnCancel: false,
    });
  }
};

$(".pedido_programado").on("click", function (event) {
  if ($(this).is(":checked")) {
    $("#pedido_programado").val("1");
    $(".display-hora-entrega").css("display", "block");
    $("#hora_entrega").removeAttr("disabled");
    $("#hora_entrega").selectpicker("refresh");
    $("#hora_entrega").selectpicker("val", "");
    $("#form-nuevo-pedido").formValidation("revalidateField", "hora_entrega");
  } else {
    $("#pedido_programado").val("0");
    $("#hora_entrega").prop("disabled", true);
    $(".display-hora-entrega").css("display", "none");
  }
});

/*
var getUrlParameter = function getUrlParameter(sParam) {
    var sPageURL = window.location.search.substring(1),
        sURLVariables = sPageURL.split('&'),
        sParameterName,
        i;

    for (i = 0; i < sURLVariables.length; i++) {
        sParameterName = sURLVariables[i].split('=');

        if (sParameterName[0] === sParam) {
            return sParameterName[1] === undefined ? true : decodeURIComponent(sParameterName[1]);
        }
    }
};
*/

function activaTab(tab) {
  $('.nav-tabs a[href="#' + tab + '"]').tab("show");
}

var impPreCuenta = function (id_pedido, id_mesa, estado, wiew) {
  $.ajax({
    url: $("#url").val() + "venta/pedido_estado_update",
    type: "post",
    dataType: "json",
    data: {
      id_mesa: id_mesa,
      estado: estado,
    },
    success: function (r) {
      return true;
    },
  }).done(function () {
    if (wiew) {
      printPdf(
        $("#url").val() + "venta/impresion_precuenta/" + id_pedido,
        true
      );
    } else {
      window.open(
        $("#url").val() + "venta/impresion_precuenta/" + id_pedido,
        "_blank"
      );
    }
  });
};

var printPdf = function (url, condicional) {
  var userAgent = navigator.userAgent || navigator.vendor || window.opera;

  window.open(url, "_blank");

  // if ((/android/i.test(userAgent)) || (/iPad|iPhone|iPod/.test(userAgent) && !window.MSStream) ) {
  //     // if(condicional){
  //         var Urlpdf = url;
  //     // }else{
  //     //     var Urlpdf = $("#url").val()+'informe/venta_all_imp/'+url;
  //     // }
  //     window.open(Urlpdf, '_blank');
  // }else{
  //     if(condicional){
  //         var Urlpdf = url;
  //     }else{
  //          var Urlpdf = $("#url").val()+'informe/venta_all_imp/'+url;
  //     }

  //     var iframe = document.createElement('iframe');
  //     iframe.className='pdfIframe'
  //     document.body.appendChild(iframe);
  //     iframe.style.display = 'none';
  //     iframe.onload = function () {
  //         setTimeout(function () {
  //             iframe.focus();
  //             iframe.contentWindow.print();
  //             URL.revokeObjectURL(Urlpdf)
  //         }, 0);
  //     };
  //     iframe.src = Urlpdf;
  //     URL.revokeObjectURL(Urlpdf)
  // }
};

var nuevo_cliente_vista = function () {
  if ($("#codcomision").val() == 1) {
    $("#td_dni").attr("checked", false);
    $("#td_ruc").attr("checked", false);
    $(".block01").css("display", "none");
    $(".block02").css("display", "none");
    $(".block03").css("display", "none");
    $(".block04").css("display", "none");
    $(".block05").css("display", "none");
    $(".block06").css("display", "none");
    $(".block07").css("display", "none");
    $(".block08").css("display", "none");
  }

  if ($("#cliente_tipo").val() != "") {
    if ($("#cliente_tipo").val() == 1) {
      $("#tipo_cliente").val(1);
      $(".block01").css("display", "block");
      $(".block02").css("display", "none");
      $(".block03").css("display", "block");
      $(".block04").css("display", "none");
      $(".block05").css("display", "block");
      $(".block06").css("display", "block");
      $(".block07").css("display", "none");
      $(".dni").prop("disabled", false);
      $(".ruc").prop("disabled", true);
      $("#form-cliente").formValidation("resetForm", true);
      $("#dni").val(
        $("#buscar_cliente")
          .val()
          .replace(/[^0-9]/g, "")
      );
      setTimeout(() => {
        $("#dni").select();
      }, 200);
      $("#seleccionar").select();
      $("#modal-cliente").modal("show");
    } else if ($("#cliente_tipo").val() == 2) {
      $("#tipo_cliente").val(2);
      $(".block01").css("display", "none");
      $(".block02").css("display", "block");
      $(".block03").css("display", "none");
      $(".block04").css("display", "none");
      $(".block05").css("display", "none");
      $(".block06").css("display", "none");
      $(".block07").css("display", "block");
      $(".dni").prop("disabled", true);
      $(".ruc").prop("disabled", false);
      $("#form-cliente").formValidation("resetForm", true);
      $("#ruc").val($("#buscar_cliente").val());
      $("#modal-cliente").modal("show");
    } else if ($("#cliente_tipo").val() == 3) {
      $("#tipo_cliente").val(1);
      $(".block01").css("display", "block");
      $(".block02").css("display", "none");
      $(".block03").css("display", "block");
      $(".block04").css("display", "block");
      $(".block05").css("display", "block");
      $(".block06").css("display", "block");
      $(".block07").css("display", "none");
      $(".dni").prop("disabled", false);
      $(".ruc").prop("disabled", true);
      $("#form-cliente").formValidation("resetForm", true);
      $("#dni").val(
        $("#buscar_cliente")
          .val()
          .replace(/[^0-9]/g, "")
      );
      setTimeout(() => {
        $("#dni").select();
      }, 200);
      $("#modal-cliente").modal("show");
    } else {
      //$('#modal-cliente').modal('show');
    }
  }
};

/* Nuevo Cliente */
var nuevoClienteVista = function () {
  console.log("adasd");

  //nuevo_cliente_vista();
};

$("#id_tdoc").change(function () {
  if ($("#id_tdoc").val() == 1) {
    $("#num_cliente").attr("maxlength", 8);
    $("#num_cliente").val("00000000");
  }
  if ($("#id_tdoc").val() == 2) {
    $("#num_cliente").attr("maxlength", 11);
    $("#num_cliente").val("");
  }
});

var listarCategorias = function () {
  $.ajax({
    dataType: "JSON",
    type: "POST",
    data: {
      codtipoped: $("#codtipoped").val(),
    },
    url: $("#url").val() + "venta/listarCategorias",
    success: function (data) {
      listarProdsMasVend();
      Categorias = data;
      Categorias.forEach((categoria) => {
        const idCategoria = categoria.id_catg;

        categoria.productos.forEach((producto) => {
          producto.id_catg = idCategoria;
          Productos.push(producto);
        });
      });

      generarCategorias(Categorias);
    },
    error: function (xhr, status, error) {
      console.error("Error al obtener categorías:", error);
    },
  });
};

// function generarCategorias(categorias) {
//   var container = $(".list-categories");

//   categoryHTML = "";

//   if (!categorias || categorias.length === 0) {
//     categoryHTML += '<p class="text-muted">No hay categorías disponibles.</p>';
//   } else {
//     var categoryHTML = `
//             <div class="card-category selected" data-id="favoritos">
//                 <div class="card-category-header hidden-xs-down">
//                     <span class="icon"><i class="far fa-heart"></i></span>
//                 </div>
//                 <div class="description">
//                     <span class="title">Favoritos</span>
//                     <span class="paragraph">Productos destacados</span>
//                 </div>
//             </div>
//         `;

//     categoryHTML += categorias
//       .map(
//         (categoria) => `
//             <div class="card-category" data-id="${categoria.id_catg}">
//                 <div class="card-category-header hidden-xs-down">
//                     <span class="icon"><i class="far fa-star"></i></span>
//                 </div>
//                 <div class="description">
//                     <span class="title">${categoria.descripcion}</span>
//                     <span class="paragraph">${
//                       categoria.cantidad
//                         ? categoria.cantidad + " items"
//                         : "Sin datos"
//                     }</span>
//                 </div>
//                 <span class="button-close" onclick="removeCategory(this)"><i class="fas fa-times"></i></span>
//             </div>
//         `
//       )
//       .join(""); // Convertimos el array en un string sin usar múltiples `.append()`
//   }

//   container.html(categoryHTML);

//   $(".card-category").on("click", function (e) {
//     $(".card-category").removeClass("selected");
//     $(this).addClass("selected");

//     var id = $(this).data("id");

//     id == "favoritos" ? listarProdsMasVend() : listarProductos(id);
//   });
// }

function generarCategorias(categorias) {
  var container = $(".list-categories");

  let categoryHTML = "";

  console.log(Productos);

  if (!categorias || categorias.length === 0) {
    categoryHTML += '<p class="text-muted">No hay categorías disponibles.</p>';
  } else {
    // Favoritos (fijo)
    categoryHTML += `
      <div class="card-category selected" data-id="favoritos">
        <span class="icon"><i class="far fa-heart"></i></span>
        <span class="title">Favoritos</span>
        <span class="close" onclick="removeCategory(this)">✖</span>
        <span class="badge">0</span>
      </div>
    `;

    // Categorías dinámicas
    categoryHTML += categorias
      .map((categoria) => {
        // Filtra productos con el mismo id_catg (comparando como string)
        const cantidad = Productos.filter(
          (p) => p.id_catg === String(categoria.id_catg)
        ).length;

        return `
        <div class="card-category" data-id="${categoria.id_catg}">
          <span class="icon"><i class="fas fa-th"></i></span>
          <span class="title">${categoria.descripcion}</span>
          <span class="badge">${cantidad}</span>
        </div>
      `;
      })
      .join("");
  }

  // Insertar en el DOM
  container.html(categoryHTML);

  // Asignar eventos de selección
  $(".card-category").on("click", function (e) {
    $(".card-category").removeClass("selected");
    $(this).addClass("selected");

    var id = $(this).data("id");

    console.log(id, "id categoria");

    selectedCategoryId = id;

    console.log(selectedCategoryId, "id categoriaGlobal");

    // id == "favoritos"
    //   ? listarProdsMasVend()
    //   : listarProductos(id, modoListaProductos);

    selectedCategoryId == null
      ? listarProductos(id, modoListaProductos)
      : listarProductos(selectedCategoryId, modoListaProductos);
  });
}

function getProductosByCategory() {
  // Devuelve la promesa de $.ajax
  return $.ajax({
    url: $("#url").val() + "venta/listarCategorias",
    dataType: "json",
    type: "POST",
    data: { codtipoped: $("#codtipoped").val() },
  }).then((data) => {
    // Limpia y carga
    Productos = [];
    (data || []).forEach((categoria) => {
      const idCategoria = categoria.id_catg;
      (categoria.productos || []).forEach((p) => {
        p.id_catg = idCategoria;
        Productos.push(p);
      });
    });
    return Productos; // útil si quieres encadenar datos
  });
}

var listarProductos = function (id_catg, tipe_view = "grid") {
  console.log("listar prodcutos", id_catg);
  console.log(Productos);

  const productosFiltrados = Productos.filter(
    (producto) => producto.id_catg == id_catg
  );

  generarProductos(productosFiltrados, tipe_view);
};

var listarProdsMasVend = function (side = false) {
  $.ajax({
    dataType: "JSON",
    type: "POST",
    data: {
      codtipoped: $("#codtipoped").val(),
      codrepartidor: $("#codrepartidor").val(),
    },
    url: $("#url").val() + "venta/listarProdsMasVend",
    success: function (data) {
      generarProductos(data);
    },
    error: function (xhr, status, error) {
      console.error("Error al obtener categorías:", error);
    },
  });
};

function limpiarDescuentos() {
  $("#tipo_descuento_select").prop("selectedIndex", 0).trigger("change");
  $("#descuento_porcentaje").val("");
  $("#descuento_monto_fijo").val("");
  $("#impuesto_bolsa").val("");
  $("#comision_delivery").val("");
  $("#observacion").val("");
}

// function generarProductos(items) {
//   var url = $("#url").val();
//   var container = $(".section-list");
//   var html = "";

//   if (items.length == 0) {
//     html = `
//     <div style="
//       display: flex;
//       flex-direction: column;
//       align-items: center;
//       justify-content: center;
//       height: 100%;
//       min-height: 400px;
//       text-align: center;
//     ">
//       <div style="margin-bottom: 10px;">
//         <svg xmlns="http://www.w3.org/2000/svg" width="120" height="120" viewBox="0 0 24 24" fill="none">
//           <path d="M7 18a2 2 0 1 0 0 4 2 2 0 0 0 0-4Zm10 0a2 2 0 1 0 .001 3.999A2 2 0 0 0 17 18Zm3.21-13H5.21l-.94-2H1v2h2l3.6 7.59-1.35 2.45A2.003 2.003 0 0 0 7 17h12v-2H7.42c-.14 0-.25-.11-.25-.25l.03-.12L8.1 13h7.45a2 2 0 0 0 1.79-1.11L21 4.6a.5.5 0 0 0-.45-.6h-.34Z" fill="#aaa"/>
//         </svg>
//       </div>
//       <p style="color: #aaa;">Parece que esta categoría aún está vacía</p>
//     </div>
//   `;
//   } else {
//     html = items
//       .map(function (item) {
//         let preciosHtml = "";
//         let tienePrecios = false;

//         if (item.precios) {
//           try {
//             var preciosArray = JSON.parse(item.precios);
//             if (preciosArray.length > 0) {
//               tienePrecios = true;
//               preciosHtml = `
//               <div class="content" style="display:none;">
//                 <div class="modal-content animated bounceInTop" style="padding:2px 4px;display:flex;flex-direction:row;flex-wrap:wrap;gap:.5rem;justify-content:space-evenly">
//             `;

//               preciosHtml += `
//               <div style="display:flex;flex-direction:column;align-items:center;gap:.3rem">
//                 <span>Precio base</span>
//                 <button
//                   class="btn btn-outline-primary btn-sm agregar-precio"
//                   data-precio="${item.pro_cos}"
//                   data-id_pres="${item.id_pres}"
//                   data-price-name="Precio base"
//                   data-producto='${JSON.stringify(item)}'
//                 >
//                   ${item.pro_cos}
//                 </button>
//               </div>
//             `;

//               preciosArray.forEach(function (precio) {
//                 preciosHtml += `
//                 <div style="display:flex;flex-direction:column;align-items:center;gap:.3rem">
//                   <span>${precio.nombre}</span>
//                   <button
//                     class="btn btn-secondary btn-sm agregar-precio"
//                     data-precio="${precio.precio}"
//                     data-id_pres="${precio.id_pres}"
//                     data-price-name="${precio.nombre}"
//                     data-producto='${JSON.stringify(item)}'
//                   >
//                     ${precio.precio}
//                   </button>
//                 </div>
//               `;
//               });

//               preciosHtml += `</div></div>`;
//             }
//           } catch (e) {
//             console.warn("Error al parsear precios:", e);
//           }
//         }

//         return `
//         <div class="card-menu-wrapper">
//           <div class="card-menu">
//             <div class="card-menu-header" style="position: relative;">
//               <img src="${
//                 url + "public/images/productos/" + item.pro_img
//               }" alt="">
//               ${renderStockBadge(item)}
//             </div>

//             <div class="menu-name">${item.pro_pre}</div>
//             <div class="menu-category prices-list" title="Ver más precios" style="padding:4px 8px;border:1px solid #7460ee;border-radius:4px;background-color:#7460ee;cursor:pointer">
//               <span class="price" style="margin:auto; color: white;">${
//                 item.pro_cos
//               }</span>
//             </div>
//           </div>
//           ${preciosHtml}
//         </div>
//       `;
//       })
//       .join("");
//   }

//   container.html(html);

//   container.find(".card-menu").each(function (index) {
//     $(this).data("item", items[index]);
//   });

//   container.find(".card-menu").on("click", function () {
//     const item = $(this).data("item");
//     if (item.precios) {
//       try {
//         const preciosArray = JSON.parse(item.precios);
//         if (preciosArray.length > 0) {
//           $(this)
//             .closest(".card-menu-wrapper")
//             .find(".content")
//             .slideToggle("fast");
//           return;
//         }
//       } catch (e) {
//         console.warn("Error al parsear precios:", e);
//       }
//     }

//     if (item.Stock && item.Stock.crt_stock == 1 && item.Stock.ingredientes) {
//       if (tieneStockDisponible(item)) {
//         item.cantidad = 1;
//         agregarProducto(item);
//         actualizarStockVisual(this, item);
//       } else {
//         mostrarAlerta(
//           "warning",
//           "Sin stock disponible",
//           "No hay stock suficiente para agregar este producto."
//         );
//       }
//     } else {
//       item.cantidad = 1;
//       agregarProducto(item);
//     }
//   });
// }

function generarProductos(items, vista = "grid") {
  const url = $("#url").val();
  const container = $(".section-list");
  let html = "";

  if (items.length === 0) {
    html = `
      <div style="display:flex;flex-direction:column;align-items:center;justify-content:center;height:100%;min-height:400px;text-align:center;">
        <div style="margin-bottom:10px;">
          <svg xmlns="http://www.w3.org/2000/svg" width="120" height="120" viewBox="0 0 24 24" fill="none">
            <path d="..." fill="#aaa"/>
          </svg>
        </div>
        <p style="color:#aaa;">Parece que esta categoría aún está vacía</p>
      </div>
    `;
  } else {
    html = items
      .map(function (item) {
        let preciosHtml = "";
        let tienePrecios = false;

        if (item.precios) {
          try {
            const preciosArray = JSON.parse(item.precios);
            if (preciosArray.length > 0) {
              tienePrecios = true;
              preciosHtml = `
              <div class="content" style="display:none; width: 100%; margin-top: 10px; background: transparent !important; box-shadow: none !important; border: none !important;">
                <div class="product-prices-list" style="display: flex; flex-direction: row; flex-wrap: wrap; gap: 4px; justify-content: center;">
            `;

              preciosHtml += `
              <div class="price-item" style="flex: 1 1 30%; min-width: 70px; display: flex; flex-direction: column; align-items: center; background: transparent; border: none;">
                <span class="price-label" style="text-align: center; font-size: 0.7rem; font-weight: 600; color: #666; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; width: 100%; margin-bottom: 2px;" title="Precio base">Base</span>
                <button class="btn btn-outline-primary btn-sm agregar-precio"
                  style="width: 100%; padding: 2px 0; font-size: 0.85rem;"
                  data-precio="${item.pro_cos}"
                  data-id_pres="${item.id_pres}"
                  data-price-name="Precio base"
                  data-producto='${JSON.stringify(item)}'>
                  ${item.pro_cos}
                </button>
              </div>
            `;

              preciosArray.forEach((precio) => {
                const nombrePrecio = precio.nombre || precio.descripcion || "Opción";
                preciosHtml += `
                <div class="price-item" style="flex: 1 1 30%; min-width: 70px; display: flex; flex-direction: column; align-items: center; background: transparent; border: none;">
                  <span class="price-label" style="text-align: center; font-size: 0.7rem; font-weight: 600; color: #666; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; width: 100%; margin-bottom: 2px;" title="${nombrePrecio}">${nombrePrecio}</span>
                  <button class="btn btn-outline-primary btn-sm agregar-precio"
                    style="width: 100%; padding: 2px 0; font-size: 0.85rem;"
                    data-precio="${precio.precio}"
                    data-id_pres="${item.id_pres}"
                    data-price-name="${nombrePrecio}"
                    data-producto='${JSON.stringify(item)}'>
                    ${precio.precio}
                  </button>
                </div>
              `;
              });

              preciosHtml += `
                </div>
              </div>
            `;

            }
          } catch (e) {
            console.warn("Error al parsear precios:", e);
          }
        }

        // HTML para vista tipo lista
        if (vista === "list") {
          return `
                <div class="card-menu-wrapper" style="border-bottom: 1px solid #ccc; padding: 10px; display: flex; align-items: center; gap: 10px; cursor: pointer;">
                  <img src="${url + "public/images/productos/" + item.pro_img
            }" alt="" style="width: 50px; height: 50px; object-fit: cover; border-radius: 4px;">
              <div style="flex-grow: 1;">
              <div style="font-weight: bold;">${item.pro_pre}</div>
              <div style="color: #888;">Precio: ${item.pro_cos}</div>
            </div>
              <div class="stock-container-list">
                ${renderStockBadgeList(item)}
              </div>
            ${preciosHtml}
          </div>
              `;
        } else {
          // HTML para vista tipo grid (tarjeta)
          return `
              <div class="card-menu-wrapper">
                <div class="card-menu">
                  <div class="card-menu-header" style="position: relative;">
                    <img src="${url + "public/images/productos/" + item.pro_img
            }" alt="">
                    ${renderStockBadge(item)}
                  </div>
                  <div class="menu-name">${item.pro_pre}</div>
                  <div class="menu-category prices-list" title="Ver más precios" style="padding:4px 8px;border:1px solid #7460ee;border-radius:4px;background-color:#7460ee;cursor:pointer">
                    <span class="price" style="margin:auto; color: white;">${item.pro_cos
            }</span>
                  </div>
                </div>
            ${preciosHtml}
          </div>
              `;
        }
      })
      .join("");
  }

  // Limpiar y aplicar clase de vista (list o grid)
  container
    .removeClass("list-view grid-view")
    .addClass(vista === "list" ? "list-view" : "grid-view")
    .html(html);

  // Eventos por tarjeta
  container.find(".card-menu-wrapper").each(function (index) {
    $(this).data("item", items[index]);
  });

  container.find(".card-menu-wrapper").on("click", function () {
    const item = $(this).data("item");
    if (item.precios) {
      try {
        const preciosArray = JSON.parse(item.precios);
        if (preciosArray.length > 0) {
          $(this).find(".content").slideToggle("fast");
          return;
        }
      } catch (e) {
        console.warn("Error al parsear precios:", e);
      }
    }

    if (item.Stock && item.Stock.crt_stock == 1 && item.Stock.ingredientes) {
      if (tieneStockDisponible(item)) {
        item.cantidad = 1;
        agregarProducto(item);
        actualizarStockVisual(this, item);
      } else {
        mostrarAlerta(
          "warning",
          "Sin stock disponible",
          "No hay stock suficiente para agregar este producto."
        );
      }
    } else {
      item.cantidad = 1;
      agregarProducto(item);
    }
  });
}

// function reponerStockVisual(product) {
//   try {
//     if(product.Stock.ingredientes){
//       const ingredientes = JSON.parse(product.Stock.ingredientes);
//       const principal = ingredientes.find(i => i.principal === 'si' || ingredientes.length === 1);

//         if (principal) {
//           const cantidadRestaurar = product.cantidad || 1;

//           if (product.Stock.receta == 1) {

//             principal.stock_actual = (
//               parseFloat(principal.stock_actual) +
//               (parseFloat(principal.cant) * cantidadRestaurar)
//             ).toFixed(2);
//           } else {

//             principal.stock_actual = (
//               parseFloat(principal.stock_actual) +
//               cantidadRestaurar
//             ).toFixed(2);
//           }

//           product.Stock.ingredientes = JSON.stringify(ingredientes);

//           actualizarBadgeDelProducto(product.id_pres, product);
//       }

//     }
//   } catch (e) {
//     console.warn("Error al reponer stock:", e);
//   }
// }

function reponerStockVisual(product) {
  try {
    if (!product?.Stock?.ingredientes) return;

    const N = (v) => Number.parseFloat(v ?? 0) || 0;

    // 1) parsear y recalcular
    const ingredientes = JSON.parse(product.Stock.ingredientes || "[]");
    const principal =
      ingredientes.find((i) => i.principal === "si") || ingredientes[0];
    if (!principal) return;

    const qty = N(product.cantidad || 1);
    const cantUnidad = N(principal.cant);
    const stockAct = N(principal.stock_actual);

    const nuevoStock =
      product.Stock.receta == 1
        ? stockAct + (cantUnidad > 0 ? cantUnidad * qty : qty)
        : stockAct + qty;

    principal.stock_actual = nuevoStock.toFixed(2);
    const jsonIng = JSON.stringify(ingredientes);

    // 2) sincronizar con el array global y con el propio product
    let prodGlobal = product;
    const idx = Productos.findIndex((p) => p.id_pres === product.id_pres);
    if (idx !== -1) {
      Productos[idx].Stock = {
        ...Productos[idx].Stock,
        ingredientes: jsonIng,
      };
      prodGlobal = Productos[idx];
    }
    product.Stock.ingredientes = jsonIng; // mantiene coherencia en el objeto local también

    // 3) actualizar el data("item") de las tarjetas en la vista de productos
    const $cards = $(".section-list .card-menu-wrapper");
    $cards.each(function () {
      const it = $(this).data("item");
      if (it && it.id_pres === prodGlobal.id_pres) {
        $(this).data("item", prodGlobal);
      }
    });

    // 4) re-render del badge en TODAS las tarjetas visibles de ese producto
    $cards.each(function () {
      const it = $(this).data("item");
      if (!it || it.id_pres !== prodGlobal.id_pres) return;

      const $wrap = $(this);
      if ($wrap.closest(".grid-view").length) {
        const $header = $wrap.find(".card-menu-header");
        $header.find(".stock-badge").remove();
        $header.append(renderStockBadge(prodGlobal));
      } else if ($wrap.closest(".list-view").length) {
        const $cont = $wrap.find(".stock-container-list");
        $cont.empty();
        $cont.append(renderStockBadgeList(prodGlobal));
      }
    });
  } catch (e) {
    console.warn("Error al reponer stock:", e);
  }
}

// function actualizarBadgeDelProducto(id_pres, product) {
//   const $cards = $(".card-menu");
//   $cards.each(function () {
//     const item = $(this).data("item");
//     if (item && item.id_pres === id_pres) {
//       const $header = $(this).find(".card-menu-header");
//       $header.find(".stock-badge").remove();
//       $header.append(renderStockBadge(product));
//     }
//   });
// }

function actualizarBadgeDelProducto(id_pres, productoActualizado = null) {
  const $cards = $(".card-menu");

  $cards.each(function () {
    const item = $(this).data("item");

    if (item && item.id_pres === id_pres) {
      const $header = $(this).find(".card-menu-header");
      $header.find(".stock-badge").remove();

      const producto =
        productoActualizado || Productos.find((p) => p.id_pres === id_pres);
      if (producto) {
        $header.append(renderStockBadge(producto));
      }
    }
  });
}

// function tieneStockDisponible(item) {
//     console.log("Verificando stock para:", item);

//   try {
//     const ingredientes = JSON.parse(item.Stock.ingredientes);
//     const principal = ingredientes.find(i => i.principal === 'si' || ingredientes.length === 1);

//     if (principal) {
//       if (item.Stock.receta == 1) {
//         if (parseFloat(principal.cant) > 0) {
//           const stockDisponible = parseFloat(principal.stock_actual) / parseFloat(principal.cant);
//           return stockDisponible > 0;
//         }
//       } else {
//         return parseFloat(principal.stock_actual) > 0;
//       }
//     }
//   } catch (e) {
//     console.warn("Error al verificar stock:", e);
//   }
//   return false;
// }

function tieneStockDisponible(item) {
  const actualizado = Productos.find((p) => p.id_pres === item.id_pres);
  if (actualizado) item = actualizado;

  try {
    const ingredientes = JSON.parse(item.Stock.ingredientes);
    const principal = ingredientes.find(
      (i) => i.principal === "si" || ingredientes.length === 1
    );

    if (principal) {
      if (item.Stock.receta == 1) {
        if (parseFloat(principal.cant) > 0) {
          const stockDisponible =
            parseFloat(principal.stock_actual) / parseFloat(principal.cant);
          return stockDisponible > 0;
        }
      } else {
        return parseFloat(principal.stock_actual) > 0;
      }
    }
  } catch (e) {
    console.warn("Error al verificar stock:", e);
  }

  return false;
}

// function actualizarStockVisual(cardElement, item) {
//   try {
//     const ingredientes = JSON.parse(item.Stock.ingredientes);
//     const principal = ingredientes.find(
//       (i) => i.principal === "si" || ingredientes.length === 1
//     );

//     if (principal) {
//       const cantidadAgregar = item.cantidad || 1;
//       let nuevoStock;

//       if (item.Stock.receta == 1) {
//         nuevoStock =
//           parseFloat(principal.stock_actual) -
//           parseFloat(principal.cant) * cantidadAgregar;
//       } else {
//         nuevoStock = parseFloat(principal.stock_actual) - cantidadAgregar;
//       }

//       principal.stock_actual = Math.max(0, nuevoStock).toFixed(2);
//       item.Stock.ingredientes = JSON.stringify(ingredientes);

//       const index = Productos.findIndex((i) => i.id_pres === item.id_pres);
//       if (index !== -1) {
//         Productos[index].Stock.ingredientes = item.Stock.ingredientes;
//       }

//       const $header = $(cardElement).find(".card-menu-header");
//       $header.find(".stock-badge").remove();
//       $header.append(renderStockBadge(item));
//     }
//   } catch (e) {
//     console.warn("Error al actualizar stock:", e);
//   }
// }

function actualizarStockVisual(wrapperEl, item) {
  try {
    console.log(Productos);

    const N = (v) => Number.parseFloat(v ?? 0) || 0;

    const ingredientes = JSON.parse(item.Stock.ingredientes || "[]");
    const principal =
      ingredientes.find((i) => i.principal === "si") || ingredientes[0];
    if (!principal) return;

    const qty = N(item.cantidad || 1);
    const cantUnidad = N(principal.cant);
    const stockActual = N(principal.stock_actual);

    let nuevoStock =
      item.Stock.receta == 1
        ? stockActual - (cantUnidad > 0 ? cantUnidad * qty : qty) // guard contra cant 0/NaN
        : stockActual - qty;

    principal.stock_actual = Math.max(0, nuevoStock).toFixed(2);

    item.Stock.ingredientes = JSON.stringify(ingredientes);

    const idx = Productos.findIndex((p) => p.id_pres === item.id_pres);
    let productoGlobal = item;
    if (idx !== -1) {
      Productos[idx].Stock = {
        ...Productos[idx].Stock,
        ingredientes: item.Stock.ingredientes,
      };
      productoGlobal = Productos[idx];
    }

    $(".section-list .card-menu-wrapper").each(function () {
      const it = $(this).data("item");
      if (it && it.id_pres === productoGlobal.id_pres) {
        $(this).data("item", productoGlobal);
      }
    });

    const $wrap = $(wrapperEl);
    if ($wrap.closest(".grid-view").length) {
      const $header = $wrap.find(".card-menu-header");
      $header.find(".stock-badge").remove();
      $header.append(renderStockBadge(productoGlobal));
    } else {
      const $cont = $wrap.find(".stock-container-list");
      $cont.empty();
      $cont.append(renderStockBadgeList(productoGlobal));
    }

    // Logs de verificación
    console.log("item:", item);
    console.log("global:", productoGlobal);
  } catch (e) {
    console.warn("Error al actualizar stock:", e);
  }
}

function renderStockBadge(item) {
  // Siempre usamos el producto más actualizado
  const actualizado = Productos.find((p) => p.id_pres === item.id_pres);
  if (actualizado) item = actualizado;

  if (item.Stock && item.Stock.crt_stock == 1 && item.Stock.ingredientes) {
    try {
      const ingredientes = JSON.parse(item.Stock.ingredientes);
      const principal = ingredientes.find(
        (i) => i.principal === "si" || ingredientes.length === 1
      );

      if (principal) {
        let stock = 0;

        if (item.Stock.receta == 1) {
          if (parseFloat(principal.cant) > 0) {
            const total =
              parseFloat(principal.stock_actual) / parseFloat(principal.cant);
            stock = total.toFixed(0);
          }
        } else {
          stock = parseFloat(principal.stock_actual).toFixed(0);
        }

        return `
              <div class="stock-badge" style="
            position: absolute;
            bottom: 5px;
            right: 5px;
            background-color: rgba(0, 0, 0, 0.7);
            color: white;
            font-size: 16px;
            padding: 2px 6px;
            border-radius: 4px;
            ">
            Stock: ${stock}
          </div>
              `;
      }
    } catch (e) {
      console.warn("Error al calcular stock en renderStockBadge:", e);
    }
  }

  return "";
}

function renderStockBadgeList(item) {
  const actualizado = Productos.find((p) => p.id_pres === item.id_pres);
  if (actualizado) item = actualizado;

  if (item.Stock && item.Stock.crt_stock == 1 && item.Stock.ingredientes) {
    try {
      const ingredientes = JSON.parse(item.Stock.ingredientes);
      const principal = ingredientes.find(
        (i) => i.principal === "si" || ingredientes.length === 1
      );
      if (principal) {
        let stock = 0;
        if (item.Stock.receta == 1) {
          const total =
            parseFloat(principal.stock_actual) / parseFloat(principal.cant);
          stock = Math.floor(total);
        } else {
          stock = Math.floor(parseFloat(principal.stock_actual));
        }

        return `
              <span class="stock-badge-list" style="
            display: inline-block;
            background: #00afe9;
            color: #333;
            font-size: 14px;
            padding: 2px 6px;
            border-radius: 4px;
            ">
            Stock: ${stock}
          </span>
              `;
      }
    } catch (e) {
      console.warn("Error al calcular stock para lista:", e);
    }
  }
  return "";
}

let _productCounter = 0;

function agregarProducto(product, esNuevo = true) {
  const item = { ...product };

  item.isNew = esNuevo;
  item.wrapperId = `po-${++_productCounter}`;

  item.nombre_precio = item.nombre_precio || "Principal";

  // Asegurar visualización forzada (Tablet Fix)
  $(".cont01").hide(); // Ocultar Empty State

  // Forzar visualización de contenedores principales por ID
  // Forzar visualización de contenedores principales por ID
  // 1. Selector Contextual Inteligente (Detectar Entorno)
  let $targetList;
  let isMobileContext = false;

  if ($(".modal-order-right #list-pedidos").length > 0) {
    $targetList = $(".modal-order-right #list-pedidos");
    isMobileContext = true;
  } else {
    $targetList = $("#columna-derecha #list-pedidos");
    if ($targetList.length === 0) $targetList = $("#list-pedidos");
  }

  // 2. Visibilidad Condicional (Tablet vs Mobile)
  // Si NO es móvil (es decir, Tablet o Desktop), forzamos la visualización.
  if (!isMobileContext) {
    $("#columna-derecha").css("display", "block");
    $("#tarjeta-derecha").css("display", "block");
    $("#header-derecha").css("display", "block").removeClass("d-none");
    $(".cont04").css("display", "block"); // Totales
    $(".card-body-right").css("display", "block"); // Fallback class

    // Aseguramos la lista genérica por si acaso
    $("#list-pedidos").css({ "display": "block", "height": "100%", "min-height": "400px" });
  }

  if (!$targetList.hasClass("po-items")) {
    $targetList.addClass("po-items");
    $targetList.css({
      "display": "block",
      "width": "100%",
      "height": "100%",
      "min-height": "400px",
      "flex": "1",
      "background-color": "#fff",
      "padding-top": "0px",
      "z-index": "10",
      "position": "relative"
    });
    // Solo forzamos altura del padre si estamos en Main View
    if ($targetList.closest("#columna-derecha").length > 0) {
      $("#tarjeta-derecha .card-body").css("height", "calc(100% - 50px)");
    }
  }

  const container = $targetList;



  // Production Item HTML (Clean)
  const newItemHtml = `
              <div class="po-item-wrapper${esNuevo ? " new-item" : ""}"
            data-wrapper-id="${item.wrapperId}" style="display:block;opacity:1;width:100%;border-bottom:1px solid #eee;">
      <button type="button" class="po-item collapsible" style="display:block;width:100%;color:#333;">
        <div class="description">
          <div class="info">
            <span class="name" style="color:#333;">
              ${item.pro_pre}
              <span class="r-order-type-label" style="margin-left:.6rem">
                ${item.pro_nom}
              </span>
            </span>
            <span class="price">${item.pro_cos}</span>
          </div>
          <div class="actions">
            <div style="display:flex;align-items:center;gap:.5rem">
              <span class="edit_precio" title="Editar pedido"
                    style="padding:4px 8px;border:1px solid #ddd;border-radius:4px;
                            color:blue;background-color:#fff">
                <i class="fas fa-pencil-alt"></i>
              </span>
              <span class="comments" title="Agregar comentario"
                    style="padding:4px 8px;border:1px solid #ddd;border-radius:4px;
                           color:#666;background-color:#fff">
                <i class="fas fa-comment"></i>
              </span>
              <span class="delete_pedido" title="Eliminar pedido"
                    style="padding:4px 8px;border:1px solid #ddd;border-radius:4px;
                           color:red;background-color:#fff">
                <i class="fas fa-trash"></i>
              </span>
            </div>

            <input type="hidden" id="notapadre"/>
            <h6 class="card-subtitle notlist p-0 m-0 small"></h6>
            <input type="hidden" id="cod_add"/>
            <input type="hidden" id="cod_pres_add"/>
            <input type="hidden" id="cod_prod_add"/>

          </div>
        </div>
      </div>
    </div>
            `;

  const newItem = $(newItemHtml).data("item", item);

  container.prepend(newItem);

  actualizarTotalesDesdeLista();
  actualizarContadorPedidos();

  // Debug Clean
  showToast(`${item.pro_pre} agregado`, "success");
}

function showToast(message, icon = "info") {
  Swal.fire({
    toast: true,
    position: "top-end",
    icon,
    title: message,
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    background: "#f0f0f0",
    customClass: {
      popup: "shadow rounded-lg",
    },
  });
}

function toggleCommentInput(element) {
  $(element).find(".comment-input").toggle();
}

function actualizarTotalesDesdeLista() {
  let subtotal = 0;

  $(".po-item").each(function () {
    const item = $(this);
    const precio = parseFloat(item.find(".price").text()) || 0;
    const cantidad = parseInt(item.find(".cantidad span").eq(1).text()) || 0;

    subtotal += cantidad * precio;
  });

  const igv = 0.0;
  const total = subtotal + igv;

  // Actualizar los valores en pantalla
  $(".sub-total div:eq(0) span:eq(1)").text("S/" + subtotal.toFixed(2));
  $(".sub-total div:eq(1) span:eq(1)").text("S/" + igv.toFixed(2));
  $(".total span:eq(1)").text("S/" + total.toFixed(2));
}

function calcularTotalDividirCuenta(subtotalSeleccionado) {
  let total = 0;
  const tipo_descuento = $("#tipo_descuento_select").val();
  const comision_delivery = parseFloat($("#comision_delivery").val()) || 0;
  const monto_descuento = parseFloat($("#descuento_monto_fijo").val()) || 0;
  const subtotal = parseFloat(subtotalSeleccionado) || 0;

  console.log("subtotalSeleccionado", subtotalSeleccionado);

  if (tipo_descuento == 1) {
    total = comision_delivery;
    $("#descuento_monto_fijo").val(0);
    $("#descuento_porcentaje").val(0);
    $(".SubtotalPedido").text(formatNumber(0));
  } else if (tipo_descuento == 2 || tipo_descuento == 3) {
    total = subtotal - monto_descuento + comision_delivery;
    $(".SubtotalPedido").text(formatNumber(subtotalSeleccionado));
  } else if (tipo_descuento == 0) {
    total = subtotal - monto_descuento + comision_delivery;
    $(".SubtotalPedido").text(formatNumber(subtotalSeleccionado));
  }

  TotalPedido = subtotal;

  $("#pago_efe").val(formatNumber(total));
  $(".totalPedidoMenosTarjeta").text(formatNumber(total));
}

function actualizarPrecioDescuentos() {
  let total = 0;
  const tipo_descuento = $("#tipo_descuento_select").val();
  const comision_delivery = parseFloat($("#comision_delivery").val()) || 0;
  const monto_descuento = parseFloat($("#descuento_monto_fijo").val()) || 0;
  const subtotal = parseFloat(TotalPedido) || 0;

  if (tipo_descuento == 1) {
    total = comision_delivery;
    $(".SubtotalPedido").text(`${formatNumber(0)} `);
  } else if (tipo_descuento == 2 || tipo_descuento == 3) {
    total = subtotal - monto_descuento + comision_delivery;
  } else if (tipo_descuento == 0) {
    $(".SubtotalPedido").text(`${formatNumber(subtotal)} `);
    total = subtotal - monto_descuento + comision_delivery;
  }

  $(".totalDescuento").text(formatNumber(monto_descuento));
  $(".totalDelivery").text(formatNumber(comision_delivery));
  $("#pago_efe").val(formatNumber(total));
  $(".totalPedidoMenosTarjeta").text(formatNumber(total));

  const dialog = document.querySelector(".dialogBtn");
  dialog.close();
}

function extraerDataDetalle() {
  var productos = [];
  var total = 0;

  $(".po-items .po-item-wrapper").each(function () {
    var prod = $(this).data("item");

    if (!prod.isNew) {
      return;
    }

    var precio = parseFloat(prod.pro_cos) || 0;
    prod.quantity =
      parseInt($(this).find(".cantidad span").eq(1).text(), 10) || 1;
    var comentarios = $(this).find(".texto-intermedio").text().trim();
    prod.comentarios = comentarios;
    total += precio * prod.quantity;

    productos.push(prod);
  });

  return {
    cod_ped: $("#id_pedido").val(),
    codtipoped: $("#codtipoped").val(),
    igv: (total * 0.1).toFixed(2),
    items: convertirItems(productos),
    subtotal: (total - total * 0.1).toFixed(2),
    total: total.toFixed(2),
  };
}

function convertirItems(itemsOriginales) {
  return itemsOriginales.map(function (item, index) {
    var area_id = parseInt(item.id_areap, 10);
    var cantidad = item.quantity;
    var comentario = item.comentarios || "";
    var id = index;
    var nombre_imp =
      item.Impresora && item.Impresora.nombre ? item.Impresora.nombre : "";
    var nombreprecio = item.nombre_precio;
    var precio = item.pro_cos;
    var presentacion = item.pro_pre;
    var producto = item.pro_nom;
    var producto_id = parseInt(item.id_pres, 10);
    var total = (parseFloat(precio) * cantidad).toFixed(2);

    return {
      area_id: area_id,
      cantidad: cantidad,
      comentario: comentario,
      id: id,
      nombre_imp: nombre_imp,
      nombreprecio: nombreprecio,
      precio: precio,
      presentacion: presentacion,
      producto: producto,
      producto_id: producto_id,
      total: total,
    };
  });
}

function dataPedido() {
  return {
    id_mesa: $(".id-mesa").val(),
    id_mozo: $("#id_mozo").val(),
    nomb_cliente: $("#buscar_cliente_pedido").val(),
    nro_personas: 1,
    cliente_id: $("#cliente_pedido_id").val(),
    id_repartidor: $("#id_repartidor").val(),
    tipo_entrega: 1,
    pedido_programado: 0,
    telefono_cliente: "0000",
    direccion_cliente: "-",
    referencia_cliente: "-",
    id_tdoc: 1,
    num_cliente: "00000000",
    canal: "2",
  };
}

let isSubmitting = false;

function guardarPedido() {
  const $btn = $("#btn_guardar_pedido");

  if (isSubmitting) return;
  isSubmitting = true;

  // 1) Desactivar el botón de inmediato
  $btn.prop("disabled", true).text("Guardando…");

  let detalle = extraerDataDetalle();
  let pedido = dataPedido();
  let tipo_pedido = "pc" + $("#codtipoped").val();

  //   console.log(pedido);
  //   console.log(detalle);
  //   return;

  if (detalle.items.length == 0) {
    mostrarAlerta(
      "warning",
      "Sin productos",
      "Debe agregar productos al pedido."
    );
    isSubmitting = false;
    $btn.prop("disabled", false).text("Hacer pedido");
    return;
  }

  $.ajax({
    dataType: "JSON",
    type: "POST",
    data: {
      codtipoped: tipo_pedido,
      pedido: pedido,
      detalle: detalle,
    },
    url: $("#url").val() + "venta/pedido_create",
    success: function (data) {
      if (data.status == "error") {
        console.error("Error al guardar pedido:", data);
        return;
      }

      $("#modal-super-test").modal("hide");
      vaciarListaProductos();

      let tipo_pedido = $("#codtipoped").val();

      if ($("#impresion_automatica_comanda").val() == 1) {
        imprimirComanda(pedido, tipo_pedido, detalle.items, data.pedido_id);
      }

      listarPedidosGuardados(tipo_pedido, data.pedido_id);
    },
    error: function (xhr, status, error) {
      console.error("Error al guardar pedido:", error);
    },
    complete: function () {
      isSubmitting = false;
      $btn.prop("disabled", false).text("realizar pedido");
    },
  });
}

function listarPedidosGuardados(tipo_pedido, id_pedido) {
  if (tipo_pedido == 1) {
    console.log("Listando pedidos para salón");

    listarPedidos(
      $("#codsalonorigen").val(),
      $("#codmesaorigen").val(),
      1,
      id_pedido,
      $("#mesa").val(),
      $("#salon").val(),
      "i"
    );
  } else if (tipo_pedido == 2) {
    console.log("Listando pedidos para mostrador");

    $(".mostrador02").trigger("click");
    mostrador_list_a();
    listarPedidosDetalle(2, id_pedido);
  } else if (tipo_pedido == 3) {
    $(".delivery02").trigger("click");
    listarPedidosDetalle(3, id_pedido, 0, "automatico");
    console.log("Listando pedidos para delivery");
    console.log(pedidoSeleccionado);
  }
}

// function imprimirComanda(pedido, idTipoPedido, detalles, codAnulacion = 0) {

//   function parsePedidoInfo(text) {
//     const [numero = "", cliente = ""] = text.split("–").map(s => s.trim());
//     return { numero, cliente };
//   }

//   function buildPrintUrl(payload) {
//     const serialized = encodeURIComponent(JSON.stringify(payload));
//     const printCom    = $('#print_com').val() === '1';
//     const pcIp        = $('#pc_ip').val();
//     const baseUrl     = $('#url').val();
//     if (printCom) {
//       return { url: `http://${pcIp}/imprimir/comanda.php?data=${serialized}`, features: '_blank' };
//     } else {
//       return {
//         url:  `${baseUrl}venta/impresion_comanda/?data=${serialized}`,
//         features: 'top=500,left=500,width=400,height=400,_blank'
//       };
//     }
//   }

//   function openPrintWindow({ url, features }) {
//     window.open(url, '_blank', features);
//   }

//   const textoPedido = $('.pedido-numero').text() || "";
//   const { numero: pedidoNumero, cliente: pedidoCliente } = parsePedidoInfo(textoPedido);

//   const gruposPorArea = detalles.reduce((acc, item) => {
//     const area = item.area_id;
//     (acc[area] = acc[area] || []).push(item);
//     return acc;
//   }, {});

//   Object.values(gruposPorArea).forEach(itemsDeArea => {
//     const impresora    = itemsDeArea[0].nombre_imp;    // asume misma impresora por área
//     const pedidoMozo   = $('#select_mozo option:selected').text();
//     const datoUsuario  = $('#dato_usuario').val();
//     const correlativo  = correlativo_imp();
//     const nombrePc     = $('#pc_name').val();
//     const direccion_comanda = $("input[name='tipo_entrega_modal']:checked").val() || "";
//     const direccion_cliente     = $('#direccion_cliente_modal').val() || "";

//     const payload = {
//       pedido_tipo      : idTipoPedido,
//       pedido_numero    : pedidoNumero,
//       pedido_cliente   : pedidoCliente,
//       pedido_mozo      : pedidoMozo,
//       direccion_cliente      : direccion_cliente,
//       direccion_comanda  : direccion_comanda,
//       dato_usuario     : datoUsuario,
//       precio_comanda   : 1,
//       correlativo_imp  : correlativo,
//       nombre_imp       : impresora,
//       nombre_pc        : nombrePc,
//       codigo_anulacion : codAnulacion,
//       items            : itemsDeArea
//     };

//     console.log("Imprimiendo comanda:", payload);

//     const { url, features } = buildPrintUrl(payload);
//     openPrintWindow({ url, features });
//   });
// }

function imprimirComanda(pedido, idTipoPedido, detalles, codAnulacion = 0) {
  function buildPrintUrl(payload) {
    const serialized = encodeURIComponent(JSON.stringify(payload));
    const printCom = $("#print_com").val() === "1";
    const pcIp = $("#pc_ip").val();
    const baseUrl = $("#url").val();

    if (printCom) {
      return {
        url: `http://${pcIp}/imprimir/comanda.php?data=${serialized}`,
        features: "_blank",
      };
    } else {
      return {
        url: `${baseUrl}venta/impresion_comanda/?data=${serialized}`,
        features: "top=500,left=500,width=400,height=400,_blank",
      };
    }
  }

  function openPrintWindow({ url, features }) {
    window.open(url, "_blank", features);
  }

  const pedidoCliente = idTipoPedido != 1 ? pedido.nomb_cliente : "";
  const pedidoNumero = pedido.numero || "";

  const gruposPorArea = detalles.reduce((acc, item) => {
    const area = item.area_id;
    (acc[area] = acc[area] || []).push(item);
    return acc;
  }, {});

  Object.values(gruposPorArea).forEach((itemsDeArea) => {
    const impresora = itemsDeArea[0].nombre_imp; // Se asume la misma impresora para toda el área
    const pedidoMozo = $("#select_mozo option:selected").text();
    const datoUsuario = $("#dato_usuario").val();
    const correlativo = correlativo_imp();
    const nombrePc = $("#pc_name").val();
    const direccion_comanda =
      $("input[name='tipo_entrega_modal']:checked").val() || "";
    const direccion_cliente = $("#direccion_cliente_modal").val() || "";

    const payload = {
      pedido_tipo: idTipoPedido,
      pedido_numero: pedidoNumero,
      pedido_cliente: pedidoCliente,
      pedido_mozo: pedidoMozo,
      direccion_cliente: direccion_cliente,
      direccion_comanda: direccion_comanda,
      dato_usuario: datoUsuario,
      precio_comanda: 1,
      correlativo_imp: correlativo,
      nombre_imp: impresora,
      nombre_pc: nombrePc,
      codigo_anulacion: codAnulacion,
      items: itemsDeArea,
    };

    console.log("Imprimiendo comanda:", payload);

    const { url, features } = buildPrintUrl(payload);
    openPrintWindow({ url, features });
  });
}

// function cancelarPedido(id_pedido, id_mesa, id_tipo_pedido) {
//   var html_confirm = '<div>Se procederá a liberar este pedido</div><br>' +
//       '<div>Ingrese código de seguridad</div><br>' +
//       '<form><input class="form-control text-center w-50" type="password" id="codigo_anular_venta_" autocomplete="off"/></form><br>' +
//       '<div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';

//   Swal.fire({
//     title: 'Necesitamos de tu Confirmación',
//     html: html_confirm,
//     icon: 'warning',
//     showCancelButton: true,
//     confirmButtonColor: '#34d16e',
//     confirmButtonText: 'Si, Adelante!',
//     cancelButtonText: "No!",
//     showLoaderOnConfirm: true,
//     preConfirm: function() {

//       return new Promise(function(resolve, reject) {

//         if ($('#codigo_anular_venta').val() === $('#codigo_anular_venta_').val()) {
//           $.ajax({
//             type: 'POST',
//             data: {
//               id_pedido: id_pedido,
//               id_mesa: id_mesa,
//               tipo_pedido: id_tipo_pedido,
//               codigo_seguridad: $('#codigo_anular_venta_').val(),
//               filtro_seguridad: $('#codigo_anular_venta').val()
//             },
//             url: $('#url').val() + 'venta/cancelarPedido',
//             dataType: 'json'
//           })
//           .done(function(response) {

//             resolve(response);
//           })
//           .fail(function(jqXHR, textStatus, errorThrown) {

//             reject(new Error('Error en la solicitud AJAX: ' + textStatus));
//           });
//         } else {

//           reject(new Error('El código ingresado es incorrecto'));
//         }
//       });
//     },
//     allowOutsideClick: false
//   }).then(function(result) {

//     if (result.value) {

//       Swal.fire({
//         title: 'Operación exitosa',
//         text: 'El pedido ha sido cancelado correctamente.',
//         icon: 'success',
//         confirmButtonColor: '#34d16e',
//         confirmButtonText: 'Aceptar'
//       });

//       $(".btn-cancelar-pedido").trigger("click");
//       console.log("Pedido cancelado y lista de productos vaciada.");
//       tab01();
//     }

//   }).catch(function(error) {

//     Swal.fire({
//       title: 'Error',
//       text: error.message,
//       icon: 'error',
//       confirmButtonColor: '#34d16e',
//       confirmButtonText: 'Aceptar'
//     });
//   });
// }

function cancelarPedido(id_pedido, id_mesa, id_tipo_pedido) {
  const modalSub = $("#modal-sub-pedido");
  const modalSuper = $("#modal-super-test");

  const isSubVisible = modalSub.hasClass("show");
  const isSuperVisible = modalSuper.hasClass("show");

  if (isSubVisible) modalSub.modal("hide");
  if (isSuperVisible) modalSuper.modal("hide");

  setTimeout(() => {
    const html_confirm = `
      <div>Se procederá a liberar este pedido</div><br>
      <div>Ingrese código de seguridad</div><br>
      <form>
        <input class="form-control text-center w-50" type="password" id="codigo_anular_venta_" autocomplete="off"/>
      </form><br>
      <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>
    `;

    Swal.fire({
      title: "Necesitamos de tu Confirmación",
      html: html_confirm,
      icon: "warning",
      showCancelButton: true,
      confirmButtonColor: "#34d16e",
      confirmButtonText: "Sí, Adelante!",
      cancelButtonText: "No",
      showLoaderOnConfirm: true,
      allowOutsideClick: false,
      preConfirm: () => {
        return new Promise((resolve, reject) => {
          const code = $("#codigo_anular_venta_").val();
          const codeRef = $("#codigo_anular_venta").val();

          if (code === codeRef) {
            $.ajax({
              type: "POST",
              url: $("#url").val() + "venta/cancelarPedido",
              data: {
                id_pedido,
                id_mesa,
                tipo_pedido: id_tipo_pedido,
                codigo_seguridad: code,
                filtro_seguridad: codeRef,
              },
              dataType: "json",
            })
              .done(resolve)
              .fail((jqXHR, textStatus) => {
                reject(new Error("Error en la solicitud AJAX: " + textStatus));
              });
          } else {
            reject(new Error("El código ingresado es incorrecto"));
            Swal.fire({
              title: "Contraseña incorrecta",
              text: "Debe ingresar la contraseña correcta o contactarse con el soporte.",
              icon: "error",
              confirmButtonColor: "#34d16e",
              confirmButtonText: "Aceptar",
            });
          }
        });
      },
    })
      .then((result) => {
        // 🔁 Si canceló el Swal (NO o cerró)
        if (
          result.dismiss === Swal.DismissReason.cancel ||
          result.dismiss === Swal.DismissReason.backdrop ||
          result.dismiss === Swal.DismissReason.close
        ) {
          setTimeout(() => {
            if ($("#rol_usr").val() == 5) {
              modalSuper.modal("show");
            }
          }, 200);
          return;
        }

        // ✅ Confirmado
        if (result.value) {
          Swal.fire({
            title: "Operación exitosa",
            text: "El pedido ha sido cancelado correctamente.",
            icon: "success",
            confirmButtonColor: "#34d16e",
            confirmButtonText: "Aceptar",
          });

          $(".btn-cancelar-pedido").trigger("click");
          console.log("Pedido cancelado y lista de productos vaciada.");
          tab01();
        }
      })
      .catch((error) => {
        Swal.fire({
          title: "Error",
          text: error.message,
          icon: "error",
          confirmButtonColor: "#34d16e",
          confirmButtonText: "Aceptar",
        });
      });
  }, 400);
}

function vaciarListaProductos() {
  $(".po-items").empty();
  subtotal = 0;
  igv = 0;
  total = 0;

  $(".sub-total div:eq(0) span:eq(1)").text("S/0.00");
  $(".sub-total div:eq(1) span:eq(1)").text("S/0.00");
  $(".total span:eq(1)").text("S/0.00");
}

function anularPedido(
  id_pedido,
  id_pres,
  cant_ped,
  prod_nom,
  prod_pre,
  fecha_pedido,
  estado_pedido,
  $wrapperElement = null,
  prodData = null
) {
  $("#modal-sub-pedido").modal("hide");
  $("#modal-super-test").modal("hide");

  const tipo_pedido = $("#codtipoped").val();

  setTimeout(() => {
    const html = `
      <div>
        Se anulará el siguiente pedido:<br>
        <strong class="text-danger">${cant_ped} UNI</strong>
        ${prod_nom} <span class="label label-warning">${prod_pre}</span>
      </div>
      <div class="mt-3">
        <input
          id="codigo_seguridad"
          class="form-control text-center w-50"
          type="password"
          placeholder="Código de seguridad"
          autocomplete="off"
        >
      </div>
      <div class="mt-3">
        <span class="text-success" style="font-size:17px;">
          ¿Está Usted de Acuerdo?
        </span>
      </div>
    `;

    Swal.fire({
      title: "Necesitamos de tu Confirmación",
      html,
      icon: "warning",
      showCancelButton: true,
      confirmButtonText: "Sí, anular",
      cancelButtonText: "No",
      focusConfirm: false,
      allowOutsideClick: false,
      showLoaderOnConfirm: true,
      willOpen: () => {
        setTimeout(() => {
          $("#codigo_seguridad").focus().select();
        }, 100);
      },
      preConfirm: () => {
        const code = $("#codigo_seguridad").val().trim();
        if (!code) {
          Swal.showValidationMessage(
            "Por favor ingresa el código de seguridad"
          );
          return false;
        }
        return new Promise((resolve, reject) => {
          $.ajax({
            url: $("#url").val() + "venta/pedido_delete",
            type: "POST",
            dataType: "json",
            data: {
              id_pedido,
              id_pres,
              fecha_pedido,
              estado_pedido,
              tipo_pedido,
              codigo_seguridad: code,
            },
          })
            .done((response) => resolve(response))
            .fail(() => {
              Swal.showValidationMessage(
                "Problemas con la conexión a internet"
              );
              reject();
            });
        });
      },
    }).then((response) => {
      if (response.isDismissed) {
        setTimeout(() => {
          if ($("#rol_usr").val() == 5) {
            $("#modal-super-test").modal("show");
          } else {
            $("#modal-sub-pedido").modal("show");
          }
        }, 200);
        return; // El producto permanece visible
      }

      const resp = response.value;

      if (!resp) {
        console.log("Operación cancelada o sin respuesta");

        setTimeout(() => {
          if ($("#rol_usr").val() == 5) {
            $("#modal-super-test").modal("show");
          } else {
            $("#modal-sub-pedido").modal("show");
          }
        }, 200);
        return; // El producto permanece visible
      }

      const codigoArr = resp.Codigo;
      const productoArr = resp.Producto;

      if (!Array.isArray(codigoArr) || !codigoArr.length) {
        Swal.fire("Error", "Respuesta inesperada del servidor", "error").then(
          () => {
            setTimeout(() => {
              if ($("#rol_usr").val() == 5) {
                $("#modal-super-test").modal("show");
              } else {
                $("#modal-sub-pedido").modal("show");
              }
            }, 200);
          }
        );
        return; // El producto permanece visible
      }

      const cod = codigoArr[0].cod;
      if (cod === "0") {
        Swal.fire("Error", "El código ingresado es incorrecto", "error").then(
          () => {
            setTimeout(() => {
              if ($("#rol_usr").val() == 5) {
                $("#modal-super-test").modal("show");
              } else {
                $("#modal-sub-pedido").modal("show");
              }
            }, 200);
          }
        );
        return; // El producto permanece visible
      }

      if (cod === "2") {
        Swal.fire(
          "Error",
          "El pedido está en preparación o ya preparado",
          "error"
        ).then(() => {
          setTimeout(() => {
            if ($("#rol_usr").val() == 5) {
              $("#modal-super-test").modal("show");
            } else {
              $("#modal-sub-pedido").modal("show");
            }
          }, 200);
        });
        return; // El producto permanece visible
      }

      if ($wrapperElement && $wrapperElement.length && prodData) {
        reponerStockVisual(prodData);
        $wrapperElement
          .find(".demo-checkbox")
          .removeData("initialized")
          .removeData("seleccionadas");
        $wrapperElement.remove();
        actualizarTotalesDesdeLista();
        actualizarContadorPedidos();
      }

      const porImpresora = {};
      productoArr.forEach((item) => {
        const imp = item.nombre_imp;
        if (!porImpresora[imp]) porImpresora[imp] = [];
        porImpresora[imp].push(item);
      });

      Object.entries(porImpresora).forEach(([nombre_imp, items]) => {
        const pedidoPrint = {
          pedido_tipo: $("#codtipoped").val(),
          pedido_numero: $(".pedido-numero").text().trim().toUpperCase(),
          pedido_cliente: $(".pedido-cliente").text().trim(),
          pedido_mozo: $("#nombre_mozo").val(),
          correlativo_imp: correlativo_imp(),
          nombre_imp,
          nombre_pc: $("#pc_name").val(),
          codigo_anulacion: 1,
          items,
        };
        const dataEncoded = encodeURIComponent(JSON.stringify(pedidoPrint));
        const isLocal = $("#print_com").val() === "1";
        const url = isLocal
          ? `http://${$(
            "#pc_ip"
          ).val()}/imprimir/comanda.php?data=${dataEncoded}`
          : `${$("#url").val()}venta/impresion_comanda/?data=${dataEncoded}`;
        const features = isLocal
          ? "_blank"
          : "_blank,top=500,left=500,width=400,height=400";
        window.open(url, "_blank", features);
      });

      // Actualizar lista de pedidos

      // Mostrar mensaje de éxito
      Swal.fire(
        "¡Anulado!",
        "El pedido ha sido anulado correctamente.",
        "success"
      );

      // Si es rol 5, mostrar modal correspondiente
      if ($("#rol_usr").val() == 5) {
        orden(id_pedido, $("#mesa").val(), $("#salon").val());
      } else {
        if (tipo_pedido == 2 || tipo_pedido == 3) {
          console.log("asdasdas");

          listarPedidosDetalle(tipo_pedido, id_pedido);
        } else if (tipo_pedido == 1) {
          listarPedidos(
            $("#codsalonorigen").val(),
            $("#codmesaorigen").val(),
            $("#codtipoped").val(),
            id_pedido,
            $("#mesa").val(),
            $("#salon").val(),
            estado_pedido
          );
        }
      }
    });
  }, 400); // Esperar a que los modales se cierren completamente
}

function actualizarContadorPedidos() {
  const count = $(".po-items .po-item-wrapper").length;
  $("#ver_seleccionados").text(`Ver seleccionados (${count})`);
}

function clickSendWhatsapp(id_venta) {
  var Urls = $("#url").val() + "comprobante/ticket/" + btoa(id_venta);
  const textos = { 1: "Boleta", 2: "Factura", 3: "Nota de venta" };
  var activo = $('input[name="tipo_doc"]:checked').val();
  var tipoText = textos[activo] || "Desconocido";

  $.ajax({
    url: $("#url").val() + "whatsapp/get_send_wsp",
    type: "POST",
    dataType: "json",
    data: {
      number: $("#numero_cliente").val(),
      media: Urls,
      filename: tipoText + ".pdf",
    },
    success: function (data) {
      console.log(data);
      if (!data.ok) {
        Swal.fire("Error", data.message, "error");
        return;
      }
      // Aquí lanzamos el Bootstrap-Toast, ¡sin cerrar el modal!
      $("#viewLivetoast").css("display", "block");
      $("#liveToast").show();
      $("#liveToast .toast-body").text("Mensaje enviado por WhatsApp");
      $("#liveToast").toast("show");
    },
    error: function (reason) {
      console.error(reason);
      Swal.fire(
        "Error",
        "Error al enviar el mensaje, intenta de nuevo.",
        "error"
      );
      // También podemos notificar con toast de error:
      $("#liveToast .toast-header strong")
        .text("Error")
        .removeClass("text-success")
        .addClass("text-danger");
      $("#liveToast .toast-body").text("No se pudo enviar el mensaje");
      $("#liveToast").toast("show");
    },
  });
}

function cancelarPedidoMozo() {
  console.log(pedidoSeleccionado);
}

function mostrarAlerta(icon, title, text) {
  Swal.fire({
    title: title,
    text: text,
    icon: icon,
    confirmButtonColor: "#34d16e",
    confirmButtonText: "Aceptar",
    allowOutsideClick: false,
    showCancelButton: false,
    showConfirmButton: true,
  }).then(function (result) {
    return false;
  });
}
