  const API_URL = 'https://pale.tufacturaya.com/restaurantepro/pedidos3/RESTAURANTE/Database/DataEmpres.php';
    
  async function fetchDataAndLogToConsole() {
    try {
        
        
        const response = await fetch(API_URL);
        const text = await response.text();
        
        try {
            const data = JSON.parse(text);
            console.log("Respuesta completa:", data);
            
            if (data.error) {
                console.error("Error del servidor:", data.error);
                return;
            }
            MostrarData(data)
            if (data.warning) {
                console.warn(data.warning);
                return;
            }
            
        } catch (parseError) {
            console.error("Error al parsear JSON:", parseError);
            console.error("Respuesta del servidor:", text);
        }
        
    } catch (error) {
        console.error("Error en la solicitud:", error);
    }
}


function MostrarData(clienteData)    
{
    const menucliente = document.querySelector(".contactos");
     menucliente.innerHTML = ""; // Limpiar menú anterior
    console.log(menucliente)
     const Nombre_comercial = document.querySelector(".hero-title");
       const Nombre_comercial2 = document.querySelector(".footer-title");
     console.log(Nombre_comercial)
     let Nombre_comerciatxt;
    clienteData.forEach(cliente  => {
        Nombre_comerciatxt = cliente.nombre_comercial;
        if(cliente.celular || cliente.email || cliente.direccion_comercial || cliente.razon_social) {
            const li = document.createElement("li");
            li.innerHTML = `
               <li id="lugar"><i class="bi bi-geo-alt"></i> ${cliente.direccion_comercial}</li>
                <li><i class="bi bi-telephone"></i> ${cliente.celular}</li> 
                <li><i class="bi bi-envelope"></i> ${cliente.email}</li> 
                <li><i class="bi bi-whatsapp"></i> Reservas: ${cliente.celular}</li>
            `;
            menucliente.appendChild(li);
        }
     Nombre_comercial.textContent = Nombre_comerciatxt;
    Nombre_comercial2.textContent = Nombre_comerciatxt;
 
  });
}

const API = 'https://pale.tufacturaya.com/restaurantepro/pedidos3/RESTAURANTE/Database/DataBase.php';
fetchDataAndLogToConsole();
fetchDataAndLogToConsole2();

console.log(API)
async function fetchDataAndLogToConsole2() {
    try {
        console.log("Iniciando solicitud a la API...");
        
        const response = await fetch(API);
        const text = await response.text();
        
        try {
            const data = JSON.parse(text);
            productosPolleria = data;

            categoriasUnicas = [...new Set(data.map(item => item.nombre_producto))];
            console.log("Categorías únicas:", categoriasUnicas);
           MenuBarraCategoria(categoriasUnicas);

            if (data.error) {
                console.error("Error del servidor:", data.error);
                return;
            }
            
            if (data.warning) {
                console.warn(data.warning);
                return;
            }
                       
        } catch (parseError) {
            console.error("Error al parsear JSON:", parseError);
            console.error("Respuesta del servidor:", text);
        }
        
    } catch (error) {
        console.error("Error en la solicitud:", error);
    }
}
function MenuBarraCategoria(categoriasUnicas){
    const menu = document.querySelector(".secondary-nav-container");

  categoriasUnicas.forEach(categoria => {
    const a = document.createElement("a");
    a.href = `#${categoria.replace(/\s+/g, "-").toLowerCase()}`; // reemplaza espacios por guiones y pasa a minúsculas
    a.textContent = categoria;
    menu.appendChild(a);
  });
}



const API3 = 'https://pale.tufacturaya.com/restaurantepro/pedidos3/RESTAURANTE/Database/tm_producto_pres.php';
fetchDataAndLogToConsole3() 
async function fetchDataAndLogToConsole3() {
    try {
        console.log("Iniciando solicitud a la API...33");
        
        const response = await fetch(API3);
        const text = await response.text();
        
        try {
            const data = JSON.parse(text);
            console.log(data)
            MostrarMenusDestacado(data);

            if (data.error) {
                console.error("Error del servidor:", data.error);
                return;
            }
            
            if (data.warning) {
                console.warn(data.warning);
                return;
            }
                       
        } catch (parseError) {
            console.error("Error al parsear JSON:", parseError);
            console.error("Respuesta del servidor:", text);
        }
        
    } catch (error) {
        console.error("Error en la solicitud:", error);
    }
}
const Img_URL = 'https://pale.tufacturaya.com/restaurantepro/facturacion/public/images/productos/';
function MostrarMenusDestacado(clienteData) {
  const caruserMenuDestacado = document.getElementById("carousel-derivery");
  caruserMenuDestacado.innerHTML = "";
console.log("Total de productos:", clienteData.length);
  clienteData.forEach((cliente, index) => {
    console.log("mi index es"+index)
    

    const divItem = document.createElement("div");
    divItem.className = "carousel-item";
    if (index === 0) divItem.classList.add("active"); // solo el primero lleva la clase active
    divItem.innerHTML = `
      <img src="${Img_URL + cliente.imagen}"  class="d-block w-100" alt="${cliente.presentacion}">
      <div class="carousel-caption d-none d-md-block">
        <h5>${cliente.presentacion}</h5>
        <p>Precio: S/. ${cliente.precio}</p>
      </div>
    `;
console.log("Slides creados:", caruserMenuDestacado.querySelectorAll(".carousel-item").length);

    caruserMenuDestacado.appendChild(divItem);
  });
}
